
// POV-Ray Object File - Speeder
// created 14-Dec-03
// last update 31-Dec-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Speeder.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "FullBodyMedRez.inc", "Engine.inc", "SpeederControls.inc"
//
// Objects:
// Speeder
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Speeder origin is under the nose near ground level, with Y=up
// Exhaust pipes extend into +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "Engine.inc"
	#include "SpeederControls.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
//#include "FullBodyMedRez.inc"
#include "FullBodyHiRez.inc"
#include "Engine.inc"
#include "SpeederControls.inc"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#ifndef (SpeederTex)
#declare SpeederTex =
	texture {
		pigment { color rgb<.954,.983,.964>*5.0 }
//		pigment { color rgb<.954,.083,.040>*1.3 }
//		finish { ambient 0.1 diffuse 0.7 specular 0.95 roughness 0.04 }
		finish { ambient 0.3 diffuse 0.3 specular 0.95 roughness 0.04 reflection 0.34 } // nice metallic sheen with a 1.3 white
	}
#end

#ifndef (SpeederPaint) // assign default body texture
	#declare SpeederPaint =
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test.png"
			png "decals.png" // top surfaces
			once
			}
		}
#end

#declare SeatTex =
	texture {
		pigment { color rgb<.024,.053,.084> }
		normal { bumps 0.6 scale .45 }
		finish { ambient 0.1 diffuse 0.7 specular 0.35 roughness 0.14 }
	}

#declare WindshieldTex =
	texture {
		pigment { color rgbt<.384,.083,.014,0.72> }
//		pigment { color rgb<.954,.083,.040>*1.3 }
		finish { ambient 0.1 diffuse 0.7 specular 0.97 roughness 0.004 reflection 0.08 }
	}
#declare WindshieldInt =
	interior { ior 1.5 }
#declare WindshieldMat =
	material {
		texture { WindshieldTex }
		interior { WindshieldInt }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare Speeder =
	union {
		object { EngineAssy rotate x*-90 scale <.3,.3,-.3> translate <6*Feet-1,6.7,-0> }
		object { SeatShape texture { SeatTex } }
		object { WindshieldShape material { WindshieldMat } }
		object { ControlGroup scale 0.6 rotate z*90 rotate x*-90 translate <3.65*Feet,21.0,0> }
		cylinder { <0,0,-3>,<0,0,3>,1.3 texture { pigment { rgb<0,0,0> } } translate <4*Feet,5,0> } // front scoop blocker

		object { FullBodyShape
			texture { SpeederTex }

			texture {
				pigment { SpeederPaint }
/*
				pigment {
					image_map { // image is always projected from -z, with front facing +z
//					png "test.png"
					png "decals.png" // top surfaces
					once
					}
				}
*/
			finish { ambient .1 }
			rotate x*-90
			translate <0,0,0.5>
			scale <8*Feet,1,8*Feet*480/640>
			}

			texture {
				pigment {
					image_map { // image is always projected from -z, with front facing +z
//					png "test.png"
					png "decals2.png" // nose number plate
					once
					}
				}
				finish { ambient .1 }
//				rotate y*180
//				translate <1,0,0>
				rotate z*21
				scale <1.2*Feet,1.2*Feet*120/400,1>
				translate <1.7*Feet,1.1*Feet,0>
			}
			texture { // topcoat
				pigment { rgbt<1,1,1,1> }
				finish { specular 0.99 roughness 0.03 }
			}
		}

	} // end union



//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 14
		location  <3*Feet, -42*Feet, 12*Feet> // overall
		look_at <5*Feet,0,4*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { Speeder scale 1.6 rotate <90,0,0> rotate <0,0,0> translate <0,0 ,18> }
object { Speeder scale 1.6 rotate <90,0,-70> rotate <0,0,0> translate <-10,80 ,18> }

#end
