
// Glenn's POV-Ray Scene File - Speeders in the City
// created 28-Nov-03
// last update 31-Dec-03
// copyright 2003 Glenn McCarter (glenn@mccarters.net)
//
// This scene uses RH coordinate system, Z = up.



//===============================================
//             Scene Switches
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare Radiosty = 0; // 0=off, 1=quick, 2=best radiosity
#declare FocalBlur = 0; // 0=off, 1=focal blur
#declare DoFog = 1; // 0=no fog, 1=fog
#declare AreaSun = 0; // 0=normal light, 1=area light for the sun
#declare Wet = 0; // 0=dry, 1=wet sidewalks
#declare DoSpeeder = 1; // 0=use simple speeder, 1=detailed
#declare DoGlow = 1; // 0=no glow, 1=glows under speeder
#declare DoPeople = 1; // 0=no figures, 1=include persons

//===============================================
//             Global Settings
//===============================================
                  
#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.5,0.5,0.5>
	ambient_light <0.1,0.1,0.1>
//	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 140
	number_of_waves 10
	noise_generator 2

#switch (Radiosty)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.5       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "GarageFurnishings.inc"
#include "CityBuildings.inc"
#include "Diner.inc"
#include "Wall.inc"
#include "Curbs.inc"

//#include "GRuler.inc" // for testing only


//===============================================
//             Variables
//===============================================

//#declare CamPos = <460*Feet,900*Feet,7*Feet>; // Camera Position


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3, 0.0,  0.0>  // aspect ratio
//	angle 35
	angle 37
	location <14*Feet,-38*Feet,3*Feet> // down the street
	look_at <5*Feet,0*Feet,4*Feet>
#if (FocalBlur = 1)
		blur_samples 100 // 100 is ok
		confidence 0.9   // this is a probability
		variance 1/1000  // 1/10000 is pretty good
		aperture 5    //lower value = wider range in focus, 10 is very blurry
		focal_point <12*Feet,10*Feet,3*Feet>
	 // end focal blur
#end
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3,     0.0,  0.0>
	angle 75
//	location <14*Feet,-38*Feet,50*Feet> // high view down the street
//	look_at <5*Feet,0*Feet,42*Feet>
	location <14*Feet,-38*Feet,80*Feet> // high view looking down
	look_at <5*Feet,0*Feet,12*Feet>
//	location <-600*Feet,500*Feet,270*Feet> // city view
//	look_at <-600*Feet,1100*Feet,100*Feet>
//	location <-14*Feet,32*Feet,8*Feet> // speeder2 view
//	look_at <-21*Feet,38*Feet,5*Feet>
//	location <-14*Feet,32*Feet,18*Feet> // reverse angle
//	look_at <0*Feet,0*Feet,8*Feet>
	}

camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare SteelTex =
	texture {
		pigment { color rgb<.24,.21,.28>*.34 }
		finish { specular 0.6 roughness .08 }
	}
#declare ConcreteTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.94 }
		normal { bumps 0.3 scale 4 }
		finish { specular 0.06 roughness .38 }
	}


//===============================================
//             Lighting
//===============================================

//object { StdBulb(100) translate <-4*Feet,4*Feet,12*Feet> }
#declare OverheadSpot =
  light_source {
    <0,0,0>
    color rgb <1, 1, 1>*100/100 // watts
    spotlight
    point_at <0,0,-100>
    radius 4    // degrees fully lit (*2)
    falloff 35*1.5   // degrees no lighting (*2)
    tightness 1
    looks_like {
			union {
				cone { // base
					<0,0,0>,8,<0,0,18>,6
				}
				torus { // base
					8,1
					rotate x*90
					scale <1,1,1.6>
				}
				sphere { // base
					<0,0,0>,6
					scale <1,1,.4>
					translate <0,0,17.3>
				}
				cylinder { // riser
					<0,0,0>,<0,0,24*Feet>,3
				}
				cylinder { // head suppport
					<0,0,0>,<60,0,24>,2
					translate <0,0,22*Feet>
				}
				cylinder { // head wire
					<0,0,0>,<27,0,-12>,0.8
					translate <0,0,24*Feet>
				}
				sphere { // head
					<0,0,0>,6
					scale <2,1,1>
					translate <60,0,24*Feet>
				}
				sphere {
					<0,0,0>,5
					scale <2,1,1>
					translate <60,0,23.4*Feet>
					texture {
						pigment { color rgb<1,.61,1> }
						finish { ambient 9 diffuse .2 }
					}
				}
				texture { SteelTex }
				translate <-60,0,-24*Feet>
			} // end union
		}
		translate <60,0,24*Feet>
	}
object { OverheadSpot rotate z*-90 translate <14,14,4> } // nearby
object { OverheadSpot rotate z*0 translate <-32*Feet,10*Feet,4> } // left side
object { OverheadSpot rotate z*-8 translate <-23*Feet,60*Feet,4> } // speeder2 spot
object { OverheadSpot rotate z*-8 translate <-32*Feet,125*Feet,4> } // gate spot

object { OverheadSpot rotate z*180 translate <4*Feet,-36*Feet,0> } // directly behind camera
object { OverheadSpot rotate z*0 translate <-27*Feet,-67*Feet,0> } // behind camera across street
object { OverheadSpot rotate z*0 translate <-29*Feet,-199*Feet,0> } // behind camera across street
object { OverheadSpot rotate z*0 translate <-40*Feet,-154*Feet,0> } // behind camera across street


#declare GirlSpot =
  light_source {
    <-26*Feet,4*Feet,60>
    color rgb <1, .58, .78>*20/100 // watts
    spotlight
    point_at <-21*Feet,34*Feet,48>+<-28,50,0>
    radius 4    // degrees fully lit (*2)
    falloff 35   // degrees no lighting (*2)
    tightness 1
  }
//object { GirlSpot } //

#declare Speeder2Headlight =
  light_source {
    <-19*Feet,50*Feet,50>
    color rgb <.77, .79, 1>*50/100 // watts
    spotlight
    point_at <-21*Feet,38*Feet,30>
    radius 1    // degrees fully lit (*2)
    falloff 48   // degrees no lighting (*2)
    tightness 1
  }
object { Speeder2Headlight } //

#declare RightSpot = // highlights the engine
  light_source {
    <0,0,0>
    color rgb <.67, .67, 1.0>*130/100 // watts
    spotlight
    point_at <-100,-20,-20>
    radius 5    // degrees fully lit (*2)
    falloff 12   // degrees no lighting (*2)
    tightness 1
		fade_distance 4*Feet
		fade_power 1
	}
object { RightSpot translate <30*Feet,0,1*Feet> }

/*
#declare GateSpot = // highlights the gate
  light_source {
    <0,0,0>
    color rgb <.97,.97,.82>*40/100 // watts
    spotlight
    point_at <0,30,-100>
    radius 8    // degrees fully lit (*2)
    falloff 45*1.5   // degrees no lighting (*2)
    tightness 1
	}
//object { GateSpot translate <-28*Feet,90*Feet,8*Feet> }
*/

#declare CitySpot = // highlights the city
  light_source {
    <0,0,0>
    color rgb <1, 1, 1>*30/100 // watts
    spotlight
    point_at <100,0,0>
    radius 12    // degrees fully lit (*2)
    falloff 35*1.5   // degrees no lighting (*2)
    tightness 1
	}
//object { CitySpot translate <30*Feet,0,1*Feet> }

#declare FarLight = // lights side of building
	light_source {
		<0,0,0>
		color rgb<1,1,.8>*.08
		fade_distance 8*Feet
		fade_power 1
	}
object { FarLight translate <-50*Feet,170*Feet,7*Feet> }

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}
/*
object { Sun
	translate <0,0,.5*Miles> // noon at Equator: directly overhead
	rotate x*50 // behind camera
  rotate z*-98// towards the left
}
*/
#if ( DoFog )

fog {
//	fog_type 1 // constant fog
	fog_type 2 // ground fog
	up <0,0,1>
	fog_alt 8*Feet
//	distance 10*Feet // deep smoke
	distance 700*Feet // deep fog
//	distance 10000*Feet // deep mist, fairly foggy
//	distance 22000*Feet // deep mist, fairly foggy
//	distance 50000*Feet // med mist, too thin
//	distance 100000*Feet // fine mist
//	distance 400000*Feet // very fine mist, almost unnoticeable
//	color rgbt<.71,.77,1,0.5> // bluish
//	color rgbt<.11,.17,.1,0.5> // blackish green
	color rgbt<.11,.11,.17,0.5> // blackish blue
}

#end

//===============================================
//             Environment
//===============================================

//background { color rgb <0.046, 0.045, 0.053> } // deep blue grey
background { color rgb <0.006, 0.005, 0.003> } // black

sky_sphere { // partly cloudy
	pigment {
//		bozo
		gradient z
		color_map { // horizon is at about .23, zenith at .75
			[ 0.0 color rgb <0.777,0.669,0.310>*.040 ] // moody horizon
			[ 0.1 color rgb <0.437,0.269,0.970>*.040 ] // mid blue
			[ 0.70 color rgb <0.467,0.469,0.670>*.008 ] // dark zenith
		}
//		scale .250
//		translate <15,25,25>
//		turbulence 0.73
//		omega 0.5		
//		rotate y*-2
	}
}

#declare BackGroundTex =
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "CrackedPavementS2.png"
				}
				scale 4*Feet
				rotate z*90
				translate <8*Feet,6*Feet+8,0>
			}
			normal { bumps 0.2 }
			finish { reflection .28 }
		}
#declare GroundPlane =
	plane { z,-0.01
		texture { BackGroundTex }
	}
object { GroundPlane }


//===============================================
//             City
//===============================================

#declare SidewalkR = 
	box {
		<0,0,0>,<100*Feet,140*Feet,4>
		texture { ConcreteTex }
	}
#declare SidewalkL =
	union {
		box { <-100*Feet,0,0>,<0,60*Feet,4> }
		box { <-100*Feet,0,0>,<0,120*Feet,4> rotate z*12 translate <0,60*Feet,0> }
		texture { ConcreteTex }
	}

#declare CurbGroup =
	union {
		object { CurbCorner(20) translate <20,20,0> }
		object { CurbSection(12*Feet) translate <20+0.3,0,0> }
		object { DrainSection translate <20+12*Feet+0.6,0,0> }
		object { CurbSection(12*Feet) translate <20+12*Feet+24+0.6,0,0> }
		object { CurbSection(12*Feet) scale <-1,1,1> rotate z*-90 translate <20,20,0> }
//		box { <20,4,0>,<100*Feet,18*Feet,3.86> texture { ConcreteTex } }
		object { Sidewalk(60) translate <20,6,3.9> }
		box { <4,20,0>,<18*Feet,100*Feet,3.86> texture { ConcreteTex } }
		cylinder { <0,0,0>,<0,0,3.85>,20-4 translate <20,20,0> texture { ConcreteTex } }
	} // end union

#declare WestWall =
	union {
		object { WallGroup(4) }
		object { WallGroup(5) rotate z*8 translate <48*Feet,0,0> }
		object { Gateway rotate z*8 translate <89*Feet,11*Feet,0> }
		object { WallGroup(4) rotate z*17 translate <105*Feet,7*Feet,0> }
	} // end union

/*
#declare MirrorWindow =
	box {
		<0,-0.1,0>,<8*Feet,1,6*Feet>
		texture {
			pigment { color rgb<0.94,0.94,1.00>*.010 }
			finish { reflection 0.20 }
		}
	}
#declare StoreWin =
	union {
		object { Store1 scale <-1,1,1> rotate z*-90 }
		object { MirrorWindow translate <4*Feet,0*Feet,20> }
	} // end union
*/

#declare BigHNN =
	union {
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z
				png "HNN_ScreenCapM.png"
				once
				}
			}
			finish { ambient 2 }
		}
		scale <20*Feet,20*Feet*3/4,1>
		rotate x*90
	}
		box {
			<-5,-0.5,-5>,<20*Feet+5,10,20*Feet*3/4+5>
			texture { pigment { rgb<.09,.09,.05>} finish { specular 0.4 roughness .06 }}
		}
	} // end union
#declare BigScreenBlock =
	union {
		object { BlockOBuildingsS1 scale <-1,1,1> }
		object { BigHNN rotate z*-90 translate <-95*Feet,30*Feet,25*Feet> }
	} // end union


//===============================================
//                  Speeder
//===============================================

#declare SpeederRot = <0,0,-24>;
//#declare SpeederRot = <0,0,-34>;
//#declare SpeederPos = <3*Feet,0,1*Feet>;
#declare SpeederPos = <2*Feet,-4,9.3>;
#declare Speeder2Rot = <0,0,90>;
#declare Speeder2Pos = <-21*Feet,34*Feet,1*Feet>;
//#declare Speeder2Pos = <-11*Feet,22*Feet,1*Feet>; // test

#if ( DoSpeeder )
	#include "Speeder.inc"
//	object { Speeder scale 1.6 rotate <90,0,0> rotate SpeederRot translate SpeederPos }
	object { Speeder scale <1.73,1.6,1.6> rotate <90,0,0> rotate SpeederRot translate SpeederPos }

	#declare SpeederTex =
		texture {
//			pigment { color rgb<.254,.283,.964>*5.0 } // too glowing blue
//			pigment { color rgb<.354,.583,.764>*5.0 } // ok bluish grey
//			pigment { color rgb<.154,.983,.164>*5.0 } // greenish yellow yuk
//			pigment { color rgb<.006,.383,.044>*5.0 } // glowing dark puke green
			pigment { color rgb<.006,.383,.044>*1.0 } // glowing dark puke green
//			pigment { color rgb<.701,.213,.084>*5.0 } // punkin orange
			finish { ambient 0.3 diffuse 0.3 specular 0.95 roughness 0.04 reflection 0.34 } // nice metallic sheen with a 1.3 white
		}
	#declare SpeederPaint =
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test.png"
			png "decalsBlue.png" // blue speeder
			once
			}
		}

	#include "Speeder.inc"
	object { Speeder scale 1.6 rotate <90,0,0> rotate Speeder2Rot translate Speeder2Pos }
#end // DoSpeeder

#if ( DoGlow )

#declare Spark1 =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z
//				png "test.png"
				png "Spark1.png" // 
				once
				}
			}
			finish { ambient 8 }
		}
		no_shadow
		scale <28,18,0.01>
		rotate x*90
	}
#declare Spark2 =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z
//				png "test.png"
				png "Spark2.png" // 
				once
				}
			}
			finish { ambient 13.5 }
		}
		scale <6,6,0.01>
		rotate x*90
	}
#declare GlowHaze =
	sphere {
		<0,0,0>,24
		scale <2,1,1>
		hollow on
		texture { pigment { rgbt<1,1,1,1> } }
		interior {
			media {
				emission <.0035,.0035,.010>
				density { spherical scale <40,20,20> }
			}
		}
	}
#declare GlowLight =
	// sphere { <0,0,0>,2 texture { SpeederTex } } // test
	light_source {
		<0,0,0>
		color rgb<0.72,0.72,1.00>
		fade_distance 1.2
		fade_power 1
	}
#declare GL = 8; // inches between glow lights
#declare SpeederGlow =
	union {
		object { GlowLight translate <1*GL,-6,0> }
		object { GlowLight translate <1*GL,6,0> }
		object { GlowLight translate <3*GL,-6,0> }
		object { GlowLight translate <3*GL,6,0> }
		object { GlowLight translate <-4*GL,0,8> }
		object { GlowHaze }
		object { Spark1 translate <0,12,-12>}
		object { Spark2 translate <8,-32,-4>}
		translate <9.0*Feet,0,0>
	} // end union
#declare Speeder2Glow =
	union {
		object { GlowLight translate <1*GL,-6,0> }
		object { GlowLight translate <1*GL,6,0> }
		object { GlowLight translate <3*GL,-6,0> }
		object { GlowLight translate <3*GL,6,0> }
		object { GlowLight translate <-4*GL,0,8> }
		object { GlowHaze }
		object { Spark1 translate <0,24,-12>}
		object { Spark2 translate <8,-32,-4>}
		translate <9.0*Feet,0,0>
	} // end union
#end // DoGlow

#declare SpeederTTex =
	texture {
		pigment { color rgb<.954,.983,.964>*1.0 }
		finish { ambient 0.3 diffuse 0.3 specular 0.95 roughness 0.04 } // temporary
	}

#declare SpeederStandin =
	union {
		cone { <0,0,3*Feet>,2,<5*Feet,0,3*Feet>,12 }
		cylinder { <5*Feet,0,3*Feet>,<11*Feet,0,3*Feet>,12 }
		box { <7*Feet,0,3*Feet-3>,<10*Feet,6*Feet,3*Feet> rotate x*-8 }
		box { <7*Feet,0,3*Feet-3>,<10*Feet,-6*Feet,3*Feet> rotate x*8 }
		cylinder { <0,0,0>,<8,0,0>,4 // fake headlight
			translate <40,0,24>
			texture { pigment { rgb<1,1,1>*10} finish { ambient 25 } }
		}
		translate <0,0,-2*Feet>
		texture { SpeederTTex }
	} // end union

#declare RS = seed(43098);
#declare FarSpeederSwarm =
	union {
		#declare SN = 0;
		#while ( SN < 160 )
			object { SpeederStandin
				rotate x*(-30+rand(RS)*60)
				rotate z*rand(RS)*360
				translate <rand(RS)*400*Feet,rand(RS)*1200*Feet,80*Feet+rand(RS)*350*Feet>
			}
			#declare SN = SN + 1;
		#end
	} // end union

//===============================================
//                  People
//===============================================

#if (DoPeople)

//cylinder { <0,0,0>,<0,0,5.5*Feet>,6 texture { ConcreteTex }}// test
#include "Girl1.inc"
object { Girl1 scale 88 rotate <90,0,165> translate <-21*Feet,34*Feet,0>+<-28,50,0> }
#include "Rider.inc"
object { Rider scale 88 rotate <90,0,0> translate <-21*Feet,34*Feet,0>+<0,82,10> }

#end


//===============================================
//             Object Placement
//===============================================

//object { SidewalkR rotate z*-8 translate <-1*Feet,0,0> }
object { CurbGroup rotate z*-8 translate <-3*Feet,-16,0.1> }
object { SidewalkL rotate z*-8 translate <-30*Feet,0,0> }
object { WestWall rotate z*84 translate <(-24-12)*Feet,6*Feet,0> }

//object { CornerDiner rotate z*-8 translate <3*Feet,6*Feet,4> }
object { CornerDiner scale <.93,1,1> rotate z*-8 translate <4.5*Feet,6*Feet,4> }
object { BlockOBuildings1 scale <1,-1,1> rotate z*-8 translate <3*Feet,-39*Feet,4> } // behind camera
object { BlockOBuildings1 scale <-1,1,1> rotate z*82 translate <-33*Feet,-39*Feet,4> } // behind camera
object { BlockOBuildings1 scale <-1,1,1> rotate z*110 translate <-43*Feet,-159*Feet,4> } // behind camera

object { BlockOBuildings1 scale <-1,1,1> rotate z*-55 translate <-20*Feet,200*Feet,0*Feet> }
object { BigScreenBlock rotate z*(180) translate <-100*Feet,-30*Feet,0> rotate z*-55 translate <-20*Feet,200*Feet,0*Feet> }

object { BigTower1 rotate z* 20 translate <-500*Feet,1100*Feet,0> }
object { Headquarters1 rotate z*30 translate <-650*Feet,1100*Feet,-30*Feet> }
object { Pyramid rotate z*-30 translate <-700*Feet,1250*Feet,-30*Feet> }
//object { Pyramid rotate z*-30 translate <-350*Feet,1200*Feet,-30*Feet> }

object { FarSpeederSwarm translate <-800*Feet,1000*Feet,0> }

#if (DoSpeeder=0)
	object { SpeederStandin rotate SpeederRot translate SpeederPos }
	object { SpeederStandin rotate Speeder2Rot translate Speeder2Pos }
#end

#if (DoGlow)
	object { SpeederGlow rotate SpeederRot translate SpeederPos }
	object { Speeder2Glow rotate Speeder2Rot translate Speeder2Pos }
#end

//OLD VERSIONS, IGNORE
/*
//object { TestSphereWhite scale 3*Feet translate <0,-5*Feet,0> }
*/
//object { StoreWin rotate z*-10 translate <8*Feet,6*Feet,4> }
//object { Diner rotate z*-190 translate <-12*Feet,-39*Feet,0> }
