
// POV-Ray Object File - Speeder Controls
// created 27-Dec-03
// last update 27-Dec-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "SpeederControls.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// HandlebarTiltGroup(GripRotDeg)
// HandlebarGroup(Tilt)
// ControlGroup
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// 
// 
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare ControlTex =
	texture {
//		pigment { color rgb<.610,.614,.928> }
		pigment { color rgb<.010,.014,.028> }
		finish { specular 0.83 roughness .02 }
	}

#declare GripTex =
	texture {
		pigment { color rgb<.110,.141,.718> }
		finish { phong .2 phong_size 17 }
	}

#declare IllumTex =
	texture {
		pigment { color rgb<.110,.141,.718> }
		finish { ambient 0.7 phong .2 phong_size 17 }
	}

#declare ChromeTrimTex =
	texture {
		pigment { color rgb<.99,.99,.99>*.38 }
		finish { specular 0.83 roughness 0.024 reflection 0.68}
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

//----------- Handlebars -----------------

#declare BrakeHandleAssy =
	union {
		box { // base
			<0,0,-0.2>,<1.8,2.1,.2>
		}
		sphere_sweep {
			b_spline
			6,
			<-1,0,0>,0.3,<0,0,0>,0.3,
			< 2,-0.3,0>,0.25,<4,-0.3,0>,.25,
			<6,0.9,0>,0.29,<7,1.2,0>,0.29
			scale <1,1,.6>
			translate <0,1.0,0>
		}
		texture { ControlTex }
	} // end union

#declare SwitchAssy =
	union {
		object { RoundedHalfBox(.3) // centered on origin
			scale <.4,1.4,1.4>
			translate <0,0.0,0.0>
			texture { ControlTex }
		}
		box {
			<-0.13,-0.88,-0.6>,<0.13,0,0.6>
			texture { IllumTex }
		}
	} // end union

#declare HandGripAssyRH =
	union {
		cylinder { // main
			<0,0,0>,<6,0,0>,.6
			texture { GripTex }
		}
		cylinder { // near flange
			<-0.13,0,0>,<0,0,0>,.9
			texture { GripTex }
		}
		sphere { // far flange
			<0,0,0>,.7
			scale <.6,1,1>
			translate <6,0,0>
			texture { GripTex }
		}
		cylinder { // handlebar end
			<-4,0,0>,<0,0,0>,.5
		}
		box { // brake cyl
			<-2,-1,-1>,<-0.4,1,1.0>
		}
		cylinder { // brake cyl
			<-1.6/2,0,0>,<-1.6/2,0,2>,0.8
		}
		object { BrakeHandleAssy translate <0,0.6,0> }
		object { SwitchAssy translate <-2.5,0,0> }
		object { SwitchAssy scale 0.8 translate <-3.0,0,0> }
		object { SwitchAssy scale 0.8 translate <-3.5,0,0> }
		texture { ControlTex }
	} // end union

#declare HandlebarBaseGroup =
	union {
		object { RoundedHalfBox(.4)
			scale <6,2.8,2>
			translate <0,0,1>
			texture { GripTex }
		}
		cylinder { // hub L strut
			<0,0,-6>,<0,0,2.5>,1
			scale <.6,1,1>
			translate <-2.4,0,0>
		}
		cylinder { // hub L strut
			<0,0,-6>,<0,0,2.5>,1
			scale <.6,1,1>
			translate <2.4,0,0>
		}
		texture { ControlTex }
	} // end union

#declare HandlebarStructureRH =
	union {
		cylinder { // base
			<0,0,0>,<3,0,0>,0.8
			scale <1,1.5,.6>
			rotate y*-10
			translate <3,0,0>
		}
		cylinder { // riser
			<0,0,0>,<6,0,0>,0.8
			scale <1,1.5,.6>
			rotate y*-50
			translate <5.5,0,0.5>
		}
		texture { ControlTex }
	} // end union


//----------- Instruments -----------------

#declare RS = seed(32095);
#macro Instrument1() // origin at faceplate
	union {
		difference {
			cylinder { // main
				<0,0,-1.6>,<0,0,0.3>,2.1
			}
			cylinder {
				<0,0,-1>,<0,0,1>,2.0
			}
		} // end difference
		cylinder { // face
			<0,0,-1>,<0,0,0>,2.0
			texture { IllumTex }
		}
		sphere { // pointer hub
			<0,0,0>,.2
			texture { ChromeTrimTex }
		}
		prism {
			linear_spline
			0.1,0.2,4
			<0.18,0>,<0,1.6>,<-0.18,0>,<0.18,0>
			rotate x*-90
			rotate z*(-60+rand(RS)*120)
			translate <0,0,0.14>
//			scale 20 
			texture { ControlTex }
		}
		torus { // chrome trim ring
			2.05,0.14
			rotate x*90
			scale <1,1,3>
			texture { ChromeTrimTex }
		}
		texture { ControlTex }
	} // end union
#end

#declare ICBase =
	union {
		box {
			<-5,-3,-4>,<5,3,-1.5>
		}
		cylinder {
			<0,0,-12>,<0,0,0>,2.3
			scale <.4,1,1>
			rotate x*-20
			translate <-3,0,-2>
		}
		cylinder {
			<0,0,-12>,<0,0,0>,2.3
			scale <.4,1,1>
			rotate x*-20
			translate < 3,0,-2>
		}
		texture { ControlTex }
	} // end union

#declare InstrumentCluster =
	union {
		object { ICBase translate <0,0,-1> }
		object { Instrument1() translate <-3,0,0> }
		object { Instrument1() translate < 3,0,0> }
		object { Instrument1() scale <.3,.3,.6> translate <-0.8,1.6,0.6> }
		object { Instrument1() scale <.3,.3,.6> translate < 0.8,1.6,0.6> }
		object { Instrument1() scale <.6,.6,.8> translate <0,-2,0> }
	} // end union

#declare InstrumentGroup =
	union {
		object { InstrumentCluster }
	} // end union

//===============================================
//             Object Groups
//===============================================

#macro HandlebarTiltGroup(GripRotDeg)
	union {
		object { HandlebarStructureRH translate <0,0,1> }
		object { HandlebarStructureRH scale <-1,1,1> translate <0,0,1> }
		object { HandGripAssyRH rotate <0,20,-GripRotDeg> translate <9,0,6> }
		object { HandGripAssyRH scale <-1,1,1> rotate <0,-20,GripRotDeg> translate <-9,0,6> }
	} // end union
#end

#macro HandlebarGroup(Tilt)
	union {
		object { HandlebarBaseGroup }
		object { HandlebarTiltGroup(30) rotate x*Tilt }
	} // end union
#end

#declare ControlGroup =
	union {
		object { HandlebarGroup(23) rotate x*20 }
		object { InstrumentGroup rotate x*50 translate <0,1,4> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1, -4*Feet, 1.3*Feet> // overall
		look_at <0*Feet,0,8>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


//object { HandlebarGroup(23) rotate x*20 rotate z*15 translate <0*Feet,0*Feet,3> }
//object { HandlebarGroup(23) rotate x*20 rotate z*125 translate <-2.3*Feet,5*Feet,3> }
object { ControlGroup rotate z*15 translate <0*Feet,0*Feet,3> }
object { ControlGroup rotate z*125 translate <-2.3*Feet,5*Feet,3> }
object { ControlGroup rotate z*-45 translate < 1.8*Feet,8*Feet,3> }

#end
