
// POV-Ray Object File - Wall
// created 14-Dec-03
// last update 20-Dec-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Wall.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// WallSection
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Engine origin is along the main driveshaft, with Z=up
// Exhaust pipes extend into +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare CapStoneTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgb<.667,.685,.603>*.8 ]
				[ 0.8 rgb<.667,.685,.603>*1.0 ]
				[ 1.0 rgb<.667,.685,.603>*.8 ]
			}
			scale <2,6,6>
			translate <0,0,5>
			turbulence 0.18
		}
		finish { ambient 0.1 specular 0.2 roughness .13 }
	}

#declare BaseStoneTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 rgb<.667,.685,.603>*0.45 ]
				[ 0.80 rgb<.667,.685,.603>*0.86 ]
				[ 0.92 rgb<.667,.685,.603>*0.56 ]
			}

			turbulence 0.2
			scale <4,14,14>
		}
		finish { ambient 0.1 specular 0.2 roughness .13 }
	}

#declare PillarStoneTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 rgb<.667,.685,.603>*0.9 ]
				[ 0.5 rgb<.667,.685,.603>*0.6 ]
				[ 1.0 rgb<.667,.685,.603>*0.9 ]
			}
			scale 7
		}
		finish { ambient 0.1 specular 0.2 roughness .13 }
	}
#declare WallTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 rgb<.432,.403,.420> ]
				[ 0.20 rgb<.632,.603,.620> ]
				[ 0.90 rgb<.832,.803,.820> ]
				[ 1.00 rgb<.432,.403,.420> ]
			}
			scale <1,1,6>
		}
	}


//===============================================
//             Macros
//===============================================

#macro WallSection(Length)
	union {
		difference {
			box {
				<0,-6,0>,<Length,6,14>
			}
			box { <-1,-2,0>,<Length+1,2,2> rotate x*45 translate <0,-5.5,13> }
			texture { BaseStoneTex }
		} // end difference
		box {
			<0,-3,12>,<Length,3,58>
			texture { WallTex }
		}
		box {
			<0,-5,58>,<Length,5,64>
			texture { CapStoneTex }
		}
	} // end union
#end

//===============================================
//             Objects
//===============================================

#declare WoodFenceS =
	box {
		<-200*Feet,0,0>,<0,300*Feet,6*Feet>
		texture { CapStoneTex }
	}

#declare Pillar =
	union {
		box {
			<-12,-12,0>,<12,12,12>
			texture { BaseStoneTex }
		}
		box {
			<-12+1.6,-12+1.6,12>,<12-1.6,12-1.6,14>
			texture { BaseStoneTex }
		}
		box {
			<-9,-9,12>,<9,9,65>
			texture { PillarStoneTex }
		}
		difference {
			box {
				<-10,-10,65>,<10,10,71>
			}
			box { <-13,-2,0>,<13,2,2> rotate x*45 translate <0,-10+0.5,70> }
			box { <-13,-2,0>,<13,2,2> rotate x*45 rotate z*180 translate <0,10-0.5,70> }
			box { <-13,-2,0>,<13,2,2> rotate x*45 rotate z*90 translate <10-0.5,0,70> }
			box { <-13,-2,0>,<13,2,2> rotate x*45 rotate z*-90 translate <-10+0.5,0,70> }
			texture { CapStoneTex }
		} // end difference
	} // end union

#macro WallGroup(Sections)
	union {
	#declare PCount = 0;
	#while ( PCount < Sections )
		object { Pillar scale 1 translate <PCount*12*Feet,0,0> }
		object { WallSection(12*Feet) translate <PCount*12*Feet,0,0> }
		#declare PCount = PCount + 1;
	#end
	} // end union
#end

#declare Lintel =
	box {
		<-10,0,0>,<8*Feet+10,8,16>
		texture { BaseStoneTex }
	}
#declare GatewayPost =
	union {
		box { <-14,-14,0>,<14,14,20> texture { BaseStoneTex } }
		object { Pillar translate <0,0,20> }
	} // end union
#declare Gateway =
	union {
		object { GatewayPost }
		object { GatewayPost translate <8*Feet,0,0> }
		object { Lintel translate <0,0,20+71> }
		object { WallSection(8*Feet) scale <-1,1,1> rotate z*40 }
		object { WallSection(8*Feet) rotate z*-40 translate <8*Feet,0,0> }
		object { Pillar translate <15*Feet,-5*Feet,0> }
		object { Pillar translate <-7*Feet,-5*Feet,0> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <3*Feet, -42*Feet, 15*Feet> // overall
		look_at <0*Feet,0,8*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

#declare WallGroupT =
	union {
		object { Pillar scale 1 translate <0,0,0> }
		object { WallSection(12*Feet) translate <-49,0,0> }
	} // end union
//object { WallGroupT rotate z*40 translate <-24,0,0> }
//object { Gateway rotate z*0 translate <0,12*Feet,0> }

#declare WestWall =
	union {
		object { WallGroup(4) }
		object { WallGroup(3) rotate z*8 translate <48*Feet,0,0> }
		object { Gateway rotate z*8 translate <89*Feet,11*Feet,0> }
		object { WallGroup(4) rotate z*17 translate <105*Feet,7*Feet,0> }
	} // end union

object { WestWall rotate z*55 translate <-40*Feet,-50*Feet,0> }

#end
