#include "colors.inc"
#include "metals.inc"
#include "glass.inc"

#include "diamond.pov"
#include "vines.pov"


// scale : centimetres


// dimensions

#declare shaft_height = 250;
#declare shaft_diameter = 6;
#declare base_diameter = 25;
#declare base_height = 7.5;
#declare gem_height = 45;
#declare gem_width = 20;
#declare gem_sides = 8;

// textures

#declare post_texture = texture {
	T_Chrome_1A
	normal { bumps 0.1 scale 0.01 }
	}
#declare gem_texture = texture {
	T_Glass1
	}

// lamppost macros

// macro for dkgdome
#macro _global_LampPost (X, Y, Z, Rot, Flip)
	object {
		geo_lamppost
		rotate x * 90
		scale 0.01
		translate <X, Y, Z>
	}
#end

// normal macro
#macro lamppost ()
	object {
		geo_lamppost
	}
#end

#declare geo_lamppost = union {

// base

sor {
	4
	<0, -0.5>
	<base_diameter, 0>
	<base_diameter * 0.5, base_height>
	<0, base_height * 0.5>
	texture { post_texture }
	
	bounded_by {
		box {
			<-base_diameter, 0, -base_diameter>
			<base_diameter, base_height * 1.1, base_diameter>
		}
	}
}

// shaft

cylinder {
	0
	y * shaft_height
	shaft_diameter / 2
	texture { post_texture }
}

// vines

object {
	// twisted_vines (total_height, total_radius, number_vines, strands_per_vine, strand_thickness, strand_turbulence,
						// twist_revolutions, twist_steps, top_split_range, top_radius, bottom_split_range, bottom_radius)
	twisted_vines (shaft_height * 1.12, shaft_diameter/2, 3, 3, 0.8, 2, 4, 30, 30, 15, base_height * 2, base_diameter / 2 * 1.75)
	rotate x * -90
	translate <0, -6, 0>
	
	texture { post_texture }
}


// gem

object {
	diamond (gem_sides, gem_width, gem_height * 0.35, gem_width * 0.5, gem_height * 0.2, gem_height * 0.65, gem_width * 0.2, gem_height * 0.45, gem_width * 0.98)
	translate y * (shaft_height + gem_height)
	
	texture { gem_texture }
	interior { I_Glass /*caustics 1*/ }
	hollow on
}

// gem glow

object {
sphere {
	0, 1
	pigment { rgbt <0, 0, 0, 1> }
	hollow on
	no_shadow
	interior {
		media {
			scattering { 2 rgb 0.5 }
			absorption 0
			density {
				spherical
				color_map {
					[ 0 rgb 0 ]
					[ 1 rgb 0.35 ]
				}
				//scale gem_width * 1.25
			}
		}
	}
}
scale gem_height * 1.5//0.7
translate y * (shaft_height + gem_height / 2)
}

// gem light
light_source {
	y * (shaft_height + gem_height + 10)
	rgb 0.18
	fade_distance 10
	fade_power 2
}

}