#!/usr/bin/python
from log import FileLog
from povwrite import PovWrite
from partsman import PartsManager
from numarray import *
import __builtin__
import random
import math
import time

#sys.stdout = open("citygen.log",'w')

print time.time()

BoundLength = 150
BoundHeight = 28 #50
InnerRad = 75
CheatBoundLength = 175

Parallelogramation = 10
DistributionFootprint = 100
SmallParallelogramation = 10
SmallDistributionFootprint = 50 #25

MaxVolume = 1600
TowerThresh = 0.5

DoorThresh = 0.2
DoorFootprint = 5 #10

allsides = 32|16|8|4|2|1
lowsides = 4|2|1
highsides = 32|16|8

CityData = zeros((BoundLength*4,BoundLength*2,BoundHeight),UInt8)

hex_offsets = ((2,0,0),(1,0,0),(0,0,0),(1,1,0),(2,1,0),(3,1,0))
def offset(center,off):
	return (center[0]+hex_offsets[off][0],center[1]+hex_offsets[off][1],center[2]+hex_offsets[off][2])

move_offsets = ((2,0,0),(2,1,0),(0,1,0),(-2,0,0),(-2,-1,0),(0,-1,0))
def move_offset(center,off):
	return (center[0]+move_offsets[off][0],center[1]+move_offsets[off][1],center[2]+move_offsets[off][2])

def getAngles(sides):
	width = (sides&1+0) + ((sides&2)>0+0) + ((sides&4)>0)
	width += ((sides&8)>0) + ((sides&16)>0) + ((sides&32)>0)

	if not ((width == 6) or (width == 0)):
		if(width > 3):
			sides = (~sides)&allsides
			if width == 5:
				angle = 1
			else:
				angle = 2
		else:
			angle = 0

		low = sides & lowsides
		high = (sides & highsides) >> 3
		if high > low:
			sides = (low << 3) | high
			angle += 3
			#print "Swapped"
                        
		#print sides
		while (not (sides&1)):
			angle += 1
			sides = sides >> 1

		if angle > 5:
			angle -= 6
	else:
		angle = 0
		
	return (width,angle)

def getAnglesFromPos(center):
	#@TODO:  this should probably be handled intelligently elsewhere
	if (center[0] <= 1)|(center[0] >= BoundLength*4-2)|(center[1] <= 1)|(center[1] >= BoundLength*2-2):
		return (0,0)
	if(center[2]>=BoundHeight-1):
		return (0,0)
	#print CityData.getshape()
	#print center
	#print offset(center,0)
	#print offset(center,1)
	#print offset(center,2)
	sides = (CityData[offset(center,0)]&1) + ((CityData[offset(center,1)]&1)<<1) + ((CityData[offset(center,2)]&1)<<2)
	sides += ((CityData[offset(center,3)]&1)<<3) + ((CityData[offset(center,4)]&1)<<4) + ((CityData[offset(center,5)]&1)<<5)
	return getAngles(sides)

def buildHex(pX,pY,pW,pZ,pXLen,pYLen,pWLen,pZLen,Val):
	pX += BoundLength - (pXLen + pWLen)/2
	pY += BoundLength - (pYLen + pWLen)/2
	y = 0
	while(y < pYLen + pWLen):
		offset1 = y - pYLen
		if offset1 < 0:
			start = pX*2 
		else:
			start = (pX + offset1)*2 + 1

		offset2 = y - pWLen
		if offset2 >= 0:
			end = (pX + pXLen + pWLen)*2
		else:
			end = (pX + pXLen + y)*2 + 1
		#dist = end - start
		#CityData[arange(dist)[:,NewAxis]+start+pW*2,y+pY+pW,arange(pZLen)[:,NewAxis][:,:,NewAxis]+pZ] = Val
		CityData[(start-pW*2):(end - pW*2),y+pY-pW,pZ:(pZ + pZLen)] = Val
		y += 1

def checkHex(pX,pY,pW,pZ,pXLen,pYLen,pWLen,pZLen):
	pX += BoundLength - (pXLen + pWLen)/2
	pY += BoundLength - (pYLen + pWLen)/2
	if((pX - pW < 0) or (pX + pXLen + pWLen - pW >= BoundLength*2)):
		return False
		print "Bad bound"
	if((pY - pW < 0) or (pY + pYLen + pWLen - pW >= BoundLength*2)):
		return False
		print "Bad bound"
	if(pZ > BoundHeight - 2):
		print "Bad height"
		return False

	return True	
	#print ((pX+pW)*2+1,pY+pW,pZ)
	if(CityData[(pX+pW)*2+1,pY+pW,pZ]&1):
		if(CityData[(pX+pXLen+pW)*2-1,pY+pW,pZ]&1):
			if(CityData[(pX+pXLen+pWLen+pW)*2-1,pY+pWLen+pW,pZ]&1):
				if(CityData[(pX+pXLen+pWLen+pW)*2-1,pY+pYLen+pWLen+pW-1,pZ]&1):
					if(CityData[(pX+pWLen+pW)*2-1,pY+pYLen+pWLen+pW-1,pZ]&1):
						if(CityData[(pX+pW)*2+1,pY+pYLen+pW,pZ]&1):
							return True
	print "Not touching"
	return False
	
def checkHeight(pX,pY,pW):
	if ((pX - pW)<= -BoundLength) or ((pX - pW)>= BoundLength):
		return -1
	if ((pY - pW)<= -BoundLength) or ((pY - pW)>= BoundLength):
		return -1
	return add.reduce(CityData[(pX-pW+BoundLength)*2,pY-pW+BoundLength]&1)

def indexToPos(index):
	return (index[0]/2 - BoundLength,index[1]-BoundLength,index[2])

totaldoors = 0
def buildDoor(pos):
	midpos = (pos[0],pos[1],pos[2]+1)
	toppos = (pos[0],pos[1],pos[2]+2)
	angles = getAnglesFromPos(midpos)

	#sides = (CityData[offset(midpos,0)]&1) + ((CityData[offset(midpos,1)]&1)<<1) + ((CityData[offset(midpos,2)]&1)<<2)
	#sides += ((CityData[offset(midpos,3)]&1)<<3) + ((CityData[offset(midpos,4)]&1)<<4) + ((CityData[offset(midpos,5)]&1)<<5)
	
	endangle = angles[1]+angles[0]-1
	if endangle > 5:
		endangle -= 6
	if endangle == 5:
		stylebottom = CityData[pos] >> 4
	else:
		stylebottom = CityData[offset(pos,endangle+1)] >> 4
	
	styletop = CityData[offset(midpos,angles[1])] >> 4

	if (CityData[pos]&2)|(CityData[midpos]&2)|(CityData[toppos]&2):
		#print "Bad Door at"+`indexToPos(pos)`
		return False
	#out.simplewrite(parts.getPart(parts.Styles[styletop]["NAME"]+'_door',(pX+pW,pY+pW,pZ),angles[1]*60))
	#out.simplewrite(parts.getPart(parts.Styles[stylebottom]["NAME"]+'_basesegbottom_360',(pX+pW,pY+pW,pZ),0))

	globals()["totaldoors"]+=1
	
	out.simplewrite(parts.getPart(parts.Styles[styletop]["NAME"]+'_door',indexToPos(pos),angles[1]*60))
	out.simplewrite(parts.getPart(parts.Styles[stylebottom]["NAME"]+'_basesegbottom_360',indexToPos(pos),0))
	#out.simplewrite(parts.getPart(parts.Styles[stylebottom]["NAME"]+'_tile',offset(((pX+pW)*2,pY+pW,pZ),angles[1]),0))
	#out.simplewrite(parts.getPart(parts.Styles[stylebottom]["NAME"]+'_tile',offset(((pX+pW)*2,pY+pW,pZ),endangle),0))

	#print "Bottom,Mid,Top"
#	print pos
#	print midpos
#	print toppos
#	print CityData[pos]
#	print CityData[midpos]
#	print CityData[toppos]
	CityData[pos] |= 2
	CityData[midpos] |= 2
	CityData[toppos] |= 2

def buildDoorPos(pX,pY,pW,pZ):
	pos = ((pX-pW+BoundLength)*2,pY-pW+BoundLength,pZ+1)
	buildDoor(pos)

def placeDoor(pX,pY,pW):
	z = checkHeight(pX,pY,pW)
	if z <= 1:
		#print "Place door started too low"
		return False
	pos = ((pX-pW+BoundLength)*2,pY-pW+BoundLength,z)
	moves = 0
	while True:
		curangles = getAnglesFromPos(pos)
		curHeight = 0
		
		while not (curangles[0] == 6):
			curHeight += 1
			if pos[2] == 0:
				#print "Place door hit bottom hard"
				return False
			check = pos	#@TODO: Remove
			pos = (pos[0],pos[1],pos[2]-1)
			if not (check[0] == pos[0] and check[1] == pos[1]):
				print 1/0
			curangles = getAnglesFromPos(pos)

		if (curHeight > 3):
			if pos[2] <= 1 or random.random() > DoorThresh:
				midpos = (pos[0],pos[1],pos[2]+1)
				if getAnglesFromPos(midpos)[0]==3:
					if not CityData[midpos]&2:
						buildDoor((pos[0],pos[1],pos[2]))
						return True

		if pos[2] <= 1:
			#print "Place door hit bottom"
			return False

		startdir = random.randint(0,5)
		curdir = startdir
		while curangles[0] == 6:
			#print "Curdir:"+`curdir`
			testPos = (pos[0],pos[1],pos[2]+1)
			testPos = move_offset(testPos,curdir)
			#@TODO: Duplication
			if (testPos[0] <= 0)|(testPos[0] >= BoundLength*4)|(testPos[1] <= 0)|(testPos[1] >= BoundLength*2):
				#print "Place door out of bounds"
				return False
			if testPos[2] >= BoundHeight:
				#print "Place door out of bounds"
				return False
			if not (CityData[testPos]&1):
				pos = move_offset(pos,curdir)
				moves += 1
				curangles = getAnglesFromPos(pos)
			else:
				curdir += 1
				if curdir > 5:
					curdir -= 6
					
				if curdir == startdir:
					#print "Place door lost"
					return False
		#print "Done"
				
			
			
			
	

		
log = FileLog("citygen.log")
out = PovWrite("citylist.pov")
parts = PartsManager()
out.include(parts.getIncludeList())

print CityData.getshape()
#buildHex(6,6,6,0,6,6,6,10)

#CityData[arange(6)+6,arange(6)+6 [:,NewAxis]] |= 1
test = arange(20)[:,NewAxis]
#CityData[test,arange(10)[:,NewAxis]+10] |= 1

#print arange(10)+10
#print arange(10)[:,NewAxis][:,:,NewAxis]
#CityData[arange(10)+10,arange(10)[:,NewAxis]+10,arange(5)[:,NewAxis]+20] |= 1
BoundWidth = (CheatBoundLength - InnerRad)
BoundCenter = (CheatBoundLength + InnerRad)/2
def baseRand():
	val = random.random()
	return abs(val)*val*HalfBoundWidth + BoundCenter

def nicescale(num,scale):
	if num == 0:
		return 0
	result = int(__builtin__.round(num*scale))
	if result == 0:
		if num == 1:
			return 1
		else:
			return 2
	else:
		return result
		
			
def buildBase():
	style = parts.StyleLookup["simple"]
	buildHex(0,0,0,0,BoundLength-1,BoundLength-1,BoundLength-1,1,1+16*style)
	random.seed(0)
	i = 0
	bail = BoundLength*BoundLength*3/DistributionFootprint
	while i < bail:
		#buildX = random.randint(-BoundLength/2,BoundLength/2)
		#buildY = random.randint(-BoundLength/2,BoundLength/2)
		#buildW = random.randint(-BoundLength/2,BoundLength/2)
		randX = random.random()-0.5
		randY = random.random()-0.5
		randW = random.random()-0.5
		flatPosX = randX - randW
		flatPosY = randY - randW

		mainRand = random.random()
		if mainRand > 0.5:
			intDist = pow(mainRand-0.5,2)*2+0.5
		else:
			intDist = -pow(mainRand-0.5,2)*2+0.5
		
		#Pythagorean theorem equivalent works pretty well for 60 degrees
		dist = math.sqrt(flatPosX*flatPosX+flatPosY*flatPosY-flatPosX*flatPosY)
		scale = (pow(intDist,1)*BoundWidth + InnerRad)/dist

		buildX = int(__builtin__.round(randX*scale,0))
		buildY = int(__builtin__.round(randY*scale,0))
		buildW = int(__builtin__.round(randW*scale,0))
		
		dims = range(Parallelogramation)
		dims[0] = random.randint(2, 15)
		dims[1] = random.randint(2, 15)
		dims[2] = random.randint(2, 15)
		#colour = random.randint(0, 1)
		buildZLength = random.randint(2, 15) #25
		choose = random.randint(0,Parallelogramation-1)
		dims[choose] = 0

		#Volume in unit triangular prisms (or was it half unit triangular prisms? I rememeber working it out once)
		volume = (dims[0]*dims[1]+dims[1]*dims[2]+dims[2]*dims[0])*buildZLength

		if volume > MaxVolume:
			if random.random() < TowerThresh:
				scale = sqrt(MaxVolume/volume)
				dims[0] = nicescale(dims[0],scale)
				dims[1] = nicescale(dims[1],scale)
				dims[2] = nicescale(dims[2],scale)
				if ((dims[0] == 0) + (dims[1] == 0) + (dims[2] == 0)) > 1:
					print "Killed width"
			else:
				scale = MaxVolume/volume
				buildZLength = nicescale(buildZLength,scale)
				if buildZLength == 0:
					print "Killed height"

				
		
	
		if(checkHex(buildX,buildY,buildW,0,dims[0],dims[1],dims[2],buildZLength)):
			buildHex(buildX,buildY,buildW,0,dims[0],dims[1],dims[2],buildZLength,1+16*style)
		i += 1
		            
def buildSmall():
	smalls = 0
	notsmalls = 0
	style = parts.StyleLookup["simple"]

	random.seed(0)
	i = 0
	bail = BoundLength*BoundLength*3/SmallDistributionFootprint
	while i < bail:
		#buildX = random.randint(-BoundLength/2,BoundLength/2)
		#buildY = random.randint(-BoundLength/2,BoundLength/2)
		#buildW = random.randint(-BoundLength/2,BoundLength/2)

		randX = random.random()-0.5
		randY = random.random()-0.5
		randW = random.random()-0.5
		flatPosX = randX - randW
		flatPosY = randY - randW

		mainRand = random.random()
		if mainRand > 0.5:
			intDist = pow(mainRand-0.5,2)*2+0.5
		else:
			intDist = -pow(mainRand-0.5,2)*2+0.5

		#Pythagorean theorem equivalent works pretty well for 60 degrees
		dist = math.sqrt(flatPosX*flatPosX+flatPosY*flatPosY-flatPosX*flatPosY)
		scale = (pow(intDist,1)*BoundWidth + InnerRad)/dist

		buildX = int(__builtin__.round(randX*scale,0))
		buildY = int(__builtin__.round(randY*scale,0))
		buildW = int(__builtin__.round(randW*scale,0))

		height = checkHeight(buildX,buildY,buildW)
		if height == -1:
			i += 1
			continue
		
		dims = range(Parallelogramation)
		dims[0] = random.randint(2, 6)
		dims[1] = random.randint(2, 6)
		dims[2] = random.randint(2, 6)
		buildZLength = random.randint(2, 6)
		choose = random.randint(0,SmallParallelogramation-1)
		dims[choose] = 0
		#print repr(height)
		#print repr(buildZLength)
		#print repr(height + buildZLength)
		#totalHeight = buildZLength+height
		notsmalls += 1
		if(checkHex(buildX,buildY,buildW,0,dims[0],dims[1],dims[2],buildZLength+height)):
			buildHex(buildX,buildY,buildW,0,dims[0],dims[1],dims[2],buildZLength+height,1+16*style)
			smalls += 1
		i += 1
	print repr(smalls)+" small bits written"
	print repr(notsmalls)+" should have been" 

minscale = 10000
def buildDoors():
	random.seed(0)
	i = 0
	bail = BoundLength*BoundLength*3/DoorFootprint
	while i < bail:
		randX = random.random()-0.5
		randY = random.random()-0.5
		randW = random.random()-0.5
		flatPosX = randX - randW
		flatPosY = randY - randW

		mainRand = random.random()
		if mainRand > 0.5:
			intDist = pow(mainRand-0.5,2)*2+0.5
		else:
			intDist = -pow(mainRand-0.5,2)*2+0.5

		#Pythagorean theorem equivalent works pretty well for 60 degrees
		dist = math.sqrt(flatPosX*flatPosX+flatPosY*flatPosY-flatPosX*flatPosY)
		scale = (pow(intDist,1)*BoundWidth + InnerRad)/dist
		if scale < minscale:
			globals()["minscale"] = scale

		buildX = int(__builtin__.round(randX*scale,0))
		buildY = int(__builtin__.round(randY*scale,0))
		buildW = int(__builtin__.round(randW*scale,0))

		#print (buildX,buildY,buildW)

		placeDoor(buildX,buildY,buildW)
		i += 1



#buildHex(0,0,0,0,0,5,BoundLength*2-5,BoundHeight,0)
#i = 0
#while i < 100:
#	 buildHex(0,0,0,0,95,95,95,1,1)
#	 i += 1

def buildTest1():
	buildHex(0,0,0,0,7,7,7,3,1)
	buildHex(0,0,0,0,6,6,6,4,1)

	buildHex(0,5,0,1,2,6,2,6,1)
	buildHex(5,0,0,1,6,2,2,6,1)
	buildHex(0,0,5,1,2,2,6,6,1)

	#buildHex(0,5,0,1,2,0,2,7,1)
	#buildHex(5,0,0,1,0,2,2,7,1)
	#buildHex(0,0,5,1,2,2,0,7,1)

	#buildHex(0,3,0,1,3,0,3,7,1)
	#buildHex(3,0,0,1,0,3,3,7,1)
	#buildHex(0,0,4,1,3,3,0,7,1)

	buildHex(0,5,0,1,2,1,2,9,1)
	buildHex(5,0,0,1,1,2,2,9,1)
	buildHex(0,0,5,1,2,2,1,9,1)

	#buildHex(0,3,0,1,3,0,3,9,1)
	#buildHex(3,0,0,1,0,3,3,9,1)
	#buildHex(0,0,4,1,3,3,0,9,1)

	buildHex(0,3,0,1,1,3,1,9,1)
	buildHex(3,0,0,1,3,1,1,9,1)
	buildHex(0,0,4,1,1,1,3,9,1)
	
	buildHex(0,3,0,1,2,0,2,10,1)
	buildHex(3,0,0,1,0,2,2,10,1)
	buildHex(0,0,3,1,2,2,0,10,1)

def buildTest2():
	buildHex(0,0,0,0,21,21,21,1,1)
	#buildHex(0,0,0,0,20,20,20,4,1)
	buildHex(0,0,0,0,3,3,3,12,1)
	buildHex(0,0,0,0,5,5,5,7,1)


def buildTest3():
	buildHex(0,0,0,0,21,21,21,1,1)
	buildHex(0,0,0,0,3,3,3,12,1)
	buildHex(0,0,4,0,5,5,5,7,1)
	buildHex(0,2,0,0,4,4,4,4,1)

def buildLamp(X,Y,W,Z):
	out.simplewrite(parts.getPart("global_LampPost",(X-W,Y-W,Z),0))
	
def buildCenter():
	style = parts.StyleLookup["simple"] << 4

	i = 1
	while i<6:
		buildHex(0,0,0,0,21-i,21-i,21-i,i,1)
		i+=1
	#buildHex(0,0,0,0,20,20,20,4,1)
	buildHex(-15,0,0,0,3,3,3,10,1+style)
	buildHex(0,-15,0,0,3,3,3,10,1+style)
	buildHex(0,0,-15,0,3,3,3,10,1+style)

	buildHex(-13,0,0,0,2,2,2,13,1+style)
	buildHex(0,-13,0,0,2,2,2,13,1+style)
	buildHex(0,0,-13,0,2,2,2,13,1+style)

	buildHex(-12,0,0,0,1,1,1,15,1+style)
	buildHex(0,-12,0,0,1,1,1,15,1+style)
	buildHex(0,0,-12,0,1,1,1,15,1+style)

	buildHex(-15,0,0,0,9,5,5,6,1+style)
	buildHex(0,-15,0,0,5,9,5,6,1+style)
	buildHex(0,0,-15,0,5,5,9,6,1+style)

	buildHex(-11,0,0,0,1,1,1,9,1+style)
	buildHex(0,-11,0,0,1,1,1,9,1+style)
	buildHex(0,0,-11,0,1,1,1,9,1+style)	
	
	buildLamp(-10,4,0,5)
	buildLamp(-10,0,4,5)
	buildLamp(0,-10,4,5)
	buildLamp(4,-10,0,5)
	buildLamp(0,4,-10,5)
	buildLamp(4,0,-10,5)

	
#buildCenter()

buildCenter()

buildBase()
buildSmall()
#buildDoors()

print "There should be %s doors"%(BoundLength*BoundLength*3/DoorFootprint,)
print "Total doors:" + `totaldoors`
print "Min scale:" + `minscale`	
print "Done building"
print time.time()

def blockIn():
	test = where(CityData==1)
	i = len(test[0])-1
	while (i >= 0):
		out.prism(test[0][i]-BoundLength*2,test[1][i]-BoundLength,test[2][i])
		i -= 1
		


print "Starting craziness"
print time.time()
temp = concatenate((lshift(CityData[3::2,1:]&1,5),zeros((BoundLength*2-1,1,BoundHeight),UInt8)),1)
temp = temp + (CityData[2::2]&1) + concatenate((lshift(CityData[2::2,1:]&1,4),zeros((BoundLength*2-1,1,BoundHeight),UInt8)),1)
temp = concatenate((temp,zeros((1,BoundLength*2,BoundHeight),UInt8)),0)
temp = temp + lshift(CityData[1::2]&1,1) + concatenate((lshift(CityData[1::2,1:]&1,3),zeros((BoundLength*2,1,BoundHeight),UInt8)),1)
temp = temp + lshift(CityData[::2]&1,2)
print time.time()
print "Craziness complete"

#print CityData[where(CityData)]
#print (CityData&1)[where(CityData)]
testing = where(temp)

offsettemp = concatenate((temp[:,:,1:],zeros((BoundLength*2,BoundLength*2,1),UInt8)),2)
temp += lshift(where(temp - offsettemp > 0,1,0),6)
temp += lshift(where(offsettemp,1,0),7)


temp2 = logical_and(where(temp,1,0)&allsides,logical_or(63-temp&allsides,temp&64))

def maskFunc(x,y,z):
	return where(y+x>BoundLength*3,1,0)

mask = fromfunction(maskFunc,(4*BoundLength,2*BoundLength,BoundHeight))
mask[(-InnerRad+BoundLength)*2:(InnerRad+BoundLength)*2,-InnerRad+BoundLength:InnerRad+BoundLength,:] = 1

temp2 = logical_and(temp2,logical_not(CityData[::2]&2))
temp2 = logical_and(temp2,mask[::2])

style = "debug"
type = "side"
test = where(temp2)

i = len(test[0])-1
print "Length:" + repr(i)
while (i >= 0):
	x = test[0][i]
	y = test[1][i]
	z = test[2][i]
	val = temp[x,y,z]
	angles = getAngles(val & allsides)
	width = angles[0]
	angle = angles[1]
			
	if val&64:
		if val&128:
			type = 'base'
		else:
			type = 'top'
	else:
		type = 'side'

	if type == 'base':
	 	#i-=1
	 	#out.simplewrite(parts.getPart("Cant_Draw_This",(x-BoundLength,y-BoundLength,z),0))
	 	#continue
		
		#topsides = CityData[x*2+2,y,z] + CityData[x*2+1,y,z]<<1 + CityData[x*2,y,z]<<2
		curcenter = (x*2,y,z+1)
		botcenter = (x*2,y,z) 
		
		topangles = getAnglesFromPos(curcenter)
		topwidth = topangles[0]
		topangle = topangles[1]

		delta = topangle-angle
		if delta < 0:
			delta += 6

		if width == 6:
			endangle = topangle+topwidth-1
			if endangle > 5:
				endangle -= 6
			if endangle == 5:
				stylebottom = CityData[botcenter] >> 4
			else:
				stylebottom = CityData[offset(botcenter,endangle+1)] >> 4
			if width > 3:
				styleleft = CityData[offset(curcenter,topangle)] >> 4
				styleright = CityData[offset(curcenter,endangle)] >> 4
			else:
				styleleft = CityData[offset(curcenter,topangle)] >> 4
				styleright = styleleft
			
			if styleleft == styleright:
				if styleleft == stylebottom: 
					out.simplewrite(parts.getPart(parts.Styles[style]["NAME"]+'_'+type+'_'+repr(width*60)+'_'+repr(topwidth*60),(x-BoundLength,y-BoundLength,z),topangle*60))
				else:
					out.simplewrite(parts.getPart("splitbase_"+parts.Styles[stylebottom]["NAME"]+'_'+parts.Styles[styleleft]["NAME"]+'_'+repr(width*60)+'_'+repr(topwidth*60),(x-BoundLength,y-BoundLength,z),topangle*60))
			else:
				#@TODO
				pass
		else:
			if False:  #topangle == 3: Multi-style support
				#@TODO
				pass
			else:
				out.simplewrite(parts.getPart(parts.Styles[style]["NAME"]+'_'+type+'_'+repr(width*60)+'_'+repr(topwidth*60)+'_'+repr(delta*60),(x-BoundLength,y-BoundLength,z),angle*60))
				pass
			
	elif type == 'side':
		curcenter = (x*2,y,z)
		if width <= 3:
			style = CityData[offset(curcenter,angle)] >> 4
			#print style
			out.simplewrite(parts.getPart(parts.Styles[style]["NAME"]+'_'+type+'_'+repr(width*60),(x-BoundLength,y-BoundLength,z),angle*60))
		else:
			style1 = CityData[offset(curcenter,angle)] >> 4
			endangle = angle+width-1
			if endangle > 5:
				endangle -= 6

			style2 = CityData[offset(curcenter,endangle)] >> 4
			if style1 == style2:
				out.simplewrite(parts.getPart(parts.Styles[style1]["NAME"]+'_'+type+'_'+repr(width*60),(x-BoundLength,y-BoundLength,z),angle*60))
				pass
			else:
#@TODO				  out.part(parts.getPart('split_'+parts.Styles[style1]["NAME"]+'_'+parts.Styles[style2]["NAME"]+'_'+type+'_'+repr(width*60)),x-BoundLength,y-BoundLength,z,angle*60)
				pass
				
				
	elif type == 'top':
		curcenter = (x*2,y,z)
		style = CityData[offset(curcenter,angle)] >> 4
		#print parts.Styles[style]["NAME"]+'_'+type+'_'+repr(width*60)
		out.simplewrite(parts.getPart(parts.Styles[style]["NAME"]+'_'+type+'_'+repr(width*60),(x-BoundLength,y-BoundLength,z),angle*60))
	else:
		test = 0/0

	#if type == 'top' or type == 'base':
	#	tile1 = CityData[x*2,y,z]
	#	tile2 = CityData[x*2+1,y,z]
	#	if (tile1&1):
	#			out.simplewrite(parts.getPart(parts.Styles[tile1 >> 4]["NAME"]+'_tile',((x-BoundLength)*2,y-BoundLength,z),0))
	#	if (tile2&1):
	#			out.simplewrite(parts.getPart(parts.Styles[tile2 >> 4]["NAME"]+'_tile',((x-BoundLength)*2+1,y-BoundLength,z),0))
		
	i -= 1
	
def drawTiles():
	curstyle = 0
	maxstyle = len(parts.Styles)
	while(curstyle < maxstyle):
		test = 0
		test = where(logical_and(CityData[:,:,:-1]&1,logical_and(rshift(CityData[:,:,:-1],4)==curstyle,logical_not(CityData[:,:,1:]&1))))
		i = len(test[0])-1
		while (i >= 0):
			#print i
			out.simplewrite(parts.getPart(parts.Styles[curstyle]["NAME"]+'_tile',(test[0][i]-BoundLength*2,test[1][i]-BoundLength,test[2][i]),0))
			#-BoundLength
			i -= 1
		curstyle += 1

CityData = logical_and(CityData,mask)
drawTiles()

print time.time()
#test = 0
#1 / test
