// diamond.pov

// Diamond building macros
// By Daniel Dresser and Fraser Kuyvenhoven

#declare to_radians = pi / 180;

// brilliant cut diamond

#macro diamond_brilliant (total_diameter)
	
	#declare girdle_height = 0.01;
	#declare tot_height = total_diameter * 0.593 + girdle_height;
	
	intersection {
	union {
		object {
			half_diamond (8, total_diameter / 2, total_diameter / 2 * 0.53, total_diameter * 0.162, total_diameter * 0.162 * 0.71)
		}
		object {
			half_diamond (8, total_diameter / 2, 0, total_diameter * 0.431, total_diameter * 0.431 * 0.71)
			scale <1, -1, 1>
			translate -y * tot_height
	}
	}
		cylinder { <0, 0, 0>, <0, -tot_height, 0>, total_diameter * 0.98 / 2 }
	}
	
#end

// diamond

#macro diamond (side_number, total_radius, crown_height, crown_table_radius, crown_curve_height, pavilion_height, pavilion_table_radius, pavilion_curve_height, girdle_radius)

	intersection {
	union {
		// crown section
		object {
			half_diamond (side_number, total_radius, crown_table_radius, crown_height, crown_curve_height)
		}
		// pavilion section
		object {
			half_diamond (side_number, total_radius, pavilion_table_radius, pavilion_height, pavilion_curve_height)
			scale <1, -1, 1>
			translate -y * (crown_height + pavilion_height)
	}
	}
		// girdle
		cylinder { <0, 0, 0>, <0, -(crown_height + pavilion_height), 0>, girdle_radius }
	}

#end


// half-diamond

#macro half_diamond (side_number, total_radius, table_radius, total_height, curve_height)

	#declare table_centre_angle = 360 / side_number / 2;
	#declare table_outer_angle = 180 - 90 - table_centre_angle;
	#declare table_inner_radius = cos (table_centre_angle * to_radians) * table_radius;
	
	#declare table_outer_radius = table_radius / cos(table_centre_angle * to_radians);
	#declare intermediate_slope = total_height / (total_radius / cos(table_centre_angle * to_radians) - table_outer_radius);	
	#declare curve_radius = table_outer_radius + ( (total_height - curve_height) / intermediate_slope);
	
	#declare star_facet_angle = atan2 (total_height - curve_height, curve_radius - table_inner_radius) / to_radians;
	#declare bezel_facet_angle = atan2 (total_height, total_radius - table_radius) / to_radians;
	
	#declare hor_girdle_edge_length = sqrt ( pow(curve_radius, 2) + pow(total_radius, 2) - 2 * curve_radius * total_radius * cos(table_centre_angle * to_radians) );
	#declare hor_girdle_outer_length = sqrt ( pow(total_radius, 2) + pow(total_radius, 2) - 2 * total_radius * (total_radius) * cos(table_centre_angle * to_radians) );
	#declare hor_girdle_sumhalf = (hor_girdle_outer_length + hor_girdle_edge_length + (total_radius - curve_radius) ) / 2;
	#declare hor_girdle_altitude = (2 / hor_girdle_outer_length) * sqrt ( hor_girdle_sumhalf * (hor_girdle_sumhalf - hor_girdle_outer_length) * (hor_girdle_sumhalf - hor_girdle_edge_length) * (hor_girdle_sumhalf - (total_radius - curve_radius) ) );
	
	#declare girdle_facet_angle = atan2 (curve_height, hor_girdle_altitude) / to_radians;
	#declare girdle_facet_rot = (180 - table_centre_angle) / 2;
	
	intersection{
	
	// top face plane
	plane { y, 0 }
	
	// bezel facet faces
	planes (side_number, -bezel_facet_angle, 0, table_radius, 0)
		
	// star facet faces
	planes (side_number, -star_facet_angle, 0, table_inner_radius, table_centre_angle)
	
	// girdle facet faces
	intersection{
	planes (side_number, -girdle_facet_angle, girdle_facet_rot - 90, total_radius, 0)
	planes (side_number, -girdle_facet_angle, - (girdle_facet_rot - 90), total_radius, 0)
	translate -y * total_height
	}
	// bottom face plane
	plane { -y, total_height }
	
	// bound entire half diamond
	bounded_by {
		box { <-total_radius, 0, -total_radius> * 1.01, <total_radius, -total_height, total_radius> * 1.01 }
	}
	
	}	
#end

box { <-1, -1, -1>, <1, 1, 1> }

// planes

#macro planes(rev_num, rot_angle_z, rot_angle_y, translate_rad, rotation_offset)
	#declare rev = 0;
	#declare rev_max = 360;
	#declare rev_ran = rev_max - rev;
	#while (rev < rev_max)
		plane {
			y, 0
			rotate <0, 0, rot_angle_z>
			rotate <0, rot_angle_y, 0>
			translate <translate_rad, 0, 0>
			rotate <0, rev + rotation_offset, 0>
		}
		#declare rev = rev + (rev_ran / rev_num);
	#end
#end
