import os
import string
from math import *
PartsPath = '/Users/render/dkgdome/'
DeclareString = "\n#macro _"

cos60 = cos(pi/3)
sin60 = sin(pi/3)
xdisp = 0.5
ydisp = tan(pi/6) * 0.5
prismoffset = 0.5/cos(pi/12)

class PartsManager:
    def isDefinitionFile(self,filename):
        if filename[0:5] == '_DEF_':
            return True
        return False

    def parseStyle(self,text):
        pos = text.find("@STYLE:")
        if pos == -1:
            return
        pos += len("@STYLE:")
        lineend = text.find('\n',pos)
        stylename = text[pos:lineend]
        stylename = string.strip(stylename)
        stylenum = len(self.Styles)
        self.StyleLookup[stylename] = stylenum
        self.Styles.append({})
        self.Styles[stylenum]["NAME"] = stylename
        
        pos = text.find('@',pos)
        while not pos == -1:
            pos += 1
            tagend = text.find(':',pos)
            tag = text[pos:tagend]
            tag = string.strip(tag)
            pos = tagend+1
            valend = text.find('\n',pos)
            val = text[pos:valend]
            self.Styles[stylenum][tag] = val
            pos = text.find('@',pos)
    
    def parseDict(self,text):
        taglen = len('$DICT:')
        pos = text.find('$DICT:')
        while not pos == -1:
            pos += taglen
            valend = text.find('\n',pos)
            vals = string.split(text[pos:valend])

            val1 = vals[0]
            if val1[0] == '_':
                val1 = val1[1:]

            val2 = vals[1]
            if val2[0] == '_':
                val2 = val2[1:]
            
            self.PartDict[val1] = val2
            pos = text.find('$DICT:',valend)
            
        
        
    def __init__(self):
        self.Styles = []
        self.StyleLookup = {}

        self.PartNames = []
        self.PartCount = 0

        self.PartDict = {}
    
        filelist = os.listdir(PartsPath)
        self.IncludeList = filter(self.isDefinitionFile,filelist)
        del filelist    #@TODO: Does this do anything?
        for file in self.IncludeList:
            print file
            infile = open(file,'r')
            intext = infile.read()
            self.parseStyle(intext)
            self.parseDict(intext)
            pos = string.find(intext,DeclareString)
            while pos >= 0:
                pos += len(DeclareString)
                posend = string.find(intext,'(',pos)
                partname = intext[pos:posend]
                partname = string.strip(partname)
                self.PartNames.append(partname)
                pos = string.find(intext,DeclareString,pos)
        del intext    #@TODO: Does this do anything?
        print self.PartNames
        print self.PartDict
        print self.Styles

    def getIncludeList(self):
        return self.IncludeList

    def isSymmetric(self,style):
        return self.Styles[self.StyleLookup[style]].has_key("SYMMETRIC")

    def getPiece(self, desc,Coords,Rot,Flip):
        if desc in self.PartNames:
            return '_'+desc+"("+repr(Coords[0])+","+repr(Coords[1])+","+repr(Coords[2])+","+repr(-Rot)+","+repr(Flip)+")"
        elif self.PartDict.has_key(desc):
            return '_'+self.PartDict[desc]+"("+repr(Coords[0])+","+repr(Coords[1])+","+repr(Coords[2])+","+repr(-int(Rot))+","+repr(Flip)+")"
        else:
            piece = string.split(desc,'_')
            curStyle = piece[0]
            curType = piece[1]
            
            if curStyle == "splitbase":
				curBottom = self.getPiece("splitbaseseg_"+piece[1]+"_segbottom_360",Coords,Rot,Flip)
				curTop = self.getPiece("splitbaseseg_"+piece[2]+"_segtop_"+piece[4],Coords,Rot,Flip)
				return curTop + " " + curBottom		
                
            #elif curStyle == "splitbaseseg":
           	#print desc
           	#pass

            elif (curType == "basesegtopwall") or (curType == "basesegbottomwall"):
                if piece[2] == "right":
                    return self.getPiece(curStyle+"_"+curType+"_left_"+piece[3],Coords,Rot,not(Flip))
            	
            elif curType == "base":
                curBottomWidth = piece[2]
                curTopWidth = piece[3]

                if curBottomWidth == '360':
                    curBottom = self.getPiece(curStyle+"_basesegbottom_"+curBottomWidth,Coords,Rot,Flip)
                    curTop = self.getPiece(curStyle+"_basesegtop_"+curTopWidth,Coords,Rot,Flip)
                    if curBottom and curTop:
                        #return "union{object{"+curTop+"} object{"+curBottom+"}}"
                        return curTop + " " + curBottom
                    else:
                        return ""
                else:   
                    curOffsetAngle = piece[4]
                    #print self.isSymmetric(curStyle)
                    '''if self.isSymmetric(curStyle) and (not curBottomWidth == '360'):
                        print "In one"
                        if int(curOffsetAngle)<<1 > int(curBottomWidth) - int(curTopWidth):
                            print "In two"
                            mirror = curStyle+'_'+curType+'_'+curBottomWidth+'_'+curTopWidth+'_'+repr(int(curBottomWidth)-int(curTopWidth)-int(curOffsetAngle))
                            #print desc
                            #print mirror
                            #print curBottomWidth
                            print "Still hanging on"
                            curPiece = self.getPiece(mirror,Coords,Rot,Flip)
                            print "Called the function"
                            if curPiece:
                                print "In three"
                                #@TODO: something about mirroring
                                #return curPiece+" scale <1,-1,1> rotate -z*"+curBottomWidth+" "
                                print "Returning mirror %s"%curPiece
                                return curPiece
                                #print desc
                            print "Out one"
                        print "Out two"
                    print "Made it this far"'''
                    if curOffsetAngle == "0":
                        #print "Should Failure ******************"
                        curBottom = self.getPiece(curStyle+"_basesegbottomwall_left_"+curBottomWidth,Coords,Rot,Flip)
                        curTop = self.getPiece(curStyle+"_basesegtopwall_left_"+curTopWidth,Coords,Rot+int(curOffsetAngle),Flip)
                    elif int(curTopWidth) + int(curOffsetAngle) == int(curBottomWidth):
                        #This would only ever actually be triggered for a non-symetric style
                        #SWEET!
                        #Or if the style is missing pieces?
                        #OOPS!
                        curBottom = self.getPiece(curStyle+"_basesegbottomwall_right_"+curBottomWidth,Coords,Rot,Flip)
                        curTop = self.getPiece(curStyle+"_basesegtopwall_right_"+curTopWidth,Coords,Rot+int(curOffsetAngle),Flip)
                    else:
                        curBottom = self.getPiece(curStyle+"_basesegbottom_"+curBottomWidth,Coords,Rot,Flip)
                        curTop = self.getPiece(curStyle+"_basesegtop_"+curTopWidth,Coords,Rot+int(curOffsetAngle),Flip)
 
                    if curBottom and curTop:
                            #return "union{object{"+curTop+" rotate -z*"+curOffsetAngle+"} object{"+curBottom+"}}"
                            return curBottom + " " + curTop
                
        return ""
        
    def transformCoords(self,Coords):
        return (Coords[0]-Coords[1]*cos60,Coords[1]*sin60,Coords[2])

    def transformTileCoords(self,Coords):
        return ((Coords[0]-1)*xdisp-Coords[1]*xdisp,Coords[1]*ydisp*3-(Coords[0]%2)*ydisp-ydisp,Coords[2])
       
    def getPart(self, desc,Coords,Rot):
        if desc[-4:] == "tile":
            if Coords[0]%2:
                Rot += 60
            RealCoords = self.transformTileCoords(Coords)            
        else:
            RealCoords = self.transformCoords(Coords)
        
        test = self.getPiece(desc,RealCoords,Rot,0)
        #if "_simple_side"[0:len("_simple_side")-1] == desc[0:len("_simple_side")-1]:
        #    print desc
        
        if test:
            #print test
            #print "Returning successful: "+test
            return test
        else:
            print "WARNING:PARTDEF: Cannot retrieve "+desc
            #return ""
            return "sphere{<"+repr(RealCoords[0])+","+repr(RealCoords[1])+","+repr(RealCoords[2])+">,0.2 pigment{rgb <0,0,1>}}"
