from math import *
cos60 = cos(pi/3)
sin60 = sin(pi/3)
xdisp = 0.5
ydisp = tan(pi/6) * 0.5
prismoffset = 0.5/cos(pi/12)

class PovWrite:
    
  def __init__(self, filename):
    self.outfile = open(filename,'w')

  def include(self,includelist):
    for file in includelist:
        text = "#include \"" + file + "\"\n"
        self.outfile.write(text)
  

  def sphere (self,x,y,z,rad):
    text = "sphere{"
    text += "<"+repr(x)+","+repr(y)+","+repr(z)+"> "
    text += repr(rad) + " "
    text += "pigment{rgb<0,0,1>}}\n"
    self.outfile.write(text)

  def hexsphere (self,x,y,z,rad):
    text = "sphere{"
    text += "<"+repr(x-y*cos60)+","+repr(y*sin60)+","+repr(z)+"> "
    text += repr(rad) + " "
    text += "pigment{rgb<0,0,1>}}\n"
    self.outfile.write(text)

  def realhexsphere (self,x,y,z,rad):
    text = "sphere{"
    text += "<"+repr(x*xdisp-y*xdisp)+","+repr(y*ydisp*3-(x%2)*ydisp)+","+repr(z)+"> "
    text += repr(rad) + " "
    text += "pigment{rgb<0,0,1>}}\n"
    self.outfile.write(text)

  def tilesphere (self,x,y,z,rad):
    text = "sphere{"
    text += "<"+repr((x-1)*xdisp-y*xdisp)+","+repr((y)*ydisp*3-((x)%2)*ydisp-ydisp)+","+repr(z)+"> "
    text += repr(rad) + " "
    text += "pigment{rgb<0,0,1>}}\n"
    self.outfile.write(text)
  
  def prism(self,x,y,z):
    text = "object{ Prism "
    if(x%2 != 0):
      text += "rotate z*180"
    text += "translate "
    text += "<"+repr(x*xdisp-y*xdisp)+","+repr(y*ydisp*3-(x%2)*ydisp+prismoffset)+","+repr(z)+"> "
    if(x%2 != 0):
      text += "pigment{rgb <1,0,0>} "
    else:
      text += "pigment{rgb <1,0,0>}"
    text += "}\n"
    self.outfile.write(text)

  def part(self,partstring,x,y,z,rot):
    text = "object{"
    text += partstring
    text += " rotate -z*" + repr(rot)
    text += " translate <"+repr(x-y*cos60)+","+repr(y*sin60)+","+repr(z)+"> "
    text += "}\n"
    self.outfile.write(text)

  def tilepart (self,partstring,x,y,z,rot):
    text = "object{"
    text += partstring
    if x % 2:
        rot += 60
    text += " rotate -z*" + repr(rot)
    text += " translate <"+repr((x-1)*xdisp-y*xdisp)+","+repr((y)*ydisp*3-((x)%2)*ydisp-ydisp)+","+repr(z)+"> "
    text += "}\n"
    self.outfile.write(text)

  def simplewrite(self,partstring):
    text = partstring
    text += "\n"
    self.outfile.write(text)  
    
  def __del__(self):
    self.outfile.write("//File successfully generated by povwrite.py")
    self.outfile.close()
