// vines.pov

// Twisting vine macro
// By Daniel Dresser and Fraser Kuyvenhoven

#macro twisted_vines (total_height, total_radius, number_vines, strands_per_vine, strand_thickness, strand_turbulence, twist_revolutions, twist_steps, top_split_range, top_radius, bottom_split_range, bottom_radius)

#declare gen = seed (1);
#declare normal_radius = total_radius;
#declare top_height = total_height - top_split_range;
#declare bottom_height = bottom_split_range;

#declare vines = number_vines;
#declare strands = strands_per_vine;
#declare thick = strand_thickness;
#declare twist = twist_revolutions * 360;
#declare step = twist_steps;
#declare turb = strand_turbulence;

#declare ang_change = 360 / vines;
#declare top_range = total_height - top_height;
#declare bottom_range = total_height - bottom_height;

// find largest radius for bounding box
#declare max_radius = total_radius;
#if (top_radius > max_radius)
	#declare max_radius = top_radius;
#end
#if (bottom_radius > max_radius)
	#declare max_radius = bottom_radius;
#end

// create twisted vines
merge {
#declare ang = 0;
#while(ang < 360)
	#declare j = 0;
	#while(j < strands)
		sphere_sweep {
			cubic_spline, step
			#declare i = 0;
			#while (i < step)
				#declare X = (rand(gen) - 0.5) * turb;
				#declare Y = (rand(gen) - 0.5) * turb;
				#declare Z = (rand(gen) - 0.5) * turb;
				
				// find current radius based on current height
				#declare curheight = total_height / step * i;
				#switch (curheight)
					#range (0, bottom_height)
						#declare curheightperc = curheight / bottom_range;
						#declare curradius = (curheightperc * normal_radius) + ( (1 - curheightperc) * bottom_radius);
					#break
					#range (top_height, total_height)
						#declare curheightperc = (curheight - top_height) / top_range;
						#declare curradius = ( (1 - curheightperc) * normal_radius) + (curheightperc * top_radius);
					#break
					#else
						#declare curradius = normal_radius;
				#end
				
				vrotate (x * curradius + z * curheight, z * (twist / step * i + ang) ) + <X, Y, Z>, thick
				#declare i = i + 1;
			#end
		}
		#declare j = j + 1;
	#end
	#declare ang = ang + ang_change;
#end
// set bounding box
bounded_by {
	box {
		<-max_radius, -max_radius, 0> * (1 + (strand_turbulence / max_radius))
		<max_radius, max_radius, total_height>  * (1 + (strand_turbulence / max_radius))
	}
}
}

#end