#include "XYZaxis"  
#include "HydraTexture.inc"
#include "Head.inc"

#declare textShift = 0;
#declare shiftIncrement = 0;


#macro segment(R)  
  sphere{<0,0,0>1 scale<R,1,R>} 
  
  #declare textShift = textShift + 1;
  texture{ 
     snakeTex
     translate textShift*shiftIncrement*y               
     scale 2.5*R
  }   
       
#end
   
#macro plainSegment(R)  
  sphere{<0,0,0>1 scale<R,1,R>} 
#end

#declare highDef = 16;  //Make 16 for really smooth   
   
#macro turn(R, pl) 
    
    #declare a = atan(1/R)*180/pi;
    #if ( pl = 0 )
       translate  R*x   
       rotate    -a*z/highDef
       translate -R*x 
    #else 
       #if ( pl > 0 )
          translate  R*z
          rotate     a*x/highDef
          translate -R*z
       #else
          translate -R*z
          rotate    -a*x/highDef
          translate  R*z
       #end 
    #end                    
#end   

#macro shiftup(R)
  translate R*y
#end

#macro unions(N)
  #declare nu = 0;

  #while (nu < (highDef*N))

    union{
  #declare nu = nu + 1;
  #end
#end   

#macro segments(Number, increase, turnRad, pl)
  #declare ns=0; 

  #while (ns < (highDef*Number))   
         object{segment(R)} turn(turnRad, pl) shiftup(1.5/highDef)  } 
         #declare R = R + increase/highDef;
         #declare ns = ns + 1;
  #end
#end   

   

#macro Tentacle(firstCurve, 
                segs1,  rad1,  dir1, 
                segs2   rad2,  dir2,
                segs3   rad3,  dir3,
                segs4   rad4,  dir4,
                segs5   rad5,  dir5,
                segs6   rad6,  dir6,
                segs7   rad7,  dir7,
                segs8   rad8,  dir8,
                segs9   rad9,  dir9,
                segs10  rad10, dir10,
                segs11  rad11, dir11,
                
                typeHead) 

object{

#declare R = 1.25;
#declare shiftIncrement = 0.16/highDef;

  unions(firstCurve + segs1 + segs2 + segs3 + segs4 + segs5 + segs6 + segs7 + segs8 + segs9 + segs10 + segs11)
  
  object{head(typeHead) scale 2.8  rotate -90*z rotate 90*x translate <-1.25, -0.9, 0> }//rotate 90*y rotate twistHead*y}  
    
  segments(segs11, 0.0, rad11, dir11)  
  segments(segs10, 0.0, rad10, dir10)  
  segments(segs9,  0.0, rad9,  dir9)  
  segments(segs8,  0.001, rad8,  dir8)  
  segments(segs7,  0.002, rad7,  dir7)  
  segments(segs6,  0.005, rad6,  dir6)  
  segments(segs5,  0.01, rad5,  dir5)  
  segments(segs4,  0.01, rad4,  dir4)  
  segments(segs3,  0.01, rad3,  dir3)  
  segments(segs2,  0.02, rad2,  dir2)  
  segments(segs1,  0.02, rad1,  dir1)  
  segments(firstCurve,  0.0,    9,  0)  
  
  scale 0.25
  rotate -90*y 
}
#end

#macro Snake(   segs1,  rad1,  dir1, 
                segs2   rad2,  dir2,
                segs3   rad3,  dir3,
                segs4   rad4,  dir4,
                segs5   rad5,  dir5,
                segs6   rad6,  dir6,
                segs7   rad7,  dir7,
                segs8   rad8,  dir8,
                segs9   rad9,  dir9,
                segs10  rad10, dir10,
                segs11  rad11, dir11,
                segs12  rad12, dir12,
                segs13  rad13, dir13,
                segs14  rad14, dir14,
                segs15  rad15, dir15,
                segs16  rad16, dir16,
                
            ) 

object{

#declare R = 0.25;
#declare highDef = highDef*2;   

  #declare shiftIncrement = 0.1/highDef;

  unions(segs1 + segs2 + segs3 + segs4 + segs5 + segs6 + segs7 + segs8 + segs9 + segs10 + segs11 + segs12 + segs13 + segs14 + segs15 + segs16)
  
  object{sphere{<0,0,0>0.01 texture {snakeTex}}}  
 
  segments(segs16, 0.05, rad16, dir16)  
  segments(segs15, 0.025, rad15, dir15)  
  segments(segs14, 0.025, rad14, dir14)  
  segments(segs13, 0.00625, rad13, dir13)  
  segments(segs12, 0.0, rad12, dir12)  
  segments(segs11, 0.0, rad11, dir11)  
  segments(segs10, 0.0, rad10, dir10)  
  segments(segs9,  0.0, rad9,  dir9)  
  segments(segs8,  0.0, rad8,  dir8)  
  segments(segs7,  0.0, rad7,  dir7)  
  segments(segs6,  0.0, rad6,  dir6)  
  segments(segs5,  0.0, rad5,  dir5)  
  segments(segs4,  0.0, rad4,  dir4)  
  segments(segs3,  0.0, rad3,  dir3)  
  segments(segs2,  0.0, rad2,  dir2)  
  segments(segs1,  0.0, rad1,  dir1)  
  
  scale 0.25
  rotate -90*y 
  rotate 180*z 
  translate 0.4*y
}
#end

