//***********************************
//	un martien
//	martien5
//
//	qui joue au foot
//
//	Pour l'image sleepy
//	IRTC Fvrier 2004
//
//	Helen - Janvier 2004
//***********************************

#include "colors.inc"
#include "textures.inc"
#include "functions.inc"







//******************************************
//	le corps du martien
//******************************************
#declare martien5=
union
	{
sphere
{
	<0,0,0>,1
	pigment
		{
		radial
		frequency 20
    			color_map
			{
      			[0.00 color MediumForestGreen]
      			[0.33 color MediumSpringGreen]
      			[0.66 color LimeGreen]
      			[1.00 color MediumForestGreen]
    			}
		}
	scale <0.80,1,0.80> 
	translate <0,2,0>

}

//*****************************************
//	la tte
//*****************************************

sphere
{
	<0,0,0>,0.7
	pigment
		{
		radial
		frequency 20
    			color_map
			{
      			[0.00 color MediumForestGreen]
      			[0.33 color MediumSpringGreen]
      			[0.66 color LimeGreen]
      			[1.00 color MediumForestGreen]
    			}
		}
	scale <1,0.80,1> 
	translate <0,3.5,0>

}

//***********************************
//	l'oeil
//***********************************


#declare oeil =
union
	{
sphere
{
	<0,0,0>, 0.2
	pigment {White}
	translate <0,3.5,-0.6>
}

sphere	// pupille
{
	<0,0,0>, 0.09
	pigment {Green}
	translate <0,3.5,-0.8>
}
	} //fin union un oeil

//	oeil droit

object
{
	oeil
	translate <-0.4,0,0>
}

//	oeil gauche

object
{
	oeil
	translate <0.4,0,0>
}

//*****************************************
//	le chapeau
//*****************************************

// spirale
#declare chapeau =
isosurface {
  function { f_helix1(x,y,z,1,8*pi,0.07,0.4*(1-y),1,1,0) }
        max_gradient 2.962
        contained_by{box {-<1,1,1>,<1,1,1>}}
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
        no_shadow
		
}

object
{
	chapeau
	scale <0.8,1,0.8>
	translate <0,4.5,0>
}

//**********************************
//	les bras
//**********************************

//-- conception d'un bras
 
#declare Z=100;
#declare bras =
union
{
#while (Z>0)
 
sphere{<Z/50,Z/8,0>,.1+Z/100  
    rotate<0,Z*5,180>
    translate<0,7.2,0>}

#declare Z=Z-1;
#end
        } // fin de l'union

object	// bras droit
{
	bras
	pigment {MediumSpringGreen}
	finish {phong 0.5 phong_size 10}
	scale 0.15
	//rotate z*90
	//rotate x*90
	translate <-0.8,3.5,0>
		
}

object	// bras gauche
{
	bras
	pigment {MediumSpringGreen}
	finish {phong 0.5 phong_size 10}
	scale 0.15
	//rotate x*180
	//rotate y*-180
	rotate z*-90
	translate <0.9,2.2,0>
	       
}

//*******************************************
//	pied
//******************************************

// hlice

#declare RA=1;
#declare pied =
isosurface {
  function { f_helix1(x,y,z,2,5,0.1,0.3,1,2,45) }
        max_gradient 2.495
        contained_by{sphere {0,RA}}
        pigment {MediumSpringGreen}//{rgb .9}
        finish {phong 0.5 phong_size 10}
		
}

object
{
	pied
	scale <1,1.3,1>	
	
}
	}	// fin de l'union gnrale composant martien2

//==========================================
//	Et voil un premier martien
//	c'est martien2 !
//==========================================
#declare martien_foot =
union
	{
object
{
	martien5
	translate <0,1,0>
}

//======================================
//	ballon martien
//======================================

// ----------------------------------------
// Boule  facette
 
#declare P=pigment{
  crackle
  metric 0
  solid
  color_map { [0 rgb 1] [1 rgb 0.5] }
  scale 0.1
}

#declare FU = function{pigment {P}}

isosurface {
        function {  x*x + y*y +z*z -1 +FU(x,y,z).red*0.2 }
        max_gradient 5.763
        accuracy 0.01
        contained_by{sphere {0,1}}
        pigment {P}
        finish {phong 0.5 phong_size 10}
		scale 0.7 
		translate <2,2,-1>
}
	}	// end union martien_foot


//================================
//	Et voil un martien
//	qui joue au foot
//================================





