//**********************************
//	Parachute
//	qui dpose la capsule
//
//	va avec sleepy.pov
//*********************************

#include "colors.inc"
#include "textures.inc"




global_settings { max_trace_level 15}


//**********************************
//	fabrication du parachute
//**********************************

//	se compose d'une toile
//	et de filins

//===========================================
//	la toile raye du parachute
//===========================================

//  realisation d'une demie sphre creuse
#declare boulle =
sphere
{ <0, 0, 0>, 3
	pigment
		{
		radial
		frequency 15
    			color_map
			{
      			[0.00 color Black]
      			[0.33 color CoolCopper ]
      			[0.66 color Wheat]
      			[1.00 color MediumForestGreen]
    			}
		}
    
}

#declare toile=
difference {    
    object { boulle }
    object { boulle  pigment { MandarinOrange } translate y*0.1}
    
}


//=====================================
//	les filins
//=====================================

#declare filins =
union
	{
cylinder	// Gauche
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate z*16
	translate <0,-1,0>
}

cylinder	// Droit
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate z*-16
	translate <0,-1,0>
}

cylinder	// Avant
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate x*-16
	translate <0,-1,0>
}

cylinder	// Arrire
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate x*16
	translate <0,-1,0>
}


cylinder	// Arrire Gauche
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate x*6
	rotate z*10
	translate <0,-1,0>
}

cylinder	// Avant Gauche
{
	<0,0,0>,<0,8.5,0>,0.02
	pigment {rgb .9}
    	finish {phong 0.5 phong_size 10}
	rotate x*-6
	rotate z*-10
	translate <0,-1,0>
}



	}


//**********************************
//	fabrication de la capsule
//**********************************

//	se compose d'une sphre aplatie
//	et d'un cne

//========================================
//	la capsule
//========================================


#declare capsule =
union
	{	
sphere
{
	<0,0,0>,1
	texture {Polished_Chrome}
	//pigment {rgb .9}
        //finish {phong 0.5 phong_size 10}
	scale <1,0.5,1>
	translate <0,2,0>
}

cone
{
    	<0, 1, 0>, 1    // Center and radius of one end
    	<0, 2, 0>, 0.1    // Center and radius of other end
	texture {Polished_Chrome}
	//pigment {rgb .9}
    	//finish {phong 0.5 phong_size 10}
	translate <0,1.08,0>
}
	
	}

//******************************************
//	regroupement du parachute
//	et de la capsule
//******************************************


#declare parachute =
union
	{	
object
{
	toile
	scale 0.8
	rotate x*180
	//rotate z*30
	translate <0, 7, 0>
}

object
{
	capsule
	translate <0,-4,0>
}

object
{
	filins
}
	} // fin de l'union des trois objets du parachute

