// Persistence of Vision Ray Tracer Scene Description File
// File: swmaiden.pov
// Vers: 3.5
// Desc: luik-printsess
// Date: 09/01/04-23.02.04
// Auth: conicsweep
//
// Rendering options: antialias +A +AM2 +R2, time 11 hours 27 minutes
//
/////////////////////////////////////////////////////////////////////////

#version 3.5;

#include "colors.inc"
#include "textures.inc" 
#include "princess.inc"
#include "swan.inc" 
#include "myhouse.inc"

#declare Photons=on;

global_settings {
  assumed_gamma 0.8
  max_trace_level 5
   assumed_gamma 1.0
   //assumed_gamma 1.2
   #if (Photons)          
    photons {
      spacing 0.02                
    }
  #end
  radiosity {
    pretrace_start 0.08          
    pretrace_end   0.04          
    count 100                     
    nearest_count 8               
    error_bound 1.8               
    recursion_limit 5             
    low_error_factor .5           
    gray_threshold 0.5            
    minimum_reuse 0.015           
    brightness 1
    adc_bailout 0.01/2
    normal on                      
  }  
} 

// ------------------- Vaatepunkt ---------------------

camera {
  location  <0.0, 4.5, -17.333>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-2.0, 0.0,  0.0>
angle 59
}                          

//-------------------Taevas--------------------

sky_sphere {
  pigment {
   granite
    turbulence 0.1
     lambda 0.5
     octaves 5
     omega 2
    color_map {
      [0.0 rgb <0.2,0.2,0.1>]   //heleroheline
      [0.2 rgb <0.0,0.0,0.0>] //veel heledam roheline 
      [0.3 rgb <0.2,0.2,0.1>]    //heleroheline
      [0.5 rgb <0.0,0.0,0.0>]   //tumeroheline
      [0.99 rgb <0.0,0.2,0.1>]   //heleroheline
    }    rotate z*10  scale <3,1,2> 
  }

pigment {
   granite
    turbulence 0.1
     lambda 0.5
     octaves 5
     omega 2
    color_map {
      [0.0 rgbt <0.0,0.2,0.1,1>]   //heleroheline
      [0.5 rgbt <0.0,0.1,0.1,0.5>]   //tumeroheline
      [0.99 rgbt <0.0,0.2,0.1,1>]   //heleroheline
    }  scale <3,1,2>   rotate z*-20
  }

pigment {
  wood
   turbulence 0.0
    color_map {
      [0.0 rgb <1.0, 0.498039, 0.2>]
      [0.4 rgbt <0.1,0.1,0.1,1>]   
      
    }  scale <2,1,1>  
  } 

pigment {
   granite
    turbulence 0.1
     lambda 0.5
     octaves 5
     omega 2
    color_map {
      [0.0 rgbt <0.0,0.2,0.1,1>]   //heleroheline
      [0.5 rgbt <0.0,0.1,0.1,0.5>]   //tumeroheline
      [0.99 rgbt <0.0,0.2,0.1,1>]   //heleroheline
    }  scale <2,1,2>   rotate z*-30
  }

pigment {
  gradient y
    turbulence 0.1
     lambda 0.5
     octaves 5
     omega 2
    color_map {
      [0.0 rgbt <0,0,0,0.6>]   //heleroheline
      [0.3 rgbt <0,0,0,0.6>]   //heleroheline
      [0.5 rgbt <0,0,0,1>]   //tumeroheline
      [0.6 rgbt <0,0,0,1>] 
      [0.8 rgbt <0,0,0,0.6>] 
      [0.99 rgbt <0,0,0,0.6>]   //heleroheline
    }  
  }      

pigment {
  gradient x
    turbulence 0.3

    color_map {
      [0.0 rgbt <0,0,0,1>]   //heleroheline
      [0.3 rgbt <0,0,0,1>]   //heleroheline
      [0.5 rgb <0,0.05,0.03>]   //tumeroheline
      [0.7 rgbt <0,0.08,0.05,0.5>] 
      [0.9 rgbt <0,0,0,1>] 
      [0.99 rgbt <0,0,0,1>]   //heleroheline
    } rotate z*-20 
  }      

pigment {
  wood
   turbulence 0.0
    color_map {
      [0.0 rgbt <0.0,0.0,0.0,1>]   
      [0.9 rgbt <0.0,0.0,0.0,0.1>]         
    }  scale <2,1,1>  
  } 
} 

//------------------- Valgusallikad ---------------------------------------
//Lights
 
//loojangu valgus
//daylight
light_source {
  0*x
  color rgb <1, 1, 0>  
  translate <-40,0, 1000>
  fade_distance 10
  fade_power 2
}  


//printsessi valgusallikas
//princesses light
light_source {
  0*x                     
  //color rgb <0.3, 0.22,0.15>
  color rgb <0.4, 0.32,0.25>         
  spotlight               
  translate <40, 60, -50> 
  point_at <2, 0, -3>      
  radius 4               
  tightness 30           
  falloff 8
  area_light <2, 0, 0>, <0, 0, 2>, 2, 2
    adaptive 1
    jitter 
  photons {          
    refraction on
    reflection on
  }             
}
 
// ------------- Krooni kivide materjal ---------------------------
//jevellery

#declare Glass3 = 
texture {
    pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
    finish  {
        ambient 0.2
        diffuse 0.1
        reflection 0.1
        specular 0.8
        roughness 0.0003
        phong 1 
        phong_size 400
     }
}

#declare Diamond_Interior = interior {ior 2}

#declare Green_Glass = 
texture {
    Glass3
    pigment { rgbf <0.7, 0.98, 1, 0.9> }
}

#declare Blue_Glass = 
texture {
    Glass3
    pigment { rgbf <120/255, 190/255, 255/255, 0.9> }
}

#declare Pink_Glass = 
texture {
    Glass3
    pigment { rgbf <255/255, 203/255, 218/255, 0.9> }
}

#declare M_Green_Glass = material {texture {Green_Glass} interior {Diamond_Interior}}
#declare Blue_Glass = material {texture {Blue_Glass} interior {Diamond_Interior}}
#declare Pink_Glass = material {texture {Pink_Glass} interior {Diamond_Interior}}

//----------------------- Vee materjal ----------------------------------------------------- 
//material for water

#declare Water =
texture {
    pigment{ rgbt <0.0, 0.3, 0.3,0.7> }
    normal {
      bozo
      frequency 3
      turbulence .5
      normal_map {
        [0.00 granite]       
        [0.50 marble turbulence .5]      
        [1.00 granite]
      }  scale <12,4.5,4.5>
    }

    finish {    
        reflection {0.3, 1 fresnel}
        conserve_energy       
    }
}

#declare Water_Int =
interior {
    ior 1.33 }

#declare M_Water =
material {
    texture {Water}
    interior {Water_Int}
    scale <3,5,5> translate <0,0,-2>
}


//-------------------- Sulgede materjal -------------------------------------
//material for featers

#declare l1 =  rgbf <1.0, 1.0, 1.0, 1>; //abivrv
#declare l2 =  rgbf <1.0, 1.0, 1.0, 0.5>; //abivrv
#declare transparent =  rgbt <0.0, 0.0, 1.0, 1>; //abivrv

#declare shine =
  texture {
    pigment {
      color rgbf <1.0,1.0,1.0,0.1>
    }
    finish{
      diffuse 0.3
      ambient 0.1
      specular 0.5
      reflection { rgb <0.25,0.25,0.25>        
        metallic
      }
      conserve_energy
    } 
   normal { bumps 0.1 scale 0.1}  
  }

#declare shine2 =
  texture {
    pigment {
      color rgb <1.0,1.0,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.1
      specular 0.5
      reflection { rgb <0.25,0.25,0.25>        
        metallic
      }
      conserve_energy
    } 
   normal { bumps 0.1 scale 0.1}  
  }

#declare spots =
texture {
  leopard 
  turbulence 0.4
    texture_map {
      [0.0  pigment {transparent}]
      [0.5 shine]
      
      
      } frequency 10 
}

//idee parema tiiva jaoks
#declare shine3a =
texture {
  gradient x
  turbulence 0.2
    texture_map {
     // [0.0  pigment {transparent}]
      [0.0 spots]
      [0.55 shine]
      //[0.99 shine]
      } scale 10
   }

#declare shine3b =
texture {
  gradient x
  turbulence 0.2
    texture_map {
     // [0.0  pigment {transparent}]
      [0.0 spots]
      [0.55 shine]
      //[0.99 shine]
      } scale 10
   }

//-------------- Krooni keskmise osa materjal ------------------------------------------

#declare Metallic_Finish =
    finish {
        metallic
        ambient 0.4
        diffuse 0.65
        specular 0.85
        roughness 0.01       
        brilliance 1.5     
      reflection {
        0.8
        metallic
      }
      conserve_energy
    }
    
#declare Gold_Nugget = 
texture {
    pigment { rgb <0.5, 0.35, 0.25> }
    finish { Metallic_Finish }
}


//------------------- Pitsi materjal ------------------------------------

#declare Pits =
texture {
   bozo
     turbulence 5
     lambda     3
     octaves    4
     omega      1
      texture_map {
        [ 0.0 Gold_Nugget  ]
        [ 0.2 Gold_Nugget  ]
        [ 0.2 pigment {l1} ]
        [ 0.4 pigment {l1} ]
        [ 0.4 Silver1      ]
        [ 0.6 Gold_Nugget  ]
        [ 0.8 pigment {l1} ]
        [ 0.9 pigment {l1} ]
        [ 0.9 Gold_Nugget  ]
      }    scale 5
       
    }  

// ---------------------- Peaehete materjal -------------------------------------    

#declare Pits2 =
  texture {
   bozo
     turbulence 5
     lambda     3
     octaves    4
     omega      1
      texture_map {
        [ 0.00 pigment {Black}]
        [ 0.05 Gold_Nugget    ]
        [ 0.35 Gold_Nugget    ]
        [ 0.40 pigment {Black}]
        
        [ 0.40 pigment {l1}   ]
        [ 0.60 pigment {l1}   ]
        
        [ 0.60 pigment {Black}]
        [ 0.65 Gold_Nugget    ]
        [ 0.95 Gold_Nugget    ]        
      }   scale 8 
      
    }  

#declare Pits2a =
  texture {
   bozo
     turbulence 5
     lambda     3
     octaves    4
     omega      1
      texture_map {
        [ 0.00 pigment {Black}]
        [ 0.05 Gold_Nugget    ]
        [ 0.45 Gold_Nugget    ]
        [ 0.50 pigment {Black}]
        
        [ 0.50 pigment {l1}   ]
        [ 0.60 pigment {l1}   ]
        
        [ 0.60 pigment {Black}]
        [ 0.70 Gold_Nugget    ]
        [ 0.95 Gold_Nugget    ]        
      }   scale 10 
      
    }  
  
#declare Pits3 =
material {
  texture {
   bozo 
     turbulence 3
     lambda     3
     octaves    5
     omega      1
      texture_map {
        [ 0.00 pigment {Black}]
        [ 0.01 Gold_Nugget    ]
        [ 0.26 Gold_Nugget    ]
        [ 0.31 pigment {Black}]
        
        [ 0.35 pigment {l1}   ]
        [ 0.56 pigment {l1}   ]
        
        [ 0.56 pigment {Black}]
        [ 0.61 Gold_Nugget    ]
        [ 0.95 Gold_Nugget    ]              
        } scale 8          
    }    
 }       



#declare forehead =
material {
  texture {  
     pigment {   
      marble  
      turbulence 0.5
         color_map {
         [0.0 color rgb <0.5, 0.35, 0.35>]
         [0.60 color rgb <0.5, 0.35, 0.55> ]
         [0.70 color rgb <0,0,0>]
         [0.75 color rgbt <0.5, 0.35, 0.25,1>]
         } frequency 10
      } 
    finish{     
        ambient 0.4
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection {0.1 metallic}
        brilliance 1.5 
        conserve_energy 
        }        
    } 
   
 texture {  
    pigment {  
    marble 
    turbulence 0.5
       color_map {
       [0.0 color rgb <0.5, 0.35, 0.35>]
       [0.60 color rgb <0.5, 0.35, 0.55> ]
       [0.70 color rgb <0,0,0>]
       [0.75 color rgbt <0.5, 0.35, 0.25,1>]
        } frequency 10 rotate z*90
      }
    finish{     
        ambient 0.4
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection {0.1 metallic}
        brilliance 1.5 
        conserve_energy
        }
    }      
    rotate z*45 scale 2    
 } 

#declare New_Brass = 
texture {
    pigment { rgb <0.70, 0.56, 0.37> }
    finish {
        ambient 0.1
        diffuse 1.0
        brilliance 15
        phong 0.41
        phong_size 5
    }
}

#declare Spun_Brass = 
texture { 
    New_Brass
    normal { waves 0.35 frequency 2 scale 0.01 }
}

#declare just_pretty =
  texture {
    bozo
    turbulence 5
    lambda 3
    octaves 4
    omega    1
    texture_map {
        [0.0 pigment {transparent}]
        [0.2 Gold_Nugget]
        [0.4 Gold_Nugget]
        [0.6 pigment {transparent}]
        [0.8 Gold_Nugget]
        [1.0 Gold_Nugget]
    }  scale 0.8
}

//---------------------- Riide materjal ----------------------------------
//material for clothes

#declare riie =
  texture {  
  pigment {   marble  turbulence 0.2
    color_map {
      [0.0 color rgbt <1,1,1.0,0.5>]
      [0.5 color rgbt <1,1,1.0,0.5> ]
      [0.6 color rgbt <1,1,1,1>]
      } frequency 20
    } 
    finish{
      diffuse 0.3
      ambient 0.1
      specular 0.3
       reflection { rgb <0.15,0.15,0.2>        
        metallic
      } 
    } 
 }   

 texture {  
  pigment {  marble turbulence 0.2
    color_map {
      [0.0 color rgbt <1,1,1.0,0.5>]
      [0.5 color rgbt <1,1,1.0,0.5> ]
      [0.6 color rgbt <1,1,1,1>]
      } frequency 20 rotate z*90
    }
    finish{
      diffuse 0.3
      ambient 0.1
      specular 0.3
       reflection { rgb <0.15,0.15,0.2>        
        metallic
      }
    } 
 }      


//----------------- Mgede materjal --------------------------------------
//material for mountains

#declare T_Mountain =
  texture {
    pigment {
      image_map { jpeg "mountain6.jpg" map_type 0 interpolate 2 once }
      rotate x*90 
    }
    finish { reflection 0.0}
  } 

#declare T_Mountain2 =
  texture {
    pigment {
      image_map { jpeg "mountain7.jpg" map_type 0 interpolate 2 once }
      rotate x*90
    }
    finish { reflection 0.0}
  } 

#declare T_Mountain3 =
texture {
  gradient x
    texture_map {
      [0.0 T_Mountain]
      [0.90 T_Mountain]
      [0.99 pigment {transparent} ]
      } 
   }

#declare m =  
height_field {
  jpeg "mountain4.jpg"  
}

//-------------------------- Vesi --------------------------------------
//water object

box {<-1000,-40,-20> <1000,-3,1000> material {M_Water rotate z*60}}


//------------------------ Med -------------------------------------------
//mountain object

object {m  texture {T_Mountain} rotate y*-40 scale <40,25,60> translate <-35,-6,30>}
object {m  texture {T_Mountain3} rotate y*-10 scale <35,10,50> translate <-40,-5.2,-20>}

//------------------------ Maja --------------------------------------------
//house object

object {fullhouse rotate <0,-85,-4>  translate <-22,8,20 >}

object {vundament rotate <0,-85,-4> translate <-22,8,20>}
 
//--------------------- Printsessi ngu ------------------------------------
//colors for princesses face

//-------------------- naha vrv -------------------------------
//skin color

#declare skin_Map =
color_map {
    [0.0 rgb <255/255, 244/255, 222/255>]
    [0.3 rgb <255/255, 227/255, 177/255>]
    [0.8 rgb <255/255, 206/255, 177/255>]
    [1.0 rgb <255/255, 206/255, 144/255>]
}

// Drew Wells' superb Jade.  Color map works nicely with other textures, too.
#declare skin = 
pigment {
    bozo
    turbulence 1.8
    color_map { skin_Map }
}
#declare lips_color =
texture {
   pigment {rgb <210/255,125/255,132/255>}
   finish {
      phong 1
      phong_size 30
      diffuse 0.7
      brilliance 8
        specular 0.8
      }
}      

#declare Blue_Agate_Map =
color_map {
    [0.5  rgb <0.30, 0.50, 0.50>]
    [0.55 rgb <0.20, 0.20, 0.30>]
    [0.6  rgb <0.25, 0.25, 0.35>]
    [0.7  rgb <0.15, 0.15, 0.26>]
    [0.8  rgb <0.10, 0.30, 0.20>]
    [0.9  rgb <0.30, 0.30, 0.50>]
    [1.0  rgb <0.10, 0.40, 0.20>]
}

#declare iris_color = 
texture {
pigment {
    agate
    color_map { Blue_Agate_Map }
}
finish {ambient 0.0}
}

#declare pearls_texture =
texture {
    pigment {
      color rgb <0.8,0.8,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.0
      specular 0.6
      reflection { 0.8 metallic }
      conserve_energy
   }
}
    
//--------------------------- Printsess ---------------------------------------------------
//herself

union {
object {face texture {skin}}
object {lips texture {lips_color}}
object {down_eyepart pigment {Black}}
object {up_eyepart pigment {Black}}
object {eyebrows pigment {Black}}
object {hair pigment {Black}}
object {eyewhite pigment {White}}
object {iris texture {iris_color}}
object {fingers texture {skin}}
object {neck texture {skin}}
object {terad pigment {Black}}
object {arm texture {skin}} 

//------------------------ luige osa -----------------------------------
//swan part
object {lace texture {riie }}
object {lace2 texture {riie}}                     
object {pits texture {Pits}}
object {pits2 texture {Pits}}
object {narmad texture {shine2}}
object {parem_tiib texture {shine3a}}
object {vasak_tiib texture {shine3a translate <8,0,0>}}
object {swanpart2 texture {shine2}}
object {rootsud pigment {White}}
object {ehe texture {Pits2a }}
object {ehe2 texture {Gold_Nugget}}
object {ehe33 texture {riie}}
object {lace3 texture {riie}}
object {ehe4 material {Pits3}}
object {suled texture {shine2}}
object {swanpart texture {shine2}}
object {swanpart3 texture {shine2}}
object {rings texture {Gold_Nugget}}
object {diamond1 material {Blue_Glass}
        photons {  
    target 1.0
    refraction on
    reflection on
    }
 }

object {diamond2 material {Pink_Glass}
        photons {  
    target 1.0
    refraction on
    reflection on
    }
 }
object {diamonds material {M_Green_Glass}
  photons {  
    target 1.0
    refraction on
    reflection on
    }
 }
 scale 0.7 rotate y*-55 translate <1,-3.7,-3.5>
}//union   



