#include "header.inc"
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Camera
camera {
  location  <0.0, 1.0, -5.0>
  look_at   <0.0, 0.5,  0.0>
  right     x*image_width/image_height
}  
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Ground
plane {
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  texture {pigment {color LimeGreen}}
  finish { crand 0.2 }
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>   // <x y z> position of light
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Sky
sky_sphere {S_Cloud3}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Radio
box {
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  .1,  .0>  // other corner position <X2 Y2 Z2>
  texture {T_Wood1 scale .1}
}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%// 
// Tower
cone {
  -1*y,  .5,
  10.1*y, .2
  translate <5,0,30>
  texture {Polished_Chrome}
  finish { ambient .5}
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Dials
cylinder {
  1*x,  1.1*x,  .1
  rotate y*90
  texture { pigment { color White }}
  translate <.7,-.7,0>
}
cylinder {
  1*x,  1.1*x,  .1
  rotate y*90
  texture { pigment { color White }}
  translate <.7,-.4,0>
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Tuner
box {
  <1, 1, 0>  // one corner position <X1 Y1 Z1>
  <2.8, 1.2, 0>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Red}}
  translate <-1.9,-1.2,-1.0001>
  texture { Glass2 }
}
box {
  <1, 1, 0>  // one corner position <X1 Y1 Z1>
  <1.01, 1.2, 0>  // other corner position <X2 Y2 Z2>
  texture { pigment { color White}}
  translate <-.7,-1.2,-1.0002>
  texture { Glass2 }
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Speaker
box {
  <0, 0, 0>  // one corner position <X1 Y1 Z1>
  < 1.4,  .6,  0>  // other corner position <X2 Y2 Z2>
  texture { pigment {color NewTan}}
  translate <-.9,-.9,-1.0001>
  finish {crand 0.05}
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Antenna
cylinder {
  0*x,  2*x,  .03 
  rotate z*100
  translate <-.7,.1,-.3>
  texture { Polished_Chrome }
}
sphere {
  <0, 1, 0> // center of sphere <X Y Z>
  0.06       // radius of sphere
translate <-1.05,1.1,-.31>
texture { Polished_Chrome }
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
// Ball
// Red Light
light_source {
  1*y                  // light's position (translated below)
  color rgb <1,0,0>    // light's color
  translate <5, 8.2, 30>
  looks_like {
sphere {
  <0, 1, 0> // center of sphere <X Y Z>
  .3       // radius of sphere
  texture { pigment { color White}}
  finish {ambient 1}
}
}
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//End Radio And Tower//
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
fog {
  fog_type   2
  distance   10
  color      rgb 0.6 // gray
  fog_offset 0.1
  fog_alt    0.2
  turbulence 0.8
}
