
#version unofficial MegaPov 1.0;
#include "mp_colors.inc"
#include "mp_functions.inc"
#include "mp_textures.inc"
#include "mp_woods.inc"
#include "stones.inc"


media {    // 
  intervals 10
  scattering { 1, rgb 0.02 }
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9  
        density {
         bozo scale 20  
         color_map {
         [0.0 rgb <.1,0,0>]
         [0.1 rgb <0,0.0,0.3>]
         [0.5 rgb <0,0,0>]
         [0.95 rgb <1,1,1>]
         }          
      }

}




// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <-40,15,5>
  //location  <-100,100,0> //bird's eye
  look_at   <-10,10,-5>
}


// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <.5,.5,.3>       // light's color
  spotlight               // this kind of light source
  translate <500, 150, -25> // <x y z> position of light
  point_at <-5, 0, -3>      // direction of spotlight
  radius 100               // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10             // intensity falloff radius (outer, in degrees)        
  media_attenuation on
  // light_source { ...
  // put this inside a light_source to give it a visible appearance
//  looks_like { sphere { 0*x, 5 pigment { Red } } }

}
// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1.5,1,0.1>       // light's color
  spotlight               // this kind of light source
  translate <500, 180, -45> // <x y z> position of light
  point_at <-5, 0, -3>      // direction of spotlight
  radius 200               // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10             // intensity falloff radius (outer, in degrees)        
  // light_source { ...
  // put this inside a light_source to give it a visible appearance  
  media_attenuation on
//  looks_like { sphere { 0*x, 5 pigment { Yellow } } }

}
// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <3,3,3>       // light's color
  spotlight               // this kind of light source
  translate <500, 160, -85> // <x y z> position of light  
  point_at <-5, 0, -3>      // direction of spotlight     
  rotate y*-15
  radius 100               // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30             // intensity falloff radius (outer, in degrees)        
  // light_source { ...
  // put this inside a light_source to give it a visible appearance  
  media_attenuation on
//  looks_like { sphere { 0*x, 5 pigment { Green } } }

}

// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1.2,1.1,0.5>       // light's color
  spotlight               // this kind of light source
  translate <50, 60, -70> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 20               // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30             // intensity falloff radius (outer, in degrees)        
  media_attenuation on
  // light_source { ...
  // put this inside a light_source to give it a visible appearance
 // looks_like { sphere { 0*x, 5 pigment { Blue } } }

}


//radiosity settings
// Auth: Kevin Ellis
// Mail: kevin.ellis [at] libertysurfcouk
// Webp: http://web.libertysurf.co.uk/kevin.ellis

#version unofficial MegaPov 0.6;

#declare Rad=1;

global_settings {


  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 40             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 0.1        // CHANGE - range from 1 to 3 - should correspond   with pretrace_end
                         // you can go lower than 1, but then you probably     will want to set
                         // pretrace_end to 0.01, which is really slow
    recursion_limit 1    // CHANGE

    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 0.5         // leave this

    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    normal on
    media on
  }
  ambient_light 0

  max_trace_level 10

}

// ----------------------------------------

#declare stucco =  //wall texture
texture {
// texture component
  pigment {
    color rgb <1,1,1>     // solid color pigment
  }
// texture component
  normal {
    granite 1          // any pattern optionally followed by an intensity value [0.5]
    bump_size 2.0   // optional
    //accuracy 0.02   // changes the scale for normal calculation [0.02]
    scale 0.3       // any transformations
  }
// control an object's surface finish
  finish {
    ambient 0.1          // ambient surface reflection color [0.1]
    // (---diffuse lighting---)
    diffuse 0.6          // amount [0.6]
    brilliance 1.0       // tightness of diffuse illumination [1.0]
  } // finish



}

#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbt 1}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}



#declare table= 
sor {
    13, // # of points
    <0.000000, 0.000000> // list of <u,v> points
    <2.5, 0.0>
    <2.5, 0.3>
    <1, 0.4>
    <0.5, 1>
    <0.5, 4.8>
    <0.7, 5.8>
    <0.6, 6.39>
    <1.4, 6.4>
    <6.8, 6.5>
    <6.9, 6.8>
    <6.89, 6.95>
    <0,6.9501>
    // [open]                 
texture {mahogany}
}

#declare container =
merge {              
    difference {                                
         sor {
        7, // # of points
        <0.000000, 0.000000> // list of <u,v> points
        <1.05, 0.000000>
        <0.79, 6>
        <0.7, 6.8>
        <0.3, 7>
        <0.05, 7.5>
        <0.0, 0>
        // [open]
       material {M_Glass}
       } 
               cylinder {
                <0,0.5,0> <0,6,0>  .55
                material {M_Glass2}
                photons {  // photon block for an object
                        target 1.0
                        refraction on
                        reflection on
                        }         
                }        
                
                }
       cylinder {   0*y,  0.5*y,  1.1     texture {DMFWood6 }   

}

#declare bowl =
union {              
        difference {
sphere { <0, 0.2, 0>, 1.3 texture {T_Stone44} translate <0,1,0>}
sphere { <0, 0.1, 0>, 1.4 texture {T_Stone35} translate <0,1.5,0>}   

 }   
sphere { <0, 0.1, 0>, 1.1 texture {New_Penny} translate <0,3.2,0> scale y*.2}

}

scale y*0.6  
}
#declare meter = 
union {
sor {
    7, // # of points
    <0.000000, 0.000000> // list of <u,v> points
    <0.2, 0.050000>
    <0.3, 0.15>
    <0.3, 0.3>
    <0.05, 0.45>
    <0.0, 0.7>
    <0.0, 1.0>
    // [open]
material {M_Glass}
}
sphere { <0, 0.1, 0>, 0.2  texture {Ruby_Glass}}
}  
    
#declare tube =                   
merge {
       difference {
                cylinder {   0.5*y,  5*y,  0.1  open 
                material { M_Glass }

                photons {  // photon block for an object
                        target 1.0
                        refraction on
                        reflection on
                        }                                      
                }
                cylinder {   0.5*y,  5*y,  0.08  open    material {M_Glass}   }
        }           

sor {
    6, // # of points
    <0.000000, 0.000000> // list of <u,v> points
    <0.2, 0.000000>
    <0.1, 0.1>
    <0.1, 0.2>
    <0.0, 0.25>
    <0.0, 1.0>
    // [open] 
    translate 5*y
    material {M_Glass}
}

        cylinder {
                0.5*y,  5*y,  .08
                texture {Tinny_Brass}
                photons {  // photon block for an object
                        target 1.0
                        refraction on
                        reflection on
                        }         
                }
      }
     
#declare galileo = 
union {
object {container scale <1,1.5,1>}     
object {meter translate <.1,2,0>}
object {meter translate <.1,.9,.1>}
object {meter translate <-.1,5,.15>}
object {meter translate y*2.5}        

}
  
#declare torricelli = 
union {
object {tube}     
object {bowl}
} 
     
#declare cup=
union {
difference {
// create a sphere shape
sphere {
  <0, 1, 0> // center of sphere <X Y Z>
  1       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
}
// create a sphere shape
sphere {
  <0, 1, 0> // center of sphere <X Y Z>
  1       // radius of sphere
  translate <0.1,0,0>
}      
}
cylinder {
  1*z,  3*z,  0.05  translate <0,1,0>
  // open
}
cylinder { <0, 2, 0>, <3, 6, 0>, .02 rotate y*-90}
}

     
#declare cup_frame = 
union {
object {cup }
object {cup translate <-3,0,-3> rotate y*90}
object {cup translate <0,0,-6> rotate y*180}
object {cup translate <3,0,-3> rotate y*-90}
texture {Soft_Silver}  
translate <-5,8.5,-14> scale 0.4
} 

#declare tablegroup = 
union {

object {torricelli translate <-7,3,-12>}            
object {galileo translate <-8,2.8,-5>}          
object {cup_frame translate <-12,-.5,-7>}
  
object {table translate <-10,-4.5,-8> scale <0,1.2,0>}
//object {candle scale 0.2 translate <-1,5,-10>}                    
}



// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>

object {tablegroup translate <5,6,5>}      

#declare F=function{pigment{
         bozo scale 20  
         color_map {
         [0.0 rgb <.1,0,0>]
         [0.1 rgb <0,0.0,0.3>]
         [0.5 rgb <0,0,0>]
         }          
  }
}
 
isosurface {
function{y-f_snoise3d(x*3,0,z*3)*0.5}
        max_gradient 5.5
        contained_by{// create a box that extends between the 2 specified points
box {
  <-1000, -3, -1000>  // one corner position <X1 Y1 Z1>
  < 1000,  1,  1000>  // other corner position <X2 Y2 Z2>
}
}
        texture{T_Stone37}
}

