/* nails.c
 * Maurizio Tomasi, 2004
 *
 * It is hard to adapt such a program for other purposes than creating
 * the file "nails_pos.inc" required by my image "The
 * Piano"... However, I am including it in the .ZIP archive hoping
 * that it will be of some use.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>

long num_of_vertexes = 0;
long num_of_objects = 0;
float accum_x = 0.0, accum_y = 0.0, accum_z = 0.0;
float min_x, min_y, min_z;
float max_x, max_y, max_z;

void
finalize_object (void)
{
  if (num_of_objects > 0)
    {
      float x, y, z;

      x = accum_x / num_of_vertexes;
      y = accum_y / num_of_vertexes;
      z = accum_z / num_of_vertexes;

      if (num_of_objects > 1)
	{
	  if (x < min_x) min_x = x;
	  if (y < min_y) min_y = y;
	  if (z < min_z) min_z = z;

	  if (x > max_x) max_x = x;
	  if (y > max_y) max_y = y;
	  if (z > max_z) max_z = z;
	}
      else
	{
	  min_x = max_x = x;
	  min_y = max_y = y;
	  min_z = max_z = z;
	}

      printf ("\tCreateNail (<%g, %g, %g>)\n", x, y, z);
    }

  accum_x = 0.0;
  accum_y = 0.0;
  accum_z = 0.0;
  
  num_of_objects++;
  num_of_vertexes = 0;
}


int
main (void)
{
  const int BUF_SIZE = 512;
  char * buffer;
  char command;

  buffer = malloc (BUF_SIZE);

  while (! feof (stdin))
    {
      char * buf_start;
      if (fgets (buffer, BUF_SIZE, stdin) == NULL && ! feof (stdin))
	{
	  perror ("Unable to read from stdin");
	  return EXIT_FAILURE;
	}

      if (feof (stdin))
	break;

      buf_start = buffer;
      while (isspace (*buf_start) && (*buf_start != 0))
	buf_start++;

      if (*buf_start == 0)
	break;
	  
      command = tolower (*buf_start++);
      
      switch (command)
	{
	case 'o': /* New object */
	  finalize_object ();
	  break;
	  
	case 'v':
	  {
	    float x, y, z;
	    sscanf (buf_start, "%f %f %f", &x, &y, &z);
	    
	    accum_x += x;
	    accum_y += y;
	    accum_z += z;
	    num_of_vertexes++;
	  }
	  break;
	  
	default:
	  fprintf (stderr, "Unknown command `%c' (ASCII %d) "
		   "in the following line:\n%s\n",
		   command, command, buffer);
	  return EXIT_FAILURE;
	}
    }

  finalize_object ();

  printf ("\n\n#declare MinPt = <%g, %g, %g>;\n"
	  "#declare MaxPt = <%g, %g, %g>;\n",
	  min_x, min_y, min_z, max_x, max_y, max_z);

  free (buffer);
  return EXIT_SUCCESS;
}
