// Persistence of Vision Ray Tracer Scene Description File
// File: keyboard.inc
// Vers: 3.5
// Desc: The rear panel with the strings (behind the hammers)
// Date: 2003/04/10
// Auth: Maurizio Tomasi
//

#ifndef (__REAR_INC__)
#declare __REAR_INC__ = 1;

#version 3.5;

#include "rand.inc"
#include "shapes.inc"

#include "nails_pos.inc"

////////////////////////////////////////////////////////////////////////

/* +-+------------------+-+ ^            +-------+
 * | |                  | | |            |       |
 * | |                  | | | A          |       |
 * | |                  | | |            |       |
 * +-+------------------+-+ + . . . . . .| . . . +----+
 * | |                  | | | B          |       |    |
 * +-+------------------+-+ + . . . . . .| . . . +----+
 * | |                  | | |            |       |
 * | |                  | | | C          |       |<--->
 * | |                  | | |            |       |  F
 * +-+------------------+-+ v            +-------+
 *                                                0
 * <-><----------------><->              <------->
 *  E         D          E                   G
 */

#macro CreateRearPanel (PanelSeed, A, B, C, D, E, F, G)
    
    #local RearZ = 0.80 * G;
    
    union
    {
        union
        {
            height_field
            {
                png "backplane.png"
                smooth
                water_level 0.05
                
                rotate -90*x

                texture
                {
                    pigment 
                    { 
                        bozo
                        color_map
                        {
                            [0.4 color rgb <220, 176, 72>/500]
                            [0.9 color rgb <189, 144, 37>/500]
                        }
                        
                        scale 0.01
                    }

                    finish
                    {
                        specular 0.5
                        roughness 0.003
                    }
                }
                texture
                {
                    pigment
                    {
                        image_map 
                        { 
                            png "backplane-tex.png" 
                            interpolate 2
                        }
                    }
                }

                // Invert the image
                //scale <1, 1, -1>
                translate <-0.5, 0, 0 /* -1 */>
                
            }
            
            box
            {
                <-0.5, 0, -0.1>, <0.5, 1, 1>

                pigment
                {
                    color rgb <0.7, 0.3, 0.05>
                }
            }
            
            scale <D, C + B + A, G/40>
            translate RearZ * z
        }
        
        #if (USE_NAILS)        
            object
            {
                CreateNails (D * 0.98, A * 0.20)
                translate <0, (C + B + A * 0.80), RearZ>
            }
        #end
    }    
#end

////////////////////////////////////////////////////////////////////////

#ifndef (INCLUDED_FLAG)
    global_settings {
      assumed_gamma 1.0
    }
    
    // ----------------------------------------
    
    camera {
      location  <0.0, 0.5, -4.0>
      direction 1.5*z
      right     x*image_width/image_height
      look_at   <0.0, 0.0,  0.0>
    }
    
    light_source {
      <0, 0, 0>            // light's position (translated below)
      color rgb <1, 1, 1>  // light's color
      translate <-30, 30, -30>
    }

    #local Seed = seed (16742);
    
    CreateRearPanel (Seed, 55, 16, 57, 140, 6.5, 31, 33)

    
#end // INCLUDED_FLAG


#end // __REAR_INC__
