
#declare R1 = seed(1334);
#declare R2 = seed(12345);
#declare R3 = seed(133444); 
#declare CuR1 = seed(1344); 


#declare NumElements1 = 30;     // 10 - 50
#declare NumElements2 = 40;     // 10 - 50
#declare NumElements3 = 30;     // 10 - 50 

#declare ElementRadius1 = 15;   //20 - 100
#declare ElementRadius2 = 15;   //20 - 100
#declare ElementRadius3 = 15;   //20 - 100

#declare CloudBrightness1 = .00001; //.5 .01 - 1: smaller is brighter 
#declare CloudBrightness2 = .08;  // .01 - 1: smaller is brighter 
#declare CloudBrightness3 = .08;  // .01 - 1: smaller is brighter 

#declare CuNumElements = 30;   // 10 - 50  30
#declare CuElementRadius = 20;   //20 - 100
#declare CuCloudBrightness1 = .005; // .01 - 1: smaller is brighter 
#declare CuCloudBrightness2 = 1;  // .01 - 1: smaller is brighter 
#declare DegToRad = 3.14159 / 180;

#declare CloudScale = 20;


#declare Media1 =
media {
	//emission 0.1/CloudScale   
	scattering {2, <.1,.1,.1> extinction CloudBrightness1/CloudScale}
	//absorption rgb<.02,.02,.05>
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end
	density {
		bozo
		turbulence 5  //1 = convective 10 = stratiform
		color_map {
			[0.0 color rgb <0, 0, 0>]
			[0.2 color rgb <.2, .2, .2>]
			[0.8 color rgb <.5, .5, .5>]
			[1.0 color rgb <.9, .9, .9>]
		}
	}
	scale 10
}

#declare Cloud1 = 
  blob { 
     threshold .6
     #declare N=1;
     #while (N<NumElements1)
//        sphere { <rand(R1)*ElementRadius1, rand(R1)*ElementRadius1 , rand(R1)*ElementRadius1>, ElementRadius1,1 
        sphere{ < (rand(R1) * ElementRadius1) + rand(R1), 
                  (rand(R1) * ElementRadius1) + rand(R1), 
                  (rand(R1) * ElementRadius1) + rand(R1) >,
                  ElementRadius1 + rand(R1),1
           scale <.5,1,.5>
           rotate <rand(R1)*180,rand(R1)*180,rand(R1)*180>
        }
        #declare N = N + 1;
     #end 
     double_illuminate
     texture{pigment{rgbt <1,1,1,1>}}
     finish { ambient 1 diffuse 1 }
     hollow on
     interior { media { Media1 }}      
     sturm  
}



