#version 3.5;       


#include "colors.inc"
#include "stones.inc"
#include "woods.inc" 
#include "metals.inc"
#include "functions.inc" 
#include "transforms.inc"

#declare High_MSamples = 0; //0 = few media samples (faster), 1 = many media samples (slower)
#include "ACloud.inc" 


#declare cm = .01;                 
#include "units.inc"                                                   

#include "Chemicals.inc"   
                                               
#declare R1 = seed(4456);
#declare PreTrace = 0;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 1; //1 - 3
#default {finish{ambient 0 } }     


#declare SlowLight = 1;                     
#declare DrawCloud = 1;
#declare DrawPipes = 1; 
#declare DrawChem =  1;

global_settings{ assumed_gamma 1  
                 max_trace_level 100

#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 50  //50
        error_bound 0.5
        recursion_limit 4
        nearest_count 1
        gray_threshold 0
        brightness 1.5    
        media on
        normal on 
        always_sample off
        save_file "PlasticsRad1"
     #else 
        load_file "PlasticsRad1"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008   //A=.01  B=.007
        count 200              //A=200  B=100
        error_bound 0.12       //A=.25  B=.15
        recursion_limit 3      //A=1    B=3
        brightness 1.0
        nearest_count 5
        media on
        normal on 
        always_sample off
        save_file "PlasticsRad2"
     #else 
        load_file "PlasticsRad2"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 400   
        error_bound 0.06
        recursion_limit 4 
        brightness 1.0
        nearest_count 8
        media on
        normal on
        always_sample off
        save_file "PlasticsRad3"
     #else 
        load_file "PlasticsRad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}
                                                           
camera {
    angle 60
//      location <18 * Feet, 6 * Feet, 23 * Feet> 
      location <15 * Feet, 6 * Feet, 21 * Feet> 
      look_at <30 * Feet, 4 * Feet, 28 * Feet>
  } 
  
//plane{y,0 pigment{color Green}} 

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.0  color Yellow * .5]
        [ 0.4  color LightBlue * .5]
        [ 0.9  color Blue * .5]
      }
      scale 2 * Feet
      translate -1.1 * Feet
    }
  } 
 
  
#if (SlowLight)
#declare Light1=   
light_source {        //outside
     0*x                 // light's position (translated below)
     color Gold * 2     // Gold
     area_light <5 * Feet,0,0> <0, 0, 5 * Feet> // lights spread out across this distance (x * z)
     8, 8                // total number of lights in grid (4x*4z = 16 lights)
     adaptive 1          // 0,1,2,3...
     circular            // make the shape of the light circular
     orient              // orient light
     jitter              // adds random softening of light                           
     translate <-50 * Feet, 13 * Feet, 100 * Feet> // <-250 13 300> position of light 
   }   

   light_source {  //inside
     0*x                 // light's position (translated below)
     color rgb < 1,1,1> * 2.5     // 1.3 White
      area_light <8 * Feet,0,0> <0, 8 * Feet, 0> // lights spread out across this distance (x * z)
     8, 8                // total number of lights in grid (4x*4z = 16 lights)
     adaptive 2          // 0,1,2,3...
     circular            // make the shape of the light circular
     orient              // orient light
     jitter              // adds random softening of light
     fade_power 2
     fade_distance 15 * Feet //10
     translate <18 * Feet, 9.8 * Feet, 8 * Feet> // <x y z> position of light
   }
    
   light_source {  //inside
     0*x                 // light's position (translated below)
     color Gold * .5   
     translate <15 * Feet, 6.5 * Feet, 21 * Feet> 
     shadowless
   }
   
  light_source {  //outside
     0*x                 // light's position (translated below)
     color Gold * .8
     translate <1400 * Feet, 160 * Feet, 1500 * Feet> 
     shadowless
   } 


   
#else

   light_source {
     0*x                 // light's position (translated below)
     color rgb <1,1,1>      // light's color
     translate <23 * Feet, 8 * Feet, 23 * Feet>  
     shadowless
   }                   
#end  //Slow Light
 

#declare StainTex1= texture{
  pigment {
            bozo
            color_map {
                       [0 color rgbt <0,0,0,.7>]  
                       [1 color rgbt <1,1,1,.9>]
            } warp{turbulence 1.5} 
  } 
}

#declare StainTex2= texture{
  pigment {
            agate
            color_map {
                       [0 color rgbt <.5,.5,.5,.7>]
                       [1 color rgbt <1,1,1,.7>]
            } 
  }  
}  
#declare StainTex3= texture{
  pigment {
            agate
            color_map {
                       [0 color rgbt <0,0,0,.92>]
                       [1 color rgbt <1,1,1,.92>]
            } 
  }  
}  
#declare StainTex4= texture{
  pigment {
            crackle
            color_map {
                       [0 color rgbt <.1,.1,.1,.5>]
                       [1 color rgbt <.9,.9,.9,.5>]
            } 
  }  
}  
             
#declare BuildingTex=  
material {
          texture { T_Wood10 
                    normal{bumps 1 scale .01 no_bump_scale}
                    finish{ambient .2 diffuse .2} 
                  }
                   
         texture{StainTex2 scale 7 * Feet}    
} 

#declare StoolTex1=
material{
          texture { T_Wood1 rotate<90,0,0> scale .15
                    //normal{bumps 1 scale .01 no_bump_scale}
                    finish{ambient 0 diffuse .5 reflection .05} 
                  }
          texture{StainTex2 scale .2 * Feet}    
}
#declare StoolTex2=
material{
          texture { T_Wood1 rotate<0,90,0> scale .2
                    //normal{bumps 1 scale .01 no_bump_scale}
                    finish{ambient 0 diffuse .5 reflection .05} 
                  }
          texture{StainTex2 scale .1 * Feet}    
}

#declare fn_Pigm1=function {
    pigment {
      agate
      color_map {
        [0 color rgb .5]
        [1 color rgb 1]
      }
    }
  }
#declare fn_Pigm2=function {
    pigment {
      agate
      color_map {
        [0 color rgb .5]
        [1 color rgb 1]
      }
    }
  }

#declare Isosfc1 = 
isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm1(x, y, z).gray*.5}

    contained_by { box { -1, 1 } } 
    max_gradient 4.88                 
  } 

#declare Isosfc2 = 
isosurface {
    function { f_rounded_box(x,y,z, .8, 1, 1, 1) - fn_Pigm2(x, y, z).gray*.5}

    contained_by { box { -1, 1 } } 
    max_gradient 5.025                 
  } 

#declare Brick =
#object{Isosfc2 
        scale <.25 * Feet,.12 * Feet,.25 * Feet>
        texture{T_Stone8 scale .05}
}

#declare Floor =
#declare X = 0;
#while (X<50)
#object{Isosfc2 
        scale <1 * Feet,.1 * Feet,40 * Feet>
        material{BuildingTex translate<rand(R1)*30 * Feet,rand(R1)*3 * Feet,rand(R1)*3 * Feet>}
        finish { 
                ambient 0
                diffuse 0.6
                reflection 0.05
        }
        translate <X * Feet, 2 * Feet, 0 * Feet>
}
   #declare X = X + 1.5;
#end

#object{Floor}

#declare WallLeft = 
union {
   difference{   
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <50 * Feet, 10 * Feet, .2 * Feet>
        pigment{color LightBlue}  
        normal{bozo .08 scale .02 no_bump_scale}
        texture{StainTex4 scale .01}
        finish{ambient 0 diffuse .6}
        translate <0 * Feet,0,30 * Feet>   
       }
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <3.5 * Feet, 2 * Feet, 5 * Feet>   //x=2
        translate <26.5 * Feet,6.5 * Feet,30 * Feet>   

        }
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <2 * Feet, 2 * Feet, 5 * Feet>
        translate <35 * Feet,6.5 * Feet,30 * Feet>   

        } 
   cutaway_textures 

   }
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <3.4 * Feet, 1.99 * Feet, .05 * Feet>  //x=1.99
        pigment{color rgbt<1,1,1,.9>}
        finish{  ambient 0
                 diffuse 0
                 reflection .15  
                 specular  .9
                 roughness .0005 
              }  
         hollow
         interior {
                   ior 1.7 
         } 
         translate <26.5 * Feet,6.5 * Feet,30 * Feet>   

        }
   
}
   
#declare Window= 
union{ 
      box { //Top
           <-1, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1,  1>  // other corner position <X2 Y2 Z2>        
           scale <3.5 * Feet, .2 * Feet, .3 * Feet>
           texture{T_Wood13 rotate<0,90,0> scale <1,.3,1>  }    
           texture{StainTex1 scale .3 * Feet}    
           finish {         
                   ambient 0
                   reflection .05
                   }
           translate <26.25 * Feet,8.5 * Feet,29.9 * Feet>   
           }
      box {   //Bottom
           <-1, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1,  1>  // other corner position <X2 Y2 Z2>        
           scale <3.5 * Feet, .2 * Feet, .3 * Feet>
           texture{T_Wood13 rotate<0,90,0> scale <1,.3,1> }    
           texture{StainTex1 scale .5 * Feet}    
           finish {         
                   ambient 0
                   reflection .05
                   }
           translate <26.25 * Feet,4.5 * Feet,29.9 * Feet>   

           }
      box {  //Left
           <-1, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1,  1>  // other corner position <X2 Y2 Z2>        
           scale <.25 * Feet, 2 * Feet, .3 * Feet>
           texture{T_Wood13 rotate<90,0,0> scale <.3,1,.3> }    
           texture{StainTex1 scale .2 * Feet}    
           finish {         
                   ambient 0
                   reflection .05
                   }
           translate <23 * Feet,6.5 * Feet,29.91 * Feet>   
           }
      box {  //Right
           <-1, -1, -1>  // one corner position <X1 Y1 Z1>
           < 1,  1,  1>  // other corner position <X2 Y2 Z2>        
           scale <.25 * Feet, 2 * Feet, .3 * Feet>
           texture{T_Wood13 rotate<90,0,0> scale <.3,1,.3> }    
           texture{StainTex1 scale .4 * Feet}    
           translate <29.5 * Feet,6.5 * Feet,29.91 * Feet>   
           finish {         
                   ambient 0
                   reflection .05
                   }
           }
          
}    
  
#declare WallRight =    box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <30 * Feet, 10 * Feet, 1 * Feet>
        rotate<0,90,0>
        translate <33 * Feet,0,0 * Feet>  //x=40 
        texture{
           pigment{color LightBlue}
           normal{bozo .05 scale .02 no_bump_scale}
        }
        texture{StainTex4 scale .01}
        finish{ambient .0 diffuse .6}
}

#declare Ceiling =  
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <50 * Feet, 1 * Feet, 30 * Feet>
        texture{pigment{color LightBlue } }
        finish{ambient .2
               diffuse .6
               }                 
        normal{bozo .15 scale .03 no_bump_scale}
        texture{StainTex4 scale .02}
        translate <0,10 * Feet,0>   
       }

#declare Bench = 
union{
   box {  //Top
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <29 * Feet, .25 * Feet, 1.5 * Feet>
        texture{T_Wood13 rotate<0,90,0> scale <1,.09,.7> normal{dents .007 scale .006 no_bump_scale} }//normal{dents .01 scale .008 no_bump_scale} }    
        texture{StainTex2 scale 2 * Feet }
        finish {
                ambient 0
                diffuse .7
                reflection .05
                } 
        translate <0 * Feet,4 * Feet,28.5 * Feet>   
       } 
   box {    //Front
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        scale <29 * Feet, .1 * Feet, .25 * Feet>
        texture{T_Wood13 rotate<0,90,0> scale .25 normal{dents .03 scale .01 no_bump_scale}}     
        texture{StainTex2 scale 3 * Feet }    
        rotate<90,0,0>
        finish {         
                ambient 0
                diffuse 0
                reflection .05
                }
        translate <0 * Feet,4 * Feet,27 * Feet>   
       } 
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <.3 * Feet, 1 * Feet, .3* Feet>
        texture{T_Wood13 rotate<90,0,0> scale .25 normal{dents .03 scale .01 no_bump_scale}} 
        texture{StainTex2 scale 1 * Feet translate <0,-1 * Feet,0>}    
        finish {         
                ambient 0
                diffuse .1
                reflection .05
                }
        translate <28.5 * Feet,3 * Feet,27.3 * Feet>   
       } 
   box {
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <.3 * Feet, 1 * Feet, .3* Feet>
        texture{T_Wood13 rotate<90,0,0> scale .25 normal{dents .03 scale .01 no_bump_scale}} 
        texture{StainTex2 scale 1 * Feet}    
        finish {         
                ambient 0
                diffuse .1
                reflection .05
                }
        translate <23 * Feet,3 * Feet,27.3 * Feet>   
       }
 
}  

#declare Shelf1 = 
union{
   box {  //Top
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <22.75 * Feet, .12 * Feet, 1 * Feet>
        texture{T_Wood13 rotate<0,90,0> normal{bumps .3 scale .3 no_bump_scale} translate<-5*Feet,0,2 * Feet>}     
        texture{StainTex2 scale 3 * Feet }
        translate <0 * Feet,7 * Feet,29.0 * Feet>   
       } 
   box {    //Front
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        scale <22.75 * Feet, .1 * Feet, .12 * Feet>
        texture{T_Wood13 rotate<0,90,0> scale .5  normal{dents .04 scale .01 no_bump_scale} translate<-5*Feet,0,1 * Feet>}     
        texture{StainTex2 scale 3 * Feet }    
        rotate<90,0,0>
        translate <0 * Feet,7 * Feet,27.9 * Feet>   
       }                 
       finish{ambient 0 diffuse 0}
}     

#declare Bracket=
       prism {
               linear_spline
               0, // sweep the following shape from here ...
               1.5, // ... up through here
               3, // the number of points making up the shape ...
              <0,0>, <0,1>, <.5,.5>   
              scale <.7,.07,.7>  * .7
              texture{T_Wood13 rotate<0,90,0>  scale .25 normal{dents .05 scale .01 no_bump_scale} translate<-4*Feet,0,1 * Feet>}     
              texture{StainTex2 scale 3 * Feet }
              finish {ambient 0 diffuse 0}    
              rotate <0,0,90> rotate <45,0,0>
       }  

#declare Shelf2=
union{
   box {  //Top
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        
        scale <22.75 * Feet, .12 * Feet, 1 * Feet>
        texture{T_Wood13 rotate<0,90,0>  normal{bumps .3 scale .3 no_bump_scale} translate<-5*Feet,0,2 * Feet>}     
        texture{StainTex2 scale 3 * Feet }
        translate <0 * Feet,5.5 * Feet,29.0 * Feet>   
       } 
   box {    //Front
        <-1, -1, -1>  // one corner position <X1 Y1 Z1>
        < 1,  1,  1>  // other corner position <X2 Y2 Z2>
        scale <22.75 * Feet, .1 * Feet, .12 * Feet>
        texture{T_Wood13 rotate<0,90,0> scale .5 normal{dents .04 scale .01 no_bump_scale} translate<-4*Feet,0,1 * Feet>}     
        texture{StainTex2 scale 3 * Feet }
        finish {ambient 0 diffuse 0}    
        rotate<90,0,0>
        translate <0 * Feet,5.5 * Feet,27.9 * Feet>   
       }
   #object{Bracket      
              translate <22.6 * Feet, 6.9 * Feet, 28.7 * Feet>
   }  
   #object{Bracket      
              translate <22.6 * Feet, 5.4 * Feet, 28.7 * Feet>
   }  
 
       finish{ambient 0}
}

#declare Stool=
union{ 
       cylinder{ 0*y*Feet, 3.5*y*Feet, .1*Feet
                 Rotate_Around_Trans(<10,0,0>, <0,1,0>) 
                 translate <0*Feet,0*Feet,-.2*Feet>
                 material{StoolTex1}
               }
       cylinder{ 0*y*Feet, 3.5*y*Feet, .1*Feet
                 Rotate_Around_Trans(<-10,0,10>, <0,1,0>) 
                 translate <.2*Feet,0*Feet,.2*Feet>
                 material{StoolTex1}
               }
       cylinder{ 0*y*Feet, 3.5*y*Feet, .1*Feet
                 Rotate_Around_Trans(<-10,0,-10>, <0,1,0>) 
                 translate <-.2*Feet,0*Feet,.2*Feet>
                 material{StoolTex1}
               }                                
               
       cylinder{ -.4*x*Feet, .4*x*Feet, .05*Feet
                 rotate <0,65,0> 
                 translate <-.15*Feet,2.6*Feet,0*Feet> 
                 material{StoolTex2}
               }
       cylinder{ -.4*x*Feet, .4*x*Feet, .05*Feet
                 rotate <0,-65,0> 
                 translate <.15*Feet,2.6*Feet,0*Feet>
                 material{StoolTex2}
               }
       cylinder{ -.4*x*Feet, .4*x*Feet, .05*Feet
                 rotate <0,180,0> 
                 translate <0*Feet,2.6*Feet,.34*Feet>
                 material{StoolTex2}
               } 
               
      torus{ .5*Feet, .5*Feet
              scale <.5,.3,.5>
              translate<0*Feet,3.5*Feet,.1*Feet>
              texture{
                       pigment{color DarkTan }
                       finish{ambient 0
                              diffuse .5
                              reflection .05 
                       }
                       normal{quilted .03 scale .05 no_bump_scale}
                     }                 
       } 
       
       pigment{color White}           
       rotate<0,0,0>
}

#if(DrawCloud)
   #object {Cloud1 
           scale <CloudScale*3 * Feet,CloudScale * Feet,CloudScale*1.3*Feet>
           translate <1800 * Feet,50 * Feet,1500 * Feet>
          }     
#end 


#object{Floor}
#object{WallLeft} 
//#object{Window}
//#object{Window translate<10*Feet,0,0>}
//#object{WallRight}
light_group {
  light_source {Light1}
  #object{WallRight}
  #object{Window} 
  #object{Mug
          translate <27.4*Feet,4.25*Feet,27.3*Feet>
  }
  #object{Gas}
  #object{Burner
          translate <25.5*Feet,4.25*Feet,27.6*Feet>
  }             
  #object{Flask
        interior {
                  ior 1.7 
                  caustics .5 
                  media{WhiteMedia}
        }

        translate <24.3 * Feet, 4.7 * Feet, 28.5 * Feet>
  }
  #object{ChemStand
        translate <23.5*Feet,4.25*Feet,28.0*Feet>
  }
  #object{StirRod 
        translate<24.0*Feet,5.4 * Feet, 28.25 * Feet>
  }
  #if(DrawPipes)
      #object{Pipes} 
  #end  
  global_lights on
} 
#object{Ceiling}
#object{Bench} 
#object{Bench 
        rotate <0,90,0> 
        translate<-10 * Feet,0 ,-6.5 * Feet>
} 

#object{Shelf1}
#object{Shelf2} 


#if(DrawChem) 


#object{WideMouthBottle
        interior {
                  ior 1.7   
                  media{RedMedia}
        }
        translate <21.5 * Feet, 7.2 * Feet, 28.5 * Feet>
       }
       
#object{WashBottle
        interior {
                  ior 1.7 
                  media{BlueMedia}
        }
        translate <22.2 * Feet, 7.2 * Feet, 28.5 * Feet>
       } 
      
#object{Vial
        interior {
                  ior 1.7   
                  media{BlueMedia}
        }
        translate <22* Feet, 5.6 * Feet, 29 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{RedMedia}
        }
        translate <22.3* Feet, 5.6 * Feet, 28.8 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{BlueMedia}
        }
        translate <21.0* Feet, 5.6 * Feet, 28.7 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{RedMedia}
        }
        translate <20.5* Feet, 5.6 * Feet, 28.6 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{BlueMedia}
        }
        translate <21.2* Feet, 5.6 * Feet, 28.5 * Feet>
       }

#object{GraduatedCylinder
        translate<21.0*Feet,4.25 * Feet, 28.7 * Feet>
       }

#object{GraduatedCylinder  scale 1.2
        translate<20.9*Feet,7.2 * Feet, 28.7 * Feet>
       }

#object{Pencil
        translate<20.9 *Feet,4.31 * Feet, 27.5 * Feet>
       }                       
                                     
#object{Pad
        translate<22.0 *Feet,4.3 * Feet, 27.8 * Feet>
       } 

#object{Pages
        translate<22.0 *Feet,4.23 * Feet, 27.8 * Feet>
       } 

#object{Stool
        translate <24.0 * Feet, 0 * Feet, 26 * Feet>
       }


//Near Table
#object{Vial
        interior {
                  ior 1.7   
                  media{RedMedia}
        }
        translate <18.7* Feet, 4.23 * Feet, 22.2 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{RedMedia}
        }
        translate <18.3* Feet, 4.23 * Feet, 21.4 * Feet>
       }
#object{Vial
        interior {                                                   
                  ior 1.7   
                  media{BlueMedia}
        }
        translate <18.8* Feet, 4.23 * Feet, 21.7 * Feet>
       }
#object{Vial
        interior {
                  ior 1.7   
                  media{BlueMedia}
        }
        translate <18.1* Feet, 4.23 * Feet, 22.0 * Feet>
       }

#object{BubbleBottle  
        scale .5
        interior {
                  ior 1.7 
                  caustics .001
                  media {BrownMedia translate <0,-1,0>}   
        }
        rotate<-2,0,-2>
        translate <19.3 * Feet, 4.79 * Feet, 20.9 * Feet>
}

#object{ChemStand
        scale .5
        translate <19.05*Feet,4.25*Feet,20.82*Feet>
}

             
#end
 
#declare T_Ground=
texture {
  pigment {
    crackle metric 1 form<0.8,0,0> 
    color_map {
      [0.0 color DarkTan * .5 ]
      [0.5 color DarkGreen  ] 
      [1.0 color DarkBrown * .5  ]
    }
    scale 200
  }
  finish {ambient <0.8, 0.9, 1.4>*0.65  //35
          diffuse 0.8
         }

  normal {
          granite .5
          scale 50000 
  }
}
 


#declare T_Rock=
texture {
  pigment {
    agate
    color_map {
      [0.2 color rgb <0.55, 0.50, 0.40> ]  
      [0.6 color rgb <0.75, 0.50, 0.50> ]  
      [1.0 color rgb <0.70, 0.60, 0.50> ]  
    }
    scale 1
    warp { turbulence 0.5 }
  }
  finish {ambient <0.8, 0.9, 1.4>*0.65  //35
          specular .01 roughness 1
          diffuse 0.2
         }

  normal {
          granite 0.6
          scale 10 //0.1
  }
  scale 1/40
} 

  
#declare Terrain=
            height_field {
            tga "Land1.tga" 
            smooth
            rotate y*10
            scale <2000 * Feet,190 * Feet,4000 * Feet> * 1   //2000,190,4000
            translate<-1400 * Feet,-102 * Feet,500 * Feet>  
          }                                       

   
object {
  Terrain  
   texture {  
             slope {<0,-1,0>,0,0.5}   
             texture_map {
                          [0.0  T_Ground]
                          [0.10  T_Ground]
                          [0.15  T_Rock scale 500]
                          [0.20  T_Stone10 scale 500 ]
                          [1.0  T_Stone10 scale 500 ]    
                         } 
   }
} 
