// Textures
#declare camera_wood =
   material{
   texture  // txt_87
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.8, 0.67, 0.25, 0.0, 0.0> ]
            [ 0.222   rgbft <0.8, 0.67, 0.25, 0.0, 0.0> ]
            [ 0.342   rgbft <0.6, 0.34, 0.04, 0.0, 0.0> ]
            [ 0.393   rgbft <0.8, 0.67, 0.25, 0.0, 0.0> ]
            [ 0.709   rgbft <0.8, 0.67, 0.25, 0.0, 0.0> ]
            [ 0.821   rgbft <0.53, 0.29, 0.02, 0.0, 0.0> ]
            [ 1.0     rgbft <0.8, 0.67, 0.25, 0.0, 0.0> ]
         }
         turbulence 0.02
         ramp_wave
         scale  0.1
         translate 10.0 * x
      }
      finish{
        ambient 0
        specular 0.5
        roughness 0.1
      }
   }
   texture  // txt_88
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 0.12    rgbft <0.7, 0.41, 0.11, 0.6, 0.0> ]
            [ 0.231   rgbft <0.7, 0.46, 0.11, 0.6, 0.0> ]
            [ 0.496   rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 0.701   rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 0.829   rgbft <0.7, 0.46, 0.11, 0.6, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
         }
         turbulence 0.01
         ramp_wave
         scale  0.5
         translate 10.0 * x
      }
      finish{
        ambient 0
        specular 0.5
        roughness 0.1
      }
   }
   }

#declare camera_metal =
texture{pigment{rgb <1,1,0>}
        finish{ambient 0 diffuse 1 specular 0.4 roughness 0.1}}





// objects
// Camera body
#declare cam1 = 
union{
        box{
                <0,0,0> <1,1,1>
                material{camera_wood}                
                scale <0.25,0.25,0.45>                
        }
        box{
                <0,0,0> <1,1,1>
                material{camera_wood}                
                scale <0.3,0.30,0.02>
                translate 0.45*z
                translate -0.05*y                
        }
        box{
                <0,0,0> <1,1,1>
                material{camera_wood}                
                scale <0.3,0.30,0.02>
                translate -0.02*z
                translate -0.05*y                
        }
        // main lense
        difference{
                cylinder{
                        <0.2,0.2,0.2>
                        <0.28,0.2,0.2>
                        0.05
                        texture{camera_metal}
                }
                cylinder{
                        <0.2,0.2,0.2>
                        <0.35,0.2,0.2>
                        0.04
                        texture{camera_metal}
                }
                
        }
        // bogus lenses
        cylinder{
                        <0.2,0.15,0.3>
                        <0.274,0.15,0.3>
                        0.02
                        texture{camera_metal} 
                }
        // little window
        cylinder{
                        <0.2,0.15,0.3>
                        <0.20,-0.008,0.3>
                        0.035
                        texture{camera_metal}
                        translate<-0.1,0,-0.1> 
                }
        cylinder{
                        <0.2,0.15,0.3>
                        <0.20,-0.01,0.3>
                        0.010
                        texture{camera_metal}
                        translate<-0.1,0,-0.085> 
                }
        
        scale <0.8,0.8,0.8>
        translate <-0.10,-0.1,1.35>
        rotate -90*z
}


#declare camera_leg =
union{
        box{
                <0,0,0>
                <1,1,1>
                material{
                        camera_wood
                }
                scale <0.03,0.03,1>
        }
        box{
                <0,0,0>
                <1,1,1>
                material{
                        camera_wood
                }
                scale <0.03,0.03,1>
                translate 0.066*x
        }
        box{
                <0,0,0>
                <1,1,1>
                material{
                        camera_wood
                }
                scale <0.03,0.03,1>
                translate <0.03,0,0.3>
        }
        cylinder{ 
                <0.045,0.02,0.6>
                <0.045,0.02,1.32>
                0.01
                texture{camera_metal}
        }
        box{
                <0,0,0>
                <1,1,1>
                texture{
                        camera_metal
                }
                scale <0.1,0.05,0.05>
                translate <0,-0.005,0.9>
        }
        box{
                <0,0,0>
                <1,1,1>
                texture{
                        camera_metal
                }
                scale <0.1,0.05,0.05>
                translate <0,-0.005,0.55>
        }
        cylinder{
                <-0.01,0.02,0.02>
                <0.13,0.02,0.02>
                0.01
                texture{ camera_metal
                }
        }
        sphere{
                0.0
                0.04
                texture{camera_metal}
                scale <0.3,0.3,1>
                rotate 30*x
                translate <-0.01,0.02,0.57>
        }
        sphere{
                0.0
                0.04
                texture{camera_metal}
                scale <0.3,0.3,1>
                rotate -30*x
                translate <-0.01,0.02,0.925>
        } 
        translate <-0.045,0.06,0>
        
}
 
#declare legs_cam =
union{
        object{
                camera_leg
                rotate 160*x
                
                
        }
        object{
                camera_leg
                rotate 160*x
                 
                rotate 120*z
                
        }
        object{
                camera_leg
                rotate 160*x
                
                rotate -120*z
                
        }
        translate 1.225*z
} 

#declare camera_hinge = 
union{ 
        cylinder{ 
                <0,0,-0.45>
                <0,0,0.33>
                0.02
                texture{camera_metal}
        }
        
        difference{
        
        intersection{
                union{
                box{ 
                        <-0,-0.01,0.15>
                        <0.12,0.01,0.3>
                        material{
                                camera_wood
                        }
                }
                box{ 
                        <-0,-0.01,0.15>
                        <0.12,0.01,0.3>
                        material{
                                camera_wood
                        }
                        rotate -120*z
                }
                box{ 
                        <-0,-0.01,0.15>
                        <0.12,0.01,0.3>
                        material{
                                camera_wood
                        }
                        rotate 120*z
                }
                } 
      
                        cone {
                          0*z,  0.9,
                          .3*z, 0.05
                          // open
                          material{
                                        camera_wood
                                }
                        } 

                }
                cylinder{ 
                                <0,0,-0.5>
                                <0,0,0.2>
                                0.08
                                material{
                                camera_wood
                                }
        }
        }
        //
        union{ 
        cylinder{
                <0,0,-0.25>
                <0,0,-0.30>
                0.05
                texture{camera_metal}
        }
        cylinder{ 
                <0,0,-0.275>
                <0.25,0,-0.275>
                0.01
                texture{camera_metal}
        }
        cylinder{ 
                <0,0,-0.275>
                <0.25,0,-0.275>
                0.01
                texture{camera_metal}
                rotate 120*z
        }
        cylinder{ 
                <0,0,-0.275>
                <0.25,0,-0.275>
                0.01
                texture{camera_metal}
                rotate -120*z
        }
        translate -0.02*z
        }



        
        translate <0,0,1>
        
}

#declare manivelle =
union{
        cylinder{
                <0,0,0>
                <0.2,0,0>
                0.015
                texture{camera_metal}
        }
        box
        { 
                <0.18,-0.02,-0.04>
                <0.18,0.22,0.04>
                texture{camera_metal}
        }
        cylinder
        {       <0.16,0.18,0>
                <0.32,0.18,0>
                0.02
                material{camera_wood rotate 90*z}
        } 
        rotate -84 * x
        translate 1.55*z       
}

#declare camera_all = 
union{
        object{legs_cam}
        object{cam1}
        object{camera_hinge
                rotate 30*z}
        object{manivelle}        
}