
#declare fancy_light = 1;

#declare llight = array[4] {<0,0,3.5>, <5,0,3.5>, <9.5,0,3>, <-9.5,0,3>};

#declare ceiling_l_color = rgb <0.9,0.9,1> * 0.05 ;
#declare amber_ligths = rgb <0,0.05,0.5> * 0.02 ;

#declare cl = 20;
#declare sp = 0.2;

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.23
  translate  <-3.009826, -4.728431, 14.310659>
}

// Shades



// simple lights
#if(fancy_light = 0)
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb ceiling_l_color    // light's color
  translate llight[0]
}
light_source {
  0*x                  // light's position (translated below)
  color rgb ceiling_l_color    // light's color
  translate llight[1]
}


#else
#if(fancy_light = -1)
#else

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb ceiling_l_color       // light's color
  area_light
  <sp, 0, 0> <0, 0, sp> // lights spread out across this distance (x * z)
  cl, cl                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate llight[0]   // <x y z> position of light
}
light_source {
  0*x                 // light's position (translated below)
  color rgb ceiling_l_color       // light's color
  area_light
  <sp, 0, 0> <0, 0, sp> // lights spread out across this distance (x * z)
  cl, cl                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate llight[1]   // <x y z> position of light
}

#end
#end


light_source {
  0*x                  // light's position (translated below)
  color rgb amber_ligths    // light's color
  translate llight[2]
}
light_source {
  0*x                  // light's position (translated below)
  color rgb amber_ligths    // light's color
  translate llight[3]
}
