/* 
        paperwork.inc
        
        Provide a macro to generate paper scattered on the floor
        
        Author: Christian Blouin
        Date  : March 16th 2004
        URL   : http://www.cs.dal.ca/~cblouin/

*/

// ----------------------------------------

#declare blank = 
   material  // blank
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>*0.1
         }      
         finish
         {
            ambient 0.0
         }
      }
   }
#declare paper_white =
material  // blank
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.0
         }
      }
   }

#declare corner_heigth = 0.35;
#declare edge_heigth = 0.15;

#macro rnd_sht(sseed)
bicubic_patch {
  type 1 // patch_type (0..1)
  // 0 = Bezier patch, just store the triangular vertices
  // 1 = Bezier patch, store all plane equations defined by
  //       the triangulation of the patch into sub patches
  //       (faster, uses more memory)
   flatness 0.1 // flatness value
  //       flatness_value = 0.0 to 1.0, with higher values
  //        giving flatter, less smooth results
  u_steps 4 // # of triangles to subdivide (1-5)
  v_steps 4 // # of triangles to subdivide (1-5) 
  #local eh = RRand(0,edge_heigth, sseed);
  #local ch = max(0, RRand(0,corner_heigth, sseed) - eh);
  <0, 0, 0> <1, 0, 0> <2.3, 0, 0> <3, 0, eh>
  <0, 1, 0> <1, 1, 0> <2.3, 1, 0> <3, 1,  eh>
  <0, 2, 0> <1, 2, 0> <2.3, 2, 0> <3, 2,  eh>
  <0, 3, 0> <1, 3, 0> <2.3, 3, 0> <3, 3, ch> 
  scale <1,8.5/11,1>*(8/36)*0.5
  translate <0,0,0.055>
  material {paper_white}
}
#end

#include "rand.inc"
#declare ss = seed(127);
#declare b = 9.5;

#macro random_sheet(sd, xmin, xmax, ymin, ymax)
        
    object {
        rnd_sht(sd)
        rotate < 0, 0,RRand(0,360,sd)>
        translate <RRand(xmin,xmax,sd), RRand(ymin,ymax,sd),0> 
        }
#end


#macro clutter_paper(number, xmin, xmax, ymin, ymax, sd)
        #while(number >= 0)
                random_sheet(sd, xmin, xmax, ymin, ymax)
        #declare number = number - 1;
        #end
#end        

clutter_paper(80,-b,0,-b,b,ss) 
clutter_paper(160,-b,-8.25,-b,b,ss) 
clutter_paper(160,-5,0,-b,b,ss)
