/*
  reel.inc
  
  Texture definition for the reel tin cases.
  
  The texture are defined by default at include time. The two macro are there to redefine the tin using 
  alternative color vectors
  
  Author : Christian Blouin
  Date   : March 13th 2004

*/ 


#declare reel_case_steel = 
   material  // reel_case_steel
   {   
      texture
      {      
         pigment
         {
            color rgb <0.39, 0.41, 0.43> 
            //reel_case_color
         }      
         normal
         {
            bumps , 0.05
            scale  0.05
         }      
         finish
         {
            ambient 0.035
            diffuse 0.3
            brilliance 2.0
            specular 0.8
            reflection
            {
               0.1 , 0.1
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }
   
#declare reel_case_steel2 = 
   material  // reel_case_steel
   {   
      texture
      {      
         pigment
         {
            color rgb <0.39, 0.41, 0.43>
         }      
         finish
         {
            ambient 0.035
            diffuse 0.3
            brilliance 2.0
            specular 0.8
            reflection
            {
               0.1 , 0.1
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }

#macro redefine_case_color(acolor)
        #declare reel_case_steel = 
                material  // reel_case_steel
                {   
                        texture
                        {      
                                pigment
                                {
                                   //color rgb <0.39, 0.41, 0.43> 
                                   acolor
                                }      
                                normal
                                {
                                   bumps , 0.05
                                   scale  0.05
                                }      
                                finish
                                {
                                   ambient 0.00
                                   diffuse 0.99
                                   brilliance 1.0
                                   specular 0.2
                                   reflection
                                      {
                                        0.1 , 0.1
                                        fresnel  off
                                        falloff  1.0
                                        exponent 1.0
                                        metallic 0.0
                                      }
                                }
                        }
                }
        
#end 

#macro redefine_case_bottom_color(acolor)
        #declare reel_case_steel2 = 
                material  // reel_case_steel
                   {   
                      texture
                      {      
                         pigment
                         {
                            acolor
                         }      
                         finish
                         {
                            ambient 0.0
                            diffuse 0.3
                            brilliance 1.0
                            specular 0.2
                            reflection
                            {
                               0.1 , 0.1
                               fresnel  off
                               falloff  1.0
                               exponent 1.0
                               metallic 0.0
                            }
                         }
                      }
                   }                
        
#end