/*
  shelf.inc
  
  Texture and model definition for the shelf used to generate the cluttering area.
  
  Everything is in there, the only useful to know is that there is an object called shelf to call if one
  want an empty shelf.
  
  Author : Christian Blouin
  Date   : March 13th 2004

*/

#declare greymaple = 
material{
   texture  // txt_175
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
            [ 0.133   rgbft <0.509429, 0.487626, 0.574841, 0.0, 0.0> ]
            [ 0.23    rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
            [ 0.336   rgbft <0.487627, 0.464854, 0.555946, 0.0, 0.0> ]
            [ 0.442   rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
            [ 0.549   rgbft <0.498546, 0.476258, 0.565409, 0.0, 0.0> ]
            [ 0.646   rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
            [ 0.743   rgbft <0.596639, 0.578711, 0.650422, 0.0, 0.0> ]
            [ 0.85    rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
            [ 0.947   rgbft <0.520348, 0.499029, 0.584304, 0.0, 0.0> ]
            [ 1.0     rgbft <0.703778, 0.699224, 0.717443, 0.0, 0.0> ]
         }
         turbulence 0.1
         ramp_wave
         scale  <2.0, 2.0, 15.0>
         rotate 90.0 * z
         translate    <-8.0, 80.0, 0.0>
      }   
      finish
      {
         ambient 0.0
         diffuse 0.8
      }
   }
   texture  // txt_176
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.843733, 0.864567, 0.6979, 1.0, 0.0> ]
            [ 0.008   rgbft <0.754445, 0.787182, 0.525285, 1.0, 0.0> ]
            [ 0.508   rgbft <0.866067, 0.883923, 0.741077, 1.0, 0.0> ]
            [ 1.0     rgbft <0.843733, 0.864567, 0.6979, 1.0, 0.0> ]
         }
         scale  <1.5, 1.5, 0.375>
         rotate 90.0 * z
      }   
      finish
      {
         ambient 0.0
         diffuse 0.8
      }
   }
}


//
// ********  OBJECTS  *******
//

#declare shelf_horiz_1 = union {
  box { // plank1
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.19, 2.0>
  }
  box { // plank2
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.46, 2.0>
  }
  scale <1.15, 1.0, 1.0>
  translate  <-0.15, 0.0, -1.8>
}
#declare middle_traverse = union {
  box { // traverse1_15
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.03>
    translate  <1.0, 0.325, 3.14>
  }
  box { // traverse1_14
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.03>
    translate  <1.0, 0.325, 2.43>
  }
  box { // traverse1_13
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.03>
    translate  <1.0, 0.325, 1.74>
  }
  box { // traverse1_12
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.03>
    translate  <1.0, 0.325, 0.94>
  }
  box { // traverse1_11
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.03>
    translate  <1.0, 0.325, 0.13>
  }
  scale <1.0, 0.9, 1.0>
  translate  <0.0, 0.02, 0.015>
}
#declare traverse = union {
  box { // traverse1_1
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <0.0, 0.325, 0.1>
  }
  box { // traverse1_2
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <2.0, 0.325, 0.1>
  }
}
#declare traverse1 = union {
  box { // traverse1_3
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <0.0, 0.325, 0.1>
  }
  box { // traverse1_4
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <2.0, 0.325, 0.1>
  }
  translate  0.8*z
}
#declare traverse2 = union {
  box { // traverse1_5
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <0.0, 0.325, 0.1>
  }
  box { // traverse1_6
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <2.0, 0.325, 0.1>
  }
  translate  1.6*z
}
#declare traverse3 = union {
  box { // traverse1_7
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <0.0, 0.325, 0.1>
  }
  box { // traverse1_8
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <2.0, 0.325, 0.1>
  }
  translate  2.3*z
}
#declare traverse4 = union {
  box { // traverse1_9
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <0.0, 0.325, 0.1>
  }
  box { // traverse1_10
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.045, 0.28, 0.07>
    translate  <2.0, 0.325, 0.1>
  }
  translate  3.0*z
}
#declare shelf_vertical = union {
  box { // leg1
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.05, 0.05, 2.0>
    translate  2.0*z
  }
  box { // leg2
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.05, 0.05, 2.0>
    translate  <0.0, 0.65, 2.0>
  }
  box { // leg3
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.05, 0.05, 2.0>
    translate  <2.0, 0.65, 2.0>
  }
  box { // leg4
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.05, 0.05, 2.0>
    translate  <2.0, 0.0, 2.0>
  }
  object { middle_traverse }
  object { traverse }
  object { traverse1 }
  object { traverse2 }
  object { traverse3 }
  object { traverse4 }
}
#declare shelf_horiz_2 = union {
  box { // plank3
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.19, 2.0>
  }
  box { // plank4
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.46, 2.0>
  }
  scale <1.15, 1.0, 1.0>
  translate  <-0.15, 0.0, -1.0>
}
#declare shelf_horiz_3 = union {
  box { // plank5
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.19, 2.0>
  }
  box { // plank6
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.46, 2.0>
  }
  scale <1.15, 1.0, 1.0>
  translate  <-0.15, 0.0, -0.2>
}
#declare shelf_horiz_4 = union {
  box { // plank7
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.19, 2.0>
  }
  box { // plank8
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.46, 2.0>
  }
  scale <1.15, 1.0, 1.0>
  translate  <-0.15, 0.0, 0.5>
}
#declare shelf_horiz_5 = union {
  box { // plank9
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.19, 2.0>
  }
  box { // plank10
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <1.0, 0.13, 0.03>
    translate  <1.0, 0.46, 2.0>
  }
  scale <1.15, 1.0, 1.0>
  translate  <-0.15, 0.0, 1.2>
}

#declare shelf =
union { // shelf
  object { shelf_horiz_1 }
  object { shelf_vertical }
  object { shelf_horiz_2 }
  object { shelf_horiz_3 }
  object { shelf_horiz_4 }
  object { shelf_horiz_5 }
  box { // leg5
    <-1, -1, -1>, <1, 1, 1>
    material {
      greymaple
    }
    scale <0.05, 0.05, 1.65>
    translate  <1.0, 0.65, 1.65>
  }
}




