//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 2 lights, 4 materials and 10 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 03/11/2004    (11.03.2004)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.4 Beta For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.756863,0.74902,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
  // radiosity (global illumination) settings
  /*radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 100                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    save_file "radio"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }*/ 

}

background { color <0.000,0.000,0.000> }

#declare point_of_focus = <-6,5,0>;

camera {  //  Camera Camera01
  //ultra_wide_angle
  location  <     -8.124,      -4.949,       1.738>
  //location  <     -8.124,      -8.949,       1.738>
  //location  <     8.124,      -14.949,       9.738>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.77778,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         74.15329    // Vertical      55.615
  look_at   <     -4.788,       2.845,       1.761>
  //look_at   <     4.788,       2.845,       1.761>
  /*focal_point point_of_focus
  aperture 0.15
  blur_samples 1000
  confidence    0.99
  variance      1/1000
  */
} 


//
// *******  L I G H T S *******
//

#declare Spotlight001 = light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000,1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    8.012  // outer radius (in deg)
    radius     8.012  // inner radius
    tightness  1.387
  rotate <90.0, 0.0, 4.0>
  translate  <-5.0, -16.0, 1.5>
}




//
// ********  MATERIALS  *******
//

#include "basic2.inc"


//
// ********  REFERENCED OBJECTS  *******
//


// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object
/*
media {    // atmospheric media sample
  intervals 10
  scattering { 1, rgb 0.03 }
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9
}*/

//
// ********  OBJECTS  *******
//

#include "projector.inc"

#include "walls.inc"

// Lights
#include "lights.inc"

// Shelves ////////////////////////////////////////////////
#include "stacks.inc"



// Paper on the floor /////////////////////////////////////
#include "paperwork.inc"


// Stage code
#include "stage.inc"
union{
        stage(10.5,6,5)
        translate <4.0,5.0,0>
}
#include "tablechair.inc"
object{
        table_nosferatu 
        translate <3.55,4.25,0.10>
}


// Nosferatu
#include "nosferatu.inc"  
object{ 
        Nosferatu
        rotate 90*x
        scale 0.18
        translate point_of_focus

} 


 


// Signature
object{
height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "signature.png"     // the file name to read
  smooth 
  water_level 0.05
  scale <0.65,0.02,0.65>
        rotate 90*x
        rotate -30*z
        
        texture{
                pigment{
                        //rgb <1,0.8,0.05> 
                        rgb <0.2,0.05,0.05>
                }
                finish{
                        ambient 1
                        //diffuse 1
                }
        }
}
  translate <-3.85,-1.65,0.1>
}

#include "reel_label.inc"
object{
        reel_label
        translate <-7.124,      -4.949,       1.738>
}

/*sphere{
        <-7.7,8.5,0.1>
        0.5
        pigment{rgb <1,0,0>}
}*/   