/*
  stack.inc
  
  Macro procedure to generate a filled shelf
  
  Use the object called cluttered_shelf. This calls the more general cluttering macro.
  The API for the macro is:
  
  clutter_area(pseed, point1, point2, width_shelf, height, case_thickness, case_radius)
  point1 -> Point where to start the line-up.
  point2 -> Point to end the line-up.
  width_shelf -> how wide can the line of stackable object can be scattered.
  
  Author : Christian Blouin
  Date   : March 13th 2004

*/

// If there is no objects reclared as reel_case, it makes on up
#ifndef (reel_case) 
        #include "colors.inc"
        #declare reel_case =
        cylinder {
          0*z,  0.1*z,  0.7
          pigment {White}
          // open
        } 
#end
     
// Import section ////////////////////////////
#include "rand.inc" 
#include "reel.inc"
#include "shelf.inc"  

#declare ms = seed(12335); // color seed
#declare ms1 = seed(123451); // pile seed                                               
                                                 
#declare case_color = array[6] {rgb<1,1,1>, rgb<0.1,0.1,0.1>, rgb<1,0.5,0.05>,rgb<0.39, 0.41, 0.43>,rgb<0.39, 0.41, 0.43>, rgb<0.39, 0.41, 0.43>}

#macro random_color(last_index_color) 
        #if(RRand(0,1,ms) < 0.5) 
                #local tempvar = RRand(0,1000,ms);
                #local tempvar = mod(tempvar,6);
                #declare last_index_color = tempvar;        
        #end      
        #local bcol = last_index_color;
        #if(RRand(0,1,ms) < 0.15)
                #local tempvar = RRand(0,1000,ms);
                #local tempvar = mod(tempvar,6);
                #declare bcol = tempvar;    
        #end
        new_reel_case(case_color[last_index_color], case_color[bcol])
#end


#macro stack_reels(case_thickness, sigma_xy, pile_heigth, pile_x, pile_y, pile_z) 
        #local it = 0;
        #while(it < pile_heigth) 
                random_color(3)
                object
                {
                        reel_case
                        //material{reel_case_steel}
                        translate <Rand_Normal(pile_x,sigma_xy,ms1), Rand_Normal(pile_y,sigma_xy,ms1), pile_z + it*case_thickness>
                } 
                #local it = it + 1;       
        #end
#end       

// Clutter a shelf
#macro clutter_area(point1, point2, width_shelf, height, case_thickness, case_radius) 
        // How high can we stack?
        #declare max_height = (height/case_thickness);
        // Main axis vector  
        #local disp = point2 - point1;
        #local lendisp = sqrt(pow(disp.x,2)+pow(disp.y,2));
        #local numstack = lendisp / (2.1*case_radius) + 1;
        #local disp = disp / numstack;
        
        // Iterative loop to find new stacks 
        #local current_stack = point1;
        #local perturb = vcross(current_stack, <current_stack.x, current_stack.y, current_stack.z +1>); 

        #while(numstack >= 0)
                #local t_stack = current_stack + perturb * RRand(-0.12,0.12,ms1);
                stack_reels(case_thickness, 0.025, max_height* RRand(0.25,1,ms1), t_stack.x, t_stack.y, t_stack.z) 
                #local current_stack = current_stack + disp * RRand(0.97,1.1,ms1);
                #declare numstack = numstack - 1;
        #end
        
        
        
#end     


//
// ********  OBJECTS  *******
//

#declare top_reel = lathe {
  cubic_spline
  7  // control points
  <0.806759, 0.427013>,
  <1.985135, -0.054059>,
  <2.051831, 0.126508>,
  <2.0, 0.5>,
  <1.670164, 0.518796>,
  <0.0, 0.53965>,
  <1.0, 1.0>
  rotate <90,0,90>
  //material {
  //  reel_case_steel
  //}
  scale <1.0, 1.0, 0.5>
}        


#declare reel_case =
union { // reel_case
  cylinder { // bottom_reel
    <0,0,1>, <0,0,0>, 1 
    //material {
    //  reel_case_steel2
    //}
    scale <2.025, 2.025, 0.25>
    translate  <0.0, -0.026482, -0.2>
  }
  object { top_reel }
  //material {
  //  reel_case_steel
  //}   
  scale <2,2,1>
} 


#macro new_reel_case(top_color, bottom_color)  

        redefine_case_color(top_color)
        redefine_case_bottom_color(bottom_color)
        
        #declare reel_case =
        union { // reel_case
          cylinder { // bottom_reel
            <0,0,1>, <0,0,0>, 1 
            material {
              reel_case_steel2
            }
            scale <2.025, 2.025, 0.25>
            translate  <0.0, -0.026482, -0.2>
          }
          object { top_reel }
          material {
            reel_case_steel
          }   
          scale <0.12,0.12,0.08>
        }         
#end

//#include "shelf.inc"


#declare clutter_path = array[10] {
  <0.10,0.30,0.235>, <1.85,0.30,0.235>,
  <0.10,0.30,1.035>, <1.85,0.30,1.035>,
  <0.10,0.30,1.835>, <1.85,0.30,1.835>,
  <0.10,0.30,2.535>, <1.85,0.30,2.535>,
  <0.10,0.30,3.235>, <1.90,0.30,3.235>
}

#declare rcoz = <0,0,0.013>; 




#macro cluttered_shelf()  
union
{   
        object{shelf}
        #local it = 0;
        #local height_s = 0.75;
        #while(it < 10) 
                #if(it >= 4) 
                #local height_s = 0.65;
                #end
                clutter_area(clutter_path[it]+rcoz, clutter_path[it+1]+rcoz, 1, height_s, 0.04, 0.35) 
                #local it = it + 2;       
        #end
        
} 
#end


// End Script
#include "rand.inc"
#declare stack_seed = seed(1129);



#declare it = 11;
#declare at = -4; 

#while(it >= 1)
        //#declare ms1 = seed(ms1+2);
        object{
                cluttered_shelf()
                scale 0.7
                translate <at + RRand(-0.1,0.1,stack_seed), it, 0>
        } 
        #declare it = it - 1.2;
#end

// Along the wall
#declare gx = -9.0;
#declare gy = 6.5;

#while(gy >= 0)
        union{
                cluttered_shelf()
                rotate <0,0,90>
                scale 0.7
                translate <gx, gy, 0>
        } 
        #declare gy = gy - 3;
#end 


// Other stacks
clutter_area(<-8.7,1.5,0.1>, <-8.6,-3,0.1>, 1, 0.75, 0.04, 0.35)
clutter_area(<-8.7,8.5,0.1>, <-6.8,8.5,0.1>, 1, 0.75, 0.04, 0.35)
clutter_area(<-4.5,8.5,0.1>, <-4.5,2,0.1>, 0.75, 0.75, 0.04, 0.35)