// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?

// material {} is a wrapper for interior and texture
// you can declare it like texture and interior too
// Note that it has nothing to do with material_map
#declare projector_mat =
material {
  texture {
    pigment { color rgb <0.5, 0.5, 0.7> }
    finish { ambient 0.0 diffuse 0.2 specular 0.6 }
  }
}





#declare projector_chrome = 
   material  // Chrome_Metal
   {   
      texture
      {      
         pigment
         {
            color rgb <0.658824, 0.658824, 0.658824>
         }      
         finish
         {
            ambient 0.0
            diffuse 0.7
            brilliance 8.0
            specular 0.8
            roughness 0.1
            reflection
            {
               0.15 , 0.15
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }

#macro capped_cylinder(beg, ende, rad, mat)
        union{
                cylinder{
                        beg ende rad
                        material{mat}
                }
                sphere{
                        beg, rad
                        material{mat}
                }
                sphere{
                        ende, rad
                        material{mat}
                }
        }
#end


#macro rail(Wdt, Dpt, Hgt, rmaj, rmin) 
        union{
        // Build control points
        #declare numpoint = Wdt / 0.5;
        #declare cpoint = array[numpoint];
        
        // Main rails
        capped_cylinder(<-Wdt/2,0,0>,<Wdt/2,0,0>,rmaj,projector_mat)
        #if(Dpt > 0)
                capped_cylinder(<-Wdt/2,0.5,0>,<Wdt/2,0.5,0>,rmaj,projector_mat)
        #end
        #if(Hgt > 0) 
                capped_cylinder(<-Wdt/2,0,-0.5>,<Wdt/2,0,-0.5>,rmaj,projector_mat)
        #end 
        
        #declare it = 0;
        #while(it < numpoint)
                #if(Dpt > 0) 
                        capped_cylinder(<(-Wdt/2)+0.5*it,0,0>, <(-Wdt/2)+0.5*it,0.5,0>, rmin, projector_chrome)
                        #if(mod(it,2) = 0)
                                 capped_cylinder(<(-Wdt/2)+0.5*it,0,0>, <(-Wdt/2)+(0.5*(it+1)),0.5,0>, rmin, projector_chrome)
                        #end
                #end
                #if(Hgt > 0) 
                        capped_cylinder(<(-Wdt/2)+0.5*it,0,0>, <(-Wdt/2)+0.5*it,0,-0.5>, rmin, projector_chrome)
                        #if(mod(it,2) = 0)
                                 capped_cylinder(<(-Wdt/2)+0.5*it,0,0>, <(-Wdt/2)+(0.5*(it+1)),0,-0.5>, rmin, projector_chrome)
                        #end
                #end
                #if(Dpt >0)
                        #if(Hgt > 0) 
                                #if(mod(it,2)=0)
                                        capped_cylinder(<-Wdt/2+ (0.5*(it)),0.5,0>,<-Wdt/2+ (0.5*(it+1)),0,-0.5>,rmin,projector_mat)
                                #else
                                        capped_cylinder(<-Wdt/2+ (0.5*(it)),0,-0.5>,<-Wdt/2+ (0.5*(it+1)),0.5,0>,rmin,projector_mat)
                                #end
                        #end
                #end
                
                #declare it = it + 1;
        #end
        }

#end



#declare hinge =
union{
        // Link
        box{
                <0.43,-0.1,0.1>
                <0.4,0.6,-0.1>
                material{projector_mat}
        }
        cylinder{
                <0.4,0.5,0>
                <-0.4,0.5,0>
                0.08
                material{projector_chrome}
        }
        box{
                <-0.43,-0.1,0.1>
                <-0.4,0.6,-0.1>
                material{projector_mat}
        } 
        cylinder{
                <0,0.5,0>
                <0,0.8,0>
                0.08
                material{projector_chrome}
        }
        cylinder{
                <0,0.6,0>
                <0,0.65,0>
                0.16
                material{projector_mat}
        }
}        


#declare spotlgt=
difference{
        union{ 
                // create a point "spotlight" (conical directed) light source
                light_source {
                  0*x                     // light's position (translated below)
                  color rgb <1,1,1>      // light's color
                  spotlight               // this kind of light source
                  point_at <0,1,0>      // direction of spotlight
                  radius 90                // hotspot (inner, in degrees)
                  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
                  falloff 180               // intensity falloff radius (outer, in degrees)  
                }


                sphere{
                        0.0 , 0.33
                        material{projector_mat}
                }
                cylinder
                {
                        <0,0,0>
                        <0,0.53,0>
                        0.33
                        material{projector_mat}
                }
                cylinder{
                        <0, 0.3, 0>
                        <0, 0.35,0 >
                        0.4
                        material{projector_mat}
                }
                cylinder{
                        <0, 0.37, 0>
                        <0, 0.40, 0>
                        0.4
                        material{projector_mat}
                }
                box{ 
                        <0.42, 0.45, 0.42>
                        <-0.42, 0.55, -0.42>
                        material{projector_mat}
                }
                cylinder{
                        <-0.5,0,0>
                        < 0.5,0,0>
                        0.03
                        material{projector_chrome}
                }
                cylinder{
                        <-0.4,0,0>
                        < 0.4,0,0>
                        0.05
                        material{projector_chrome}
                }
                cylinder{
                        <-0.43,0,0>
                        <-0.51,0,0>
                        0.09
                        material{projector_mat}
                }
                cylinder{
                        < 0.43,0,0>
                        < 0.51,0,0>
                        0.09
                        material{projector_mat}
                }
        }
        union{
                sphere{
                        0.0 , 0.30
                        material{projector_mat}
                }
                cylinder
                {
                        <0,0,0>
                        <0,0.70,0>
                        0.30
                        material{projector_mat}
                }
        } 
        //scale 0.33
}   

#macro stand(length)
union{
        cylinder{
                <-length/2,0.0,0>
                < length/2,0.0,0>
                0.07
                material{projector_chrome}
        } 
        // Feet hinges
        #local temp = length/2 - 0.1; 
        cylinder{ 
                <-temp,0,0>
                <-temp+0.15,0,0>
                0.15
                material{projector_mat}
        }
        cylinder{ 
                <temp,0,0>
                <temp-0.15,0,0>
                0.15
                material{projector_mat}
        }
        cylinder{ 
                <-temp+0.075,-0.20,0>
                <-temp+0.075,-0.1,0>
                0.15
                material{projector_mat}
        }
        cylinder{ 
                <temp-0.075,-0.20,0>
                <temp-0.075,-0.1,0>
                0.15
                material{projector_mat}
        }
        
}
#end
                 

#declare spot_head =
union{
        object{hinge}
        object{spotlgt}
}


#macro make_hinge(orienta)
        union{
        object{hinge rotate orienta*y}
        difference{
        cylinder{
                <-0.20,0.93,0>
                < 0.20,0.93,0>
                0.15
                material{projector_mat}
        }
        cylinder{
                <-0.26,0.93,0>
                < 0.26,0.93,0>
                0.1
                material{projector_mat}
        }
        }
}
#end 

// make one leg
#macro make_a_leg(heigth)
        #declare step = array[3] {1.5, 3, 4.5};
        #switch(heigth)
                #range(0, 1.7)
                        #declare step[1] = step[0] + 0.1;
                        #declare step[2] = step[1] + 0.1;
                #break
                #range(1.70001, 3.1)
                        #declare step[1] = heigth - 0.1;
                        #declare step[2] = heigth; 
                #break
                #range(3.10001, 4.5)
                        #declare step[2] = heigth;
                #end
        #break
        union{ 
                cylinder{
                        <0,0,0>
                        <0,step[0],0> 
                        0.2
                        material{projector_mat}
                } 
                cylinder{
                        <0,0,0>
                        <0,step[1],0> 
                        0.17
                        material{projector_chrome}
                }
                cylinder{
                        <0,0,0>
                        <0,step[2],0> 
                        0.15
                        material{projector_chrome}
                }
                // heads
                cylinder{
                        <0,step[0]-0.1,0>
                        <0,step[0]-0.01,0> 
                        0.25
                        material{projector_mat}
                } 
                cylinder{
                        <0,step[1]-0.1,0>
                        <0,step[1]-0.01,0> 
                        0.20
                        material{projector_mat}
                }
                cylinder{
                        <0,step[2]-0.1,0>
                        <0,step[2]-0.01,0> 
                        0.20
                        material{projector_mat}
                }
                // Knobs
                cylinder{
                        <0,step[0]-0.05,-0.28>
                        <0,step[0]-0.05,-0.35> 
                        0.1
                        material{projector_mat}
                }
                cylinder{
                        <0,step[0]-0.05,-0.20>
                        <0,step[0]-0.05,-0.30> 
                        0.04
                        material{projector_chrome}
                }
                sphere{
                        <0,0,0>
                        0.09
                        scale 0.5*z
                        translate <0,step[0]-0.06,-0.35>
                        material{projector_chrome}
                }
                cylinder{
                        <0,step[1]-0.05,-0.28>
                        <0,step[1]-0.05,-0.35> 
                        0.1
                        material{projector_mat}
                }
                cylinder{
                        <0,step[1]-0.05,-0.20>
                        <0,step[1]-0.05,-0.30> 
                        0.04
                        material{projector_chrome}
                }
                sphere{
                        <0,0,0>
                        0.09
                        scale 0.5*z
                        translate <0,step[1]-0.06,-0.35>
                        material{projector_chrome}
                }   
                scale <0.6,1,0.6>
                
        }
#end

#macro spot_ligth(elevation, orienta, shaft_offset)
        // Make a head
        union{
                //object{hinge rotate orienta*y }
                make_hinge(orienta) 
                object{spotlgt rotate<elevation,orienta,0>} 
                scale 0.5
                translate <shaft_offset, -0.475,0>                
        }
#end


// ///////////////////////////////////////////////////////////////
// ///////////////////////////////////////////////////////////////

#macro stage(Wdt, Dpt, Hgt)
        #declare vof = Hgt;
        union{ 
                object{
                        rail(Hgt,Dpt,Hgt,0.05,0.03)
                        rotate 90*y
                        translate<Wdt/2,-Dpt/2,vof/2>
                }
                object{
                        rail(Hgt,Dpt,Hgt,0.05,0.03)
                        rotate 90*y
                        rotate -90*z
                        translate<-Wdt/2,-Dpt/2,vof/2>
                }
                object{
                        rail(Hgt,Dpt,Hgt,0.05,0.03)
                        rotate 90*y
                        rotate -180*z
                        translate<-Wdt/2,Dpt/2,vof/2>
                }
                object{
                        rail(Hgt,Dpt,Hgt,0.05,0.03)
                        rotate 90*y
                        rotate 90*z
                        translate<Wdt/2,Dpt/2,vof/2>
                }
                // front back
                object{
                        rail(Wdt,Dpt,Hgt,0.05,0.03)
                        translate <0,-Dpt/2,vof>
                }
                object{
                        rail(Wdt,Dpt,Hgt,0.05,0.03)
                        rotate 180*z
                        translate <0,Dpt/2,vof>
                }
                // Sides
                object{
                        rail(Dpt,Dpt,Hgt,0.05,0.03) 
                        rotate 90*z
                        translate <Wdt/2,0,vof>
                }
                object{
                        rail(Dpt,Dpt,Hgt,0.05,0.03) 
                        rotate -90*z
                        translate <-Wdt/2,0,vof>
                } 
                // front stand
                object{
                        spot_ligth(-150,-45,0)
                        rotate 90*x
                        translate <0,-Dpt/2,Hgt-0.7>        
                }
                object{
                        spot_ligth(-150,-90,-2)
                        rotate 90*x
                        translate <0,-Dpt/2,Hgt-0.7>        
                }
                object{
                        stand(Wdt-1.2)
                        rotate -90*x
                        translate <0,-Dpt/2,Hgt-0.7>
                }
                // side stand
                object{
                        spot_ligth(120,0,0)
                        rotate 90*x
                        rotate 90*z
                        translate <-Wdt/2,0,Hgt-0.7>        
                }
                object{
                        spot_ligth(120,20,-1.5)
                        rotate 90*x 
                        rotate 90*z
                        translate <-Wdt/2,0,Hgt-0.7>        
                }
                object{
                        stand(Dpt-1.2)
                        rotate -90*x 
                        rotate 90*z
                        translate <-Wdt/2,0,Hgt-0.7>
                }
                #include "set_script.inc"
                # include "raven.inc"

                object{
                        raven
                        rotate 90*x
                        rotate 90*z
                        translate <-5,-1.55,5.05>
                
                } 
                
                #include "camera.inc"
                object{
                        camera_all 
                        rotate 85*z
                        translate <-2,-1.4,0.1>
                }
                object{
                        camera_all
                        rotate 5*z
                        translate <-5.2,-2.5,0.0>
                }
                
        }
#end  

