
// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0> 
/*
#declare blank =
material{
texture{
        pigment{
image_map {  
  png "bricks.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // once           // for no repetitive tiling
  // [filter N V]   // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index] 
} // image_map
 //rotate 90*x
}}}



union { // walls
  box { // right_wall
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 10.0, 10.0>
    translate  <-10.0, 0.0, 9.0>
  }
  box { // back_wall
    <-1, -1, -1>, <1, 1, 1>
    scale <11.0, 0.05, 10.0>
    translate  <0.0, 9.5, 9.0>
  }
  box { // left_wall
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 10.0, 10.0>
    translate  <10.0, 0.0, 9.0>
  }
  box { // floor
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <11.0, 11.0, 0.05>
  }
  box { // ceiling
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <11.0, 11.0, 0.05>
    translate  18.0*z
  }
  material {
    blank
  }
}
*/

//  $MRY$: 'blank'


#declare blank = 
   material  // blank
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.0
         }
        
      }
   }


//  $MRY$: 'film'




#declare floor_pigment =
pigment{ 
        agate
        color_map
        {
                [0 rgb <0.5,0.5,0.5>]
                [0.2 rgb <0.45,0.45,0.5>]
                [1 rgb <0.5,0.5,0.5>]
        }
        scale 0.05
        turbulence 1.5 
}

#declare floor_bump = 
normal{ 
        //agate 0.5
        bump_map
        {
                        png "floor_bump.png" 
                        //once 
                        //use_color
                        bump_size 5
        }
        //rotate 90*x 
}

#declare shinyfloor =
texture{
        pigment{
                floor_pigment
               
        }
        normal{ 
                floor_bump
                /* */
                //scale <2.0,1.5,1>
                //translate <-0.9,-0.6,0>                 
        } 
        finish
        { 
                reflection {0.15 0.25} 
                ambient 0.0
        }
        
}

#declare shinyfloor1 =
texture{
        pigment{
                floor_pigment
        }
        normal{
                floor_bump 
                //scale <2.0,1.5,1>
                //translate <-0.9,-0.6,0>
                
        } 
        finish
        { 
                //reflection 0.05
                ambient 0.0
                diffuse 0.3
        }
        
}

#declare floormap =
        material
        {       
                texture{
                        image_pattern{png "floor_base.png" once} 
                        texture_map{
                        [0 shinyfloor]
                        [1 shinyfloor1]
                        } 
                        
                        scale <2.0,1.5,5>
                        translate <-0.9,-0.6,0>
                        scale  <11,11,1>
                }
        }


//  $MRY$: 'brickwall'


#declare brickwall = 
   material  // brickwall
   {                           
      texture
      {      
         pigment
         {
            brick
               pigment
               {
                  color rgb <0.737255, 0.741176, 0.733333>
               }
               pigment
               {
                  color rgb <0.839216, 0.835294, 0.819608>
               }
            mortar 0.05
            turbulence 0.05
            ramp_wave
            scale  0.1
         }      
         normal
         {  
            brick
            mortar 0.05
            bump_size 0.05
            turbulence 0.05
            ramp_wave
            scale  0.1
         }
         finish
         {
            ambient 0.0
         }
      }
   }


//  $MRY$: 'bwall1'


#declare _auto_name_no_1_ = 
   texture
   {   
      pigment
      {
         agate
         agate_turb 1.0
         pigment_map
         {
            [0.0   
               color rgb <0.666667, 0.490196, 0.333333>
            ]
            [0.257667
               color rgb <0.8229, 0.490196, 0.333333>
            ]
            [0.257667
               color rgb <0.230448, 0.115442, 0.061219>
            ]
            [1.0   
               color rgb <1.0, 1.0, 1.0>
            ]
         }
         turbulence 1.0
         ramp_wave
         scale  0.1
      }
      finish
         {
            ambient 0.0
         }
   }

#declare bwall1 = 
   material  // bwall1
   {   
      texture { _auto_name_no_1_ }
   }


//  $MRY$: 'floor_texture'


#declare floor_texture = 
   material  // floor_texture
   {   
      texture
      {      
         pigment
         {
            checker
               pigment
               {
                  crackle form <-1.0, 1.0, 0.0>
                  pigment_map
                  {
                     [0.0   
                        color rgb <0.85098, 0.768627, 0.184314>
                     ]
                     [0.1411
                        color rgb <0.937467, 0.470572, 0.0>
                     ]
                     [0.171767
                        color rgb <0.937467, 0.470572, 0.0>
                     ]
                     [0.2147
                        color rgb <0.501961, 0.501961, 0.501961>
                     ]
                     [1.0   
                        color rgb <0.416667, 0.416667, 0.416667>
                     ]
                  }
                  scale  0.1
               }
               pigment
               {
                  color rgb <0.0104, 0.0104, 0.0104>
               }
            scale  0.1
         }
         finish
         {
            ambient 0.0
         }
      }
   }


//  $MRY$: 'Rusty_Iron1'


#declare Rusty_Iron1 = 
   material  // Rusty_Iron1
   {   
      texture
      {      
         pigment
         {
            agate
            agate_turb 1.0
            color_map
            {
               [ 0.0     rgbft <0.21, 0.1, 0.1, 0.0, 0.0> ]
               [ 0.5     rgbft <0.25, 0.25, 0.01, 0.0, 0.0> ]
               [ 0.6     rgbft <0.3, 0.1, 0.1, 0.0, 0.0> ]
               [ 0.6     rgbft <0.15, 0.1, 0.1, 0.0, 0.0> ]
               [ 1.0     rgbft <0.15, 0.1, 0.1, 0.0, 0.0> ]
            }
         }
      }
   }


//
// ********  OBJECTS  *******
//

#declare pillars = union {
  box { // pillar
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.5, 0.75, 10.0>
    translate  <-6.0, 8.770803, 9.920561>
  }
  box { // pillar1
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.5, 0.75, 10.0>
    translate  <0.0, 8.770803, 9.920561>
  }
  box { // pillar2
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.5, 0.75, 10.0>
    translate  <6.0, 8.770803, 9.920561>
  }
  translate  0.611916*y
}



box { // left_wall
  <-1, -1, -1>, <1, 1, 1>
  material {
    brickwall
  }
  scale <0.05, 10.0, 10.0>
  translate  <10.0, 0.0, 9.0>
}


box { // back_wall
  <-1, -1, -1>, <1, 1, 1>
  material {
    brickwall
  }
  scale <11.0, 0.05, 5.0>
  translate  <0.0, 9.5, 5.0>
}


box { // right_wall
  <-1, -1, -1>, <1, 1, 1>
  material {
    brickwall
  }
  scale <0.05, 10.0, 10.0>
  translate  <-10.0, 0.0, 9.0>
}


  box { // ceiling
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <11.0, 11.0, 0.05>
    translate  18.0*z
  }
  
  box { // floor
    <-11, -11, -0.05>, <11, 11, 0.05>
    material {
      //floor_texture
      floormap
    }
    //scale <11.0, 11.0, 0.05>
  }
    


/*
difference { // film_filter
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <2.0, 0.15, 2.0>
    translate  2.0*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <1.0, 0.2, 1.0>
    translate  2.0*z
  }
  translate  <-5.5, -5.0, -0.5>
}
*/



box { // back_wall1
  <-1, -1, -1>, <1, 1, 1>
  material {
    brickwall
  }
  scale <11.0, 0.05, 5.0>
  rotate 20.0*x
  translate  <0.0, 7.857297, 14.717477>
}




box { // pillar3
  <-1, -1, -1>, <1, 1, 1>
  material {
    blank
  }
  scale <0.5, 0.75, 10.0>
  rotate -90.0*x
  translate  <9.331708, -0.389523, 10.647334>
}


box { // pillar4
  <-1, -1, -1>, <1, 1, 1>
  material {
    blank
  }
  scale <0.5, 0.75, 10.0>
  rotate -90.0*x
  translate  <-9.501721, 0.222393, 10.647334>
}

#declare ph = 0.8;

#declare pipes1 = union {
  cylinder { // pipe6
    <0,0,1>, <0,0,0>, 1 
    material {
      blank
    }
    scale <0.15, 0.15, 45.0>
    rotate -90.0*y
    translate  <15.0, 9.0, 6.0>
  }
  cylinder { // pipe7
    <0,0,1>, <0,0,0>, 1 
    material {
      blank
    }
    scale <0.15, 0.15, 45.0>
    rotate -90.0*y
    translate  <15.0, 9.0, 6.5>
  }
  // here
  translate ph*z
}


difference { // pillar_with_holes
  object { pillars }
  object { pipes1 }
}


union { // pipes
  cylinder { // pipe1
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Iron1
    }
    scale <0.1, 0.1, 30.0>
    rotate -90.0*y
    translate  <15.0, 9.0, 6.0>
  }
  cylinder { // pipe2
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Iron1
    }
    scale <0.1, 0.1, 30.0>
    rotate -90.0*y
    translate  <15.0, 9.0, 6.5>
  }
  translate ph*z
}


#declare up_pipe =
union{
        cylinder { // pipe3
          <0,0,1>, <0,0,0>, 1 
          material {
            Rusty_Iron1
          }
          scale <0.15, 0.15, 0.75>
          rotate -90.0*y
          translate  <-0.7, 9.0, 6.0>
        }
        cylinder { // pipe4
          <0,0,1>, <0,0,0>, 1 
          material {
            Rusty_Iron1
          }
          scale <0.15, 0.15, 0.75>
          translate  <-1.0, 9.0, 5.25>
        }
        
        
        cylinder { // pipe5
          <0,0,1>, <0,0,0>, 1 
          material {
            Rusty_Iron1
          }
          scale <0.1, 0.1, 5.5>
          translate  <-1.0, 9.0, 0.0>
        } 
        translate ph *z
}

up_pipe