// PS2        
//3.2"(H)  8
//12"(W)   30
//7.25"(D) 18     

#declare PS2_Finish = finish { phong 0.8 phong_size 80 ambient 0.0 diffuse 0.3 }      

#declare PS2_Grey_Tex = texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }
                
#declare MemoryCard = union
{
        box { <-3, -0.5, -10> <3, 0.5, 0> }
        cylinder { <-2, -0.5, -10> <-2, 0.5, -10> 1 }
        cylinder { <2, -0.5, -10> <2, 0.5, -10> 1 }
        box { <-2, -0.5, -11> <2, 0.5, -9> }
        scale 1.0
        texture { pigment { color rgb <0.05, 0.05, 0.05> } finish { PS2_Finish } }
}



#declare PS2 = union
{   
        
//        box { <0, 0, 0> <60, 16, 36> }
        // inner box
        difference
        { 
                box { <0, 0, 3> <53, 15, 36> }
                union
                {
                        box { <1, 1, 4> <52, 14, 35> }   
                        // USB port
                        box { <2, 2, 2.9> <4, 3, 5.1> }
                        box { <2, 3.5, 2.9> <4, 4.5, 5.1> }                        

                        // air vent grooves
                        #declare ventX = 0;
                        #while (ventX < 14)
                                #declare ventY = 0;
                                #while (ventY < 5)
                                        box { <12+(ventX*2.5), 1.5+(ventY*0.5), 0> <12+(ventX*2.5)+2.0, 1.5+(ventY*0.5)+0.375, 6> }  
                                        #declare ventY = ventY+1;
                                #end
                                #declare ventX = ventX+1;
                        #end                                   
                }       
        }
        // top box
        box { <0, 6, 1> <59, 15, 36> }
        // Grooved part
        difference
        {
                union
                {
                        box { <0.001, 15.2, 0> <60, 16, 36> }
                        box { <0.001, 13.6, 0> <60, 14.4, 36> }
                        box { <0.001, 12, 0> <60, 12.8, 36> }
                        box { <0.001, 10.4, 0> <60, 11.2, 36> }
                        box { <0.001, 8.8, 0> <60, 9.6, 36> }
                        box { <0.001, 7.2, 0> <60, 8, 36> }   
                }
                union
                {              
                        // buttons
                        superellipsoid {<0.05, 0.05> scale 1.1 translate <57, 14, 0.9> }                
                        box { <-1.1, -1.1, -2> <1.1, 1.1, 2> translate <57, 9.2, 0.9> }
                        // logo
                        box {  <-0.15, -0.15, -0.1> <4.9, 0.9, 1> rotate <0, 0, -90> translate <58.5, 14, 0> pigment { rgb <0.02, 0.02, 0.02> } finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 } }
                        // CD Drive bay
                        box { <32, 10, -0.1> <32.5, 13, 2> }
                        box { <54, 10, -0.1> <54.5, 13, 2> }  
                        box { <32, 10, -0.1> <54.5, 10.2, 2> }
                        box { <32, 12.8, -0.1> <54.5, 13, 2> }
                                              
                }
        }        
        // USB Port
        difference
        {
                box { <1, 1, 2.99999> <8, 7, 3> }  
                union
                {
                        box { <2, 2, 2.9> <4, 3, 5.1> }
                        box { <2, 3.5, 2.9> <4, 4.5, 5.1> }                        
                }
                
                        texture
                        {
                                pigment 
                                {
                                        gradient y
                                        color_map 
                                        {
                                                [ 0.0 color rgb <0.01, 0.01, 8> ]
                                                [ 1.001 color rgb <0.0, 0.0, 2> ]
                                        } 
                                        scale 5
                                        translate <0, 0.9, 0> 
                                } 
                                finish 
                                {
                                        specular 0.4 roughness 0.1 ambient 0.0 diffuse 0.3                                                                         
                                }
                        } 
        }
        // USB port metal surround
        difference
        {
                box { <2, 2, 2.95> <4, 3, 3.1> }
                box { <2.1, 2.1, 2.9> <3.9, 2.9, 5.1> }
                texture { Chrome_Metal }
        }

        difference
        {
                box { <2, 3.5, 2.95> <4, 4.5, 3.1> }                        
                box { <2.1, 3.6, 2.9> <3.9, 4.4, 5.1> }
                texture { Chrome_Metal }
        }  
        
        // Buttons

        // On/Off
        union
        {
                superellipsoid { <0.05, 0.05> }
                union
                {
                        box { <-0.05, 0, -1.001> <0.05, 0.5, -1> }
                        difference 
                        {
                                cylinder { <0, 0, -1.001> <0, 0, -1> 0.45 }
                                union
                                {
                                        cylinder { <0, 0, -1.002> <0, 0, -0.999> 0.325 }
                                        box { <-0.15, 0, -1.0012> <0.15, 0.5, -.999> }
                                }
                        } 
                        text 
                        {
                                ttf             // font type (only TrueType format for now)
                                "crystal.ttf",  // Microsoft Windows-format TrueType font file name
                                "RESET",      // the string to create
                                0.01,              // the extrusion depth
                                0               // inter-character spacing    
                                scale <0.6, 0.45, 1> 
                                translate <-0.7, -0.85, -1.001>
                        }

                        pigment { color rgb <0.15, 1, 0.15> }
                        finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 }
                }
                pigment { color rgb <0.02, 0.02, 0.02> }
                finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 }
                
                translate <57, 14, 0.9>
        }      
        // Eject
        union
        {                        
                difference
                {
                        box { <-1, -1, -2> <1, 1, 2> }
                        box { <-2, -2, -2> <2, 2, 0> translate <0, -2, 0> rotate <15, 0, 0> translate <0, 2, -1> }
                       
                }
                union
                {
                        box { <-0.5, -0.5, -0.001> <0.5, -0.375, 0> }   
                        box { <-0.5, -0.275, -0.001> <0.5, -0.15, 0> }
                        box { <-0.5, -0.5, -0.001> <-0.375, -0.25, 0> }
                        box { <0.375, -0.5, -0.001> <0.5, -0.25, 0> }   
                        
                        // triangle
                        box { <-0.5, 0, -0.001> <0.5, 0.125, 0> }
                        box { <-0.70711, -0.125, -0.001> <0, 0, 0> rotate <0, 0, -45> translate <0.5, 0.125, 0> }
                        box { <0, -0.125, -0.001> <0.70711, 0, 0> rotate <0, 0, 45> translate <-0.5, 0.125, 0> }                       
                        translate <0, -2, 0> 
                        rotate <15, 0, 0>
                        translate <0, 2, -1>
                        pigment { color rgb <0.25, 0.25, 1> }
                        finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 }
                }                          
                pigment { color rgb <0.02, 0.02, 0.02> }
                finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 }
                
                translate <57, 9.2, 0.9> 
        }    
        // Product placement
        text 
        {
                ttf             // font type (only TrueType format for now)
                "ROCKB.TTF",  // Microsoft Windows-format TrueType font file name
                "SONY",      // the string to create
                0.5,              // the extrusion depth
                0               // inter-character spacing    
                scale <1.65, 1.1, 1>
                rotate <0, 0, -90> 
                translate <58.5, 14, -0.1>     
                
                pigment { color rgb <0.5, 0.5, 0.575> }
                finish { specular 1 roughness 0.035 reflection 0.25 brilliance 3 ambient 0.0 diffuse 0.3 }
        }  
        box { <-0.05, -0.1, 0.1> <4.85, 0.85, 1> rotate <0, 0, -90> translate <58.5, 14, 0> pigment { rgb <0.02, 0.02, 0.02> } finish { phong 1 phong_size 100 ambient 0.0 diffuse 0.3 } }
        
        // Badge
        box 
        { 
                <0, 0, 0> <1, 1, 0.5> 
                texture 
                { 
                        pigment 
                        {
                                image_map { gif "PS2.gif" map_type 0 interpolate 2 filter 0, 1  
                                        transmit 139, 1 }
                        }
                        finish { phong 1 ambient 0.0 diffuse 0.3 }
                }   
                scale 2
                translate <43, 10.5, -0.05>
         }     
         
         // Memory Cards and Dual Shock plugs     
         object { MemoryCard translate <10.5, 11, 4> }   
         sphere { <11.25, 10.55, -9.25> 0.7 }
         object { MemoryCard translate <10.5, 13, 4> }
         object { MemoryCard translate <19, 11, 4> }   
         sphere { <19.9, 10.95, -9.25> 0.7 }
         object { MemoryCard translate <19, 13, 4> }
         
         
        
                        
        texture 
        { 
                pigment  
                {
                        color rgb <0.05, 0.05, 0.05> 
                }
                finish 
                {
                        PS2_Finish
                }
        }
}             


#declare DirButton = union {
        superellipsoid { <0.2, 0.2> }
        superellipsoid { <0.2, 0.2> scale <0.707, 1, 0.707> rotate <0, 45, 0> translate <0, 0, 1> }  
        texture
        {
                pigment { rgb <0.1, 0.1, 0.1> }
                finish { phong 0.5 ambient 0.0 diffuse 0.3 }
        }
}

// DualShock
#declare DualShock = union
{   
        #declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
        #declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density
        
        // left side 
        difference
        {
                union
                {
                        blob 
                        {
                                threshold 0.6
                                
                                // handle
                                #declare sr=4;
                                #declare zstep=0.5;
                                #declare er=6;
                                #declare length=10;
                                #declare rstep=(er-sr)/(length/zstep);
                                #declare ys=0;
                                #declare xs=0;
                                #declare ye=4;
                                #declare xe=3;
                                #declare ystep=(ye-ys)/(length/zstep);
                                #declare xstep=(xe-xs)/(length/zstep);
                                
                                
                                #declare zpos=0; 
                                #declare xpos=0;
                                #declare ypos=0;
                                #declare r=sr;
                                #while(zpos < length)
                                        sphere { <0, 0, 0>, r, StrengthVal scale <1, 0.75, 1> translate <xpos, ypos, zpos>}
                                        
                                        #declare xpos=xpos+xstep;
                                        #declare ypos=ypos+ystep;
                                        #declare zpos=zpos+zstep;
                                        #declare r=r+rstep;
                                #end          
                                
                                #declare xpos=xpos+0.5;    
                                #declare zpos=zpos+3;
                                
                                cylinder { <xpos, ypos-1, zpos>, <xpos, ypos+2, zpos>, 12, StrengthVal } 
                                cylinder { <xpos, ypos+14, zpos>, <xpos, ypos+15, zpos>, 12, -StrengthVal } 
                                cylinder { <xpos, ypos-15, zpos>, <xpos, ypos-9.5, zpos>, 12, -StrengthVal } 
                                
                                #declare xpos=xpos+6;
                                #declare zpos=zpos-5;
                                cylinder { <xpos, ypos-1, zpos>, <xpos, ypos+2, zpos>, 6, StrengthVal } 
                                cylinder { <xpos, ypos+11, zpos>, <xpos, ypos+15, zpos>, 6, -StrengthVal } 
                                cylinder { <xpos, ypos-15, zpos>, <xpos, ypos-8, zpos>, 6, -StrengthVal } 
                        
                                // back support part
                                #declare xpos=xpos-7; 
                                #declare ypos=ypos-1.5; 
                                #declare zpos=zpos+11;  
                                
                                sphere { <0, 0, 0>, 4, StrengthVal translate <xpos, ypos+1, zpos-2> }

                                sphere { <0, 0, 0>, 4, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos, zpos> }
                                sphere { <0, 0, 0>, 3.5, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-1, zpos+0.1> }
                                sphere { <0, 0, 0>, 3, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-2, zpos+0.2> }
                                sphere { <0, 0, 0>, 2.5, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-3, zpos+0.3> }
                                
                        } 
                        // right side
                        blob 
                        {
                                threshold 0.6
                                
                                // handle
                                #declare sr=4;
                                #declare zstep=0.5;
                                #declare er=6;
                                #declare length=10;
                                #declare rstep=(er-sr)/(length/zstep);
                                #declare ys=0;
                                #declare xs=0;
                                #declare ye=4;
                                #declare xe=-3;
                                #declare ystep=(ye-ys)/(length/zstep);
                                #declare xstep=(xe-xs)/(length/zstep);
                                
                                
                                #declare zpos=0; 
                                #declare xpos=0;
                                #declare ypos=0;
                                #declare r=sr;
                                #while(zpos < length)
                                        sphere { <0, 0, 0>, r, StrengthVal scale <1, 0.75, 1> translate <xpos, ypos, zpos>}
                                        
                                        #declare xpos=xpos+xstep;
                                        #declare ypos=ypos+ystep;
                                        #declare zpos=zpos+zstep;
                                        #declare r=r+rstep;
                                #end          
                                
                                #declare xpos=xpos-0.5;    
                                #declare zpos=zpos+3;
                                
                                cylinder { <xpos, ypos-1, zpos>, <xpos, ypos+2, zpos>, 12, StrengthVal } 
                                cylinder { <xpos, ypos+14, zpos>, <xpos, ypos+15, zpos>, 12, -StrengthVal } 
                                cylinder { <xpos, ypos-15, zpos>, <xpos, ypos-9.5, zpos>, 12, -StrengthVal } 
                                
                                #declare xpos=xpos-6;
                                #declare zpos=zpos-5;
                                cylinder { <xpos, ypos-1, zpos>, <xpos, ypos+2, zpos>, 6, StrengthVal } 
                                cylinder { <xpos, ypos+11, zpos>, <xpos, ypos+15, zpos>, 6, -StrengthVal } 
                                cylinder { <xpos, ypos-15, zpos>, <xpos, ypos-8, zpos>, 6, -StrengthVal } 

                                // back support part
                                #declare xpos=xpos+7; 
                                #declare ypos=ypos-1.5; 
                                #declare zpos=zpos+11;
 
                                sphere { <0, 0, 0>, 4, StrengthVal translate <xpos, ypos+1, zpos-2> }

                                sphere { <0, 0, 0>, 4, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos, zpos> }
                                sphere { <0, 0, 0>, 3.5, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-1, zpos+0.1> }
                                sphere { <0, 0, 0>, 3, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-2, zpos+0.2> }
                                sphere { <0, 0, 0>, 2.5, StrengthVal scale <1, 1, 0.7> translate <xpos, ypos-3, zpos+0.3> }

                                translate <26.5, 0, 0> 
                        } 
                
                        // box to join sides   
                        superellipsoid 
                        {
                                <0.5, 0.3>
                                scale <9, 3, 5> 
                                translate <13, 5.5, 12> 
                        }  
                        // top buttons
                        superellipsoid
                        {
                                <0.5, 0.4>
                                scale <3, 2.5, 3> 
                                translate <3, 5.5, 18>
                        }
                        superellipsoid
                        {
                                <0.5, 0.4>
                                scale <3, 2.5, 3> 
                                translate <23.5, 5.5, 18>
                        }
        
                }    
                // make top flat        
                union
                {
                        
                        box { <-5, 8.8, 0> <32, 10, 25> }  
                        
                        // cut crosses for buttons
                        box { <2.25, 8.6, 9.75> <4.75, 9.1, 16.75> }
                        box { <0, 8.6, 11.875> <7, 9.1, 14.375> }
                        // right side
                        union
                        {
                                box { <2.25, 8.6, 9.75> <4.75, 9.1, 16.75> }
                                box { <0, 8.6, 11.875> <7, 9.1, 14.375> } 
                                translate <20, 0, 0>  
                        }
                        
                        // cut button holes 
                        cylinder { <0, 0, 0> <0, 1, 0> 1.15 translate <23.5, 8, 11> }
                        cylinder { <0, 0, 0> <0, 1, 0> 1.15 translate <23.5, 8, 15.5> }
                        cylinder { <0, 0, 0> <0, 1, 0> 1.15 translate <21.25, 8, 13.125> }
                        cylinder { <0, 0, 0> <0, 1, 0> 1.15 translate <25.75, 8, 13.125> }    
                        
                        // cut analogue stick holes
                        cylinder { <0, 0, 0> <0, 4, 0> 2.1 translate <8.4, 5, 8.9> }
                        cylinder { <0, 0, 0> <0, 4, 0> 2.1 translate <26.5-8.4, 5, 8.9> }
                         
                        
                }                      
        }   
        // analogue sticks
        union
        {
                intersection
                {
                        sphere { <0, 0, 0> 3 }
                        cylinder { <0, 0, 0> <0, 3.1, 0> 2.1 }
                }   
                cylinder { <0, 2, 0> <0, 5, 0> 1.1 }    
                intersection
                {
                        sphere { <0, 0, 0> 2.1 scale <1, 0.4, 1> }
                        box { <-2.15, 0, -2.15> <2.15, 2.1, 2.15> }
                        translate <0, 4.95, 0> 
                        texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.3 ambient 0.0 diffuse 0.3 } 
                                normal { granite scale 0.1 } } 
                }                                                                          
                bounded_by { box { <-3.1, -0.1, -3.1> <3.1, 7, 3.1> } }
                                                   
                translate <8.4, 5.5, 8.9>                
                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3 } } 
                
        }   
        // right stick 
        union
        {
                intersection
                {
                        sphere { <0, 0, 0> 3 }
                        cylinder { <0, 0, 0> <0, 3.1, 0> 2.1 }
                }   
                cylinder { <0, 2, 0> <0, 5, 0> 1.1 }    
                intersection
                {
                        sphere { <0, 0, 0> 2.1 scale <1, 0.4, 1> }
                        box { <-2.15, 0, -2.15> <2.15, 2.1, 2.15> }
                        translate <0, 4.95, 0> 
                        texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.3 ambient 0.0 diffuse 0.3  } 
                                normal { granite scale 0.1 } } 
                }
                bounded_by { box { <-3.1, -0.1, -3.1> <3.1, 7, 3.1> } }
                                                   
                translate <26.5-8.4, 5.5, 8.9>                
                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3 } } 
                
        }   
        // buttons 
        // /\
        // --
        union
        {
                cylinder { <0, 3, 0> <0, 6, 0> 1.10 } 
                sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6, 0> }     
                intersection
                {
                        union
                        {
                                box { <-0.7, 0, -0.075> <0.7, 7, 0.075> translate <0, 0, -0.5> }
                                box { <0, 0, -0.15> <1.3, 7, 0> rotate <0, -60, 0> translate <-0.7, 0, -0.425> }
                                box { <-1.3, 0, -0.15> <0, 7, 0> rotate <0, 60, 0> translate <0.7, 0, -0.425> }
                                
                                
                                
                        }
                        
                        sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6.001, 0> }    
                        texture { pigment { rgb <0.3, 1, 0.3> } finish { phong 1 ambient 0.0 diffuse 0.3  } } 
                }  
                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3 } } 
                bounded_by { box { <-1.2, 2.9, -1.2> <1.2, 7, 1.2> } }
                translate <23.5, 3, 15.5> 
        }
        // X
        union
        {
                cylinder { <0, 3, 0> <0, 6, 0> 1.10 } 
                sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6, 0> }   
                intersection
                {
                        union
                        {
                                box { <-0.8, 0, -0.075> <0.8, 7, 0.075> rotate <0, 45, 0> }
                                box { <-0.8, 0, -0.075> <0.8, 7, 0.075> rotate <0, -45, 0> }
                                
                        }
                        
                        sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6.001, 0> }    
                        texture { pigment { rgb <0.3, 0.3, 1> } finish { phong 1 ambient 0.0 diffuse 0.3 } } 
                }  
                  
                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3 } } 
                bounded_by { box { <-1.2, 2.9, -1.2> <1.2, 7, 1.2> } }
                translate <23.5, 3, 11> 
        }
        // []
        union
        {
                cylinder { <0, 3, 0> <0, 6, 0> 1.10 } 
                sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6, 0> }     
                intersection
                {
                        union
                        {
                                box { <-0.65, 0, -0.65> <0.65, 7, -0.5> }
                                box { <-0.65, 0, 0.5> <0.65, 7, 0.65> }
                                box { <-0.65, 0, -0.65> <-0.5, 7, 0.65> }  
                                box { <0.5, 0, -0.65> <0.65, 7, 0.65> }  
                                
                        }
                        
                        sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6.001, 0> }    
                        texture { pigment { rgb <1, 0.6, 0.6> } finish { phong 1 ambient 0.0 diffuse 0.3 } } 
                }  

                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3  } } 
                bounded_by { box { <-1.2, 2.9, -1.2> <1.2, 7, 1.2> } }
                translate <21.25, 3, 13.125> 
        }
        // ()
        union
        {
                cylinder { <0, 3, 0> <0, 6, 0> 1.10 } 
                sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6, 0> }   
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 7, 0> 0.75 }
                                cylinder { <0, 0, 0> <0, 7.1, 0> 0.6 }
                        }
                        
                        sphere { <0, 0, 0> 1.10 scale <1, 0.25, 1> translate <0, 6.001, 0> }    
                        texture { pigment { rgb <1, 0.3, 0.3> } finish { phong 1 ambient 0.0 diffuse 0.3 } } 
                }  
  
                texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { phong 0.4 ambient 0.0 diffuse 0.3 } } 
                bounded_by { box { <-1.2, 2.9, -1.2> <1.2, 7, 1.2> } }
                translate <25.75, 3, 13.125> 
        }   
        
        // Directional buttons
        object { DirButton scale <0.9, 1, 0.7> translate <3.5, 8.25, 11.25> } 
        object { DirButton scale <0.9, 1, 0.7> rotate <0, 180, 0> translate <3.5, 8.25, 15.25> } 
        object { DirButton scale <0.9, 1, 0.7> rotate <0, -90, 0> translate <5.5, 8.25, 13.125> } 
        object { DirButton scale <0.9, 1, 0.7> rotate <0, 90, 0> translate <1.5, 8.25, 13.125> } 
        
        // Select Button
        superellipsoid 
        { 
                <.2, 0.2>  scale <0.8, 1, 0.4> translate <10.5, 8, 13.25> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }
        }  
        // analog button
        superellipsoid 
        { 
                <.2, 0.2>  scale <0.8, 1, 0.45> translate <13.2, 7.6, 10.2> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }
        }  
        
        // text for buttons
        intersection
        {
                superellipsoid 
                {
                        <0.5, 0.3>
                        scale <9, 3, 5> 
                        translate <13, 5.501, 12> 
                }  
        
                union
                {
                        text { ttf "ARIALNB.TTF", "SELECT", 5, 0 scale <0.625, 0.75, 1> rotate <90, 0, 0> translate <9.5, 10, 12.15>  }
                        text { ttf "ARIALNB.TTF", "START", 5, 0 scale <0.625, 0.75, 1> rotate <90, 0, 0> translate <15.15, 10, 12.15>  }
                        text { ttf "ARIALNB.TTF", "PlayStation", 5, 0 scale <0.6, 0.7, 1> rotate <90, 0, 0> translate <12, 10, 13.0>  }
                        text { ttf "ARIALNB.TTF", "ANALOG", 5, 0 scale <0.8, 0.9, 1> rotate <90, 0, 0> translate <11.75, 10, 11.0>  }
                }
                pigment { rgb <1, 1, 1> }
                finish { phong 1 ambient 0.0 diffuse 0.3 }   
                bounded_by { box { <-9, -3, -5> <9, 4, 5> } translate <13, 6, 12> }    
                translate <0,0, 0>
        }
        
        // Start button
        intersection
        {
                superellipsoid { <0.2, 0.2> }
                superellipsoid { <0.2, 0.2> rotate <0, 45, 0> scale <1, 1, 0.707> translate <-1, 0, 0> }
                scale <1.25, 1, 0.45>
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3  }
                }                                
                bounded_by { box { <-1.6, -1.1, -1> <1, 2, 1> } } 
                translate <16.5, 8, 13.25>
        } 
        // top buttons
        superellipsoid
        {
                <0.2, 0.2>
                scale <1.6, 0.7, 1> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }                                
                translate <3, 6.25, 20.35>
        }
        superellipsoid
        {
                <0.2, 0.2>
                scale <1.6, 0.7, 1> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }                                
                translate <23.5, 6.25, 20.35>
        }

        superellipsoid
        {
                <0.2, 0.2>
                scale <1.25, 0.85, 1> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }                                
                translate <3, 4.5, 20.35>
        }
        superellipsoid
        {
                <0.2, 0.2>
                scale <1.25, 0.85, 1> 
                texture
                {
                        pigment { rgb <0.1, 0.1, 0.1> }
                        finish { phong 0.5 ambient 0.0 diffuse 0.3 }
                }                                
                translate <23.5, 4.5, 20.35>
        }
        
                            
                                  
        scale 0.8

        texture 
        { 
                pigment  
                {
                        color rgb <0.05, 0.05, 0.05> 
                }
                finish 
                {
                        PS2_Finish
                }
        }
}                                                  
