// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"   
#include "textures.inc"


// macros can have parameters and are useful for 'programming' scenes
#macro PieceBase(R1, H, R2)
        merge
        {
                cylinder { <0, 0+R2, 0> <0, H-R2, 0> R1 }
                cylinder { <0, 0, 0> <0, H, 0> R1-R2 }
                torus { R1-R2, R2 translate <0, H-R2, 0> } 
                torus { R1-R2, R2 translate <0, R2, 0> } 
                difference
                {
                        cylinder { <0, 0, 0> <0, H*2, 0> R1-(R1/5) }
                        torus { R1-(R1/5), H*1.2 translate <0, H*1.2, 0> }    
                        translate <0, H, 0>                 
                } 
//                torus { R1-(R1/2), R1/2 translate <0, H*3+(R1/2), 0> }       
//                torus { R1-(R1/5), R1/5 translate <0, R1/5, 0> scale <1, 2, 1> translate <0, H*3, 0> }       

                #local R1sq = R1*R1;
                // This works for the sizes I am using but will probably not work
                // for many different sizes (I wish I paid attention in math...)
                #local R2sq = (R1-(R1/5))*(R1-(R1/5))-(H*2.4);
                #local Y1 = sqrt(R1sq-R2sq); 
                intersection
                {
                        sphere { <0, 0, 0> R1 translate <0, Y1, 0> }
                        box { <-R1-0.1, 0, -R1-0.1> <R1+0.1, R1+Y1+0.1, R1+0.1> }    
                        scale <1, 0.75, 1>
                        translate <0, (H*3), 0>
                }   
                torus { R1-(R1/4), H translate <0, H*3+(R1), 0> }  
                difference
                {
                        cylinder { <0, 0, 0> <0, H*2, 0> R1-(R1/4) }
                        torus { R1-(R1/4), H translate <0, H, 0> }
                        translate <0, H*4+R1, 0>
                } 
                torus { R1-(R1/4), R2 translate <0, H*6+R1, 0> } 
        }
#end    

#declare tPawn = 1;    
#declare tBishop = 2;    
#declare tQueen = 3;
#declare tKing = 4; 
#declare tRook = 5;    
#declare tKnight = 6;
    

    
#macro Piece(R1,H, R2, H2, pType)
        
        merge
        {
                PieceBase(R1, H, R2)
                #switch(pType)
                #case(tPawn)               
                        difference 
                        {
                                cylinder { <0, 0, 0> <0, H2, 0> R1-(R1/4) }
                                torus { R1-R1/4, R1*0.45 translate <0, R1*0.45, 0> scale <1, H2*0.625, 1> }
                                translate <0, H*6+R1+R2, 0>
                        }                    
                        merge
                        {
                                torus { R1-(R1/4) R2 }
                                cylinder { <0, -R2, 0> <0, R2, 0> R1-(R1/4) }
                                cone { <0, R2, 0> R1-(R1/4) <0, H2/10, 0> R1/4 }
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, H2/10, 0> R1/4 }
                                        torus { R1/4, H2/20 translate <0, H2/20, 0> }
                                        translate <0, H2/10, 0>                                        
                                }                      
                                difference
                                {
                                        sphere { <0, R1-(R1/3)-(H2/30), 0> R1-(R1/3) }
                                        box { <-R1, -R1, -R1> <R1, 0, R1> } 
                                        translate <0, H2/5, 0>
                                }
                                translate <0, H*6+R1+R2+H2, 0>   
                        }
                #break
                #case(tBishop)               
                        difference 
                        {
                                cylinder { <0, 0, 0> <0, H2, 0> R1-(R1/4) }
                                torus { R1-R1/4, R1*0.45 translate <0, R1*0.45, 0> scale <1, H2*0.625, 1> }
                                translate <0, H*6+R1+R2, 0>
                        }       
                        merge
                        {
                                torus { R1-R1/2.5 R2*3 }
                                cylinder { <0, -R2*3, 0> <0, R2*3, 0> R1-R1/2.5 }  
                                torus { R1-(R1/2.5)-(R2*6), R2*3 translate <0, R2*3, 0> }
                                torus { R1-(R1/2.5)-(R2*9), R2*3 translate <0, R2*6, 0> }     
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, H2/8, 0> R1-(R1/2.5)-(R2*9) }   
                                        torus { R1-(R1/2.5)-(R2*9), H2/12 translate <0, H2/12, 0> }                                        
                                        translate <0, R2*9, 0> 
                                }  
                                difference
                                {            
                                        merge
                                        {
                                                cone { <0, 0, 0> R1-(R1/2.5)-(R2*9)-(H2/14) <0, H2/3.5, 0> R1-(R1/2.5)-(R2*4) }
                                                intersection
                                                {
                                                        sphere { <0, H2/9, 0> R1-(R1/2.5)-(R2*2.55) }
                                                        box { <-R1, 0, -R1> <R1, R1-(R1/2.5)-R2, R1> }   
                                                        scale <1, 0.75, 1>
                                                        translate <0, H2/3.5, 0> 
                                                } 
                                                merge
                                                {
                                                        cone { <0, 0, 0> R1-(R1/2.5)-(R2*8.5) <0, H2/9.5, 0> R1-(R1/2.5)-(R2*18) }
                                                        difference
                                                        {
                                                                cylinder { <0, 0, 0> <0, H2/14, 0> R1-(R1/2.5)-(R2*18) }
                                                                torus { R1-(R1/2.5)-(R2*16.5), H2/24 translate <0, H2/28, 0> scale <1, 1.4, 1>  }
                                                                translate <0, H2/9.5, 0>
                                                        }
                                                        difference
                                                        {
                                                                sphere { <0, R1/19.2, 0>  R1-(R1/2.5)-(R2*18.75) }  
                                                                box { <-R1, -R1, -R1> <R1, 0, R1> }
                                                                translate <0, H2/9.5+H2/14, 0>
                                                        }
                                                        translate <0, H2/3.5+((R1-(R1/2.5)-R2)*0.75), 0>                                          
                                                        
                                                }                                   
                                        }
                                        difference
                                        {
                                                box { <-R1, 0, -R2> <R1, R1, R2> }
                                                sphere { <0, 0, 0> R1/2 scale <0.75, 1.2, 0.75>   }
                                                rotate <-30, 0, 0> translate <0, R1/2.5, -R1/20> 
                                        }
                                        translate <0, R2*9+(H2/8), 0> 
                                }
                                translate <0, H*6+R1+(R2*3)+H2, 0> 
                        }
                #break
                #case(tQueen)               
                        difference 
                        {
                                cylinder { <0, 0, 0> <0, H2, 0> R1-(R1/4) }
                                torus { R1-R1/4, R1*0.45 translate <0, R1*0.45, 0> scale <1, H2*0.625, 1> }
                                translate <0, H*6+R1+R2, 0>
                        }  
                        merge
                        {
                                torus { R1-R1/2.5 R2*3 }
                                cylinder { <0, -R2*3, 0> <0, R2*3, 0> R1-R1/2.5 }    
                                torus { R1-(R1/2.5)-(R2*8), R2*2 translate <0, R2*2, 0> }
                                torus { R1-(R1/2.5)-(R2*10), R2*2 translate <0, R2*4, 0> }     
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, H2/16, 0> R1-(R1/2.5)-(R2*10) }   
                                        torus { R1-(R1/2.5)-(R2*10), H2/32 translate <0, H2/32, 0> }                                        
                                        translate <0, R2*6, 0> 
                                }      
                                torus { R1-(R1/2.5)-(R2*10), R2*2 translate <0, R2*8+(H2/16), 0> }  
                                
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, H2/3, 0> R1-R1/3 }   
                                        union
                                        {
                                                torus { R1-R1/3, (R1-R1/3)-(R1-(R1/2.5)-(R2*10)) scale <1, 2.5, 1> } 
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 0, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 45, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 90, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 135, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 180, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 225, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 270, 0> translate <0, H2/2.25, 0> }   
                                                cylinder { <0, 0, -R1> <0, 0, 0> R1/4.5 scale <1, 0.75, 1> rotate <-20, 315, 0> translate <0, H2/2.25, 0> }   
                                                sphere  { <0, 0, 0> R1-(R1/3) scale <1, 0.5, 1>  translate <0, (R1-(R1/3))*0.3+(H2/3), 0> }
                                        
                                        }
                                                                                
                                        translate <0, R2*10+(H2/16), 0> 
                                }       
                                sphere { <0, R2*10+(H2/16)+H2/3-(R1*0.05), 0> R1/4 }
                                sphere { <0, R2*10+(H2/16)+H2/3-(R1*0.05)+(R1/4)+(R1/14), 0> R1/10 }
                                cylinder { <0, R2*10+(H2/16)+H2/3-(R1*0.05), 0> <0, R2*10+(H2/16)+H2/3-(R1*0.05)+(R1/4)+(R1/10), 0> R1/14 }
                                translate <0, H*6+R1+(R2*3)+H2, 0> 
                        }
     
                #break  
                #case(tKing)               
                        difference 
                        {
                                cylinder { <0, 0, 0> <0, H2, 0> R1-(R1/4) }
                                torus { R1-R1/4, R1*0.45 translate <0, R1*0.45, 0> scale <1, H2*0.625, 1> }
                                translate <0, H*6+R1+R2, 0>
                        }       
                        merge
                        {
                                torus { R1-R1/2.5 R2*3 }
                                cylinder { <0, -R2*3, 0> <0, R2*3, 0> R1-R1/2.5 }  
                                torus { R1-(R1/2.5)-(R2*10), R2*4 translate <0, R2*4, 0> } 
                                cylinder { <0, 0, 0> <0, R2*14, 0> R1-(R1/2.5)-(R2*12) }
                                torus { R1-(R1/2.5)-(R2*12), R2*3 translate <0, R2*13, 0> } 
                                
                                merge
                                {
                                        cone { <0, 0, 0> R1-(R1/2.5)-(R2*12) <0, H2/3, 0> R1-(R1/4) } 
                                        intersection
                                        {
                                                sphere { <0, 0, 0> R1-(R1/4) scale <1, 0.25, 1> }
                                                box { <-R1, 0, -R1> <R1, R1, R1> }
                                                translate <0, H2/3, 0>
                                        }                                
                                        torus { R1/10, R1/10 translate <0, R1/10, 0> scale <1, 1.25, 1>                                         
                                                translate <0, H2/3+((R1-(R1/4))*0.25), 0> }             
                                        // Cross on top
                                        merge
                                        {
                                                difference
                                                {
                                                        box { <-R1/4.5, -R1/4, -R1/10> <R1/4.5, R1/4, R1/10> }
                                                        union
                                                        {
                                                                sphere { <0, 0, 0> R1/4.5 scale <0.75, 1.10, 1> translate <-R1/4.5, 0, 0> }
                                                                sphere { <0, 0, 0> R1/4.5 scale <0.75, 1.10, 1> translate <R1/4.5, 0, 0> }
                                                        }                                                                
                                                }
                                                difference
                                                {
                                                        box { <-R1/4.5, -R1/6, -R1/10.1> <R1/4.5, R1/6, R1/10.1> }
                                                        union
                                                        {
                                                                sphere { <0, 0, 0> R1/4.5 scale <1.1, 0.5, 1> translate <0, -R1/6, 0> }
                                                                sphere { <0, 0, 0> R1/4.5 scale <1.1, 0.5, 1> translate <0, R1/6, 0> }
                                                        }     
                                                       // translate <0, (R1/4.5), 0>                                                           
                                                }
                                                sphere { <0, 0, 0> R1/11 scale <1, 0.75, 1> translate <0, R1/4, 0> }
                                                translate <0, H2/3+((R1-(R1/4))*0.25)+(R1/2.1), 0> 
                                        }        
                                        translate <0, R2*15, 0>    
                                }
                                translate <0, H*6+R1+(R2*3)+H2, 0> 
                        }
                #break       
                #case(tRook)               
                        merge
                        {       
                                torus { R1-(R1/3) R2*3 }
                                cone { <0, 0, 0> R1-(R1/3) <0, H2, 0> R1-(R1/2.25) } 
                                torus { R1-(R1/2.25) R2*3 translate <0, H2, 0> }    
                                cone { <0, 0, 0> R1-(R1/2.25) <0, H2/6, 0> R1-(R1/4) translate <0, H2, 0> } 
                                torus { R1-(R1/2.5) R2*2 translate <0, H2+R2*5, 0> }                     
                                torus { R1-(R1/3.5) R2*2 translate <0, H2+R2*9, 0> }                     
                                
                                difference
                                {         
                                        merge
                                        {
                                                cylinder { <0, R2, 0> <0, H2/2, 0> R1-(R1/10) } 
                                                cylinder { <0, 0, 0> <0, (H2/2)+R2, 0> R1-(R1/10)-R2 } 
                                                torus {  R1-(R1/10)-R2 R2 translate <0, R2, 0> }
                                                torus {  R1-(R1/10)-R2 R2 translate <0, H2/2, 0> }                                                
                                        
                                        }                                                           
                                        union
                                        {
                                                box { <-R1/3.5, H2/3.1, -R1> <R1/3.5, H2, R1> rotate <0, 45, 0> }
                                                box { <-R1/3.5, H2/3.1, -R1> <R1/3.5, H2, R1> rotate <0, -45, 0> }
                                                cylinder { <0, H2/3.1, 0> <0, H2, 0> R1-(R1/3) }
                                        }
                                        translate <0, H2+(H2/6), 0> 
                                }
                                        
                                
                                translate <0, H*6+R1+R2, 0>
                        }                    
                #break
                #case(tKnight)               
                        merge
                        {  
                                // Here's the difficult one..
                                // create a smooth blobby shape
                                #declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
                                #declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density
                                
                                #declare koff = 0;
                                #declare koffstep = (360/20)/4;
                                #declare ypos=0;
                                #declare ystep=H2/20;
                                                                                             
                                
                                blob {
                                  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
                                  threshold 0.6
                                  #while(ypos < H2)
                                        #declare kr1 = R1/6-(ypos/20);
                                        #declare ks = 360/16;   
                                        #declare krot = 0;     
                                        #declare kz=R1-(R1/2)-(ypos/5);   
                                        
                                        #declare kzoff = (R1-(R1/2)-kz);
                                        
                                        #while(krot < 360)
                                                sphere { <0, 0, 0>, kr1, StrengthVal translate <0, ypos, -kz> rotate <0, krot+koff, 0> translate <0, 0, kzoff> }
                                                #declare krot = krot+ks;    
                                                #if(krot <= 180)          
                                                        #declare kzoff = kzoff*0.75;
                                                #else
                                                        #declare kzoff = kzoff/0.75;                                                
                                                #end
                                                
                                        #end
                                        #declare ypos = ypos+ystep;
                                        #declare koff = koff+koffstep; 
                                        #if(ypos > (ystep*2))   
                                                #if(ypos < (ystep*4.1))
                                                        #declare koffstep = (360/20)/8;
                                                #else                                                   
                                                #if(ypos < (ystep*5.1))
                                                        #declare koffstep = (360/20)/16;
                                                #else   
                                        
                                                #if(ypos < (ystep*7.1))
                                                        #declare koffstep = -((360/20)/16);  
                                                #else
                                                #if(ypos < (ystep*12.1))
                                                        #declare koffstep = -((360/20)/8);  
                                                #else
                                                #if(ypos < (ystep*18.1))
                                                        #declare koffstep = -((360/20)/16);  
                                                #end 
                                                #end
                                                #end
                                                #end   
                                                #end
                                                
                                        #end  
                                  #end
                                  
                                  // now for the head....
                                  
                                  // right side
                                  cylinder { <-R1/10, 0, 0>, <R1/10, 0, 0>, R1/1.5, StrengthVal scale <0.25, 0.75, 1> rotate <20, 2, 0> translate <kz+(R1/30), H2+(R1/5), 0> } 
                                  cylinder { <-R1/10, 0, 0>, <R1/10, 0, 0>, R1/3, StrengthVal scale <0.25, 0.75, 1> rotate <20, 2, 0> translate <kz+(R1/10.5), H2+(R1/4), 0> } 
                                  
                                  // left side                                  
                                  cylinder { <-R1/10, 0, 0>, <R1/10, 0, 0>, R1/1.5, StrengthVal scale <0.25, 0.75, 1> rotate <20, -2, 0> translate <-(kz+(R1/30)), H2+(R1/5), 0> } 
                                  cylinder { <-R1/10, 0, 0>, <R1/10, 0, 0>, R1/3, StrengthVal scale <0.25, 0.75, 1> rotate <20, -2, 0> translate <-(kz+(R1/10.5)), H2+(R1/4), 0> } 
                                  
                                  // mouth                                 
                                  cylinder { <0, -R1/10, 0>, <0, R1/10, 0>, R1/2.6, StrengthVal scale <0.75, 0.2, 1> rotate <-10, 0, 0> translate <0, H2, -(kz*2)> } 
                                  cylinder { <0, -R1/10, 0>, <0, R1/10, 0>, R1/2.75, StrengthVal scale <0.75, 0.2, 1> rotate <-5, 0, 0> translate <0, H2+(R1/6), -(kz*2)> } 
                                  
                                  // nose
                                  cylinder { <0, R1/10, 0>, <0, R1/10, R1>, R1/1.5, StrengthVal scale <0.75, 0.8, 0.5> rotate <-12, 0, 0> translate <0, H2+(R1/13), -(kz*2.3)> } 
                                  
                                  // top of head
                                  cylinder { <0, -R1/10, 0>, <0, R1/10, 0>, R1/1.4, StrengthVal scale <1, 0.25, 1> rotate <5, 0, 0> translate <0, H2+(R1/2), (kz/5)> } 
                                  sphere { <0, 0, 0>, R1/2, StrengthVal scale <1, 0.5, 0.8> rotate <10, 0, 0>  translate <0, R1*1.65, kz*0.65> }                                
                                  sphere { <0, 0, 0>, R1/2.5, StrengthVal scale <1.35, 1, 0.7> translate <0, R1*1.3, kz*1.1> }                                
                                  // eyes
                                  sphere { <0, 0, 0>, R1/7, -StrengthVal scale <0.75, 0.5, 1> rotate <5, 30, -5> translate <kz*0.9,H2+(R1/2.35), -kz*1.65> }
                                  sphere { <0, 0, 0>, R1/7, StrengthVal scale <0.55, 0.6, 1> rotate <5, 20, -5> translate <kz*0.935,H2+(R1/2.35), -kz*1.5> }

                                  sphere { <0, 0, 0>, R1/7, -StrengthVal scale <0.75, 0.5, 1> rotate <5, -30, -5> translate <-(kz*0.9),H2+(R1/2.35), -kz*1.65> }
                                  sphere { <0, 0, 0>, R1/7, StrengthVal scale <0.55, 0.6, 1> rotate <5, -20, -5> translate <-(kz*0.935),H2+(R1/2.35), -kz*1.5> }

                                  
                                  // right ear
                                  sphere { <kz+(R1/20)+0.15,H2+(R1/1.65), kz*0.1>, R1/8, StrengthVal }
                                  sphere { <kz+(R1/20)+0.175,H2+(R1/1.625), kz*0.4>, R1/10, StrengthVal }
                                  sphere { <kz+(R1/20)+0.2,H2+(R1/1.6), kz*0.7>, R1/12, StrengthVal }
                                  sphere { <kz+(R1/20)+0.225,H2+(R1/1.575), kz*0.9>, R1/14, StrengthVal }
                                  sphere { <kz+(R1/20)+0.25,H2+(R1/1.55), kz*1.1>, R1/16, StrengthVal }
                                  sphere { <kz+(R1/20)+0.25,H2+(R1/1.65), kz*1.2>, R1/18, StrengthVal }
                                  
                                  sphere { <kz+(R1/20)+0.175,H2+(R1/1.925), kz*0.4>, R1/10, StrengthVal }
                                  sphere { <kz+(R1/20)+0.175,H2+(R1/1.95), kz*0.6>, R1/10, StrengthVal }
                                  sphere { <kz+(R1/20)+0.2,H2+(R1/1.85), kz*0.7>, R1/12, StrengthVal }
                                  sphere { <kz+(R1/20)+0.225,H2+(R1/1.8), kz*0.9>, R1/14, StrengthVal }
                                  sphere { <kz+(R1/20)+0.25,H2+(R1/1.75), kz*1.1>, R1/16, StrengthVal }

                                  // left ear
                                  sphere { <-(kz+(R1/20)+0.15),H2+(R1/1.65), kz*0.1>, R1/8, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.175),H2+(R1/1.625), kz*0.4>, R1/10, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.2),H2+(R1/1.6), kz*0.7>, R1/12, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.225),H2+(R1/1.575), kz*0.9>, R1/14, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.25),H2+(R1/1.55), kz*1.1>, R1/16, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.25),H2+(R1/1.65), kz*1.2>, R1/18, StrengthVal }
                                  
                                  sphere { <-(kz+(R1/20)+0.175),H2+(R1/1.925), kz*0.4>, R1/10, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.175),H2+(R1/1.95), kz*0.6>, R1/10, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.2),H2+(R1/1.85), kz*0.7>, R1/12, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.225),H2+(R1/1.8), kz*0.9>, R1/14, StrengthVal }
                                  sphere { <-(kz+(R1/20)+0.25),H2+(R1/1.75), kz*1.1>, R1/16, StrengthVal }
                                  
                                  // mane
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/18, StrengthVal scale <2, 1, 1> rotate <35, 0, 0> translate <0, H2+(R1/1.5), kz*-0.25> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/19, StrengthVal scale <2, 1, 1> rotate <36, 0, 0> translate <0, H2+(R1/1.55), kz*-0.02> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/19, StrengthVal scale <2, 1, 1> rotate <37, 0, 0> translate <0, H2+(R1/1.6), kz*0.2> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/20, StrengthVal scale <2, 1, 1> rotate <38, 0, 0> translate <0, H2+(R1/1.65), kz*0.4> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/20, StrengthVal scale <2, 1, 1> rotate <39, 0, 0> translate <0, H2+(R1/1.7), kz*0.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/21, StrengthVal scale <2, 1, 1> rotate <40, 0, 0> translate <0, H2+(R1/1.75), kz*0.8> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/21, StrengthVal scale <2, 1, 1> rotate <41, 0, 0> translate <0, H2+(R1/1.8), kz*1.0> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/22, StrengthVal scale <2, 1, 1> rotate <42, 0, 0> translate <0, H2+(R1/1.85), kz*1.2> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/22, StrengthVal scale <2, 1, 1> rotate <43, 0, 0> translate <0, H2+(R1/1.9), kz*1.4> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <44, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 


                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <54, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <64, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <74, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <84, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <94, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <104, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <114, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <124, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <134, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <144, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 
                                  cylinder { <0, 0, 0>, <0, R1/5, 0>, R1/23, StrengthVal scale <2, 1, 1> rotate <154, 0, 0> translate <0, H2+(R1/1.95), kz*1.6> } 

                                  // [sturm]
                                  scale 2
                                }     

                                
                                translate <0, H*6+R1+R2, 0>
                        }                    
                #break

              
                #end  
        }


#end



#declare ChromeTex = texture {
    pigment { rgb <0.1, 0.1, 0.1> }
    finish {
        ambient 0.0
        diffuse 0.5
        brilliance 6.0
        reflection 0.45
        phong 0.8
        phong_size 120
        metallic
    }
}     


#declare BrassTex = texture {
    pigment { rgb <0.5, 0.3, 0.0> }
    finish {
        ambient 0.0
        diffuse 0.3
        brilliance 5.0
        reflection 0.2
        specular 0.8
        roughness 0.01       
        metallic
        }    
        normal
        {
                dents 0.1 
                turbulence 0.1256
                scale <.2, 1.5, .2>
                rotate <15, 5, -30>
        }
}             
texture
{
        pigment 
        {       
                dents  
                turbulence 0.3244
                colour_map
                {
                        [ 0.0 rgbf <1, 1, 1, 1> ]
                        [ 0.8 rgbf <1, 1, 1, 1> ]
                        [ 1.001 rgbf <0.2, 0.1, 0, 0> ]
                }    
                scale <0.25, 1.7, 0.5>
                rotate <10, 0, -20>    
        }
                
                                                   
        finish
        {
                ambient 0
                diffuse 0.3
                reflection 0.0001
                specular 0.02
                roughness 0.15
        }   
        normal
        {
                granite
        }
         
        
 
}


/*    
union
{     
        union
        {
                Piece(2.5, 0.2, 0.05, 5.25, tKing)    
                translate <16, 0, 0>
        }      
        union
        {
                Piece(2.25, 0.2, 0.05, 4.75, tQueen)
                rotate <0, 30, 0>
                translate <10, 0, 0>     
        }      
        union
        {
                Piece(1.95, 0.2, 0.05, 3.5, tBishop)
                translate <4, 0, 0>
        }      
        union
        {
                Piece(1.75, 0.2, 0.05, 2.5, tPawn)
                rotate <0, 0, 0>
                translate <-14, 0, 0>
        }  
        union
        {
                Piece(1.8, 0.2, 0.05, 3.25, tRook)    
                rotate <0, 0, 0>
                translate <-8, 0, 0>
        }  

        union
        {
                Piece(1.8, 0.2, 0.05, 2, tKnight)    
                rotate <0, 0, 0>
                translate <-2, 0, 0>
        }  
           
          
        texture { BrassTex }       
}
*/