// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;
#include "colors.inc"   
#include "textures.inc"  
#include "shapes.inc" 
#include "shapesq.inc"  

// create a smooth blobby shape
#declare RadiusVal   = 1.4; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density

#declare Bag=union
{
blob {
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
#declare MarbleSpacing = 1.5;
#declare yPos=1.5;
#declare xPos=0; 
#declare rotStart = 0;
 
#while(yPos < 6)   
        #declare xPos=xPos-(MarbleSpacing*0.5);
        #declare zPos=6-yPos;      
        
        #while(zPos > 0)
        #declare yStep = 100/zPos;       
        #declare yRot=rotStart;
        #declare rotStart=rotStart+(yStep/2);
                #while(yRot < (360+rotStart))
                        sphere { <0, yPos, zPos>, RadiusVal, StrengthVal rotate <0, yRot, 0> translate <xPos, 0, 0> }
                        
                        #declare yRot=yRot+yStep;
                #end
                #declare zPos=zPos-(MarbleSpacing*0.5);
        #end
        #declare yPos=yPos+MarbleSpacing*0.8;
#end                                            
 
#declare zPos=0;

#while (zPos < 6.3)
        cylinder { <0, (cos(zPos*5)*0.1), -1.5+zPos/2> <5, (cos(zPos*5)*0.4), -3+zPos> RadiusVal/7, StrengthVal rotate <0, 0, 10> translate <2.65, 2, 0> }
        cylinder { <0, (cos(95+zPos*5)*0.025), -1.5+zPos/2> <5, (cos(zPos*5)*0.1), -3+zPos> RadiusVal/7, StrengthVal rotate <0, 0, -1> translate <2.65, 1, 0> }
        #declare zPos=zPos+0.1;
#end 

#declare endRot=0;

#while (endRot < 180)
        cylinder { <0, 0.25, 0> <5.4, 1.15, 0> RadiusVal/7, StrengthVal  rotate <-endRot, 24, 0> 
                translate <2.65, 2.15, -0.9> }    
        cylinder { <0, 0.25, 0> <5.4, 1.15, 0> RadiusVal/7, StrengthVal rotate <endRot, -27, 0> 
                translate <2.65, 2.15, 0.9> }    

        #declare endRot=endRot+5;
#end
 
        sphere { <0, 0, 0> RadiusVal, StrengthVal translate <3, 2.5, 0> }
        sphere { <0, 0, 0> RadiusVal, StrengthVal translate <2, 2.25, 1> }
        sphere { <0, 0, 0> RadiusVal, StrengthVal translate <2, 2.25, -1> }

  // [sturm]   
  texture { 
                pigment 
                { 
                        quilted 
                        color_map 
                        { 
                                [ 0 color rgb <0.25, 0.125, 0.05> ] 
                                [ 1 color rgb <0.175, 0.09, 0.01> ]
                        }  
                        control0 0.1 control1 1
                        scale 0.125
                }
                normal
                {
                average
                normal_map
                {
                        [1, quilted 2 scale 0.125 ]
                        [1, wrinkles 1.5 scale 0.5 turbulence 0.12 ]
                }   
                
                }
                        
                finish { specular 0.04 roughness 0.7 ambient 0.0 diffuse 0.4 } 
          } 
 
 } 
 
// String
 merge
 {
  torus { 2, 0.1 rotate <90, 90, 0> 
   
  texture 
  { 
        pigment { 
                radial frequency 100
                color_map 
                { 
                        [ 0 color rgb <0.795, 0.7169, 0.55> ]
                        [ 1 color rgb <0.87, 0.785, 0.595> ]
                }  
                }        
        normal {
                 
                radial frequency 200  
                normal_map { 
                        [ 0 quilted bump_size 0.5 scale 0.1 ]
                        [ 1 gradient y bump_size 0.02 scale 0.1 ]   
                        }
                bump_size 2.25
                }        

        finish { specular 0.1 roughness 0.5 ambient 0.0 diffuse 0.4 } 
        rotate <0, 0, 70>     
        rotate <0, 40, 0>   
  }
      scale <1, 0.55, 1.125> translate <3.9, 2.15, 0>
  
  } 
  merge
  {
        torus { 0.2, 0.1 rotate <0, 0, 30> }
        torus { 0.3, 0.1 rotate <0, 0, -30> }
          texture 
          { 
                pigment { 
                        radial frequency 100
                        color_map 
                        { 
                                [ 0 color rgb <0.795, 0.7169, 0.55> ]
                                [ 1 color rgb <0.87, 0.785, 0.595> ]
                        }  
                        }        
                normal {
                         
                        radial frequency 200  
                        normal_map { 
                                [ 0 quilted bump_size 0.5 scale 0.1 ]
                                [ 1 gradient y bump_size 0.02 scale 0.1 ]   
                                }
                        bump_size 2.25
                        }        
        
                finish { specular 0.1 roughness 0.5 ambient 0.0 diffuse 0.4 } 
                rotate <0, 0, -10>     
                rotate <0, 40, 0>   
          }                        
          translate <3.9, 2.15, -2.25>  
  }
  // create a curved tube object translating a sphere along a certain path
  merge
  {
  merge 
  {
  sphere_sweep {
  //linear_spline                 // linear curve
  cubic_spline                // alternative spline curves
  //b_spline
  6,                            // number of specified sphere positions
  <-1, 0, 1>, .1                // position, radius
  <-0.1, 0, 0>, .1                 // ...
  < 0.5, 0.5, -2>, .1
  < -0.75, -0.5, -3.5>, .1   
  < 1, 0, -5>, .1   
  < 0, -.5, -7>, .1   

  tolerance 0.01  
  bounded_by { box { <-1, -0.75, -6> <1.25, 0.75, 0.1> } }
  } 
  
  #declare fraySeed=seed(124);
        
  #declare frayEnd=0;
  union
  {
  #while (frayEnd < 40)
        #declare rot=360*(rand(fraySeed));
          sphere_sweep {
          //linear_spline                 // linear curve
          cubic_spline                // alternative spline curves
          //b_spline
          6,                            // number of specified sphere positions
          <-0.1*rand(fraySeed), 0, 0.1*rand(fraySeed)>, .01                // position, radius
          <-0.01*rand(fraySeed), 0, 0>, .01                 // ...
          < 0.05*rand(fraySeed), 0.05*rand(fraySeed), -0.1>, .01
          < -0.1*rand(fraySeed), -0.1*rand(fraySeed), -0.2>, .01   
          < 0.1*rand(fraySeed), 0, -0.3>, .01   
          < 0, -.1*rand(fraySeed), -0.5>, .01   
        
          tolerance 0.01  
          translate <0.1*rand(fraySeed), 0, 0>
          rotate <0, 0, rot>
          
          }       
        
        #declare frayEnd=frayEnd+1;
  
  #end
          bounded_by { box { <-0.5, -0.5, -0.6> <0.5, 0.5, 0.1> } }  
          rotate <0, 15, 0>
          translate <1, 0, -4.99> 

  }
  
  texture 
  { 
        pigment { 
                radial frequency 100
                color_map 
                { 
                        [ 0 color rgb <0.795, 0.7169, 0.55> ]
                        [ 1 color rgb <0.87, 0.785, 0.595> ]
                }  
                }        
        normal {
                 
                radial frequency 200  
                normal_map { 
                        [ 0 quilted bump_size 0.5 scale 0.1 ]
                        [ 1 gradient y bump_size 0.02 scale 0.1 ]   
                        }
                bump_size 2.25
                }        

        finish { specular 0.1 roughness 0.5 ambient 0.0 diffuse 0.4 } 
        rotate <0, 0, 110>     
        rotate <0, 40, 0>
        translate <0, -1, -2.75>   
  }

  rotate <0, 30, 0>            // optional  
  translate <-0.1, 0.1, 0>
  }
  
  merge
  {
  sphere_sweep {
  //linear_spline                 // linear curve
  cubic_spline                // alternative spline curves
  //b_spline
  6,                            // number of specified sphere positions
  <0.5, 0, 1>, .1                // position, radius
  <0.1, 0, 0>, .1                 // ...
  <-0.5, -0.5, -2>, .1
  <0.1, 0.25, -3>, .1   
  <-0.1, 0, -5>, .1   
  <-0.5, -0.5, -7>, .1   

  tolerance 0.01             // optional   
  bounded_by { box { <-1, -0.75, -6> <1.25, 0.75, 0.1> } }
  } 
  
  #declare frayEnd=0;
  union
  {
  #while (frayEnd < 40)
        #declare rot=360*(rand(fraySeed));
          sphere_sweep {
          //linear_spline                 // linear curve
          cubic_spline                // alternative spline curves
          //b_spline
          6,                            // number of specified sphere positions
          <-0.1*rand(fraySeed), 0, 0.1*rand(fraySeed)>, .01                // position, radius
          <-0.01*rand(fraySeed), 0, 0>, .01                 // ...
          < 0.05*rand(fraySeed), 0.05*rand(fraySeed), -0.1>, .01
          < -0.1*rand(fraySeed), -0.1*rand(fraySeed), -0.2>, .01   
          < 0.1*rand(fraySeed), 0, -0.3>, .01   
          < 0, -.1*rand(fraySeed), -0.5>, .01   
        
          tolerance 0.01  
          translate <0.1*rand(fraySeed), 0, 0>
          rotate <0, 0, rot>
          
          }       
        
        #declare frayEnd=frayEnd+1;
  
  #end
          bounded_by { box { <-0.5, -0.5, -0.6> <0.5, 0.5, 0.1> } }
          translate <-0.1, 0, -4.99> 

  }
  
  texture 
  { 
        pigment { 
                radial frequency 100
                color_map 
                { 
                        [ 0 color rgb <0.795, 0.7169, 0.55> ]
                        [ 1 color rgb <0.87, 0.785, 0.595> ]
                }  
                }        
        normal {
                 
                radial frequency 200  
                normal_map { 
                        [ 0 quilted bump_size 0.5 scale 0.1 ]
                        [ 1 gradient y bump_size 0.02 scale 0.1 ]   
                        }
                bump_size 2.25
                }        

        finish { specular 0.1 roughness 0.5 ambient 0.0 diffuse 0.4 } 
        rotate <0, 0, 110>     
        rotate <0, 40, 0>
        translate <0, -1, -2.5>   
  }
  rotate <0, 0, 35>
  rotate <0, -20, 0> 
  translate <-0.3, -.15, 0>
  }  
  translate <3.9, 2, -2.5>
  } 
  scale <1, 1, 1.1>
  translate <0, 0, -0.2>
}


  translate <0, -0.75, 0>
 
}


                                                                        
#declare RadiusVal   = 0.15; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density


#declare mBit = blob
// create a smooth blobby shape
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
#declare Steps=75;
#declare rv=0;      
#declare yv=-1;
#declare rs=720/Steps;
#declare ys=2/Steps; 
#declare xp=0.1;
#declare xs=0.4/(Steps/2);

#while (rv < 720)
  sphere { <0, 0, 0>, RadiusVal, StrengthVal scale <xp*7, 1, 0.5> translate <xp,yv,0>rotate <0, rv, 0> } 
  #declare rv=rv+rs;
  #declare yv=yv+ys;  
  #declare xp=xp+xs;
  #if(xp > 0.4)
        #declare xs=-xs;
  #end
#end
  sturm
}

#declare MyMarbleGlass = material {  
texture {
    pigment { rgbf<0.9, 1.0, 0.9, 0.675> }
    finish  { Glass_Finish }
}
interior { ior 1.5 }//caustics 1 }
}

// marbles
#declare RedMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  

}    

#declare BlueMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Blue ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Blue ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Blue ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Blue ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  

}   


#declare YellowMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.7, 1, 0.7>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  

}   

#declare GreenMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Green ][ 1 color Clear ] } }
        scale <0.95, 1, 0.95>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Green ][ 1 color Clear ] } }
        scale <0.95, 1, 0.95>
        rotate <0, 180, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
}   


#declare OrangeMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Orange ][ 1 color Clear ] } }
        scale <0.95, 1, 0.95>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Orange ][ 1 color Clear ] } }
        scale <0.95, 1, 0.95>
        rotate <0, 180, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
}   


#declare RGBYMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Green ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Blue ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
} 

#declare RYMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Red ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
} 

#declare PBMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color DarkPurple ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color SkyBlue ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color DarkPurple ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color SkyBlue ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
} 

#declare GYMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Green ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Green ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Yellow ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
}  


#declare WierdMarble = union
{
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color SeaGreen ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        }

        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color Aquamarine ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 90, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color NeonPink ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 180, 0>        
        }
        object { mBit translate <0, 0, 0> pigment { spiral1 5  
        color_map { [0 color BlueViolet ][ 1 color Clear ] } }
        scale <0.8, 1, 0.8>
        rotate <0, 270, 0>        
        }

        sphere { <0, 0, 0> 1.5 material { MyMarbleGlass } }  
}  

