
#local Normal = <0,0,0>;
#local NeedleStart = <-4.35,10,-5.5>;
#local NeedlePosition = trace( Ground, NeedleStart, -y, Normal );
object { Needle rotate x*91.5 rotate z*-2 rotate y*97 translate y*0.35 
	scale 0.33*0.75
	translate NeedlePosition
}
	
#if( Quality > 8 )
	
	#declare GrassDriedPercent = 0.125;
	#declare OuterTex = texture { GrassTex }
	#declare GrassScaleFactor = 2;
	#declare GrassPebbles = true;
	
	#macro PlaceGrass( StartPlace, TheGround, Seed )
			#local Normal = <0,0,0>;
			#local GrassLocation = trace( TheGround, StartPlace, -y, Normal );
			object{ GrassBush( GrassLocation, Seed ) }		
	//		cylinder { GrassLocation, GrassLocation+y*16.5, 0.5
	//			pigment { rgb <0,1,0> }
	//		}
	#end
	
	#macro PlacePlant( StartPlace, TheGround, Seed )
			#local Normal = <0,0,0>;
			#local PlantLocation = trace( TheGround, StartPlace, -y, Normal );
			object{ Plant( PlantLocation, Seed ) }		
	//		cylinder { PlantLocation, PlantLocation+y*16.5, 0.5
	//			#local Intensity = Seed/40;
	//			pigment { rgb <0,Intensity,0> }
	//		}
	#end
	
	
	#local Plants = 0;
	#local PlantCount = 0;
	#local PRand = seed( 8 );
	#while( PlantCount < Plants )
		#local Normal = <0,0,0>;
		#local GrassStart = <66*rand(PRand)-28,30,15+40*rand(PRand)>;
		#local GrassLocation = trace( BackGround, GrassStart, -y, Normal );
		#debug concat( "Grass on background at <", vstr( 3,GrassLocation,", ",1,5),">\n" )
		object{ GrassBush( GrassLocation, 100*rand(PRand) ) }
		
		#local PlantCount = PlantCount+1;
	#end
	
	// Background: <-48, -5, 15> to <68, 10, 55>
	PlaceGrass( <-13,20,30>, BackGround, 16 )
	PlaceGrass( <-10,20,45>, BackGround, 2 )	// Okay
	PlaceGrass( <-25,20,52>, BackGround, 3 )	// Okay
	
	PlaceGrass( <42,20,50>, BackGround, 9 )	// Okay

	
	
	PlaceGrass( <14,30,14.8>, Ground, 25 )	// 17 tolerable, as is 18, and 22
	
	// Closeup grass
	#declare GrassScaleFactor = 1.25;	
//	PlaceGrass( <1.175,20,-13.75>, Ground, 20 )
//	object { GrassBush(<0,0,0>, 20 ) rotate x*-6 translate <1.1725,-0.14,-13.75> }

	#declare GrassScaleFactor = 0.35;	
	PlaceGrass( <0.87,20,-10.425>, Ground, 46 ) // This one's okay, on the right

	#local Plants = 0;
	#local PlantCount = 0;
	#local PRand = seed( 18 );
	#while( PlantCount < Plants )
		#local Normal = <0,0,0>;
		#local GrassStart = <66*rand(PRand)-28,30,0+15*rand(PRand)>;
		#local GrassLocation = trace( Ground, GrassStart, -y, Normal );
		#debug concat( "Grass on foreground at <", vstr( 3,GrassLocation,", ",1,5),">\n" )
		object{ GrassBush( GrassLocation, 100*rand(PRand) ) }
		#local PlantCount = PlantCount+1;
	#end
	
	#declare OuterTex = texture { WrinklyTex }
	#declare PlantScaleFactor = 0.15;
	
	PlacePlant( <2.25,30,-7.25>, Ground, 17 )
	
	PlacePlant( <1.12046,30,0.35>, Ground, 34 )				
	PlacePlant( <-2.52100,30,-0.53148>, Ground, 33 )	// Okay
	PlacePlant( <-3.08496,30,9.33358>, Ground, 28 )		// Okay
	PlacePlant( <9.73801,30,3.57977>, Ground, 28 )		// Okay
	PlacePlant( <-6.55735,30,3.29029>, Ground, 27 )		// Okay
	PlacePlant( <7.88591,30,0.66355>, Ground, 22 )		// Okay
	PlacePlant( <0.51891,30,7.15180>, Ground, 16 )		// Okay
	PlacePlant( <-8.28595,30,9.97269>, Ground, 14 )		// Okay
	
	
	#local Plants = 30;
	#local PlantCount = 0;
	#local PRand = seed( 23 );
	#while( PlantCount < Plants )
		#local Normal = <0,0,0>;
		#local PlantStart = <66*rand(PRand)-28,30,10*rand(PRand)+5>;
		#local PlantLocation = trace( Ground, PlantStart, -y, Normal );
		#debug concat( "Plant on foreground at <", vstr( 3,PlantLocation,", ",1,5),">  Seed: ", str( PlantCount, 3, 1 ), "\n" )
	
		object{ Plant( PlantLocation, PlantCount ) }
		
	//	text {
	//		ttf "timrom.ttf",
	//		str( PlantCount, 3, 1 )
	//		0.3, <0.0, 0.0, 0.0>
	//		scale 0.5
	//		translate PlantLocation+<0,1,0>
	//		pigment { rgb 1 }
	//	}
		
	//	cylinder { PlantLocation, PlantLocation+y*16.5, 0.5
	//			#local Intensity = PlantCount/Plants;
	//			pigment { rgb <0,Intensity,0> }
	//		}	
		#local PlantCount = PlantCount+1;
	#end
	
	// -13 to 42 
	#local Plants = 100;
	#local PlantCount = 0;
	#local PRand = seed( 20 );
	#while( PlantCount < Plants )
		#local Normal = <0,0,0>;
		#local PlantStart = <55*rand(PRand)-13,30,30*rand(PRand)+15>;
		#local PlantLocation = trace( BackGround, PlantStart, -y, Normal );
		object{ Plant( PlantLocation, PlantCount ) }	
			
	//	text {
	//		ttf "timrom.ttf",
	//		str( PlantCount, 3, 1 )
	//		0.3, <0.0, 0.0, 0.0>
	//		scale 0.65
	//		translate PlantLocation+<0,1,0>
	//		pigment { rgb <1,0.5,0.5> }
	//	}	
		#local PlantCount = PlantCount+1;
	#end

	// Tiny foreground grass
	#declare GrassTex = texture { YoungGrassTex }
	#declare GrassScaleFactor = 0.125;
	#declare GrassDriedPercent = 0;
	#declare GrassBlades = 14;
	#declare GrassPebbles = false;
	object { GrassBush(<0,0,0>, 83 ) translate <-3.25, -0.0, -9.75>} 

//	#declare GrassScaleFactor = 0.15;	
		
	// Remove this if it looks silly (middle bottom)
	PlaceGrass( <-1.53,20,-11.95>, Ground, 83)

#end
