#declare RockBasePigment = pigment {
	agate
	color_map {
		[ 0.45 rgb <0.287541, 0.291096, 0.312215> ]
		[ 0.8 rgb <0.332540, 0.339361, 0.251286> ]
	}
	scale 0.5
}

#declare RockVeinBasePigment = pigment {
	crackle
	color_map {
		[ 0.075*0.2 rgbf <0.511315, 0.388540, 0.339590, 0.3> ]
		[ 0.125*0.2 rgbf <0.511315, 0.388540, 0.339590, 0.3> ]
		[ 0.175*0.2 rgbt 1 ]
	}
	turbulence 0.7
	scale <0.75,0.3,0.5>
	rotate <-5,20,25>
}

#declare ClearPigment = pigment {
	rgbf 1
}

#declare RockVeinPigment = pigment {
	bozo
	pigment_map {
		[ 0.4 ClearPigment ]
		[ 0.6 RockVeinBasePigment scale 4 ]
	}
	scale 0.25
	translate 6
}

#declare RockWhiteBlotchesPigment = pigment {
	bozo
	color_map {
		[ 0.2 rgbf <0.782803, 0.769131, 0.728130, 0.6> ]
		[ 0.375 rgbf 1 ]
	}
	scale <0.05,0.025,0.025>
	rotate <-10,30,10>
	translate 4
}

#declare RockDirtPigment = pigment {
	leopard
	color_map {
		[ 0.2 rgbt <0.307698, 0.247669, 0.108629, 1> ]
		[ 0.22 rgbt <0.307698, 0.247669, 0.108629, 0.3> ]
		[ 0.3 rgbt <0.307698, 0.247669, 0.108629, 0.6> ]
		[ 0.8 rgbt <0.307698, 0.247669, 0.108629, 0.9> ]
	}
	turbulence 0.3
	scale 0.25
	translate <-0.6,0,0>
}

#declare RockNormal = 	normal {
		crackle 0.6
		bump_size 2.0
		scale <0.02,0.02,0.1>
		rotate y*75
	}
	
#declare RockFinish = 	finish { specular 0.1 roughness 0.1 }


#declare RockBaseTex = texture {
	pigment { RockBasePigment }
	normal { RockNormal }
	finish { RockFinish }
}

#declare RockVeinTex = texture {
	pigment { RockVeinPigment }
	normal { RockNormal }
	finish { RockFinish }
}

#declare RockWhiteBlotchesTex = texture {
	pigment { RockWhiteBlotchesPigment }
	normal { RockNormal }
	finish { specular 0.175 roughness 0.1 }
	translate 2
}

#declare RockDirtTex = texture {
	pigment { RockDirtPigment }
	normal { RockNormal }
	finish { specular 0.05 roughness 0.1 }
}

#declare RockTex = texture { RockBaseTex }
texture { RockVeinTex }
texture { RockWhiteBlotchesTex }
texture { RockDirtTex }

#declare Crackles =
function{
	pigment{ crackle turbulence 0.1
	color_map{
		[0.0 color rgb 1]
		[1.0 color rgb 0]
	}
	
	translate <1700654, -334200, 512934 >} 
}

#declare TinyCrackles =
function{
	pigment{ crackle turbulence 0.7
	color_map{
		[0.0 color rgb 1]
		[1.0 color rgb 0]
	}
	
	translate -70000} 
}

#declare Granite = 
function{
	pigment { dents // turbulence .25
	color_map{ 
		[0.0 color rgb 0.0]
		[1.0 color rgb 0.2]
	}
	
	translate 494949
	}
}

#declare RockBase = 
isosurface{
	function{  
		x*x + y*y + z*z -1.0 
		+	Crackles(1.1*x,.95*y,.9*z).gray * .65 
		+	TinyCrackles(7.5*x, 7.5*y, 7.5*z).gray * .04 //.07  
 		+	Granite(12*x, 12*y, 12*z ).gray * .015
	}


	//eval 
	accuracy .00001	
	max_gradient 6.389
	contained_by {
		box{<0.0, 2, 2>,<-2, -2, -2> }
	}
	
	scale 2.5
	rotate <63, -30, -90>
	scale <1.1, 1, 1.4>
}

#declare Rock = object { 
	RockBase 
	translate <-2.95, -1.2, -11.2>
	texture { RockTex }
}

//#include "Terrain.inc"

//object{ Ground } 

#include "Ant.mcr"


RandomizeAnt( 49 )
//#declare AntLeg4XRot = -40;
//#declare Leg4JointAngle1 = 20;
#declare Leg4JointAngle2 = 30;
#declare Leg4JointAngle3 = 20;

#declare Leg2JointAngle1 = Leg2JointAngle1+3;


#declare AntGeneral = 
object { Ant() 
scale 0.15*0.3
rotate y*231
translate <-2.35, .52, -11.0>
}


sphere {
	<-2.29,0.7,-11.1>, 0.001
	texture {
		pigment {
			rgb 1
		}
		finish { ambient 1 diffuse 0 }
	}
	no_shadow
}

light_source {
	<-1.93, 1.50, -13.0>
	rgb 0.7
	spotlight
 	point_at <-2.29, .7, -11.1>
	radius 2
	falloff 4
	tightness 10
//	shadowless
}
