#ifndef( Quality )
#declare Quality = 9;
#end

#if( Quality > 5 )
sky_sphere {
	pigment { 
		gradient y
		color_map {
			[ 0.45 rgb <0.950225, 0.549676, 0.527245> ]
			[ 0.54 rgb <0.741344, 0.817380, 0.950210> ]
			[ 0.6 rgb <0.184161, 0.354635, 0.895933> ]
			[ 1 rgb <0,0,0.5> ]
		}	
		scale 2
		translate y*-1
	}
}
#end

#declare ClearTex = texture {
	pigment { rgbf 1 }
}

#ifndef( CloudLevelMin )
#declare CloudLevelMin = 0.2;
#declare CloudLevelTop = 0.6;
#end

#declare CloudTextureBase = texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.1,0.1,0.1,0.9> ]
			[ CloudLevelTop-0.1*0.1 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*1
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.2,0.2,0.2,0.8> ]
			[ CloudLevelTop-0.1*0.2 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*2
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.3,0.3,0.3,0.7> ]
			[ CloudLevelTop-0.1*0.3 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*3
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.4,0.4,0.4,0.6> ]
			[ CloudLevelTop-0.1*0.4 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*4
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.5,0.5,0.5,0.5> ]
			[ CloudLevelTop-0.1*0.5 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*5
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.6,0.6,0.6,0.4> ]
			[ CloudLevelTop-0.1*0.6 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*6
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.7,0.7,0.7,0.3> ]
			[ CloudLevelTop-0.1*0.7 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*7
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.8,0.8,0.8,0.2> ]
			[ CloudLevelTop-0.1*0.8 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*8
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <0.9,0.9,0.9,0.1> ]
			[ CloudLevelTop-0.1*0.9 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*9
}
texture {
	pigment { 
		bozo
		color_map {
			[ CloudLevelMin rgbf <1.0,1.0,1.0,0.0> ]
			[ CloudLevelTop-0.1*1.0 rgbf 1 ]
		}
		turbulence 0.75
	}
	translate y*0.01*10
}

#ifndef( CloudTranslation )
#declare CloudTranslation = 0;
#end

#declare CloudTexture = texture {
	CloudTextureBase
	scale <0.75,0.1,0.3>
	translate CloudTranslation
}

#if( Quality > 8 )

light_group {

	light_source {
		<-900,400,-100>
		rgb <1,0.99,0.95>
	}

	light_source {
		<-900,400,-10>
		rgb <1,0.99,0.95>
		shadowless

	}


	sphere {
		<0,0,0>, 1 hollow
		texture {
			gradient y
			texture_map {
				[ 0.55 ClearTex ]
				[ 0.6 CloudTexture ]
			}
			scale 2
			translate y*-1
		}
		scale 1000
		rotate x*2
	}
	
	#declare CloudTexture = texture {
		CloudTextureBase
		translate <5,0,0>
		scale <0.75,0.1,0.3>*1/1.5
	}
	
	sphere {
		<0,0,0>, 1 hollow
		texture {
			gradient y
			texture_map {
				[ 0.55 ClearTex ]
				[ 0.6 CloudTexture ]
			}
			scale 2
			translate y*-1
		}
		scale 1500
		rotate x*2
	}
	
	#declare CloudTexture = texture {
		CloudTextureBase
		translate <8,0,0>
		scale <0.75,0.1,0.3>*1/2
	}
	
	sphere {
		<0,0,0>, 1 hollow
		texture {
			gradient y
			texture_map {
				[ 0.55 ClearTex ]
				[ 0.6 CloudTexture ]
			}
			scale 2
			translate y*-1
		}
		scale 2000
		rotate x*2
	}
	global_lights off
}
#end
