#debug "--- SugarCube.inc --- \n"

#declare SugarTex = 
texture{
	pigment{
		color rgb <1.15, 1.15, 1.15>
	}
	finish{
		specular 1
		ambient .45
	}
}

#macro MakeSugarCube(numberElements, elementSize)

#local CubeRandom = seed( 498314  );


union{
	#local i = 0;
	#while (i<numberElements)
	
	#local xtrans = (rand(CubeRandom)*2)-1;
	#local ytrans = (rand(CubeRandom)*2)-1;
	#local ztrans = (rand(CubeRandom)*2)-1;
	#local edge_tolerance = 1.84;
	#while((abs(xtrans) + abs(ytrans) > edge_tolerance) | (abs(ytrans)+abs(ztrans) > edge_tolerance) | (abs(ztrans)+abs(xtrans) > edge_tolerance)) 
			#if(xtrans > 0)
				#local xtrans = xtrans - .01;
			#else
				#local xtrans = xtrans +.01;
			#end
				
			#if(ytrans > 0)
				#local ytrans = ytrans - .01;
			#else
				#local ytrans = ytrans +.01;
			#end
			
			#if(ztrans > 0)
				#local ztrans = ztrans - .01;
			#else
				#local ztrans = ztrans +.01;
			#end
	#end
	box{
		<1, 1, 1>, <-1, -1, -1>
		scale elementSize
		rotate<rand(CubeRandom)*90, rand(CubeRandom)*90, rand(CubeRandom)*90>
		
		
		
		translate <xtrans, ytrans, ztrans>		
				texture { SugarTex } 
		
	}
	
	
	#local i  = i + 1;
	#end
	

}
#end

//for the REAL sugar cube, use the next 4 lines...
#if( Quality > 10 )
#declare CubeBase = MakeSugarCube(17500, .025)
#declare SugarCube = 
object{
	CubeBase
	scale <1.0, .90, 1.0>
//	scale 0.9
//	rotate <-14, 0, 6>
//	translate <.6, 1.3*0.93, -5.45>
	texture { SugarTex } 
}
#else
//for a FAKE sugar cube, use the next 3 lines...
//#declare SugarCube = 
//box{ 
//	 < 1, 1, 1 >, <-1, -1, -1>
//	
//
//	
//	scale 1.0
//	scale <1.0, .90, 1.0>
//	scale 0.9
//	rotate <-14, 0, 6>
//	translate <.6, 1.3*0.9, -5.45>
//	
//	texture { SugarTex } 
//}
#end

