// Persistence Of Vision Raytracer Version 3.5
// File: GWC_72.POV
// Date: June 2004
// Auth: James Coons
// Desc: Great Wall Of China - IRTC Entry for "Epic Proportions"
//
#include "colors.inc"

// ************************************************************************************************************************
#declare Quality   = 99;   // 0 = Lowest, 9=Highest; 99=Use Settings                /Quality
#declare Camera_No =  1;   // 1=Normal, 2=Wide, 3=Extra_Wide, 4=Bird_1; 5=Bird_2; 6=God_1, 7=God_2                  /Camera
#declare Debug_On  =  0;   // 0=No, 1=Yes                                           /Debug
// ************************************************************************************************************************
#declare Mtn_On            =     1;          // 0=No, 1=Yes
#declare Mtn_Normal        =     1;          // 0=No, 1=Yes
#declare Mtn_Image         =     1;          // 0=Solid Color, 1=Pigment Image
// ************************************************************************************************************************
#declare Wall_On           =     1;          // 0=No, 1=Yes
#declare Wall_Image        =     1;          // 0=Solid Color, 1=Image Map
#declare Wall_Normal       =     1;          // 0=No, 1=Yes
// ************************************************************************************************************************
#declare Gate_On           =     1;          // 0=No, 1=Yes
// ************************************************************************************************************************
#declare Sky_Image         =     1;          // 0=Solid Color, 1=Pigment Image
#declare Sky_Tint          = LightBlue    ;  // Color to Tint Sky
#declare Sky_Angry         =   0.4+0.75   ;  // "Angriness" of Sky (0.0=Normal, 1.0=Very Angry) 
#declare Sky_Seed          =     2;          // Produce Variations of Sky (any number is valid)
// ************************************************************************************************************************
#declare Mural_On          =     1;          // 0=No, 1=Yes
#declare Mural_Image       =     1;          // 0=Solid Color, 1=Image Map
#declare Mural_Normal      =     1;          // 0=No, 1=Yes
// ************************************************************************************************************************
#declare Sun_Color         =                 // Color used for Sun
   (White*.9+Gold*.5+SkyBlue*.25)*1.1;  
#declare Sun_Pos           = <2000,9000,-6000> ; // /Sun
// ************************************************************************************************************************
#declare Can_On            =     1;          // 0=No, 1=Yes
#declare Crayons_On        =     1;          // 0=No, 1=Yes
#declare Fog_On            =     0;          // 0=No, 1=Yes
// ************************************************************************************************************************
   #if (Quality=0)
      #declare Debug_On    = Debug_On;       // 0=No, 1=Yes
      #declare Mtn_On      =     1;          // 0=No, 1=Yes
      #declare Mtn_Normal  =     0;          // 0=No, 1=Yes
      #declare Mtn_Image   =     0;          // 0=Solid Color, 1=Image Map
      #declare Wall_On     =     1;          // 0=No, 1=Yes
      #declare Wall_Image  =     0;          // 0=Solid Color, 1=Image Map
      #declare Wall_Normal =     0;          // 0=No, 1=Yes
      #declare Gate_On     =     1;          // 0=No, 1=Yes
      #declare Sky_Image   =     0;          // 0=Solid Color, 1=Image Map
      #declare Can_On      =     1;          // 0=No, 1=Yes
      #declare Crayons_On  =     1;          // 0=No, 1=Yes
      #declare Mural_On    =     1;          // 0=No, 1=Yes
      #declare Mural_Image =     0;          // 0=Solid Color, 1=Image Map
      #declare Mural_Normal=     0;          // 0=No, 1=Yes
      #declare Fog_On      =     0;          // 0=No, 1=Yes
   #end
   #if (Quality=9)
      #declare Debug_On    =     0;          // 0=No, 1=Yes
      #declare Mtn_On      =     1;          // 0=No, 1=Yes
      #declare Mtn_Normal  =     1;          // 0=No, 1=Yes
      #declare Mtn_Image   =     1;          // 0=Solid Color, 1=Image Map
      #declare Wall_On     =     1;          // 0=No, 1=Yes
      #declare Wall_Image  =     1;          // 0=Solid Color, 1=Image Map
      #declare Wall_Normal =     1;          // 0=No, 1=Yes
      #declare Gate_On     =     1;          // 0=No, 1=Yes
      #declare Sky_Image   =     1;          // 0=Solid Color, 1=Image Map
      #declare Can_On      =     1;          // 0=No, 1=Yes
      #declare Crayons_On  =     1;          // 0=No, 1=Yes
      #declare Mural_On    =     1;          // 0=No, 1=Yes
      #declare Mural_Image =     1;          // 0=Solid Color, 1=Image Map
      #declare Mural_Normal=     1;          // 0=No, 1=Yes
      #declare Fog_On      =     0;          // 0=No, 1=Yes
   #end

// ************************************************************************************************************************
// Available Cameras             - /Camera /Look /Angle
//    Camera 1 - Normal          - Normal View used for Final Render    (80 degrees)
//    Camera 2 - Wide            - Wide Angle View                      (Normal View, 120 degrees)
//    Camera 3 - Extra_Wide      - Extra_Wide Angle View                (Normal View, 150 degrees)
//    Camera 4 - Bird_1          - High Overhead View                   (Overhead, 75 units up)
//    Camera 5 - Bird_2          - Very High Overhead View              (Overhead, 150 units up)
//    Camera 6 - God_1           - Ultra High Overhead View             (Overhead, 300 units up)
//    Camera 7 - God_2           - Super High Overhead View
// ************************************************************************************************************************
#declare Camera_Pos        = <-6,8,-41>      ;     // Default (8 units high)
#declare Camera_Aim        = <-2,-5,-5>      ;     // Default
#declare Camera_Angle      = 80              ;     // Default
// ************************************************************************************************************************
#if (Camera_No=1) // 1=Normal /Normal
   #declare Camera_Pos     = Camera_Pos      ;
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = Camera_Angle    ;
#end
#if (Camera_No=2) // 2=Wide /Wide
   #declare Camera_Pos     = Camera_Pos      ;
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = Camera_Angle+40 ;           // 120 degrees
#end
#if (Camera_No=3) // 3=Extra_Wide /Extra_Wide
   #declare Camera_Pos     = Camera_Pos      ;
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = Camera_Angle+70 ;           // 150 degrees
#end
#if (Camera_No=4) // 4=Bird_1 (overhead*1) /Bird_1 /Bird_1
   #declare Camera_Pos     = <-1,75,-15>     ;           // 75 units high
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = 75              ;
#end
#if (Camera_No=5) // 5=Bird_2 (overhead*2) /Bird_2 /Bird2
   #declare Camera_Pos     = <-1,150,-30>    ;           // 150 units high
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = 75              ;
#end
#if (Camera_No=6) // 6=God_1 (overhead*4) /God_1 /Bird*4
   #declare Camera_Pos     = <-1,300,-60>    ;           // 300 units high
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = 75              ;
#end
#if (Camera_No=7) // 6=God_2 (overhead*4) /God_1 /Bird*4
   #declare Camera_Pos     = <-0.1,600,-120> ;           // 600 units high
   #declare Camera_Aim     = Camera_Aim      ;
   #declare Camera_Angle   = 75              ;
#end

// ************************************************************************************************************************
// Sun /Sun /Light
// ************************************************************************************************************************
light_source {0 Sun_Color fade_distance 50000 fade_power 1 translate Sun_Pos}

// ************************************************************************************************************************
// Camera 
// ************************************************************************************************************************
camera {location Camera_Pos 
   angle Camera_Angle
   look_at Camera_Aim }

// ************************************************************************************************************************
// Macro:   Mixes pigment by averaging at various angles. 05/21/2004
// Note:    This either replaces the "pigment{}" statement or must appear in a "texture{}" statement.
//          
// Example: sphere {0,5 Mix_Pigment (granite, 0.1) }
//      or: sphere {0,5 texture {Mix_Pigment (granite, 0.1) } }
// ************************************************************************************************************************
#macro Mix_Pigment (pcPigment, pcScale)
   pigment {average
      pigment_map {
         [+1.00 pcPigment rotate <87,5,7> scale 1.00 turbulence 0.02]   // xz Plane
         [+0.80 pcPigment rotate <7,7,5>  scale 0.87 turbulence 0.04]   // xy Plane
         [+0.70 pcPigment rotate <9,87,7> scale 0.67 turbulence 0.08]   // yz Plane
         [-0.25 pcPigment rotate <47,47,47> scale 0.25 turbulence 0.2]  // Chaotic Effect
         }
      scale pcScale
      }
#end

// ************************************************************************************************************************
// Sky Sphere (pigmented or plain) /Sky
// ************************************************************************************************************************
#declare Sky_Radius = 500000;          // Radius of Sky Sphere
sphere { <0.0, 0.0, 0.0>, Sky_Radius*5 translate <0,-Sky_Radius,0> 
   #if (Sky_Image = 0)
      pigment {Sky_Tint}
   #else
      pigment {
         agate scale 320000 turbulence 0.15
         // average scale 320000 turbulence 0.15
         pigment_map {
            [+1.0  image_map {jpeg "_Clouds.jpg" map_type 1} rotate y*(Sky_Seed) warp {turbulence 0.1} ]
            [+0.2 Sky_Tint]
            #if (Sky_Angry>0)
               [-(Sky_Angry/2) image_map {jpeg "_Clouds.jpg" map_type 1} rotate y*(Sky_Seed*13) warp {turbulence 0.4} ]
               [-(Sky_Angry/4) image_map {jpeg "_Clouds.jpg" map_type 1} rotate y*(Sky_Seed*7) warp {turbulence 0.4} ]
               // [-(Sky_Angry/4) image_map {jpeg "_Clouds.jpg" map_type 1} rotate y*(Sky_Seed*7) warp {turbulence 0.4} ]
            #end
            }
         }
   #end  
   finish {ambient 1.0 diffuse 0 reflection 0 }
   inverse
   no_shadow
   scale <100,20,100>
}

// ************************************************************************************************************************
// Pigment Images /Image
// ************************************************************************************************************************
#declare Play_Dough_1  = pigment {image_map { jpeg "_wall.jpg"      interpolate 2.0 map_type 0 } rotate z*15}
#declare Rock          = pigment {image_map { jpeg "_rock14.jpg"    interpolate 2.0 map_type 0 } rotate z*15}
#declare Blue_Rock     = pigment {image_map { jpeg "_Rock14_HC.jpg" interpolate 2.0 map_type 0 } turbulence <0,0.1,0> }
#declare Brown_Rock    = pigment {image_map { jpeg "_Rock08.jpg"    interpolate 2.0 map_type 0 } turbulence <0,0.1,0> }
#declare Dirt          = pigment {image_map { jpeg "_Dirt.jpg"      interpolate 2.0 map_type 0 } turbulence 0.25}
#declare Grass         = pigment {image_map { jpeg "_Grass.jpg"     interpolate 2.0 map_type 0 } }
// #declare Grass_Mixture = Mix_Pigment (Grass,1.0) ;

// ************************************************************************************************************************
// *** Mtn_Texture /texture
// ************************************************************************************************************************
#declare Mtn_Texture =
   texture {
      slope {y, 0.0, 1.0 // altitude 1.0 // , 0.0, 1.0
         } scale 40
      // gradient y scale 10*4*2 // translate y*.5 // May work, but will not look the same
      texture_map {
         // [0.00 Grass_Mixture rotate x*75 
         [0.00 Grass rotate x*90
            scale 0.15
            finish {ambient 0.30 reflection 0.02 }  
            ]
         [0.45 Blue_Rock 
            rotate x*65 rotate z*17 scale 0.52
            finish {ambient 0.35 reflection 0.02 diffuse 0.25 crand 0.25} 
            #if (Mtn_Normal=1) normal {agate 1.0 scale 0.20} #end
            ]
         [0.50 Brown_Rock 
            rotate x*65 scale 0.59*0.75
            finish {ambient 0.30 reflection 0.02 diffuse 0.25} 
            #if (Mtn_Normal=1) normal {granite 1.0 scale 0.2*2} #end
            ]
         [0.60 Dirt 
            scale 0.03 rotate x*85
            finish {ambient 0.30 reflection 0.02 }  
            #if (Mtn_Normal=1) normal {agate 1.0 scale 0.25 scale <0.1,1,0.1> } #end 
            ]
         // [1.00 Grass_Mixture rotate x*75 
         [1.00 Grass rotate x*90
            scale 0.15
            finish {ambient 0.30 reflection 0.02 }  
            ]
      // turbulence 0.2 // Try
      }
   }

// ************************************************************************************************************************
// HF Mountain /mountain /mtn
// ************************************************************************************************************************
#if (Mtn_On=1)
   #declare Mtn_Object = height_field {
      jpeg "_mtn_31.jpg" smooth
      translate <-.5,0,-.5> 
         scale <208, 51, 225> 
         #if (Mtn_Image=0)
            pigment {color Green/2}
            finish {ambient 0.4 reflection 0.10 diffuse 0.50}
            #if (Mtn_Normal=1) normal {granite 1.0 scale 10} #end
         #else
            texture {Mtn_Texture}
         #end
         translate <0,-20,35>
   }
   object {Mtn_Object}
#end

// ************************************************************************************************************************
// Great Wall /Wall
// ************************************************************************************************************************
#declare Wall_Texture = 
   pigment {
      average
      pigment_map {
         [1.0 image_map { jpeg "_Wall.jpg" interpolate 2.0 map_type 0 } ]
         [0.2 agate scale 5.0]
         }
      rotate y*10
      } 
#declare Main_Wall    = box {<0,0,0> <1,1,1> translate -0.5 rotate x*-90 scale <40+10+20/2,14*1.2,4.0>*<5,1,1> translate <0,-7-1,-12> }
#declare Hole_In_Wall = height_field {jpeg "_Hole.jpg" smooth translate -.5 rotate x*-90 scale <62*0.9,40,35> translate <-3,0,0> }
#declare Wall_Object  = difference {object {Main_Wall} object {Hole_In_Wall} }
#if (Wall_On=1)
   // Main Wall (Front and Sides)
   object {
      Wall_Object
      #if (Wall_Image=0)
         pigment {color Brown} 
      #else
         texture {Wall_Texture scale <15,5,5> } 
      #end
      finish {ambient 0.4 reflection 0.02 diffuse 0.5}
      #if (Wall_Normal=1) normal {granite 2.0 scale 1 accuracy 1e-6} #end
      }
   // Fill-In Wall (Brickwork on Top Edge)
   object {
      Wall_Object translate <.001,+.001,+.001>
      #if (Wall_Image=0)
         pigment {color Brown} 
      #else
         texture {Wall_Texture scale <15,5,5> rotate x*90} 
      #end
      finish {ambient 0.4 reflection 0.02 diffuse 0.5}
      #if (Wall_Normal=1) normal {granite 2.0 scale 1 accuracy 1e-6} #end
      }
#end

// ************************************************************************************************************************
// Yellow Can of Play Dough (Pov's "Ray-Doh") with Dough /Can
// ************************************************************************************************************************
#if (Can_On=1)
   #declare Can_Scale    = 3                ; // Adjusted Scale of Can
   #declare Can_Location = <21,-5.-5,5>     ; // Final Location of Can
   // *********************************************************************************************************************
   #declare Play_Dough_Can =
      difference {
         // Play Dough Can /Can
         cylinder {-1.5*y, 1.5*y, 1.38
            finish {ambient 0.4 reflection 0.1 phong 1 phong_size 1e4 roughness 0.2}
            pigment {image_map { jpeg "_Label.jpg" interpolate 2.0 map_type 2} translate y*-.52 scale 3.0 rotate y*-(170+15) }
            normal {agate 0.1 scale 0.056 }
            double_illuminate
            }
         // Play Dough Can (Hollow Area in Can)
         cylinder {-1.5*y, 1.6*y, 1.30625
            pigment {color (Yellow*1.1+Orange)*0.25 filter 0.85}
            finish {ambient 0.6 reflection 0.2 phong 1 phong_size 1e4 roughness 0.2}
            normal {agate 0.1 scale 0.08*0.7 }
            double_illuminate
            }
         }
   // *********************************************************************************************************************
   #declare Dough_Object =
      // *** Play Dough Ball *** /Dough /Ball
      height_field {
         jpeg "_dough.jpg" smooth water_level 5/255
         translate -.5 
         scale <2.4, 3.2175, 2.534125>
            translate <-0.2,0.4,0>
         texture {Play_Dough_1 scale 3.0
            pigment {turbulence 0.50}
            // normal {agate 0.1 scale 0.08*0.7 }
            finish {ambient 0.6 reflection 0.02 diffuse 0.2 crand 0.1}
            #if (Wall_Normal=1) normal {agate 20 scale 10.0 accuracy 1e-8} #end
            }
         }
   // *********************************************************************************************************************
   union {
      object {Play_Dough_Can}
      object {Dough_Object}
      scale Can_Scale
      rotate z*80
      rotate y*-20
      translate Can_Location
      translate y*-2
   }
#end

// ************************************************************************************************************************
// Draw Reference Axes (For Testing)
//    Note: Tic Marks are drawn every 1 POV unit on each Axis by using an alternative light/dark color gradient. 
//          Each Axis is colored as follows: X=Red, Y=Green and Z=Blue. The Origin is a White Circle. The width
///         of the Tic Marks can be changed using the axStep variable. 
// #declare Debug_On  =  1;   // 0=No, 1=Yes (insert at top of scene file)
// ************************************************************************************************************************
#if (Debug_On=1)
   #declare axShowAxes = 1    ; // 0=No, 1=Yes
   #declare axShowTics = 0    ; // Number of Points, radiating out from Origin
   #declare axRadius   = 0.15 ; // Size of Axis Cylinders in POV Units
   #declare axStep     = 1    ; // Number of POV Units per TIC Mark
   #declare axSize     = 5000 ; // Max. Size of each Axis
   // Draw Main Axes
   #if (axShowAxes=1)
      union {
         // X-Axis (Red)
         cylinder {<-axSize,0,0>, <axSize,0,0>, axRadius 
            pigment {gradient x scale axStep*2
               color_map {[0.00 Red*5] [0.50 Red*5] [0.50 Black] [1.00 Black] } } }         
         // Y-Axis (Green)
         cylinder {<0,-axSize,0>, <0,axSize,0>, axRadius 
            pigment {gradient y scale axStep*2
               color_map {[0.00 Green*5] [0.50 Green*5] [0.50 Black] [1.00 Black] } } }              
         // Z-Axis (Blue)
         cylinder {<0,0,-axSize>, <0,0,axSize>, axRadius 
            pigment {gradient z scale axStep*2
               color_map {[0.00 Blue*5] [0.50 Blue*5] [0.50 Black] [1.00 Black] } } }
         // Origin (White)
         sphere { <0, 0, 0>, axRadius*2.1 pigment {color White } }  
         finish {ambient 2.0 diffuse 0.5 reflection 0.0}
         }
   #end
#end

// *********************************************************************************************************************
// Crayon Macro
//    Input: cra_Image_No      = 1           ; // Image Number for Crayon Wrapper
//           cra_Label_Angle   = 45          ; // Rotation of Label around Crayon
//           cra_Wax_Color     = Brown       ; // Color of Crayon Stick
// *********************************************************************************************************************
// #macro MakeCrayon (cra_Label_Angle, cra_Rotation, cra_Translation, cra_Wax_Color, cra_Image_No)
#macro MakeCrayon (cra_Image_No, cra_Label_Angle, cra_Wax_Color)
   // Crayon starts out with bottom at origin and length of crayon along positive y-Axis
   // First rotation moves the Crayon Wrapper around the Crayon for better visibility
   #declare cra_R =  1/6*4 ;  // Crayon Radius
   #declare cra_H = 12/6*4 ;  // Crayon Length
   // ******************************************************************************************************************
   #declare Crayon_Wrapper =
      object {
         // Crayon Wrapper /Crayon /Wrapper
         cylinder {<0,0,0> <0,cra_H>, cra_R
            pigment {image_map {
               #switch (cra_Image_No)
                  #case (1) jpeg "_crayon1.jpg" #break
                  #case (2) jpeg "_crayon2.jpg" #break 
                  #case (3) jpeg "_crayon3.jpg" #break 
                  #case (4) jpeg "_crayon4.jpg" #break 
               #end
               interpolate 2.0 map_type 2} rotate y*(240+cra_Label_Angle) scale <1,2*4,1> }
            finish {ambient 0.3 reflection 0.15 phong 1 phong_size 1e4 roughness 0.2}
            normal {agate 0.1 scale 0.08*0.7 }
         }     
      }
   // ******************************************************************************************************************
   #declare Crayon_Stick =
      // Crayon Stick /Crayon /Stick
      object {
         height_field {
            jpeg "_Stick.jpg" smooth water_level 5/255 translate <-.5,0,-.5> 
            scale <cra_R*2,cra_H*1.30,cra_R*2>
            pigment {color (cra_Wax_Color*0.4) }
            finish {ambient 0.6 reflection 0.30 diffuse 0.2}
            translate y*-0.48
            }
      }
   // ******************************************************************************************************************
   union {
      object {Crayon_Wrapper}
      object {Crayon_Stick}
   }
#end

// *********************************************************************************************************************
// "Ray-Ola" Crayon
// *********************************************************************************************************************
#if (Crayons_On=1)
   object {MakeCrayon (1, -5, Green*0.95) rotate z*+90                          translate < 0.00,-12.9-0.4-2.0,  0.0> } // Green/Grass
   object {MakeCrayon (2,-60, Brown*1.20) rotate z*+90 rotate y*+30             translate <12.85,-13.5-0.2-2.0,  4.1> } // Brown/Earth
   object {MakeCrayon (3, 55, Blue *0.60) rotate z*-90 rotate x*+30             translate < 0.00,-12.9-0.4-2.0, -5.0> } // Blue/Sky
   object {MakeCrayon (4,-15, White*0.90) rotate z*+90 rotate y*-65 rotate x*-5 translate <-2.00,-12.7-0.3-2.0,-10.0> } // Gray/Rock
#end

// *********************************************************************************************************************
// Various Murals
// *********************************************************************************************************************
#if (Mural_On=1)
   // ******************************************************************************************************************
   // Warning Mural
   // ******************************************************************************************************************
   box {<0,0,0> <1,1,1> 
      #if (Mural_Image=1)
         pigment {image_map {jpeg "_Mural1.jpg" map_type 0} }
      #else
         pigment {White}
      #end 
      finish {ambient 0.6 reflection 0.15 diffuse 0.2}
      scale <1.0,1,0.01> * 5 // Maintain Proportions
      translate <-25.5-4+1,-13+4,-14.2>
      #if (Mural_Normal=1)
         normal {
            average
            normal_map {
               [1.0 agate 3.0 scale 1.0 accuracy 1e-8]
               [1.0 granite 2.0 scale 1 accuracy 1e-6]
               }
            }
      #end
      }
   // ******************************************************************************************************************
   // Chinese Emperor Mural
   // ******************************************************************************************************************
   box {<0,0,0> <1,1,1> 
      #if (Mural_Image=1)
         pigment {image_map {jpeg "_Mural2.jpg" map_type 0} }
      #else
         pigment {color (White+Red+Brown)/3}
      #end 
      finish {ambient 0.6 reflection 0.15 diffuse 0.2}
      scale <0.61,1,0.01> * 5 // Maintain Proportions
      translate <-21,-13+4,-14.2>
      #if (Mural_Normal=1)
         normal {
            average
            normal_map {
               [1.0 agate 3.0 scale 1.0 accuracy 1e-8]
               [1.0 granite 2.0 scale 1 accuracy 1e-6]
               }
            }
      #end
      }
   // ******************************************************************************************************************
   // Calligraphy Mural
   // ******************************************************************************************************************
   box {<0,0,0> <1,1,1> 
      #if (Mural_Image=1)
         pigment {image_map {jpeg "_Mural3.jpg" map_type 0} }
      #else
         pigment {White*0.7}
      #end 
      finish {ambient 0.6 reflection 0.15 diffuse 0.2}
      scale <0.39,1,0.01> * 5 // Maintain Proportions
      translate <17.8,-13+3,-14.2+0.1>
      #if (Mural_Normal=1)
         normal {
            average
            normal_map {
               [1.0 agate 3.0 scale 1.0 accuracy 1e-8]
               [1.0 granite 2.0 scale 1 accuracy 1e-6]
               }
            }
      #end
      }
   // ******************************************************************************************************************
   // Horse Mural (Cloth)
   // ******************************************************************************************************************
   box {<0,0,0> <1,1,1> 
      #if (Mural_Image=1)
         pigment {image_map {jpeg "_Mural4.jpg" map_type 0} }
      #else
         pigment {Brown*0.4}
      #end 
      finish {ambient 0.6 reflection 0.15 diffuse 0.2}
      scale <1.0,1,0.01> * 5 // Maintain Proportions
      translate <20.6,-13+3,-14.1>
      #if (Mural_Normal=1)
         normal {
            average
            normal_map {
               [1.0 agate 3.0 scale 1.0 accuracy 1e-8]
               [1.0 granite 2.0 scale 1 accuracy 1e-6]
               }
            }
      #end
      }
#end

// ************************************************************************************************************************
// HF Gate /Gate
// ************************************************************************************************************************
#if (Gate_On=1)
   #declare Gate_Object =
      union {
         height_field {
            jpeg "_gate.jpg" smooth water_level 25/255 
               translate -0.5
               rotate x*-90
            scale <3.5,5,0.25>*0.8*1.2*1.2
            #if (Wall_Image=0)
               pigment {color Brown*0.75} 
            #else
               texture {Wall_Texture scale 0.5 } 
            #end
            finish {ambient 0.4 reflection 0.02 diffuse 0.5}
            #if (Wall_Normal=1) normal {granite 2.0 scale 1/10 accuracy 1e-6} #end
            }
         height_field {
            jpeg "_fence.jpg" smooth water_level 25/255 
               translate -0.5
               rotate x*-90
            scale <3.5,5,0.25>*0.8*1.2
            #if (Wall_Image=0)
               pigment {color Brown*0.60} 
            #else
               texture {Wall_Texture scale <0.02,4.0,0.2> }
            #end
            finish {ambient 0.3 reflection 0.02 diffuse 0.5}
            #if (Wall_Normal=1) normal {granite 2.0 scale <.1,2,.1> accuracy 1e-6} #end
            }
      }
   object {Gate_Object translate <-18+5-(6*0),-13,-32+17.5> } // Left Side
   object {Gate_Object translate <-18+5-(6*1),-13,-32+17.5> } 
   object {Gate_Object translate <-18+5-(6*2),-13,-32+17.5> } 
   // object {Gate_Object translate <15+(6*0),-13,-32+17.5> } // Right Side
   // object {Gate_Object translate <15+(6*1),-13,-32+17.5> } 
   // object {Gate_Object translate <15+(6*2),-13,-32+17.5> } 
#end

// *********************************************************************************************************************
// Fog Effects
// *********************************************************************************************************************
#if (Fog_On=1)
   fog {
     fog_type 2               // 1=constant, 2=ground_fog
     distance 10*10*2
     color LightBlue
     fog_offset 0.5*10/4      // height of constant fog
     fog_alt 0.5*10/4         // at fog_offset+fog_alt: density=25%
   }
#end
