#include <iostream>
#include <cstdlib>
#include <cstdio>
#include <cmath>

//#include <qt.h>
//#include <qimage.h>

#include "Maze.h"

#define SQR(x) ((x)*(x))

const float Width = 128.0;
const float Height = 128.0;
const int HorizCells = 80;
const int VertCells = 80;
const float HeightScale = 5.0f;

const float CameraX=5.0, CameraY=8.0, CameraZ=5.0;

    const float CellWidth = Width/float(HorizCells);
    const float CellHeight = Height/float(VertCells);
    const float WallHeight = 1.0f;
    const float WallThickness = CellWidth*0.05f;
    const float HeightV = 0.1;
    
    const int HorizBricks = 5;
    const int VertBricks = 10;
    const float BrickV = 0.1;
    const float BrickFudge = 0.00;
    const float BrickWidth = CellWidth/float(HorizBricks) - BrickFudge;
    const float BrickHeight = WallHeight/float(VertBricks) - BrickFudge;
    const float NoBrickV = 0.2;

    const float BrickDistThreshold = 40.0;


class PovrayMaze : public DrawableMaze
{
public:
    PovrayMaze( int w, int h, int s=0 ) : DrawableMaze(w,h,s)
    {
    }

protected:
    void drawWallEvent( int x1, int y1, int x2, int y2 );

private:
};


PovrayMaze maze(HorizCells,VertCells);

//QImage ground;

int tga_w, tga_h;
unsigned int *heights;



void povBox( float x1, float y1, float z1, float x2, float y2, float z2 )
{
    std::cout << "box { <" << x1 << "," << y1 << "," << z1 << ">, ";
    std::cout << "<" << x2 << "," << y2 << "," << z2 << ">";
    std::cout << "}" << std::endl;
}


void PovrayMaze::drawWallEvent( int x1, int y1, int x2, int y2 )
{
    float left, right, top, bottom;
    float ofs,wallh;
    int px,py;
    unsigned int pixel;
    
    px = int( (float(x1+x2)/2.0f) * float(tga_w-1) / float(HorizCells));
    py = int( (float(y1+y2)/2.0f) * float(tga_h-1) / float(VertCells));
    pixel = heights[tga_w*(tga_h-1-py)+px];
    ofs = float(pixel)*HeightScale/65535.0;
    

    left = float(x1)*CellWidth;
    top = float(y2)*CellHeight;
    right = float(x2)*CellWidth;
    bottom = float(y1)*CellHeight;
    if (x1==x2)
	right += WallThickness;
    else
	bottom += WallThickness;
    wallh = WallHeight+HeightV*drand48();

    /*
    bool bricks = SQR((left+right)/2.0-CameraX)+SQR((top+bottom)/2.0-CameraZ)+SQR(ofs-CameraY) < SQR(BrickDistThreshold);
    */

    bool bricks = SQR((left+right)/2.0-CameraX)+SQR((top+bottom)/2.0-CameraZ) < SQR(BrickDistThreshold);


    if (bricks)
    {
	float noprob = NoBrickV;
	float brickv = 0.0;

	for (int vbrick=0; vbrick<VertBricks; vbrick++)
	{
	    float bricku = 0.0;
	    float uofs = vbrick%2 ? WallThickness/2.0f : 0.0f;

	    for (int ubrick=0; ubrick<HorizBricks; ubrick++)
	    {
		if (drand48()>noprob)
		{
		    double vary = BrickV*drand48();
		    if (x1==x2)
			povBox(left+vary,ofs+WallHeight-brickv,uofs+bottom+bricku,
			       left+vary+WallThickness,ofs+WallHeight-(brickv+BrickHeight),uofs+bottom+bricku+BrickWidth);
		    else
			povBox(uofs+left+bricku,ofs+WallHeight-brickv,bottom+vary,
			       uofs+left+bricku+BrickWidth,ofs+WallHeight-(brickv+BrickHeight),bottom+vary-WallThickness);
		}
		bricku += BrickWidth+BrickFudge;
	    }
	    brickv += BrickHeight+BrickFudge;
	    noprob /= 2.0;
	}
    }
    else
	povBox(left,ofs,top,right,ofs+wallh,bottom);
	

}


const int NDebris = 1000;
const float DebrisRadius = 100.0;

void place_debris()
{

    for (int i=0; i<NDebris; ++i)
    {
	float r = drand48()*DebrisRadius;
	float a = drand48()*M_PI/2;
	float x = r*cos(a);
	float z = r*sin(a);
	float y;
	int px,py;
	unsigned int pixel;

	px = int( x * float(tga_w-1) / Width);
	py = int( z * float(tga_h-1) / Height);
	pixel = heights[tga_w*(tga_h-1-py)+px];
	y = float(pixel)*HeightScale/65535.0;

	std::cout << "box { <" << 0 << "," << 0 << "," << 0 << ">, ";
	std::cout << "<" << BrickWidth << "," << BrickHeight << "," << WallThickness << ">" << std::endl;
	std::cout << "rotate <" << drand48()*10.0 << "," << drand48()*360.0 << ",0.0>" << std::endl;
	std::cout << "translate <" << x << "," << y << "," << z << ">" << std::endl;
	std::cout << "}" << std::endl;
    }

}


void read_tga( const char *fname )
{
    FILE *f = fopen(fname,"rb");
    fseek(f,12,0);
    fread(&tga_w,2,1,f);
    fread(&tga_h,2,1,f);
    fseek(f,2,1);
    
    heights = new unsigned int[tga_w*tga_h];
    for (int i=0; i<tga_w*tga_h; i++)
    {
	unsigned int p;
	fread(&p,4,1,f);
	heights[i] =  (((p&0x00FF0000)>>8)+((p&0x0000FF00)>>8));
    }
    fclose(f);
}


int main( int argc, char *argv[] )
{
    read_tga("output.tga");
    maze.regenerate(Maze::Disjoint);
    maze.drawMaze();
    place_debris();
}
