
#include "ColossusTex.inc"
          
          
#macro Turret(topR, botR, cornerR, H)


union{

   cone{ <0,-H, 0> botR <0,H-cornerR, 0> topR }
   cone{ <0,-H, 0> botR <0,H, 0> topR - cornerR }
   torus{ topR-cornerR, cornerR translate (H-cornerR)*y }

}                   

#end


#declare wallR     = 350;
#declare wallH     = 12.5;
#declare cornerRad = 0.5;
#declare wallW     = 16;
#declare insetH    = 3;
#declare insetW    = 7;


#declare Walls =

union{

   difference{
    
      cylinder{<0,-wallH,-wallR> <0,wallH,-wallR> wallR + wallW/2}
      
      
      union{
         cylinder{ <0,-wallH,-wallR> <0,wallH + 0.1,-wallR> wallR - wallW/2}   
         
         
         cylinder{ <0,wallH-insetH,-wallR> <0,wallH + 0.1,-wallR> wallR + insetW} //Inset   
         
         
         cylinder{ <0,wallH - cornerRad,-wallR> <0,wallH + 100,-wallR> wallR + cornerRad + insetW}  //top edge
         cylinder{ <0,wallH - cornerRad - insetH ,-wallR> <0,wallH + 100,-wallR> wallR - wallW/2 + cornerRad} //lower edge
      }


   }
   
   torus{ wallR + insetW + cornerRad, cornerRad translate < 0, wallH - cornerRad, -wallR > }     //top edge
   torus{ wallR - wallW/2 + cornerRad, cornerRad translate < 0, wallH - cornerRad - insetH, -wallR > }     //lower edge
} 

#declare SeaWalls =
union{
   
   object{ Turret(10,10.5,1,15.2) translate <-68, 0, 5> }
   object{ Turret(10,10.5,1,15.2) translate <  2, 0, 0> } 
   
   difference{
      object{Walls rotate 7*y translate < 0, 0, 4> }
      box{<-65,-100,-100><2,100,100>}      
      box{<-1000,-1000,-1000><1000,1000,-wallR>}
   }
   
   rotate 35*y       
   
   translate<1,0,2>
                                                             
   texture{StoneTex}                                                          
   
} 

    