//twoup.pov          18 June 2004      for   "Epic proportions"  IRTC May/June
                      
// "ELEVATOR"

#include "colors.inc" 
#include "woods.inc"
#include "metals.inc" 
#global_settings { max_trace_level 15 }   

camera { 
         location < 0, 0, -4000 >                  
         look_at < 0, 1500, 0 > 
         angle 15  
       } 
    
        
background { color rgb < 0.4, 0.4, 0.5 > }  
                                                   
 light_source { < 1000, 15000, 15000 > color White }                             // Sunlight 
 light_source { < 0, -1500, -3000 > color rgb < 0.18, 0.18, 0.28 > shadowless }  // Earthlight 
 light_source {                                                                  // pseudo sunlight
                 < 150, 3500, -2000 > color White
                         spotlight 
                         point_at < -30, 400, -3000 >
                         falloff 10
                         radius 9
                         tightness 0
               }
light_source { < 2, 383, -3033 > color Yellow }                               // lights in rooms
light_source { < -15, 384, -3032 > color Yellow }  
light_source { < -47, 400, -3029 > color Yellow } 
             
                  
     
                        
// EARTH  *********************************************************************************

#declare Earth =
                union {
                        sphere { < 0, -1010, 0 >,2250
                                        pigment { 
                                                  bozo
                                                  color_map {
                                                              [ 0 color rgb < 0.5, 0.5, 0.85 > ]
                                                              [ 0.25 color rgb < 0.5, 0.5, 1 > ]
                                                              [ 0.25 color rgb < 0.6, 0.8, 0.785 > ]
                                                              [ 0.3 color rgb < 0.47, 0.6, 0.583 > ]
                                                              [ 0.43 color rgb < 0.47, 0.6, 0.784 > ]
                                                              [ 0.5 color rgb < 0.87, 0.7, 0.583 > ]
                                                              [ 0.55 color rgb < 0.5, 0.5, 0.8 > ]
                                                              [ 1 color rgb < 0.5, 0.5, 1 > ]
                                                            }
                                                      scale 2000
                                                      turbulence 0.6 omega 0.4 lambda 6
                                                 }            
                                          finish { ambient 0.3 phong 0.5 phong_size 20 }
                               }                        
                  sphere { < 0, -1010, 0 >,2251
                                  pigment {
                                             bozo
                                             color_map {
                                                         [ 0 color Clear ]
                                                         [ 0.475 color rgb < 0.95, 0.95, 1 > ]
                                                         [ 0.5 color rgb < 0.95, 0.95, 1 > ]
                                                         [ 0.55 color Clear ]
                                                         [ 1 color Clear ]
                                                       }
                                               scale  300
                                               turbulence 0.8 omega 0.8 lambda 3.5
                                          }
                                  finish { ambient 0.8 }
                          } 
                     }     

// SKY ***************************************************************************

#declare Sky =
               sphere { < 0, 1800, 0 >,20000
                                pigment {
                                          gradient z
                                          color_map {
                                                      [ 0 color rgb < 0.85, 0.85, 1 > ]
                                                      [ 0.5 color rgb < 0.75, 0.75, 1 > ]                                                                                            
                                                      [ 0.98 color Black ]
                                                      [ 1 color rgb < 0.75, 0.75, 1 > ]  
                                                     
                                                      
                                                    }
                                             scale 15000
                                             
                                        }
                                finish { ambient 0.8 }
                      }                     
#declare Moon =
                sphere { < 0, 0, 0 >,75
                                  translate < 1500, 8000, 14000 >
                                  pigment { 
                                           bozo
                                           color_map {
                                                      [ 0 color Gray95 ]
                                                      [ 0.5 color Gray95 ]
                                                      [ 0.7 color Gray80 ]
                                                      [ 0.9 color Gray85 ]
                                                      [ 1 color Gray95 ]
                                                     }
                                              scale 30
                                          }            
                                  finish { ambient 0.2 diffuse 0.8 }
                       }                                                               

#declare Star =
                 sphere { < 0, 0, 0 >,0.5
                            pigment { color White }
                            finish { ambient 1 }
                        }
#declare Number_of_Cycles = 40 ;
#declare Count_per_Cycle = 60 ;

#declare Starting_Angle = 0 ; 
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;
#declare SD2 = seed(2) ;

#declare Stars =
                union {
                       #while ( Count >= 0 )
                       object { Star
                                scale 0.5*rand(SD1) 
                                translate < 200*rand(SD2), 120*rand(SD1), 0 >
                                rotate < 0, 0, Starting_Angle*rand(SD2) >
                               }
                       #declare Starting_Angle = Starting_Angle + Angle ;
                       #declare Count = Count - 1 ;
                       #end
                       } 
                       
#declare Starset =
                   difference {
                                object { Stars scale 10 }
                                cylinder { < 0, -3330, -1000 >,<  0, -3330, 1000 >,3300 
                                                   scale < 2, 1, 1 > 
                                                   pigment { color Clear }
                                                   finish { ambient 0
                                                            diffuse 0 
                                                          }
                                          }
                              }  
                                                                                                                                               
// PASSENGERS ************************************************************************

#declare Carpet =
                  box { < -8, -2, 0 >,< 8, 0, 26 >
                             clipped_by {
                                          cylinder { < 0, -3, 20.05 >,< 0, 1, 20.05 >,20 }
                                        }  
                             pigment { checker
                                       color rgb < 0.8, 0.6, 0.8 >
                                       color rgb < 0.8, 0.7, 0.9 >
                                     }
                             finish { ambient 0.4 }
                      }
#declare Woman =
                union {
                        sphere { < 0, 0, 0 >,0.6                            // face
                                   scale < 0.6, 1, 0.8 > 
                                   translate y*7.7
                                   pigment { color rgb < 1, 0.8, 0.8 > }
                                   finish { ambient 0.4 }
                              }
                        difference {                                         // hair   
                                    sphere { < 0, 0, 0 >,0.7
                                              scale < 0.8, 1, 0.8 >
                                           }
                                    box { < -0.9, 0.1, 0 >,< 0.9, -0.9, -0.9 > }
                                            pigment { color rgb < 0.7, 0.6, 0.5 > }
                                            finish { ambient 0.2 }                                            
                                            translate y*7.7
                                     } 
                        cylinder { < 0, 7.25, 0 >,< 0, 7, 0 >,0.2                 // neck
                                         pigment { color rgb < 1, 0.8, 0.8 > }
                                         finish { ambient 0.4 }
                                 }
                        cylinder { < -1.5, 4.7, -1.5 >,< -1.15, 4.7, -1.5 >,0.12  // r hand
                                         pigment { color rgb < 1, 0.8, 0.8 > }
                                         finish { ambient 0.4 }
                                 }         
                         cylinder { < 1.5, 4.7, -1.5 >,< 1.15, 4.7, -1.5 >,0.12  // l hand
                                         pigment { color rgb < 1, 0.8, 0.8 > }
                                         finish { ambient 0.4 }
                                 }                  
                        superellipsoid { < 0.3, 0.3 >                          // chest
                                             scale < 1, 1, 0.3 >
                                             translate y*6
                                       } 
                        sphere { < -0.27, 6.2, -0.7 >,0.35 scale < 1, 1, 0.34 > }     
                        sphere { < 0.27, 6.2, -0.7 >,0.35 scale < 1, 1, 0.34 > }                  
                        cylinder { < 0, 5, 0 >,< 0, 6, 0 >,0.7                 // waist
                                            scale < 1, 1, 0.5 >
                                 }
                        cone { < 0, 5, 0 >,0.7,< 0.2, 3.5, 0 >,1.1                 // skirt
                                            scale < 1, 1, 0.5 >
                             }
                        cone { < -0.18, 4, 0 >,0.45,< -0.2, 0, 0 >,0.18 }            // r leg
                        cone { < 0.58, 4, 0 >,0.45,< 1.4, 0, 0 >,0.18 }              // l leg
                        
                        cone { < -0.2, 0.1, 0 >,0.18,< -0.22, 0, -0.7 >,0.09 }          // r foot
                        cone { < 1.4, 0.1, 0 >,0.18,< 1.7, 0, -0.6 >,0.09 }          // l foot
                        
                        cone { < -0.8, 6.8, 0 >,0.2,< -0.9, 5.5, -0.6 >,0.15 }            // r upperarm
                        cone { < -0.9, 5.5, -0.6 >,0.15,< -1.2, 4.7, -1.5 >,0.1 }            // r forearm
                        
                        cone { < 0.8, 6.8, 0 >,0.2,< 0.9, 5.5, -0.6 >,0.15 }              // l arm
                        cone { < 0.9, 5.5, -0.6 >,0.15,< 1.2, 4.7, -1.5 >,0.1 }              // l arm
                                             pigment { color Orange }
                                             finish { ambient 0.4 }
                     }
#declare ManA =
                union {
                        sphere { < 0, 0, 0 >,0.7                            // face
                                   scale < 0.6, 1, 0.8 > 
                                   translate y*8.7
                                   pigment { color rgb < 1, 0.8, 0.8 > }
                                   finish { ambient 0.4 }
                              }
                        difference {                                         // hair   
                                    sphere { < 0, 0, 0 >,0.75
                                              scale < 0.8, 1, 0.8 >
                                           }
                                    box { < -0.9, 0.1, 0.9 >,< 0.9, -0.9, -0.9 > }
                                            pigment { color rgb < 0.7, 0.4, 0.4 > }
                                            finish { ambient 0.2 }                                            
                                            translate y*8.7
                                     } 
                        cone { < 0, 8.25, 0 >,0.3,< 0, 7, 0 >,0.4                 // neck
                                         pigment { color rgb < 1, 0.8, 0.8 > }
                                         finish { ambient 0.4 }
                                 }
                        sphere { < 0, 0, 0 >,0.25 scale < 1.5, 1, 0.5 >            // left hand
                                                  translate < -0.25, 6.5, -0.5 >
                                                  pigment { color rgb < 1, 0.8, 0.8 > }
                                                  finish { ambient 0.4 }
                                 }         
                        sphere { < 0, 0, 0 >,1 scale < 1.25, 0.8, 0.5 >         // shoulders
                                               translate y*7.25
                               }                         
                        
                        superellipsoid { < 0.3, 0.3 >                          // chest
                                             scale < 0.8, 1.1, 0.4 >
                                             translate y*6.5
                                       } 
                                      
                        cylinder { < 0, 5.5, 0 >,< 0, 6.5, 0 >,0.7                 // waist
                                            scale < 1, 1, 0.5 >
                                 }
                        cone { < 0, 6, 0 >,0.7,< 0, 4.5, 0 >,1                 // skirt
                                            scale < 1, 1, 0.5 >
                             }
                        cone { < -0.35, 4.8, 0 >,0.5,< -1.2, 0, 0 >,0.22 }            // r leg
                        cone { < 0.35, 4.8, 0 >,0.5,< 0.8, 0, 0 >,0.22 }              // l leg
                        
                        cone { < -1.2, 0.1, 0.25 >,0.3,< -1.8, 0, -0.7 >,0.2 }          // r foot
                        cone { < 0.8, 0.1, 0.25 >,0.3,< 0.9, 0, -0.7 >,0.2 }          // l foot
                        
                        cone { < -0.9, 7.4, 0 >,0.35,< -1.6, 5.85, 0 >,0.3 }            // r upperarm
                        sphere { < -1.6, 5.85, 0 >,0.3 }
                        cone { < -1.6, 5.9, 0 >,0.3,< -0.8, 4.7, 0 >,0.2 }            // r forearm
                        
                        cone { < 0.9, 7.4, 0 >,0.35,< 1.4, 5.75, 0 >,0.3 }              // l upper arm
                        sphere { < 1.4, 5.75, 0 >,0.3 }
                        cone { < 1.4, 5.75, 0 >,0.3,< 0, 6.5, -0.5 >,0.2 }              // l forearm
                                             pigment { color rgb < 0.5, 0.6, 0.7 > }
                                             finish { ambient 0.4 }
                     } 
#declare ManB =
                union {
                        sphere { < 0, 0, 0 >,0.7                            // face
                                   scale < 0.6, 1, 0.8 > 
                                   translate y*8.7
                                   pigment { color rgb < 1, 0.8, 0.8 > }
                                   finish { ambient 0.4 }
                              }
                        difference {                                         // hair   
                                    sphere { < 0, 0, 0 >,0.75
                                              scale < 0.8, 1, 0.8 >
                                           }
                                    box { < -0.9, 0.1, 0.9 >,< 0.9, -0.9, -0.9 > }
                                            pigment { color rgb < 0.7, 0.4, 0.4 > }
                                            finish { ambient 0.2 }                                            
                                            translate y*8.7
                                     } 
                        cone { < 0, 8.25, 0 >,0.3,< 0, 7, 0 >,0.4                 // neck
                                         pigment { color rgb < 1, 0.8, 0.8 > }
                                         finish { ambient 0.4 }
                                 }
                        sphere { < 0, 0, 0 >,0.25 scale < 1.5, 1, 0.5 >            // left hand
                                                  translate < -0.65, 6, -0.5 >
                                                  pigment { color rgb < 1, 0.8, 0.8 > }
                                                  finish { ambient 0.4 }
                                 }         
                        sphere { < 0, 0, 0 >,1 scale < 1.25, 0.8, 0.5 >         // shoulders
                                               translate y*7.25
                                               pigment { color Yellow }
                               }                         
                        
                        superellipsoid { < 0.3, 0.3 >                          // chest
                                             scale < 0.8, 1.1, 0.4 >
                                             translate y*6.5
                                       } 
                                      
                        cylinder { < 0, 5.5, 0 >,< 0, 6.5, 0 >,0.7                 // waist
                                            scale < 1, 1, 0.5 >
                                 }
                        cone { < 0, 6, 0 >,0.7,< 0, 4.5, 0 >,1                 // skirt
                                            scale < 1, 1, 0.5 >
                             }
                        cone { < -0.35, 4.8, 0 >,0.5,< -0.7, 0, 0 >,0.22 }            // r leg
                        cone { < 0.35, 4.8, 0 >,0.5,< 0.8, 0, 0 >,0.22 }              // l leg
                        
                        cone { < -0.7, 0.1, 0.25 >,0.3,< -0.7, 0, -0.7 >,0.2 }          // r foot
                        cone { < 0.8, 0.1, 0.25 >,0.3,< 0.9, 0, -0.7 >,0.2 }          // l foot
                        
                        cone { < -0.9, 7.4, 0 >,0.35,< -0.8, 5.85, -0.6 >,0.3 }            // r upperarm
                        sphere { < -0.8, 5.85, -0.6 >,0.3 }
                        cone { < -0.8, 5.9, -0.6 >,0.3,< -0.2, 5.7, -0.6 >,0.2 }            // r forearm
                        
                        cone { < 0.9, 7.4, 0 >,0.35,< 0.8, 5.75, -0.4 >,0.3 }              // l upper arm
                        sphere { < 0.8, 5.75, -0.4 >,0.3 }
                        cone { < 0.8, 5.75, -0.4 >,0.3,< -0.6, 6, -0.5 >,0.2 }              // l forearm
                                             pigment { color White }
                                             finish { ambient 0.4 }
                     } 
                                            
#declare Seat =
                 union {
                         cylinder { < -1.25, 0, 0 >,< 1.25, 0, 0 >,1.1
                                           scale < 1, 0.5, 1 >
                                           translate y*1 
                                  }                             
                         cylinder { < -1.25, 0, 0 >,< 1.25, 0, 0 >,1.1
                                           scale < 1, 1, 0.5 >
                                           rotate x*20
                                           translate < 0, 2, 1 > 
                                  }
                                          pigment { color Red }
                                          finish { ambient 0.3 }
                        }
#declare Seats =
                 union {
                         object { Seat translate < -5.25, 0, 10 > }  
                         object { Seat translate < -1.75, 0, 10 > } 
                         object { Seat translate < 1.75, 0, 10 > } 
                         object { Seat translate < 5.25, 0, 10 > } 
                       }                                                                                 
#declare Pass =
                  union { 
                         object { Carpet }
                         object { Woman translate z*1.75 }
                         object { ManA translate < -4, 0, 4 > }                        
                         object { Seats translate z*-3}                         
                         rotate y*180
                         rotate x*-90
                         translate y*20
                         rotate z*200
                         translate z*-84.25   
                        }
#declare Pass2 =
                  union { 
                         object { Carpet }                        
                         object { ManB translate < 3, 0, 3 > }
                         object { Seats translate z*-4 }                         
                         rotate y*180
                         rotate x*-90
                         translate y*20
                         rotate z*300
                         translate z*-84.25   
                        }                      
 


                                                                                              
// ELEVATOR  *************************************************************************

                                            
#declare Ribbon =
                  box { < -0.5, -5, 0 >,< 0.5, 5, -5000 >
                                 rotate z*-30
                                 rotate < 25, 0, 1 >
                                 translate y*-1010
                                 pigment { 
                                           gradient z
                                           color_map {
                                                       [ 0 color Red ]
                                                       [ 0.25 color Red ]
                                                       [ 0.25 color Gray50 ]
                                                       [ 0.5 color Gray50 ]
                                                       [ 0.5 color White ]
                                                       [ 1.0 color White ]
                                                      }
                                               scale 3
                                           }            
                                 finish { ambient 0.3 }
                      }
#declare Rib =
               union {
                       cylinder { < 0, 20, 0 >,< 0, 20, -25 >,1 }
                       sphere { < 0, 20, 0 >,1 }
                       sphere { < 0, 20, -25 >,1 }
                                          pigment { color White }
                                          finish { ambient 0.23 phong 1 } 
                     } 
#declare Ribs =
                union {
                        object { Rib }
                        object { Rib rotate z*10 }   
                        object { Rib rotate z*20 }  
                        object { Rib rotate z*30 }  
                        object { Rib rotate z*40 }  
                        object { Rib rotate z*50 }  
                        object { Rib rotate z*60 }  
                        object { Rib rotate z*70 }  
                        object { Rib rotate z*80 }
                        object { Rib rotate z*90 }  
                        object { Rib rotate z*100 }   
                        object { Rib rotate z*110 }  
                        object { Rib rotate z*120 }  
                        object { Rib rotate z*130 }  
                        object { Rib rotate z*140 }  
                        object { Rib rotate z*150 }  
                        object { Rib rotate z*160 }  
                        object { Rib rotate z*170 }
                        object { Rib rotate z*180 }
                         object { Rib rotate z*-10 }   
                        object { Rib rotate z*-20 }  
                        object { Rib rotate z*-30 }  
                        object { Rib rotate z*-40 }  
                        object { Rib rotate z*-50 }  
                        object { Rib rotate z*-60 }  
                        object { Rib rotate z*-70 }  
                        object { Rib rotate z*-80 }
                        object { Rib rotate z*-90 }  
                        object { Rib rotate z*-100 }   
                        object { Rib rotate z*-110 }  
                        object { Rib rotate z*-120 }  
                        object { Rib rotate z*-130 }  
                        object { Rib rotate z*-140 }  
                        object { Rib rotate z*-150 }  
                        object { Rib rotate z*-160 }  
                        object { Rib rotate z*-170 }  
                        
                       }
#declare Well =
                box { < -5, 0, -30 >,< 5, 25, -50 >
                               pigment { color Gray80 }
                               finish { ambient 0.23 }
                    }
#declare Room =               
                 superellipsoid { < 0.2, 0.2 >
                                    scale < 8, 12, 6 >
                                    translate y*20
                                    pigment { color rgb < 1, 0.8, 0.5 > }
                                    finish { ambient 0.65 }
                                 }
                   
                                          
#declare Rooms =
                  union {
                          object { Room rotate z*100 }                          
                          object { Room rotate z*200 }
                          object { Room rotate z*300 } 
                         }                         
#declare Adoor =
                cylinder { < 0, 0, 0 >,< 0, 0, -100 >,20 
                                clipped_by {
                                            box { < -5, 0, -30 >,< 0, 25, -50 > }
                                           }
                                translate < 5, -19.2, 0 >
                                rotate z*130
                                translate < -4.9, 19.2, 0 >
                                pigment { 
                                                gradient z
                                                color_map {
                                                            [ 0 color White ]
                                                            [ 0.95 color White ]
                                                            [ 0.95 color Gray90 ]
                                                            [ 1 color Gray90 ]
                                                           }
                                                   scale 3
                                                 }            
                                finish { ambient 0.23 phong 1 }
                         }                   
#declare Bdoor =
                cylinder { < 0, 0, 0 >,< 0, 0, -100 >,20 
                                clipped_by {
                                            box { < 0, 0, -30 >,< 5, 25, -50 > }
                                           }
                                translate < -5, -19.2, 0 >
                                rotate z*-130
                                translate < 4.9, 19.2, 0 >
                                pigment { 
                                                gradient z
                                                color_map {
                                                            [ 0 color White ]
                                                            [ 0.95 color White ]
                                                            [ 0.95 color Gray90 ]
                                                            [ 1 color Gray90 ]
                                                           }
                                                   scale 3
                                                 }            
                                finish { ambient 0.23 phong 1 }
                         }                                            
#declare Dish =
               union {
                       cylinder { < 0, -5, -5 >,< 0, 0, -8 >,0.2 pigment { color Gray60 } }
                       cylinder { < 0, 0, -7.5 >,< 0, 0, -8.5 >,0.2 pigment { color Gray60 } }
                       cylinder { < 0.5, 0, -1 >,< 0.5, -4, 0 >,0.4 }
                       cylinder { < 0.5, -4, 0 >,< 0.5, -8, -2 >,0.4 }  
                       cylinder { < -0.5, 0, -1 >,< -0.5, -4, 0 >,0.4 }
                       cylinder { < -0.5, -4, 0 >,< -0.5, -8, -2 >,0.4 }  
                       cylinder { < 0, 0, 0 >,< 0, 0, -2 >,0.5 }
                       sphere { < 0, 0, 0 >,5 scale < 1, 1, 0.5 >
                                        clipped_by {
                                                    box { < -5, -5, 1 >,< 5, 5, 3 > }
                                                   }
                                        translate z*-5 
                              }            
                           pigment { color rgb < 1, 0.97, 0.8 > }
                           finish { ambient 0.23 }
                        }
#declare Antenna =
                    union {
                           object { Dish translate z*-2 }
                           object { Dish rotate y*180 translate z*2 }
                           cylinder { < -0.6, 0, -2 >,< 0.6, 0, -2 >,0.4 }
                           cylinder { < -0.6, 0, 2 >,< 0.6, 0, 2 >,0.4 }                          
                           translate < 0, 25, -40 >
                           pigment { color White }
                           finish { ambient 0.23 }
                        }
#declare Joint =
                union {
                        sphere { < 0, 0, 0 >,3.5  scale < 1, 0.2, 1 > 
                                                translate y*0.5
                                                pigment { color White }
                                                finish { ambient 0.23 } 
                               } 
                        cylinder { < 0, 0, 0 >,< 0, 0.5, 0 >,3.6 
                                                pigment { color Black }
                                                finish { ambient 0.23 } 
                               } 
                        }                                                               
#declare Shoe =
                union {
                        difference {
                                     superellipsoid { < 0.5, 0.5 >
                                                       scale < 5, 7, 20 >
                                                       pigment { color White }
                                                       finish { ambient 0.23 phong 1 } 
                                                      } 
                                      box { < -0.5, -8, -25 >,< 0.5, 8, 25 >
                                                         pigment { color Gray30 }
                                                         finish { ambient 0.3 }
                                          }
                                   } 
                          cylinder { < 0, 0, -15 >,< 20, 0, 0 >,4 scale < 1, 0.5, 1 > }   
                          cylinder { < 0, 0, -15 >,< -20, 0, 0 >,4 scale < 1, 0.5, 1 > }              
                          object { Joint   translate < 0, 7, 10 > }
                          object { Joint   translate < 0, 7, -10 > } 
                          object { Joint rotate x*180  translate < 0, -7, 10 > }
                          object { Joint rotate x*180  translate < 0, -7, -10 > }                         
                         
                                    pigment { color White }
                                    finish { ambient 0.23 } 
                        }                                                                              
#declare Window =
                 cylinder { < 0, 0, -81.6 >,< 0, 0, -98.4 >,19.9 
                                     pigment { color rgbt < 1, 0.8, 1, 0.5 > }
                                     finish { ambient 0
                                              diffuse 0
                                              reflection 0.25
                                            }
                          } 
#declare Cargo =
                superellipsoid { < 0.4, 0.4 >
                                 scale < 10, 4, 20 >
                                 translate y*20 
                                 pigment { color Gray85 }
                                 finish { ambient 0.23 }
                               }
#declare Godoor =
                 union { 
                         cylinder { < 0, 0, 100 >,< 0, 0, -100 >,20 
                                       clipped_by {
                                                    superellipsoid { < 0.4, 0.4 >
                                                                     scale < 9.7, 3.8, 19.7 >
                                                                     translate y*20
                                                                   }
                                                  }                    
                                       pigment { 
                                                gradient z
                                                color_map {
                                                            [ 0 color White ]
                                                            [ 0.95 color White ]
                                                            [ 0.95 color Gray90 ]
                                                            [ 1 color Gray90 ]
                                                           }
                                                   scale 8
                                                 }            
                                         finish { ambient 0.23 phong 1 }
                                   }
                         box { < -1.5, 19.9, -10 >,< 1.5, 20.1, 10 >
                                           rotate z*-22
                                           pigment { checker color Yellow color Black  scale 1.5 }
                                           finish { ambient 0.3 } 
                             }
                      }                     
                                   
#declare Eye =    
              sphere { < 0, 0, 0 >,2
                           scale < 1, 1, 2 >
                           translate y*15
                           pigment {
                                      gradient z
                                      color_map {
                                                  [ 0 color rgbt < 1, 1, 0.5, 0.6 > ]
                                                  [ 0.3 color Clear ]
                                                  [ 0.3 color White ]
                                                  [ 1.0 color White ]
                                                 }
                                           scale 8
                                           translate z*-5
                                    }
                            finish { ambient 0.23 phong 1 phong_size 60 }
                     }                                                                                                                                                                                                                                                                                                                                                                                                                                        
#declare PodA =
              union {
                     difference {
                                  union {
                                         cylinder { < 0, 0, 0 >,< 0, 0, -100 >,20 }                               
                                         cylinder { < 0, 0, -81.6 >,< 0, 0, -98.4 >,20.1
                                                      pigment { color rgb < 0.4, 0.4, 1 > } 
                                                      finish { ambient 0.23 }
                                                  }                                           
                                        
                                         sphere { < 0, 0, 0 >,20 scale < 1, 1, 1.5 > translate z*-100 }
                                         sphere { < 0, 0, 0 >,20 scale < 1, 1, 1.5 > }
                                        } 
                                  union {
                                          object { Well }
                                          object { Rooms translate z*-90 }
                                          object { Cargo rotate z*200 translate z*-55 }                                          
                                        } 
                                } 
                     torus { 19.6, 0.15  rotate x*90
                               translate z*-88.3
                               pigment { color rgb < 1, 0.3, 0.3 > } 
                               finish { ambient 0.4 }
                            }                   
                     object { Ribs }
                     
                    
                     object { Window }
                     object { Godoor rotate z*200 translate z*-55 }
                     object { Eye rotate z*140 translate z*-119 }
                     object { Eye rotate z*-40 translate z*-119 }
                     object { Eye rotate z*8 translate z*-119 }
                     object { Pass }
                     
                          pigment { 
                                    gradient z
                                    color_map {
                                               [ 0 color White ]
                                               [ 0.95 color White ]
                                               [ 0.95 color Gray90 ]
                                               [ 1 color Gray90 ]
                                              }
                                       scale 8
                                   }            
                          finish { ambient 0.23 phong 1 }
                    }      
#declare PodB =
              union {
                     difference {
                                  union {
                                         cylinder { < 0, 0, 0 >,< 0, 0, -100 >,20 }                               
                                         cylinder { < 0, 0, -81.6 >,< 0, 0, -98.4 >,20.1
                                                      pigment { color rgb < 0.4, 0.4, 1 > }
                                                      finish { ambient 0.23 }
                                                  }   
                                        
                                         sphere { < 0, 0, 0 >,20 scale < 1, 1, 1.5 > translate z*-100 }
                                         sphere { < 0, 0, 0 >,20 scale < 1, 1, 1.5 > }
                                        } 
                                  union {
                                          object { Well }
                                          object { Rooms translate z*-90 }
                                          object { Cargo rotate z*290 translate z*-55 }                                          
                                        } 
                                } 
                     torus { 19.6, 0.15  rotate x*90
                               translate z*-88.3
                               pigment { color rgb < 1, 0.3, 0.3 > } 
                               finish { ambient 0.4 }
                            }                   
                     object { Ribs }
                     object { Adoor }
                     object { Bdoor }
                     object { Antenna }
                     object { Window }
                     object { Godoor rotate z*290 translate z*-55 }
                     object { Eye rotate z*140 translate z*-119 }
                     object { Eye rotate z*-40 translate z*-119 }
                     object { Eye rotate z*8 translate z*-119 }
                     object { Pass }
                     object { Pass2 }
                          pigment { 
                                    gradient z
                                    color_map {
                                               [ 0 color White ]
                                               [ 0.95 color White ]
                                               [ 0.95 color Gray90 ]
                                               [ 1 color Gray90 ]
                                              }
                                       scale 8
                                   }            
                          finish { ambient 0.23 phong 1 }
                    } 
#declare Hatch =
                 superellipsoid { < 0.8, 0.8 >
                                      scale < 4.1, 2, 4.1 >
                                      pigment { color Red }
                                      finish { ambient 0.23 }
                                }
#declare Hat =
               cylinder { < -24, 0, 0 >,< 24, 0, 0 >,3
                                 scale < 1, 1, 2.5 >
                                 clipped_by {
                                               superellipsoid { < 0.8, 0.8 > 
                                                                scale < 3.6, 2, 3.6 > 
                                                                translate y*-2.5
                                                              }
                                            }
                                 translate < 1, -10, -70 >            
                                 pigment { checker color Yellow color Black  scale 1.5 }
                                 finish { ambient 0.23 } 
                         }                                                                            
#declare Joiner =
                 union {
                  difference {
                               cylinder { < -24, 0, 0 >,< 24, 0, 0 >,3
                                               scale < 1, 1, 2.5 >
                                        }
                               object { Hatch translate y*-2.5 }                
                                             translate < 1, -10, -70 >
                                              pigment { 
                                                        gradient x
                                                        color_map {
                                                                   [ 0 color White ]
                                                                   [ 0.95 color White ]
                                                                   [ 0.95 color Gray90 ]
                                                                   [ 1 color Gray90 ]
                                                                  }
                                                          scale 3
                                                      }            
                                             finish { ambient 0.23 }
                             }
                  object { Hat }
                        }                                                              
#declare Lift =
               union {
                       object { PodA translate x*-24 }
                       object { PodB rotate z*-60 translate x*24 } 
                       object { Joiner }                        
                       object { Shoe }
                       object { Shoe translate z*-120 }                    
                                           rotate z*-30 
                                           translate < 0, 0, -3250 >
                                           rotate < 25, 0, 1 >
                                           translate y*-1010
                     } 
                     
// SCENE  *******************************************************************
                                                                                                                       
object { Earth }
object { Starset translate < 0, 4000, 7000 > }
object { Sky rotate x*23 }
object { Moon }                        
object { Ribbon  }
object { Lift } 
                                                   