#include "header.inc"
camera { 
        location <0,1,-5>
        look_at <0,0,0>
}   
light_source {<0, 1, -5> color rgb 0.3}
#declare Rad = 50000;
#declare fn_RMF = function{ f_ridged_mf(x, y, z, 0.1, 3.1, 8 ,0.7, 0.8, 2) }

////////////////////
////////Sun/////////
////////////////////
light_source {<-20, 30, 30>*30 color White*1.5 }
sphere { 0*x, 5 pigment { White } translate <-15, 6, 30>*30 finish { ambient 1.0 } }

#declare sky_vect = z;
#declare cam_loc = <0,1,-5>;
#declare lookat = <0,0,0>;


#declare light_loc = <-15,6,30>*30;
#include "35mm.flr"
#include "nkflare.inc"              

////////////////////
///////Ground///////
////////////////////
isosurface {     
	function {y - f_snoise3d(x/7, 0, z/2)*0.5}
	threshold 0
	max_gradient 1.1
	contained_by {box {<-100,-3,-100>, < 100, 1, 100>}}

	texture {
		pigment {color LightWood}
		normal {granite bump_size 0.1 scale 0.01}
		finish {
			brilliance 1.6
			specular 0.3
		}		
	}
	
	texture {
		pigment {color LightWood}
		normal {granite 0.2 scale 0.02}
		finish {
			brilliance 1.6
			specular 0.3
		}
	}
}       
/////////////////
///////Sky///////
/////////////////
sphere { 
   <0, 0, 0>, 1
   texture {
      pigment {
         gradient z
         pigment_map {
            [0.00 color rgb <0.6667, 0.7255, 0.7725>]
            [0.19
               spherical
               color_map {
                  [0.08 color rgb <0.33, 0.37, 0.90> ]
                  [0.14 color rgb <0.3210, 0.53, 0.9259> ]
                  [0.26 color rgb <0.3610, 0.57, 0.9259> ]
                  [0.50 color rgb < 0.880, 0.935, 0.976 > ]
               }
               scale 1.8
               translate <-0.7, 0.7, 0.24>
            ]
         }
      }
      finish {
         diffuse 0
         ambient 1
      }
   }
   scale Rad*<20, 20, 4>
   translate -2*z
   no_shadow
   hollow on
}