// testing.pov
// POV-Ray 3.5 scene file by Ewan Grant
// Copyright POV-Team, 1995
#include "colors.inc"
#include "textures.inc"


//Main camera
//  camera { location <-50, 600, -50> look_at < 0, 0, 0> angle 90 }   
  camera { location < -160.2, 95.6, -159.1> 
           look_at < 0, -0.1, 0> 
           angle 90 
         }

// An area light (creates soft shadows)
light_source {  0*x                 
                color rgb 0.9    
                area_light
               <20, 0, 0> <0, 0, 20> // lights spread out across this distance (x * z)
                5, 5                // total number of lights in grid (4x*4z = 16 lights)
                adaptive 1          // 0,1,2,3...
                jitter              // adds random softening of light
                circular            // make the shape of the light circular
                orient              // orient light
                translate < 1200, 900, -160>   // <x y z> position of light
                media_interaction off
             }   


//The Sky
//--------------

sky_sphere {          
    pigment { gradient y
        color_map { [0, 1  color red 0.55 green 0.64 blue 0.65
                           color red 0.0 green 0.0 blue 0.47 ]  } 
        rotate -16*z
        rotate  10*x
            }
          }

//Clouds
//----------------------------
        
plane { y, 28000
        texture {
               pigment { bozo
               color_map {  [0.29 color rgbf < 1.0, 1.00, 1.00, 1.00 > ]
                            [0.50 color rgbf <0.90, 0.90, 0.90, 0.95 > ]
                            [0.99 color rgb < 1.0, 1.00, 1.00 > ]
                  }
                  scale 12000
                  turbulence 0.8
                }   
           finish { ambient 0.8 }
               }
        rotate <30, 15, -25>
        translate < 5000, 0, -10000 >
        hollow
      }
      
      
//North Star
//----------------------------
      
sphere {  <0, 0, 0> 80
     texture {
           pigment { color White*2  }
                finish { ambient 1 }
              } 
     translate <  48000, 6000, 40000 >
       }


 
#declare Rock =

texture {
   pigment { 
     image_map { tga "P5160235.tga" 
                 map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                 interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
               }
          rotate 90*x
          rotate -65*y
            }
        }
             
#declare Rock2 =

texture {
   pigment { 
     image_map { tga "Rock01.tga" 
                 map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                 interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
               }
          rotate 90*x
          rotate -65*y
            }
        }
          
#declare Sand =

texture {
   pigment { 
     image_map { tga "sand04.tga" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                 map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                 interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
               }
          rotate 90*x 
          rotate 60*y
           }
         } 


#declare Ground1 =
 
height_field { tga "erosion16.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <330, 120, 300>
             } 

#declare Desert =
 
height_field { tga "hair2.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <600, 50, 600>
               rotate -160*y
             } 
             
#declare DesertDune =
 
height_field { tga "artery3.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <900, 80, 330>
             }
             
#declare Ground3 =
 
height_field { tga "erosion15.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <900, 220, 900>
             }
             
#declare Boulder =
 
height_field { tga "erosion15.tga"
               smooth
               water_level 0.3 
               translate <-0.5, -0.5, -0.5>
               scale < 80, 16, 80>
             }  
             
#declare Caveroof =
 
height_field { tga "cave02.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <300, 90, 300>
             } 

#declare Cavefloor =
 
height_field { tga "cave-floor.tga"
               smooth 
               translate <-0.5, -0.5, -0.5>
               scale <200, 50, 200>
               rotate -90*y
             }
             
object { Ground1 
         texture { Rock scale 50}
         finish { diffuse 0.7 ambient 0.4  }
         rotate 6*x
         translate < -80, -8, 280 >
       }
     
object { Desert 
         texture { Sand scale 65}
         finish { diffuse 0.8 ambient 0.3  }
         rotate < 6, 5, -10>
         translate < 50, -26, 20>
       }
       
object { DesertDune
         texture { Sand scale 50 }
         finish { diffuse 0.7 ambient 0.3  }
         rotate -10*x
         rotate 0*z
         rotate 245*y
         translate < 20, -22, -50>
       } 
       
object { Ground3 
         texture { Rock scale 80}
         finish { diffuse 0.7 ambient 0.38  }
         rotate 10*x 
         rotate 12*y
         rotate -10*z
         translate < 720, -100, 90>
       }
       
object { Boulder 
         texture { Rock2 rotate 35*y scale 30}
         finish { diffuse 0.7 ambient 0.4  }
         rotate < 5, -45, -20>
         translate < -130, 6, -60 >
       } 
       
object { Caveroof 
         texture { Rock2 scale 20}
         finish { diffuse 0.9 ambient 0.3  }
         rotate 180*z
         rotate 310*y
         translate <-90, 135, -180>
         no_shadow
       }
       
object { Cavefloor 
         texture { Rock2 rotate -75*y scale 30}
         finish { diffuse 0.7 ambient 0.3  }
         rotate <-33, 215, 0>
         translate < -92, 51, -143 >
       }
 

               
       
               
               
               
#include "txttree.inc"

#declare txtTree=texture{txtTree_6}

#declare txtLeaf=texture{txtLeaf_5}

#declare Leaf=object{#include "gtleaf4.inc"} // declares the Leaf object 

#declare Tree1=object{#include "gttree4.inc" }                        

#declare Foliage1=object{#include "gtfoliage4.inc"
                          texture{txtLeaf} 
                        }
                                                     

#declare Bamboo_like=

union{  object{Tree1}  
        object{Foliage1} 
     }

 object { Bamboo_like 
          scale < 1.5, 1, 1.5 > 
          translate < -160, 5, -60 >
        } 


 
       
                 
#declare MapTex =

texture {
   pigment { 
     image_map { tga "map.tga" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                 map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                 interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
               }
          rotate 90*x 
          
           }
         }
         
#declare CompTex =

texture {
   pigment { 
     image_map { tga "compass.tga" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                 map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                 interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
               }
          rotate 90*x 
          
           }
         }
         
#declare Map =                      
box {  <-3.2, 0, -2.4> < 3.2,  0.01,  2.4>  
       texture { MapTex 
                 scale < 6.4, 1, 4.8 >
                 translate <-3.2, 0, 2.4 >
                }
       finish { ambient 0.6 }
     }
     

#declare CompassRim =

union {      
 difference {
     
  cylinder {  < 0, 0, 0> < 0,  0.31, 0>  1.1
              pigment { Copper }
              finish { ambient 0.5 }
           }
         
    cylinder {  < 0, -0.1, 0> < 0,  0.32, 0>  1.0
                pigment { Copper }
                finish { ambient 0.5 }
             }
             
           } // end difference
           
  torus {  1.05,  0.051 
           pigment { Copper }
           finish { ambient 0.5 }
           translate 0.3*y
        }
        
      } // end union
      
      
#declare Compass = 

 union {                     
    cylinder {  < 0, 0, 0> < 0,  0.3, 0>  1
                texture { CompTex 
                          scale 2
                          translate < 1.0, 0, 1.0 >
                        }
                  finish { ambient 0.6 }
              } 
              
    object { CompassRim }
        
        } // end union
        
     
     
    
     object { Compass
              rotate < 55, 58, 48 > 
              scale 0.75
              translate < -151, 81.76, -155> 
            }
              
     object { Map
              rotate < 55, 58, 48 >
              scale 1.33 
              translate < -149, 82.2, -156>
              no_shadow     
               
             }