// Persistence Of Vision Raytracer Version 3.5
// File : CHLORIDE.POV (temp name: TGT_xx.POV)
// Date : June-July 2004
// Auth : James Coons
// Desc : IRTC Entry for "Desert"
// Title: Chloride, Arizona

// GOALS: TGT_16_xx:
//    ... Incorporate "cliff" texture onto mountains.
//    ... Verify Normals on buildings.
//    ... Finals Tweaks on Brothel Walls ... in progress.
//    ... Finals Tweaks on Saloon Walls ... in progress.
//    GOAL: Re-Add One Shack behind Brothel, re-scale.
//    GOAL: Re-establish Wheel, Work on Wagon Wheel Texture
//
//    DROP: Use SCREEN.INC to place Title directly into the image. 
//
//    DONE: Placed more trees and bushes randomly.
//    DONE: Tweaked Saloon Sign and Cowboy.

#include "COLORS.INC"   // Standard
#include "WOODS.INC"    // Standard
#include "Forms.TXT"    // Make_Form Macro    - Base is Centered at <0,0,0>
#include "Plants.TXT"   // Make_Plant Macro   - Base is Centered at <0,0,0>
#include "Saloon.TXT"   // Make_Saloon Macro  - Base is Centered at <0,0,0>
#include "Brothel.TXT"  // Make_Brothel Macro - Base is Centered at <0,0,0>

global_settings {max_trace_level 50}

// ************************************************************************************************************************
// /Q Choices: 0=Min Res All Objects, 9=Max Res All Objects, 99=Use Settings
// ************************************************************************************************************************
#declare Q        = 99; // 99=Use Settings
#declare Q        =  0; //  0=Min Res All Objects
#declare Q        =  9; //  9=Max Res All Objects

// ************************************************************************************************************************
#declare Axes     =  0; // 0=No, 1=Yes (Debugging Axes)                                                          /Axes
#declare GridLines=  0; // 0=No, 1=Yes (Projected Debugging Grid Lines)                                          /GridLines

// ************************************************************************************************************************ 
// /View /Cam (Copy/Paste below as needed)
//     Various Camera Views (some set Quality, Sun Position and Debugging)
// ************************************************************************************************************************
#declare View_No  =010; // /010=Custom View
#declare View_No  =100; // /100=High View of Valley, Lo-Res
#declare View_No  =101; // /101=High View of Valley, Hi-Res
#declare View_No  =200; // /200=High View of Town, Lo-Res
#declare View_No  =201; // /201=High View of Town, Hi-Res
#declare View_No  =301; // /301=Town From North
#declare View_No  =302; // /302=Town From South
#declare View_No  =303; // /303=South Closeup Of Town 
#declare View_No  =304; // /304=Wagon Wheel by Saloon
#declare View_No  =400; // /400=God View, Lo-Res
// ************************************************************************************************************************
#declare View_No  =700; // /700=Saloon (Front)
#declare View_No  =701; // /701=Saloon (Overhead)
#declare View_No  =800; // /800=Brothel (Left/Front/Ground Level)     CHECKED
#declare View_No  =801; // /801=Brothel (Left/Front/Above)            CHECKING
#declare View_No  =802; // /802=Brothel (Top)
// ************************************************************************************************************************
#declare View_No  =700; // /700=Saloon (Front)
// ************************************************************************************************************************

// ************************************************************************************************************************
// /Sun Choices: 1=Right Rear, 9=Sunset Center
// ************************************************************************************************************************
#declare Sun_No    = 03; // /Sun03=Sunset Right
#declare Sun_No    = 02; // /Sun02=Overhead Left
#declare Sun_No    = 09; // /Sun09=Sunset Center
#declare Sun_No    = 08; // /Sun08=Sunset Left
#declare Sun_No    = 01; // /Sun01=Right Rear

// ************************************************************************************************************************
// *** Force Settings for Lo-Res and Hi-Res Views ***
// ************************************************************************************************************************
   #if (View_No = 100 | View_No = 200 | View_No = 400) 
      // Force Settings for 100=High View of Valley, Lo-Res
      // Force Settings for 200=High View of Town, Lo-Res
      // Force Settings for 400=God View, Lo-Res
      #declare Q       =  0; // 0=Min Res All Objects
   #end
   #if (View_No = 101 | View_No = 201 | View_No = 401) 
      // Force Settings for 101=High View of Valley, Hi-Res
      // Force Settings for 201=High View of Town, Hi-Res
      // Force Settings for 401=God View, Hi-Res
      #declare Q       =  9; // 0=Max Res All Objects
   #end

// ************************************************************************************************************************
// *** Quality Settings 
// ************************************************************************************************************************
#declare Normals_On     =  0;    // 0=No, 1=Yes
#declare Images_On      =  1;    // 0=Color, 1=Image
#declare Shapes_On      =  1;    // 0=Color, 1=Image
#declare Fog_On         =  1;    // 0=No, 1=Yes
#declare Dust_On        =  0;    // 0=No, 1=Yes
#declare Clouds_On      =  1;    // 0=No, 1=Yes

// ************************************************************************************************************************
// *** Object Settings 
// ************************************************************************************************************************
#declare Desert_On      =  1;    // 0=No, 1=Yes
#declare Plants_On      =  1;    // 0=No, 1=Yes
#declare Buildings_On   =  1;    // 0=No, 1=Yes

// ************************************************************************************************************************
#declare Sky_Color      = LightBlue    ;  // Color of Sky (if Q=0)
#declare Sun_Color      =                 // Color used for Sun
   (White*.9+Gold*.5+SkyBlue*.25) + Orange;  
      
// ************************************************************************************************************************
   #if (Q=0)
      #declare Axes         =  Axes;          // 0=No, 1=Yes
      #declare GridLines    =  GridLines;     // 0=No, 1=Yes
      #declare Desert_On    =     1;          // 0=No, 1=Yes
      #declare Plants_On    =     1;          // 0=No, 1=Yes
      #declare Buildings_On =     1;          // 0=No, 1=Yes
      #declare Normals_On   =     0;          // 0=No, 1=Yes
      #declare Images_On    =     0;          // 0=Color, 1=Image
      #declare Shapes_On    =     1;          // 0=Color, 1=Image
      #declare Fog_On       =     0;          // 0=No, 1=Yes
      #declare Dust_On      =     0;          // 0=No, 1=Yes
      #declare Clouds_On    =     0;          // 0=No, 1=Yes
   #end
   #if (Q=9)
      #declare Axes         =     0;          // 0=No, 1=Yes
      #declare GridLines    =     0;          // 0=No, 1=Yes
      #declare Desert_On    =     1;          // 0=No, 1=Yes
      #declare Plants_On    =     1;          // 0=No, 1=Yes
      #declare Buildings_On =     1;          // 0=No, 1=Yes
      #declare Normals_On   =     1;          // 0=No, 1=Yes
      #declare Images_On    =     1;          // 0=Color, 1=Image
      #declare Shapes_On    =     1;          // 0=Color, 1=Image
      #declare Fog_On       =     1;          // 0=No, 1=Yes
      #declare Dust_On      =     1;          // 0=No, 1=Yes
      #declare Clouds_On    =     1;          // 0=No, 1=Yes
   #end

// ************************************************************************************************************************
// Available Cameras and Views /Views /Cameras
// ************************************************************************************************************************
#declare Camera_Pos           = <+1, 26,-155>   ; // Default
#declare Camera_Aim           = <-5,-21,0>      ; // Default
// ************************************************************************************************************************
#switch (View_No)
   // ************************************************************************************************************************
   #case (100) // /100=High View of Valley, Lo-Res /High /Overhead /Valley /Cam100
      // Lo-Res View of the Entire Valley
      #declare Camera_Pos     = <0,900,-5>      ;
      #declare Camera_Aim     = <0,500,50>      ;
      #break
   #case (101) // /101=High View of Valley, Hi-Res /High /Overhead /Valley /Cam101 
      // Hi-Res View of the Entire Valley
      #declare Camera_Pos     = <0,120,-50>     ;
      #declare Camera_Aim     = <0,0,-50>       ;
      #break
   // ************************************************************************************************************************
   #case (200) // /200=High View of Town, Lo-Res /High /Overhead /Town /Cam200 
      // Lo-Res View of the Town
      #declare Camera_Pos     = <0,120,-50>     ;
      #declare Camera_Aim     = <0,0,-50>       ;
      #break
   #case (201) // /201=High View of Town, Hi-Res /High /Overhead /Town /Cam201 
      // Hi-Res View of the Town
      #declare Camera_Pos     = <0,120,-50>     ;
      #declare Camera_Aim     = <0,0,-50>       ;
      #break
   // ************************************************************************************************************************
   #case (301) // Town From North - /Cam301 /301 /North
      #declare Camera_Pos     = <0.5,24,31>     ;
      #declare Camera_Aim     = <-1,5,-19>      ;
      #break
   #case (302) // Town From South - /Cam302 /302 /South
      #declare Camera_Pos     = <-15,13,-135>   ;
      #declare Camera_Aim     = <0,-21,0>       ;
      #break
   #case (303) // South Closeup Of Town - /Cam303 /303 
      #declare Camera_Pos     = <-36+11-5,8,-66-5>     ;
      #declare Camera_Aim     = <-5+11-3-2-5-3-2,-22,43> ;
      #break
   #case (304) // Wagon Wheel Near Saloon - /Cam304 /304 /Wheel
      #declare Camera_Pos     = <-36-3-1-1, 9-4-1-2-1-1-0.5-0.2, -63+5+3+1+4.2-5+2>   ;
      #declare Camera_Aim     = <-36-1-2-1+0.2-0.5, 9-4-1-3-1+0.8-0.5, -63+5+9.2>     ;
      #break
   // *********************************************************************************************************************
   #case (700) // /700=Saloon /Cam700 /Saloon
      #declare Camera_Pos     = <-36+3,8,-66>   ;
      #declare Camera_Aim     = <-5-1-5,-22,43>   ;
      #break
   #case (701) // /701=Saloon (Overhead) /Cam701 /Saloon
      #declare Camera_Pos     = <-34,16+2,-42-1>;
      #declare Camera_Aim     = <-34,0,-40-1>   ;
      #break
   // *********************************************************************************************************************
   #case (800) // /800=Brothel (Left/Front/Ground Level) - /Cam800 /Brothel
      #declare Camera_Pos     = <-22-3, 8, -61+3-3>     ;
         #declare Camera_Pos     = <-22-3, 2+2, -61+3+3+3>;
      #declare Camera_Aim     = <5-3-3+2+4+3+5+15, -22+3+3, 43>    ;
      #break
   #case (801) // /801=Brothel (Left/Front/Above) /Cam801 /Brothel
      #declare Camera_Pos     = <-31+3+5-2-1, 17-2-2-1, -46-6-2+1+1> ;
      #declare Camera_Aim     = <-21+2-5+3+1, 5, -39-3-3>   ;
      #break
   #case (802) // /802=Brothel (Top) /Cam802 /Brothel
      #declare Camera_Pos     = <-18, 14, -47-0.5> ;
      // #declare Camera_Aim     = <-23+0.4+3+2,  5, -46+1.5+1-2> ;
      #declare Camera_Aim     = <-20,  5, -47+0.5> ;
      #break
   // *********************************************************************************************************************
   #case (900) // God View, Lo-Res - /Cam900 /High /Overhead Orthographic /God
      #declare Camera_Pos     = <0,900,-5>      ;
      #declare Camera_Aim     = <0,500,50>      ;
      #break
   #case (901) // God View, Hi-Res - /Cam901 /High /Overhead Orthographic /God
      #declare Camera_Pos     = <0,900,-5>      ;
      #declare Camera_Aim     = <0,500,50>      ;
      #break
   // *********************************************************************************************************************
#end

// ************************************************************************************************************************
// *** All other Custom Views (Temporary)
// ************************************************************************************************************************
#if (View_No=010) // 10=Custom /Custom /010 /Cam010
   // Inside View of Saloon
      #declare Camera_Pos     = <-34,1.0,-49>      ;
      #declare Camera_Aim     = <-31,0,41>         ;
   // View of Saloon and Brothel
   #declare Camera_Pos     = <-36+11-5,8,-66-5>     ;
   #declare Camera_Aim     = <-5+11-3-2-5-3,-22,43> ;
#end // /Cam /Custom

// ************************************************************************************************************************
// Sun /Sun /Light
// ************************************************************************************************************************
#switch (Sun_No)
   #case (1) // Behind, to the Right /Sun01
      #declare Sun_Transform = transform {translate <2000,9000,-6000> }
      #break
   #case (2) // 02=Overhead Left /Sun02
      #declare Sun_Transform = transform {translate <-5000,9000,-5000> }
      #break
   #case (3) // Sunset Right /Sun03
      #declare Sun_Transform = transform {translate <-500,2000,5000> rotate y*45} 
      #break
   #case (8) // Sunset Left /Sun08
      #declare Sun_Transform = transform {translate <-500,2000,5000> } 
      #break
   #case (9) // Sunset Center /Sun09
      #declare Sun_Transform = transform {translate <-500,2000,5000> 
         rotate y*32 rotate x*20
         }
      #break
   #else     // Behind, to the Right
      #declare Sun_Transform = transform {translate <2000,9000,-6000> }
      #break
#end

// Main Light Source
light_source {0 Sun_Color fade_distance 50000 fade_power 1 
   transform Sun_Transform
   looks_like {sphere {<0,0,0> 800*0.75*0.75
      transform Sun_Transform
      pigment {Sun_Color} finish {ambient 1.0} } }
}
// Second Fill-In Light
light_source {<-5000,9000,-5000> Sun_Color/50 fade_distance 50000 fade_power 1}

// ************************************************************************************************************************
// Camera 
// ************************************************************************************************************************
camera {
   // #if (View_No=201) // 201=High View of Valley, Lo-Res /High /Overhead /View /Cam100
   //    orthographic
   // #end
   location Camera_Pos 
   look_at Camera_Aim
   /*
   #if (View_No=xxx)
      up z // Straighten horizon for certain Views
   #end
   */
   }

// ************************************************************************************************************************
// *** Outer Sky Sphere
// ************************************************************************************************************************
#include "sky.INC" // /Sky

// ************************************************************************************************************************
// *** Low, Layered Clouds ***
// ************************************************************************************************************************
#include "clouds.INC" // /Clouds

// ************************************************************************************************************************
// /Textures for Desert Surface
//    Note: TRANSFORMs are used to keep the Textures and Normals synchronized.
// ************************************************************************************************************************

// ************************************************************************************************************************
// Mossy_Texture - Brown Dirt, with Self-Normals, and self-similar mixing using Granite texture. /Mixed_Dirt 
// ************************************************************************************************************************
#declare Mossy_Transform = transform {rotate x*90 rotate y*41 scale 50*0.9*0.5}
#declare Mossy_Layer =
   texture {
      // Long-Shot Main Texture
      pigment {image_map {jpeg "_Dirt06.jpg" interpolate 2.0 map_type 0 }
         transform {Mossy_Transform} 
         }
      finish {ambient 0.3 reflection 0} 
      #if (Normals_On=1)
         normal {
            average
            normal_map {
               [1.0 bump_map {jpeg "_Dirt06.jpg" bump_size 7.5} // Self-Normal
                  transform Mossy_Transform accuracy 1e-9]
               [0.4 granite 0.5 scale 3 accuracy 1e-9]
               }
            }       
      #end
      }
#declare Mossy_Texture =
   texture {
      average
      texture_map {
         [1.0 Mossy_Layer rotate y*31 scale 0.025*15]
            [0.8 Mossy_Layer rotate y*67 scale 0.025*35]
            [-0.15 Mossy_Layer rotate y*71 scale 0.025*35/10 pigment {turbulence 0.5} ]
            [-0.10 Mossy_Layer rotate y*61 scale 0.025*50 pigment {turbulence 0.1} ]
            [-0.05 Mossy_Layer rotate y*41 scale 0.025*200 pigment {turbulence 0.7} ]
         }
      } ;

// ************************************************************************************************************************
// Transformation of HF into Desert Surface
// ************************************************************************************************************************
#declare Desert_Transform = // /Land /Desert
   transform {translate -0.5 
      scale <660,33,800>
      translate z*150
      scale <1,1.5,1>
      translate y*(22.5+2.15)
      } ;
#declare Desert_Texture_Scale = 2.0 ;
#declare Scaling = 20 ;
#declare Desert_Texture = 
   texture {
      // slope {y, 0.0, 1.0} // altitude 1.0 // , 0.0, 1.0 // Didn't have the desired effect
      // crackle scale 30 translate 100
      granite scale Scaling sine_wave
      texture_map {
         // [0.00 Mossy_Texture scale Desert_Texture_Scale scale 1/Scaling]
         [0.00 Mossy_Texture scale Desert_Texture_Scale scale 1/Scaling/2/1]
         [0.50 Mossy_Texture scale Desert_Texture_Scale scale 1/Scaling/2/2]
         }
      rotate x*-15 rotate z*-15 // Try to correct "smear" effect
      }

// *********************************************************************************************************************
// Fog Effects /Fog
// *********************************************************************************************************************
#include "fog.INC" // /Fog

// ************************************************************************************************************************
// Draw Reference Axes (For Debugging)
// ************************************************************************************************************************
#include "Axes.INC" // /Axes
 
// ************************************************************************************************************************
// *** HF - Desert Surface /Desert /Land/ /Hills /Basin
// ************************************************************************************************************************
#declare HF_Ground = height_field {jpeg "_Floor.jpg" smooth}   // *** HF - Desert Surface (Hills and Basin) ***
#if (Desert_On=1)
   object {HF_Ground transform Desert_Transform
      // *** HF - Desert Hills Surface *** /Desert
      #if (Images_On=1)
         texture {Desert_Texture}
      #else
         pigment {color Brown*0.50} finish {ambient 0.3}
      #end
      } 
#end

// ***************************************************************************************************************************
#if (Buildings_On=1) // (Left-To-Right, Back-To-Front)
   // ************************************************************************************************************************
   // Town Saloon, based on a Canadian Copper Mine /Saloon
   // ************************************************************************************************************************
   #declare Saloon_Object = Make_Saloon ()
   object {Saloon_Object // original size: 493x460
      scale <11,6.45/1.07,9.4> 
      translate <-34,-0.2,-41> 
      }

   // ************************************************************************************************************************
   // Town Brothel, based on "The House of Soiled Doves" in Chloride, Arizona /Brothel
   // ************************************************************************************************************************
   #declare Make_Brothel_Object = Make_Brothel()
   object {Make_Brothel_Object
      scale .62*<8.8,7.2,8.8>
      translate <-34+11,-0.10,-46>
      }

/* // These haven't been tested lately and may no longer work //
   #declare Shack_No = 1 ; // /Shack
      #include "Shacks.TXT" // Shack_Object centered at <0,0,0>
      object {Shack_Object // /Shack1, Right #1
         scale <9.0,8.6*0.75,9.3> 
         rotate y*10 
         translate <25,-3+1,-20> }
      
   #declare Shack_No = 1 ; // /Shack
      #include "Shacks.TXT" // Shack_Object centered at <0,0,0>
      object {Shack_Object // /Shack2, Right #2
         scale <9.1,8.6*0.75,9.4> 
         rotate y*30 scale <-1,1,-1> 
         translate <19,-3+1,-37> }
      
   #declare Shack_No = 1 ; // /Shack
      #include "Shacks.TXT" // Shack_Object centered at <0,0,0>
      object {Shack_Object // /Shack3, Left #1
         scale <12,8.6*0.75*1.1,9.2> rotate y*90 
         translate <-8,-3+1+1,-22+4> }
      
   #declare Shack_No = 1 ; // /Shack
      #include "Shacks.TXT" // Shack_Object centered at <0,0,0>
      object {Shack_Object // /Shack4, Left #2
         scale <-1,1,-1>
         scale <11,8.6*0.75,9.4> translate <-13,-3+1,-35> }
*/
      
#end
   
#if (Plants_On=1) // /Plants (Left-To-Right)
   // ************************************************************************************************************************
   // Brown_Tree_1 Left of the Saloon /Tree
   // ************************************************************************************************************************
   object {Make_Plant (1) // Brown_Tree_1
      scale <4,8,4> rotate y*10
      translate <-41, -0.4, -44>
      }

   // ************************************************************************************************************************
   // Yucca_Plant in Front of Left Saloon Window /Yucca
   // ************************************************************************************************************************
   object {Make_Plant (2) // Yucca_Plant
      scale <3.84,7.04,3.84>*0.46
      translate <-37.5, -0.2, -47>
      }

   // ************************************************************************************************************************
   // Yucca_Plant at Right Corner of Saloon /Yucca
   // ************************************************************************************************************************
   object {Make_Plant (2) // Yucca_Plant
      scale <1.5, 2.5, 1.5> rotate y*15
      translate <-28, -0.3, -46>
      }

   // ************************************************************************************************************************
   // Brown_Tree_1 Behind Brothel /Tree
   // ************************************************************************************************************************
   object {Make_Plant (1) // Brown_Tree_1
      rotate y*47
      scale <6.6, 9.6, 6.6>
      translate <-19-3, -1.6, -30-5-3+1>
      }

   // ************************************************************************************************************************
   // Red_Bush Right of Northern Pass
   // ************************************************************************************************************************
   object {Make_Plant (4) // Red_Bush
      rotate y*47
      scale <6.6, 9.6, 6.6>
      translate <-22+120, -1.6, -37+150>
      }

   // ************************************************************************************************************************
   // Brown_Tree_1 Left in Northern Mountains
   // ************************************************************************************************************************
   object {Make_Plant (1) // Brown_Tree_1
      rotate y*47
      scale <6.6, 9.6*1.5, 6.6>
      translate <-22-50, -2.0, -37+120>
      }

   // ************************************************************************************************************************
   // Brown_Tree_2 Left in Northern Mountains
   // ************************************************************************************************************************
   object {Make_Plant (2) // Brown_Tree_2
      rotate y*47
      scale <6.6*1.1, 9.6, 6.6*1.1>
      translate <-22-50+20, -1.2, -37+110-20>
      }

   // ************************************************************************************************************************
   // Red_Bush Right of Brothel
   // ************************************************************************************************************************
   object {Make_Plant (4) // Red_Bush
      scale <3, 4.5, 3>
      translate <-38+15+5+1-0.5, -0.2, -46-0.5>
      }

   // ************************************************************************************************************************
   // Yucca_Plant Clusters in Foreground of Saloon /Yucca
   // ************************************************************************************************************************
   object {Make_Plant (2) // Yucca_Plant
      scale <3.84,7.04,3.84>*0.2
      translate <-37.5+10, -0.2, -47-10>
      }
   object {Make_Plant (2) // Yucca_Plant
      scale <0.4,0.7,0.4>
      translate <-37.5+10-3, -0.2, -47-10+2>
      }
   object {Make_Plant (2) // Yucca_Plant
      scale <0.4*3,0.7*2,0.4*3>
      translate <-37.5+10-3-2, -0.2-0.2, -47-10+2+2>
      }
   object {Make_Plant (2) // Yucca_Plant
      scale <0.4*6,0.7*2,0.4*6>
      translate <-37.5+10-3-2-4, -0.2-0.2, -47-10+2>
      }

#end

   // ************************************************************************************************************************
   // Man_01 - Stranger Inside Saloon Window
   // ************************************************************************************************************************
   #declare Man_No = 1;
      #include "HF_Man.TXT" // /Man /Stranger
      object {Man_Object
         scale 0.5
         translate <-29-2.3, 0.6, -47+1.5>
         }

/*
   // ************************************************************************************************************************
   // Wagon_Wheel Leaning against Saloon
   // ************************************************************************************************************************
   #declare Wagon_Wheel = Make_Form (1) ; // Wagon_Wheel /Wheel
   object {Wagon_Wheel
      scale <1.5,0.12,1.5> rotate x*-90
      rotate x*45
      rotate y*45
      translate <-38-0.4,2.0-3.4-0.50,-44.4-0.3+1.0>
      translate <0,0,-2.1>
         translate <0,.4,-1>
         translate <-1.6,0.2,0.5>
      finish {ambient 0.3 reflection 0}
      #if (Images_On)
         pigment {image_map {jpeg "_Wheel2.jpg"
            interpolate 2.0 map_type 0 }
            rotate x*90
            }
      #else
         pigment {color (Brown+Gray)/2}
      #end
      }
*/

   // ************************************************************************************************************************

