// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Photon Scene Template
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "stones.inc"
#include "skies.inc"
#include "TdG_Textures.inc"

// radiosity (global illumination) settings
#declare Radiosity=off;
#if(Radiosity)
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
#end


// ----------------------------------------

#declare CamPos = <-7,1,-7>;

camera {
	location CamPos
	look_at < -.8, .3, 1>
}
// sun ---------------------------------------------------------------
light_source{<2500,5000,-3500>*.5 color White media_interaction on }
// sky ---------------------------------------------------------------
sphere{<0,1,0>,10000 hollow  // 
      
      texture{ pigment {color rgb<0.2,0.5,0.8>*3}
               finish {ambient 1  diffuse 0}}
     }
sphere{<0,1,0>,1 hollow  // 
      texture{pigment { bozo turbulence 0.65
                        octaves 6  omega 0.7 lambda 2 
                        color_map { [0.0 color rgb <0.95, 0.95, 0.95>]
                                    [0.1 color rgb <0.85, 0.85, 0.85>*2]
                                    [0.5 color rgbt <1, 1, 1, 1> ]
                                    [1.0 color rgbt <1, 1, 1, 1> ]   }
                        rotate<10,20,0>
                        scale <0.3, 0.4, 0.2>*3 }
              finish {ambient 1 diffuse 0}}
      scale 1000}  
// fog at the horizon     
fog{distance 300000 color White}


// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1.3,1.1,1>*0.2    // light's color
  translate <0,1,0>
  shadowless
media_interaction on media_attenuation on
}


#declare P1=function{pattern{granite 
   turbulence 0.3 scale 0.5}}
#declare P2=function{pattern{boxed 
   turbulence 0.3 scale 0.7}}
#declare P3 = function{pattern{bozo 
   turbulence 0.8 scale 0.03}}

#declare P=function{P1(x,0,z)*0.3 +P2(x,0,z)}
#declare mound =   
        //height_field{function 300,300 {P(x,0,y)}
        isosurface {
            function { y - P(x,0,1-z)} 
            max_gradient 4
            contained_by{box{<0,0,0>,<1,1,1>}} 
             
    translate <-0.5,-.2,-0.5>
    rotate y*90
    scale <25,10,25>
   texture{TdG_LightBandedSandstoneRubble}
   //texture {T_Grnt11}
    }

object {mound }       

        //height_field{function 300,300 {P3(x,0,y)}
       isosurface {
            function { y - P3(x,0,1-z)} 
            max_gradient 4
            contained_by{box{<0,0,0>,<1,1,1>}} 
            
    translate <-0.5,-.3,-0.5>
    rotate y*90
    scale <40,0.4,40>
   texture{ TdG_LightSand }
}
plane {y,0      texture{TdG_LightSand}
 }

#include "mummy_g.inc"

union {
object{ P_Hip }
object{ P_Abdomen }
object{ P_Chest }
object{ P_Neck }
object{ P_Head }
object{ P_Right_Collar }
object{ P_Right_Shoulder }
object{ P_Right_Forearm }
object{ P_Right_Hand }
object{ P_Right_Thumb_1 }
object{ P_Right_Thumb_2 }
object{ P_Right_Thumb_3 }
object{ P_Right_Index_1 }
object{ P_Right_Index_2 }
object{ P_Right_Index_3 }
object{ P_Right_Mid_1 }
object{ P_Right_Mid_2 }
object{ P_Right_Mid_3 }
object{ P_Right_Ring_1 }
object{ P_Right_Ring_2 }
object{ P_Right_Ring_3 }
object{ P_Right_Pinky_1 }
object{ P_Right_Pinky_2 }
object{ P_Right_Pinky_3 }
object{ P_Left_Collar }
object{ P_Left_Shoulder }
object{ P_Left_Forearm }
object{ P_Left_Hand }
object{ P_Left_Thumb_1 }
object{ P_Left_Thumb_2 }
object{ P_Left_Thumb_3 }
object{ P_Left_Index_1 }
object{ P_Left_Index_2 }
object{ P_Left_Index_3 }
object{ P_Left_Mid_1 }
object{ P_Left_Mid_2 }
object{ P_Left_Mid_3 }
object{ P_Left_Ring_1 }
object{ P_Left_Ring_2 }
object{ P_Left_Ring_3 }
object{ P_Left_Pinky_1 }
object{ P_Left_Pinky_2 }
object{ P_Left_Pinky_3 }
object{ P_Right_Thigh }
object{ P_Right_Shin }
object{ P_Right_Foot }
object{ P_Right_Toe }
object{ P_Left_Thigh }
object{ P_Left_Shin }
object{ P_Left_Foot }
object{ P_Left_Toe }
object{ P_hair }
scale 3
rotate y*-110
translate <-.8,0.05,0>
} // image_map

#include "brick_pile_g.inc"

union {object{ P_cube2_default }  
scale .3
rotate y*170
translate <-.30,.2,0.8>

}
