//Render at 2048 x 2048 pixels

#include "colors.inc"

global_settings {hf_gray_16}

camera {
  location -10*z
  right 1*x
}

#declare HFPig = pigment {
  quilted control0 0.67 control1 1
  turbulence 0.75
  octaves 4
  omega 0.7
  color_map {
    [0.0  color rgb 0]
    [1.0  color rgb 2]
  }
}

plane {z, 0
  texture {
    pigment {
      average
      pigment_map {
        [1.0  HFPig translate 1000*x scale 5.0]
        [0.01 HFPig translate 1000*z scale 0.5]
      }  
    }
    finish {ambient 1}
  }                
}   
