camera {
   location <14,17,14>
   look_at <7,19,20>
   focal_point <13,17,14>
   aperture 0.012
   blur_samples 50
}           

light_source {
   <-4,30,40>
   color rgb 1.2
}

#declare Ground = function {
   pigment {
      dents
      turbulence 0.9
      scale 0.2
      color_map {
         [ 0 color rgb 0 ]
         [ 0.5 color rgb 0.9 ]
         [ 1 color rgb 1 ]
      }
   }
}

#declare Ground2 = function {
   pigment {
      dents
      turbulence 1
      scale 0.01
      color_map {
         [ 0 color rgb 0 ]
         [ 1 color rgb 1 ]
      }
   }
}

height_field {
   function 5000, 5000 { Ground(x,y,0).gray/2 + Ground2(x,y,0).gray/40 }
   pigment {
      gradient y
      color_map {
         [ 0 color rgb 1.5 ]
         [ 0.3 color rgb <1,0.5,0> ]
      }
   }
   finish {
      ambient rgb <0.2, 0.8 0.2>/5
   }
   translate -0.5
   scale <50,10,50>
   translate 20*y   
}

height_field {
   function 100, 100 { Ground(x,y,0).gray/2 + Ground2(x,y,0).gray/40 }
   smooth
   pigment {
      color transmit 1
   }
   interior {
      media { 
         scattering { 2, rgb <1,0.5,0.4>/5 }
         density {  
            bozo
            scale 0.001
            color_map {
               [ 0 rgb 0 ]
               [ 1 rgb 1 ]
            }
         }
      }
   }
   translate -0.5
   scale <50,8,50>
   translate <-0.5,19.2,0> 
   hollow
}

cylinder {
   <-1,-20,-3>, <-1,120,-3>, 100
   pigment {
      color transmit 1
   }
   interior {
      media {
         emission rgb <0, 0.5, 0.9>/300                           
         scattering { 5, rgb <0.2, 0.8 0.2>/150 eccentricity 0.7 }
      }
   }
   hollow
}

fog {
   fog_type 2
   distance 50
   color rgb 0.7
   fog_offset 5
   fog_alt 7.1
   turbulence 0.1
}