global_settings {assumed_gamma 1.0}

#include "functions.inc"
#include "colors.inc"

#declare scorpianColLight = Red;
#declare scorpianColDark  = rgb<0.1,0,0>;


#declare scorpianColLight = rgb<0.4,0.005,0.0>;
#declare scorpianColDark  = rgb<0.01,0.00,0.0>;

#declare scorpianColLight = rgb<0.7,0.01,0.0>;
#declare scorpianColLight = rgb<0.5,0.0125,0>;


#declare scorpianShine = finish{ phong 0.5 }

#declare tummyTex =
texture{
     pigment{
       gradient y     
       turbulence 0.2
        color_map{
             [0 rgb<.6,0,0>]
             [0.6 rgb<0.2,0.0>] 

        } 
        scale<1,1.5,1>      
        translate <0,0.7,0>
     }    
     normal{wrinkles turbulence 1 bump_size .2 scale 0.1 }
     finish{phong 0.1}
}

#declare tummyTex =
texture{
     pigment{
       gradient y     
       turbulence 0.2
        color_map{
             [0 scorpianColLight]
             [0.6 scorpianColDark] 

        } 
        scale<1,1.5,1>      
        translate <0,0.7,0>
     }    
     normal{wrinkles turbulence 1 bump_size .2 scale 0.1 }
     finish{phong 0.1}
}

#declare link = 

union{
  isosurface {
  function { f_torus(x,y,z,1*(y/6+0.5),0.1*(2+x/1.6)) } 
    max_gradient 10
    contained_by { box { -3, 3 } } 
    scale <1,4,1> 
    rotate 180*x   
    pigment{radial 
            color_map{
               [0.1  scorpianColDark]
               [0.5  scorpianColLight]
               [0.85 scorpianColDark]
            }
            
            rotate 90*x  
            rotate 18*z
            translate <-3,0,0>
            frequency 11
           }
    normal{radial turbulence 0.1 frequency 6 rotate 30*y} 
    normal{ bumps bump_size 0.0625 scale 0.05}    
    scale <1,1.1,1>
    finish{scorpianShine }
 }
  sphere{
    <0,0,0> 0.45 translate 0.9*y
    pigment{scorpianColDark}
    finish{scorpianShine }
  }   
}


#declare sting =

isosurface {                           

  function { f_piriform_2d
     (x+y*y, y+x*x, z, -1, 1, -1, 1, 1, 0, -90)}
    max_gradient 8
    scale <1,1.25,1> 
    rotate -140*z
    pigment{
      gradient x 
      turbulence 0.25
      color_map{
               [0  scorpianColLight]
               [0.5  scorpianColDark]
               [1  scorpianColDark]
      }
      scale 1.2*x 
      translate -.15*x                
    }      
    finish{scorpianShine }
}

#declare tail =
union{

   object{link rotate -80*z}   
   object{link scale 0.9 rotate -40*z  translate <1.4,0.8,0>}   
   object{link scale 0.81 rotate - 0*z  translate <1.95,2.2,0>}   
   object{link scale 0.73 rotate  40*z  translate <1.525,3.475,0>}   
   object{link scale <0.61,0.9,0.61> rotate  80*z  translate <0.275, 4.125, 0>}   
   
   object{sting scale 1.5 translate<-1.95,4.7,0> }   
   rotate 10*z
   translate <0.85, .4, 0>   
   scale .4
} 

  
#declare bodyRing =

union{
   torus{ 
     0.375, 
     0.2 
     rotate 90*z
     scale<1.4,1,1>  
     texture{tummyTex}
   }
   
   intersection{
     torus{ 
       0.5 + .025, 
       0.125 
       rotate 90*z
       scale<3,1,1>
     }
     
     sphere{<0,.5,0>.25 scale < 1, 1, 8>}     
     pigment{
        onion 
        color_map{
              [0  scorpianColLight]  
              [0  scorpianColLight] 
              [.8  scorpianColDark]
        }  
        scale 0.7
        translate<0,0.5,0>
     }    
    normal{ bumps bump_size 0.4 scale 0.1}    
    finish{phong 1.5 }
   }
   scale < 1, 0.5, 1> 
   scale 0.9
   
}

/************************************

        HEAD BLANKER
        
*************************************/       

#declare headBlanker =
blob{
    threshold 0.6        
    sphere{<0,0,0>.6, 1}       
    cylinder{<0,0,0><-0.3,0,0>0.3, 1 scale<1,0.9,1>}  


    sphere{<-0.5,0.2, 0.2>.3, 0.25 }
    sphere{<-0.5,0.2,-0.2>.3, 0.25 }


    scale <1.25,0.95,1.1>
    translate 0.025*y
}


/************************************

        JAW
        
*************************************/  
     
#declare jaw = 
union{
    blob{
      threshold 0.6        
      sphere{<0,0,0>.6, 1}       
      cylinder{<0,0,0><-0.3,0,0>0.3, 1 scale<1,0.9,1> }  


      sphere{<-0.45,0, 0.08>.1, 0.7 }
      sphere{<-0.45,0,-0.08>.1, 0.7 }


      scale <1.25,0.95,1.1>
      translate 0.0125*y
    }
}
     
    
    
/************************************

        FULL HEAD
        
*************************************/       


#declare head =  
union{  
  difference{
    blob{
      threshold 0.6        
      sphere{<0,0,0>.6, 1}       
      cylinder{<0,0,0><-0.3,0,0>0.3, 1 scale<1,0.9,1>}  

      sphere{<-0.075,0.15,0>.18, 1 scale<0.9,1,0.4>pigment{scorpianColDark}finish{scorpianShine }}

      sphere{<-0.075,0.325, 0.075>.075, -0.75 scale<2,1,0.5>pigment{scorpianColDark}finish{scorpianShine }}
      sphere{<-0.075,0.325,-0.075>.075, -0.75 scale<2,1,0.5>pigment{scorpianColDark}finish{scorpianShine }}

      sphere{<-0.5,0.2, 0.2>.3, 0.25 pigment{scorpianColDark}finish{scorpianShine }}
      sphere{<-0.5,0.2,-0.2>.3, 0.25 pigment{scorpianColDark}finish{scorpianShine }}


      scale <1.25,0.95,1.1>
      translate 0.025*y
    }
    
    object{ headBlanker scale < 1.5, 1, 1.1> translate <-0.1, -0.075, 0> rotate 5*z }
    
    pigment{
       onion
       color_map{
             [0   scorpianColDark]
             [0.3 scorpianColDark]
             [0.6 scorpianColLight]
             [1   scorpianColDark]
       }  
       scale <.7,0.7,.3>
       translate<-0.15,0.5,0>
     }
     normal{ bumps bump_size 0.125 scale 0.05}    
    finish{phong 2 }
  }  
  
  object{jaw scale 0.99}
  
  sphere{<0,0,0>.035 translate <-0.11,0.27,-0.0275> pigment{Black} finish{phong 8}}
  sphere{<0,0,0>.035 translate <-0.11,0.27, 0.0275> pigment{Black} finish{phong 8}} 
  
}

/************************************

        MIDDLE BODY
        
*************************************/       

#declare midbody =

union{

   #declare n = 0;
   #while ( n < 7 )
       
       object{ bodyRing  scale<1/(1+n/4),1,0.5*(1+(3.5*3.5 - (n-3.5)*(n-3.5))/20)> translate <0,-5+n/50,0> rotate -5*n*z/(1+n/7) }  
       
       #declare n = n + 1;
   #end
   
   translate 5*y 
   
   translate <-0.23,0,0> 
   
}


#macro legSeg1(Shift, a, X)  

  isosurface {
  function { f_torus(x + 0.1*X*f_noise3d(0, 6*X*y, 6*X*z),y,z,0.5-(y-Shift)*(y-Shift),0.1*(2+x/a)) } 
//  function { f_torus(x,y,z,0.5-(y-Shift)*(y-Shift),0.1*(2+x/a)) } 
    max_gradient 10
    contained_by { box { -3, 3 } } 
    scale <0.5,4,0.5> 
    pigment{gradient y 
            color_map{
               [0  scorpianColDark]
               [0.5  scorpianColLight]
               [1 scorpianColDark]
            }  
            translate 0.5*y
            scale 1.7
           }
    normal{radial turbulence 0.1 frequency 6 rotate 30*y} 
    normal{ bumps bump_size 0.0625 scale 0.05}    
    finish{scorpianShine }
    
    scale <0.9, 0.65, 0.9>
    translate 0.5*y
 }
#end
#macro legSeg2(Shift, a, X)  


  isosurface {
  function { f_torus(x + 0.1*X*f_noise3d(0, 6*X*y, 6*X*z) ,y + x/a,z,0.5-(y-Shift)*(y-Shift),0.3) } 
//  function { f_torus(x,y + x/a,z,0.5-(y-Shift)*(y-Shift),0.3) } 
    max_gradient 10
    contained_by { box { -3, 3 } } 
    scale <0.5,4,0.5> 
    pigment{gradient y 
            color_map{
               [0  scorpianColDark]
               [0.5  scorpianColLight]
               [1 scorpianColDark]
            }  
            translate 0.5*y
            scale 2.4
           }
    normal{radial turbulence 0.1 frequency 6 rotate 30*y} 
    normal{ bumps bump_size 0.0625 scale 0.05}    
    finish{scorpianShine }
    
    scale <0.7, 0.45, 0.7>
    translate 0.5*y
 }
#end
/************************************

        BODY = TAIL + MIDDLE BODY
        
*************************************/       

#declare body =
union{
  
  union{
    object{ midbody } 
    object{tail}
    rotate 20*z  
    translate <1.75,0.25,0>
  }
  object{ head }

  texture{tummyTex}
}   


/************************************

        LEGS LEGS LEGS LEGS
        
*************************************/       

#macro backLeftLeg(X,Y)        
union{
   
union{
union{ 
union{
union{  
union{

   object{legSeg1(-0.5, 20, 1.5*Y)  scale <0.25,0.4,0.25>  
    rotate X*x
    rotate -60*z
    translate <-0.0,0.78,0>
   }
   object{legSeg2(0,20, 0.9*Y) scale <0.35,0.75,0.35>  
   }
   rotate 30*z   
   rotate 10*x
   translate <-0.0,1.5,0>
   }
   object{legSeg2(-0.25,20, 1*Y) scale <0.7,1.5,0.5> 
   }
   rotate 80*z
   translate <-0.03,1.28,0>
   }
   object{legSeg1(0.2, 2, 1*Y)  scale <0.65,1.25,0.4> 
   } 
   rotate -90*y
   rotate 40*x 
   translate 0.95*y
   }
   object{legSeg2(-0.2,20, Y)rotate 90*y  scale<0.7,1,0.7>
   }  
   rotate -45*z translate <-0.065,0.95,0>
   }
   object{legSeg2(.3, 20, 1) }                           
   }
   
   scale 0.6 
   rotate -85*x
   rotate -30*y               
   scale 0.8
   translate<0.2,-0.1,-0.05>
}
#end
#macro backRightLeg(X, Y)        
union{
   
union{
union{ 
union{
union{  
union{

   object{legSeg1(-0.5, 20, 1.5*Y)  scale <0.3,0.5,0.3>  
    rotate  -60*z
    rotate X*y
    translate <-0.0,0.78,0>
   }
   object{legSeg2(0,20, 0.9*Y) scale <0.35,0.75,0.35>  
   }
   rotate  30*z   
   rotate -10*x
   translate <-0.0,1.5,0>
   }
   object{legSeg2(-0.25,20, 1*Y) scale <0.7,1.5,0.5> 
   }
   rotate 80*z
   translate <-0.03,1.28,0>
   }
   object{legSeg1(0.2, 2, 1*Y)  scale <0.65,1.25,0.4> 
   } 
   rotate 90*y
   rotate -40*x 
   translate 0.95*y
   }
   object{legSeg2(-0.2,20, Y)rotate -90*y  scale<0.7,1,0.7>
   }  
   rotate -45*z translate <-0.065,0.95,0>
   }
   object{legSeg2(.3, 20, 1) }                           
   }
   
   scale 0.6 
   rotate 85*x
   rotate 30*y  
   scale 0.8
   translate<0.2,-0.1,-0.03>
}

#end


/************************************

        CLAWS
        
*************************************/       
                 
#declare leftClawArm =
union{   
   
   
union{
union{ 
union{
   
   object{legSeg1(-0.2,2,0)
   scale<0.9,1.5,0.9>
   rotate -45*z
   translate <-01,-1,0>
   
   }
   object{legSeg2(0,20,1)
   } 
   rotate 180*y
   scale<1.125,1,1.125>
   rotate 110*z
   translate<0.9,1.5,0>
   }
   
   sphere{<0,1,0>0.25 pigment{scorpianColDark}}

   object{legSeg2(.3,4,1)
   }
   scale<1,0.75,1>
   translate<0,0.5,0>
   }
   
   object{legSeg2(.3,20,1)}
   }
   scale 0.3     
   rotate 100*y
   rotate 90*z
   rotate -20*y 
   rotate -10*z
   translate<-0.1,-0.04,-0.2>
   
}
                 
#declare rightClawArm =
union{   
   
   
union{
union{ 
union{
   
   object{legSeg1(-0.2,2,0)
   scale<.9,1.5,.9>
   rotate -45*z
   translate <-01,-1,0>
   
   }
   object{legSeg2(0,20,1)
   } 
   rotate 180*y
   scale<1.125,1,1.125>
   rotate 110*z
   translate<0.9,1.5,0>
   }
   
   sphere{<0,1,0>0.25 pigment{scorpianColDark}}

   object{legSeg2(.3,4,1)
   }
   scale<1,0.75,1>
   translate<0,0.5,0>
   }
   
   object{legSeg2(.3,20,1)}
   }
   scale 0.3     
   rotate -100*y
   rotate 90*z
   rotate 20*y 
   rotate -10*z
   translate<-0.1,-0.04,0.2>
   

}

#declare leftClaw =
union{

  blob{
    threshold 0.6
    #declare N = 0;
    #while ( N < 20 )
      sphere{ <0,0,0> 0.1*(1 - 0.03*N) 1 translate<0,0.1,-1> rotate 2.5*N*y }
      #declare N = N+1;
    #end
  
    cylinder{<-0.2,0.1,-1><0.2,0.1,-1>0.125 0.25}
    sphere{<0,0,0>0.5 1  scale <1.5,0.9,0.75> translate<0.125,0,-1>} 
    
    sphere{<0,0,0>0.2, -0.8 translate<-0.2,-0.2,-1>}
    sphere{<0,0,0>0.15, -0.8 translate< 0.5,0,-0.9>}
  
  }
  
  blob{
    threshold 0.6
    #declare N = 0;
    #while ( N < 20 )
      sphere{ <0,0,0> 0.1*(1 - 0.03*N) 1 translate<0,-0.1,-1> rotate 2.5*N*y }
      #declare N = N+1;
    #end
  
    cylinder{<-0.2,-0.1,-1><0.2,-0.1,-1>0.125 0.25}
    rotate -10*z
  }
  
  pigment{
    gradient x    
    turbulence 0.5
       color_map{

               [0  scorpianColLight]
               [0.1  scorpianColLight]
               [0.95 scorpianColDark]
               [1 scorpianColDark]
            }       
       scale 1.3
       translate 0.5*x
            
    }  
    
     normal{ bumps bump_size 0.0625 scale 0.05}    
     finish{phong 2}  
  scale 0.9
  translate<-2.825,0.15,0>
}                  

#declare rightClaw =
union{

  blob{
    threshold 0.6
    #declare N = 0;
    #while ( N < 20 )
      sphere{ <0,0,0> 0.1*(1 - 0.03*N) 1 translate<0,0.1,1> rotate -2.5*N*y }
      #declare N = N+1;
    #end
  
    cylinder{<-0.2,0.1,1><0.2,0.1,1>0.125 0.25}
    sphere{<0,0,0>0.5 1  scale <1.5,0.9,0.75> translate<0.125,0,1>} 
    
    sphere{<0,0,0>0.2, -0.8 translate<-0.2,-0.2,1>}
    sphere{<0,0,0>0.15, -0.8 translate< 0.5,0,0.9>}
  
  }
  
  blob{
    threshold 0.6
    #declare N = 0;
    #while ( N < 20 )
      sphere{ <0,0,0> 0.1*(1 - 0.03*N) 1 translate<0,-0.1,1> rotate -2.5*N*y }
      #declare N = N+1;
    #end
  
    cylinder{<-0.2,-0.1,1><0.2,-0.1,1>0.125 0.25}
    rotate -10*z
  }
  
  pigment{
    gradient x    
    turbulence 0.5
       color_map{

               [0  scorpianColLight]
               [0.1  scorpianColLight]
               [0.95 scorpianColDark]
               [1 scorpianColDark]
            }       
       scale 1.3
       translate 0.5*x
            
    }  
    
     normal{ bumps bump_size 0.0625 scale 0.05}    
    finish{phong 2 }  
    scale 0.9
  translate<-2.825,0.15,0>
}                  

#declare scorpian =
union{
  
  union{
  
    object{backLeftLeg(0, 1)}
    object{backLeftLeg(20, .9)  scale 0.9 rotate 15*y rotate 0.5*x translate  <-0.15,0,0.1>}        
    object{backLeftLeg(60, .7)  scale 0.7 rotate 30*y rotate -0.5*x translate  <-0.15,0,0.075>}        
    object{backLeftLeg(40, .6)  scale 0.6 rotate 50*y translate  <-0.1,0,0.05>}        
  
    object{backRightLeg(0, 1)  rotate -0.5*z}
    object{backRightLeg(40, .9) scale 0.9 rotate -15*y rotate -1.5*x rotate -1*z translate <-0.2,0,-0.1>}
    object{backRightLeg(-30, .7)scale 0.7 rotate -40*y rotate 2*x translate <-0.15,0,-0.075>}
    object{backRightLeg(-10, .6) scale 0.6 rotate -69*y rotate 6*x translate <-0.1,0,-0.05>}      
    
#if (legsOnly = 0)
                
    object{leftClawArm rotate 4*x}
    object{rightClawArm rotate -4*x}

    object{body}
#end 
  
  
    rotate  5*z
    translate <-1.75,0.225,0>
 }

#if (legsOnly = 0) 
 object{ leftClaw  rotate 4*x} 
 object{ rightClaw rotate -4*x}
#end

 translate <1.5,0.995,0>  
}
/*


//object{ XYZaxis } 
                           
light_source {
       <200,100, -100> 
       color rgb <1,1,1>*2.25 
}  
        
light_source {
    <0,0, -100> 
    color rgb <1,1,1>*0.5
    shadowless
}  
        
        
 
background { color rgb<0.7607843,0.7490196,0.6470588>  }

camera { location <0, 2.25, -30>   look_at  < 1,0, 0> angle 14 }
  

object{ 
  scorpian
  rotate -80*x
  translate <1.75,1.5,0>
} 
 
object{ 
  scorpian         
  rotate -90*y 
  translate<-1.25,-1,2>
}  

object{ 
  scorpian
  translate <2.25,-2.2,0>
}  


object{ 
  scorpian         
  rotate 20*y 
  translate<-0.35,0,0>
}  
 
plane{<0,0,1>100   pigment{   bozo   color_map{      [0 Brown]      [1 Black]    } scale 3 }}   

*/