// PoVRay 3.6 Scene File " ... .pov"
// created by   Chris Holtorf  
// Date:   ...
//--------------------------------------------------------------------------
//Lost
#version 3.6;

// ==== Includes ====
#include "colors.inc"	  
#include "textures.inc"	 
#include "functions.inc"  
#include "Looking.inc"
#include "stones1.inc"
#include "rand.inc" 
#include "ColumnSection.inc"

global_settings {
  assumed_gamma 2.532
    radiosity {
      pretrace_start 0.08           
      pretrace_end   0.04          
      count 1600                     
      nearest_count 10              
      error_bound 1.3              
      recursion_limit 5            
      low_error_factor .5           
      gray_threshold 0.8            
      minimum_reuse 0.015          
      brightness .85                

      adc_bailout 0.01/2
      normal on                  
    }
  #end
}

 
camera {
  location  <0, 1.5,0>
  look_at   <0, 2, 960>
  right x*image_width/image_height  
}

#declare sun_angle = 19.5;
  
light_source {
  0*x                 
  color rgb <239,118,3>/255       
  area_light
  <8, 0, 0> <0, 0, 8> 
  4, 4                
  adaptive 0          
  jitter              
  circular           
  orient              
  translate <-12,1000*sin(sun_angle),1000>
}

 
//Person
object{ Looking scale 3 rotate<0,10,0> translate<1.5,0.2,6>}

//Columns
#declare CDia = 0.05;
object { Column_Section scale <CDia,0.125,CDia> rotate<83,0,-5> translate<2.5,0.9,20> texture { T_Stone17 scale 0.025 }}    
object { Column_Section scale <CDia,0.125,CDia> rotate<80,-10,-5> translate<4.5,0.95,21> texture { T_Stone17 scale 0.025 }}
object { Column_Section scale <CDia,0.125,CDia> rotate<60,10,5> translate<6.5,0.95,19> texture { T_Stone17 scale 0.025 }}
         

//Desert sand landscape
#declare fn_RMF = function{ f_ridged_mf(x, y, z, 0.1, 3.1, 8 ,0.7, 0.8, 2) }
#declare Sand = 
isosurface {
   function {
      z - fn_RMF(x, y, z)*0.07
   }

   max_gradient 1.3

   contained_by { box { <-15, -15, 0.0>, <15, 15, 0.5> } } rotate<0,0,90>

   texture {
      pigment { color rgb <1.4, 0.85, 0.6>  }   
      finish { diffuse 0.7 specular 0.1 }
    }

   scale <50,50,50>
   translate -0.16*z

   clipped_by {
      box { <-1.95,  -1.95, 1>, < 1.95,  1.95, -1> inverse }
   }

   photons { collect off }
rotate<-90,-30,0> translate<0,0,0>
}
object { Sand } 

//Background images
#declare Panoramic=union{
   object{plane {z,0 texture{pigment{ image_map{jpeg "Desert6b.jpg" once}} finish{ambient 1 diffuse 0}}}}
   translate z*0.5-x*0.5-y*0.5 
   hollow
   scale <2000,1500,2000> 
   no_shadow 
} 

object{ Panoramic rotate<0,0,0> translate<0,0,400>} 
       
 fog {
  fog_type   2
  distance   200
  color      rgbt<0.7,0.7,0.7,0.6>
  fog_offset 1
  fog_alt    3.5
  turbulence 0.6
  }
