#declare Photons=on;
#include "colors.inc" 
#include "woods.inc"
global_settings {
    assumed_gamma 1.0  
    max_trace_level 15
  #if (Photons)         
 photons {
      spacing 0.00002                
      count 10000000              
     jitter 1.0               

   }     
 radiosity {
    pretrace_start 0.08           
    pretrace_end   0.04         
    count 69                    
    nearest_count 7             
    error_bound 1           
    recursion_limit 3            
    low_error_factor .5        
    gray_threshold 0.0          
    minimum_reuse 0.015         
    brightness 0.3              

    adc_bailout 0.01/2

  
      }
}
   
light_source {
  <-200, 1000,-1000>      
  color rgb 1    
  
parallel
  
photons {
    refraction on
    reflection on
  }  
   

}


/*light_source {
  <10000, 1000, 1000>     
  color rgb .32     
  parallel 
  photons {
    refraction on
    reflection on
  } 
   shadowless
}   */






camera { 

        location <4.5,1.25,4.5>  
        look_at <0,.4,0> 
          right     x*image_width/image_height
  aperture .1
             
  blur_samples 50       
  focal_point <1.5,.5,2>   
  confidence 0.95           
  variance 1/200  
        }

         

sky_sphere {
  pigment {
    gradient y
    color_map { [0.5 color rgb <0.051,0.051, .89>] [1 color rgb <0.8,0.75,.45, >] }
    
   rotate x*180
  }
}

        
        
fog {
  fog_type   2
  distance   200
  color      <0.7,0.65,.350>
  fog_offset 0.1
  fog_alt    0.2
  turbulence 3
}
  






      
#declare Sand = texture { pigment {
  agate    color_map { [1 color rgb <.85, .81, .69>] [.5 color rgb <0.7,0.67,.5>] }      
  agate_turb .9  }scale <.05, .05, .05>}    
  
  
  
  

#declare Mud_N = height_field 
		{ png
			"river2.png"	
			 smooth
			 texture {Sand } 
			photons {
				target 1.0
				refraction on				
				reflection on} 
scale <10, 0.15, 10> };

#declare Mud_N1 = merge 
                              {  object {Mud_N scale <1, 1, 1>}
                                 object {Mud_N scale <1, 1, -1>}
                                 object {Mud_N scale <-1, 1, 1>}
                                 object {Mud_N scale <-1, 1, -1>}
					}; 
					     
#declare Mud_N2 = merge 
                              {  object {Mud_N1 scale <1, 1, 1>}
                                 object {Mud_N1 translate <-20, 0, 0> scale <1, 1, -1>}
                                 object {Mud_N1 translate <0, 0, -20> scale <-1, 1, 1>}
                                 object {Mud_N1 translate <20, 0, 20> scale <-1, 1, -1>}
					};

#declare Mud_N3 = merge 
                             
                              {  object {Mud_N2 scale <1, 1, 1>}
                                 object {Mud_N2 translate <-40, 0, 60> scale <1, 1, -1>}
                                 object {Mud_N2 translate <20, 0,-40> scale <-1, 1, 1>}
                                 object {Mud_N2 translate <60, 0, 20> scale <-1, 1, -1>}
					};
#declare Mud_N4 = merge 
                              {  object {Mud_N3 }
                                 object {Mud_N3 translate <-80, 0, 0> }
                                 object {Mud_N3 translate <0, 0,-80> }
                                 object {Mud_N3 translate <-80, 0, -80> }
					}; 
					

                                           
object {Mud_N4}   




plane {
  y, 
  -.1 
   texture {Sand} 
			
}    
  
  
  
#declare Glass = material 
                { texture {
                pigment { color rgbft <0.15, 0.7, 0.15, .2, 0.85> }
               
                
               
  finish {                                                                                   
    ambient 0.05         
    diffuse 0.1        
    brilliance .5     
    specular 0.75       
    roughness 0.051    
    reflection {
      0.2                     
      .5                     
      fresnel on               
      falloff 1.0              
      exponent 1.0             
    }
    conserve_energy            
   
    irid {               
      0.01              
      thickness 0.0005   
      turbulence 0.001   
    } 
  } 

  }
  
 interior {
    ior 1.5
        caustics            0.1
        dispersion          1.0
        dispersion_samples  10
        fade_distance       3
        fade_power          1002
        fade_color          <.3,0.3,0.3>}
    


     
    
  } ; 

                           
                              
#declare Rim = torus {.17, .03 scale <1, 1.2, 1> translate y*4 
      
                                 material {Glass} 
                      
  photons{
    target 1.0          
    refraction on
    reflection on
   
  }
            
                      };                       
                              
       



#declare Body = difference {

blob {
threshold .2
cylinder { 0*y,  2.5*y, .75 , 1
}   
  
  cylinder {2.5*y,  4*y, 0.25, 1} 
  
  material { Glass } 
  photons{
    target 1.0          
    refraction on
    reflection on
   
  }

   
 
} 


blob {
threshold .2
cylinder { 0*y,  2.5*y, .749 , 1}   
  
  cylinder {2.5*y,  5*y, 0.249, 1} 
  
  material { Glass } 
  photons{
    target 1.0         
    refraction on
    reflection on
    
  }


 }  
 
 
box {
  <-3, -3, -3>  
  < 3,  0,  3>  
  material { Glass }
}

 
}
  
#declare Bottom = difference { 
                                cylinder {0*y, .1*y, .56 material { Glass } photons{
    target 1.0          
    refraction on
    reflection on
  
         } }                      cone {<0, 0, 0>, .55, <0, .05, 0>, .01 material { Glass } photons{
    target 1.0          
    refraction on
    reflection on
  
                            } }} ;
#declare Bottle = merge {
        object { Body }
        object { Rim }    
        object { Bottom }
        
        
      }  
       
#declare Cork =    //Copied directly from textures.inc, included with POV-Ray 3.6 instalation
texture {
    pigment {
        granite
        color_map {
            [0.00 rgb <0.93, 0.71, 0.532>]
            [0.60 rgb <0.98, 0.81, 0.60>]
            [0.60 rgb <0.50, 0.30, 0.20>]
            [0.65 rgb <0.50, 0.30, 0.20>]
            [0.65 rgb <0.80, 0.53, 0.46>]
            [1.00 rgb <0.85, 0.75, 0.35>]
        }
    }
    finish{ 
        specular 0.1 
        roughness 0.5 
    }
    scale 0.25     // Generally looks best scaled longer on one axis
}


#declare Cork_obj = cone {<0, 0, 0>, .11, <0, .3, 0>, .155 
                                texture { Cork } 
                                                       
  photons{
    target 1.0          
    refraction on
    reflection on
   
   }

}  

#declare Paper = texture { pigment {rgb <.5, .5, .5>}finish {                                                                                   
    ambient 0.2          
    diffuse 1         
  
   reflection {
      0.01                     
      .02                       
      fresnel on             
      falloff 1.0          
      exponent 1.0            
    }               
    conserve_energy            
    
   
   irid {             
      0.05              
      thickness 0.0005   
      turbulence 0.001   
    }  
  } 

  }
  





  

#declare Message = union {        difference {lathe {
                                                        linear_spline 
                                         2, 
                                                 < .05,0>, < .05,2> 
                                 translate x*.05
                                                texture {Paper}}
    
                                    box {
                                               <4, -.5,0>  
                                               < -4,  4,  -4>}
                                              
       
      
                                   }


                        difference {lathe {
  linear_spline 
 2, 
  < .1,0>, < .1,1.5> 
texture {Paper}}
    
                                    box {
                                               <-4, -.5, 0>  
                                               < 4,  4,  4>}  

                                 }
                                 
                                 
                       difference {lathe {
  linear_spline 
  2, 
  < .2,0>, < .2,2> 
  translate x*.1
texture {Paper}}
    
                                    box {
                                               <4, -.5,0>  
                                               < -4,  4,  -4>}
                                              
       
      
                                   }
                difference {        lathe {
  linear_spline 
  2,
  < .4,0>, < .4,2>  translate x*-.1 
texture {Paper}}
    
                                    box {
                                               <-4, -.5, 0>  
                                               < 4,  4,  4>} 
                                                
                                         }     
                                                  

                                 
                              
        }  
#declare Cross = union {
                                box {
                                <-3, 0, -.5>  
                                 < 3,  .5,  .5> texture { T_Wood3 } 
                        }  
                                box {
                                 <-.5, 0, -5>  
                        <.5,  .5,  3>  
                         texture { T_Wood3 } }    
                                             
  photons{
    target 1.0         
    refraction on
    reflection on
   
  }

                         }  
                          
                                               
#declare Full_object = union {
                                object { Bottle }
                                object { Cork_obj translate y*3.8}
                                object { Message rotate x*180 translate y*2.5  rotate y*-45  scale z*.8}
                              }  
                                 
object {Full_object rotate x*90 rotate y*25  rotate z*-2 translate y*.6 translate z*.5}  
object {Cross  scale <.5, .75, .5> rotate x*-3 rotate z*-5  rotate y*-100  translate z*-12  }
                                                       
    #end   
                      
                     
