// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = radians(180); // Maximum u value
#declare uNum = 90; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 2252; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(356); // Maximum v value
#declare vNum = 90; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 7335; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = true; // True if uv-mapping used
#declare Smooth = 1; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions

#macro rd(a,b,m,n1,n2,n3,th)
	pow(pow(abs(cos(m*th*0.25)/a),n2)+pow(abs(sin(m*th*0.25)/b),n3),-1/n1)
#end

#macro pof(n,ex,of) pow((n+of)*(n+of),ex*.5)-of #end

#declare a1=pi+2;
#declare b1=pi-2;
#declare m1=5.5;
#declare n11=1.50;
#declare n21=1.75;
#declare n31=1.25;

#declare a2=phi(2);
#declare b2=phi(3);
#declare m2=1;
#declare n12=0.30;
#declare n22=-.25;
#declare n32=-.35;

// point function
#macro pnt(i, j, p, q)
	#local rdi = rd(a1,b1,m1,n11,n21,n31,i);
	#local rdj = rd(a2,b2,m2,n12,n22,n32,j);
	#local si = sin(i);
	#local ci = cos(i);
	#local sj = sin(j);
	#local cj = cos(j);
	
  /*torus
  #local xp = sj*(rdj+rdi*si);
  #local yp = cj*(rdj+rdi*si);*/
  //sphere
  #local xp = rdj*cj*rdi*si; 
  #local yp = rdj*sj*rdi*si; 
  #local zp = rdi*ci;
  #local dz = pof(zp, 1.3, 4.5);
  <xp+.1*dz,zp,yp>
#end
